/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ExtItfPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowTaskExtItfPlugin
extends AbstractWorkflowPlugin {
    private static final String BUTTON_CONFIRM = "btnok";
    private static final String SELECT_USEROPERATION = "useroperation";
    private static final String CONTAINER_EXT_ITF = "extitfpanel";
    private static final String PANEL_OPERATION = "operation_panel";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        Object deciOperValue;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object value = parameter.getCustomParam("value");
        Object type = parameter.getCustomParam("type");
        Object stencilType = parameter.getCustomParam("stencil_type");
        Object modelType = parameter.getCustomParam("model_type");
        String extItfVal = null;
        String operation = null;
        if (value instanceof Map) {
            Map map = (Map)value;
            extItfVal = (String)map.get("implementation");
            operation = (String)map.get("operation");
        }
        if ("start".equals(type)) {
            this.initEntryExecutionTime(operation, modelType, stencilType);
        } else if ("run".equals(type)) {
            deciOperValue = parameter.getCustomParam("decition_operation_value");
            this.initLeaveAndHandleTaskExecutionTime(deciOperValue, operation, (String)stencilType, type, modelType);
        } else {
            deciOperValue = parameter.getCustomParam("decition_operation_value");
            this.initLeaveAndHandleTaskExecutionTime(deciOperValue, operation, (String)stencilType, type, modelType);
        }
        this.openExtItfInContainer(extItfVal, "calculate_participant".equals(operation));
    }

    private void initEntryExecutionTime(String value, Object modelType, Object stencilType) {
        if (stencilType == null) {
            return;
        }
        ComboEdit select = (ComboEdit)this.getControl(SELECT_USEROPERATION);
        String stencilTypeStr = (String)stencilType;
        select.setComboItems(DesignerPluginUtil.getEntryPluginExecutionTime(modelType, stencilTypeStr));
        this.getModel().setValue(SELECT_USEROPERATION, (Object)(WfUtils.isNotEmpty((String)value) ? value : "normal"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (SELECT_USEROPERATION.equals(name)) {
            this.updateType(e);
        }
    }

    public void updateType(PropertyChangedArgs e) {
        Object[] changeSet = e.getChangeSet();
        if (WfUtils.isEmptyForArrays((Object[])changeSet)) {
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object value = parameter.getCustomParam("value");
        String extItfVal = null;
        if (value instanceof Map) {
            Map map = (Map)value;
            extItfVal = (String)map.get("implementation");
        }
        if (!WfUtils.isNullObject((Object)changeSet[0])) {
            this.openExtItfInContainer(extItfVal, "calculate_participant".equals(changeSet[0].getNewValue()));
        }
    }

    private void initLeaveAndHandleTaskExecutionTime(Object value, String operation, String stencilType, Object type, Object modelType) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if ("run".equals(type)) {
            List<ComboItem> runItems = null;
            runItems = "BillTask".equals(stencilType) || "UserTask".equals(stencilType) && "BizFlowModel".equals(modelType) ? DesignerPluginUtil.getRunPluginForBillTaskComboItems() : DesignerPluginUtil.getRunPluginComboItems();
            items.addAll(runItems);
            operation = operation == null ? runItems.get(0).getValue() : operation;
        } else if ("end".equals(type)) {
            items.add(DesignerPluginUtil.getDefaultPluginComboItem());
        }
        String defaultDecision = null;
        if (value instanceof JSONArray && !"BillTask".equals(stencilType)) {
            JSONArray opers = (JSONArray)value;
            int size = opers.size();
            JSONObject oper = null;
            String name = null;
            String number = null;
            for (int i = 0; i < size; ++i) {
                oper = opers.getJSONObject(i);
                number = oper.getString("number");
                if (defaultDecision == null && Boolean.TRUE.equals(oper.getBoolean("defaultDecision"))) {
                    defaultDecision = number;
                }
                name = oper.getString("name");
                items.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u65f6", (String)"WorkflowTaskExtItfPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), name)), number));
            }
        }
        ComboEdit select = (ComboEdit)this.getControl(SELECT_USEROPERATION);
        select.setComboItems(items);
        if (WfUtils.isNotEmpty((String)operation)) {
            this.getModel().setValue(SELECT_USEROPERATION, (Object)operation);
        } else if (defaultDecision != null) {
            this.getModel().setValue(SELECT_USEROPERATION, defaultDecision);
        } else {
            this.getModel().setValue(SELECT_USEROPERATION, (Object)"end");
        }
    }

    private void openExtItfInContainer(String value, Boolean isCalculateParticipant) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityId = (String)parameter.getCustomParam("entityId");
        String types = "";
        types = WfUtils.isNotEmpty((String)entityId) ? (isCalculateParticipant.booleanValue() ? ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"}) : ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script", "operation"})) : "class";
        String type = null;
        if (value != null) {
            Map fromJsonString = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            type = (String)fromJsonString.get("type");
        }
        String pageId = DesignerPluginUtil.openExtItfInContainer(this.getView(), (IFormPlugin)this, types, entityId, (String)(isCalculateParticipant != false && "operation".equals(type) ? null : value), CONTAINER_EXT_ITF);
        this.getPageCache().put("pageId", pageId);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey().toLowerCase()) {
            case "btnok": {
                this.confirm();
            }
        }
    }

    private void confirm() {
        String value = ExtItfPluginUtil.invokeConfirmMethod(this.getView(), this.getPageCache().get("pageId"), new Object[]{this.getView()});
        if (WfUtils.isEmpty((String)value)) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object rowIndex = parameter.getCustomParam("rowIndex");
        data.put("type", parameter.getCustomParam("type"));
        data.put("rowIndex", rowIndex == null ? null : rowIndex + "");
        data.put("extItf", value);
        data.put("operation", (String)this.getModel().getValue(SELECT_USEROPERATION));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("pageId");
    }
}

