/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.property.alias.AliasConverterFactory;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BaseTaskListener;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowTaskPluginsPlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String PROPERTY_ENTITY_ID = "entityId";
    private static final String TYPE_ENTRY = "start";
    private static final String TYPE_LEAVE = "end";
    private static final String KEY_PLUGIN = "plugin";
    private static final String GRID_ENTRY = "entry";
    private static final String GRID_LEAVE = "leave";
    private static final String GRID_RUN = "run";
    private static final String TITLE_ENTERNODE = "enternode_title";
    private static final String TITLE_LEAVENODE = "leavenode_title";
    private static final String OPERATION_DECISION = "leave_operation";
    private static final String ENTRY_EXECUTION_TIME = "entry_operation";
    private static final String LISTENER_IMPLEMENTATIONTYPE = "implementationType";
    private static final String BTN_ADDENTRYPLUGIN = "addentryplugin";
    private static final String BTN_MODIFYENTRYPLUGIN = "modifyentryplugin";
    private static final String BTN_ADDLEAVEPLUGIN = "addleaveplugin";
    private static final String BTN_ADDRUNPLUGIN = "addrunplugin";
    private static final String BTN_MODIFYLEAVEPLUGIN = "modifyleaveplugin";
    private static final String BTN_MODIFYRUNPLUGIN = "modifyrunplugin";
    private static final String FLOWRECORDFORMATTER = "flowrecordformatter";
    private static final String TRIGGERCOMPENSATION = "triggercompensation";
    private static final String THROW_PANEL = "throw_panel";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(FLOWRECORDFORMATTER);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADDENTRYPLUGIN, BTN_MODIFYENTRYPLUGIN, BTN_ADDLEAVEPLUGIN, BTN_MODIFYLEAVEPLUGIN, FLOWRECORDFORMATTER, BTN_ADDRUNPLUGIN, BTN_MODIFYRUNPLUGIN});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject properties = this.getCellProperties();
        this.initPluginEntry(properties);
        this.initFlowRecordFormatter(properties);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"throwpanel"});
    }

    private void initFlowRecordFormatter(JSONObject properties) {
        String flowRecordFormatter = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, FLOWRECORDFORMATTER);
        if (WfUtils.isNotEmpty((String)flowRecordFormatter)) {
            String flowRecordFormatterValue = ExternalInterfaceUtil.getFormattedShowValue((String)flowRecordFormatter);
            this.getModel().setValue(FLOWRECORDFORMATTER, (Object)flowRecordFormatterValue);
        } else {
            this.getModel().setValue(FLOWRECORDFORMATTER, null);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        JSONObject properties = this.getCellProperties();
        switch (key = ctrl.getKey()) {
            case "addentryplugin": {
                this.addOrUpdateExternalInterface(properties, true, false, true);
                break;
            }
            case "modifyentryplugin": {
                this.addOrUpdateExternalInterface(properties, true, true, true);
                break;
            }
            case "addleaveplugin": {
                this.addOrUpdateExternalInterface(properties, false, false, false);
                break;
            }
            case "modifyleaveplugin": {
                this.addOrUpdateExternalInterface(properties, false, true, false);
                break;
            }
            case "flowrecordformatter": {
                this.showPageForFlowRecordFormatter(properties, this.getModelJsonString());
                break;
            }
            case "addrunplugin": {
                this.runAddOrUpdateExternalInterface(properties, false, false);
                break;
            }
            case "modifyrunplugin": {
                this.runAddOrUpdateExternalInterface(properties, false, true);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "flowrecordformatter": {
                this.flowRecordFmtChanged(newValue);
                break;
            }
            case "triggercompensation": {
                this.getView().setVisible((Boolean)newValue, new String[]{THROW_PANEL});
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void flowRecordFmtChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(FLOWRECORDFORMATTER, null);
        }
    }

    private void showPageForFlowRecordFormatter(JSONObject properties, String modelJson) {
        try {
            String entityId = properties.getString(PROPERTY_ENTITY_ID);
            String types = WfUtils.isNotEmpty((String)entityId) ? ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"}) : ExternalInterfaceUtil.getTypes((String[])new String[]{"class"});
            String value = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "flowRecordFormatter");
            IFormView view = this.getView();
            view.getFormShowParameter().setCustomParam("hideParameterConfig", (Object)Boolean.TRUE);
            DesignerPluginUtil.openExternalInterface(view, (IFormPlugin)this, types, properties.getString(PROPERTY_ENTITY_ID), value);
        }
        catch (Exception e) {
            this.log.error(String.format("\u521d\u59cb\u5916\u90e8\u63a5\u53e3\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addOrUpdateExternalInterface(JSONObject properties, boolean entry, boolean update, boolean needSourceElement) {
        HashMap<String, Object> value = null;
        Integer focusRow = null;
        if (update) {
            EntryGrid grid = (EntryGrid)this.getControl(entry ? GRID_ENTRY : GRID_LEAVE);
            focusRow = grid.getEntryState().getFocusRow();
            if (focusRow < 0) {
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                return;
            }
            IDataModel model = this.getModel();
            value = new HashMap<String, Object>(grid.getItems().size());
            for (Control field : grid.getItems()) {
                value.put(field.getKey().replace(grid.getKey() + "_", ""), model.getValue(field.getKey(), focusRow.intValue()));
            }
        }
        String entityId = null;
        if ("BillTask".equals(this.stencilType) && needSourceElement) {
            String sourceEntityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "sourceEntityNumber");
            if (!WfUtils.isNotEmpty((String)sourceEntityNumber)) {
                this.getView().showTipNotification(WFMultiLangConstants.getUnConfigSourceEntityNumber());
                return;
            }
            entityId = MetadataDao.getIdByNumber((String)sourceEntityNumber, (MetaCategory)MetaCategory.Form);
        } else {
            entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_ENTITY_ID);
        }
        FormShowParameter parameter = this.getExtItfShowParameter(focusRow, value, entityId, properties);
        parameter.setCustomParam("type", (Object)(entry ? TYPE_ENTRY : TYPE_LEAVE));
        this.showForm(parameter);
    }

    private void runAddOrUpdateExternalInterface(JSONObject properties, boolean entry, boolean update) {
        HashMap<String, Object> value = null;
        Integer focusRow = null;
        if (update) {
            EntryGrid grid = (EntryGrid)this.getControl(GRID_RUN);
            focusRow = grid.getEntryState().getFocusRow();
            if (focusRow < 0) {
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                return;
            }
            IDataModel model = this.getModel();
            value = new HashMap<String, Object>(grid.getItems().size());
            for (Control field : grid.getItems()) {
                value.put(field.getKey().replace(grid.getKey() + "_", ""), model.getValue(field.getKey(), focusRow.intValue()));
            }
        }
        String entityId = null;
        if ("BillTask".equals(this.stencilType)) {
            String sourceEntityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "sourceEntityNumber");
            if (WfUtils.isNotEmpty((String)sourceEntityNumber)) {
                entityId = MetadataDao.getIdByNumber((String)sourceEntityNumber, (MetaCategory)MetaCategory.Form);
            }
        } else {
            entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_ENTITY_ID);
        }
        FormShowParameter parameter = this.getExtItfShowParameter(focusRow, value, entityId, properties);
        Object deciOperValue = DesignerModelUtil.getOperationOrDecision(this.stencilType, properties);
        parameter.setCustomParam("decition_operation_value", deciOperValue);
        parameter.setCustomParam("type", (Object)GRID_RUN);
        this.showForm(parameter);
    }

    protected FormShowParameter getExtItfShowParameter(Integer focusRow, Map<String, Object> value, String entityId, JSONObject properties) {
        FormShowParameter parameter = this.getShowParameter(KEY_PLUGIN, "wf_taskplugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("rowIndex", (Object)focusRow);
        parameter.setCustomParam("value", value);
        parameter.setCustomParam("optionalActions", ProcTemplatePluginUtil.getOptionalOperationNumbers((Map<String, Object>)properties));
        parameter.setCustomParam("stencil_type", (Object)this.stencilType);
        parameter.setCustomParam("model_type", (Object)this.modelType);
        parameter.setCustomParam(PROPERTY_ENTITY_ID, (Object)entityId);
        return parameter;
    }

    private void initPluginEntry(JSONObject properties) {
        JSONArray taskListeners;
        this.getModel().deleteEntryData(GRID_ENTRY);
        this.getModel().deleteEntryData(GRID_LEAVE);
        this.getModel().deleteEntryData(GRID_RUN);
        Object deciOperValue = DesignerModelUtil.getOperationOrDecision(this.stencilType, properties);
        ArrayList<ComboItem> leaveItems = new ArrayList<ComboItem>();
        leaveItems.add(DesignerPluginUtil.getDefaultPluginComboItem());
        ArrayList<ComboItem> runItems = new ArrayList<ComboItem>();
        runItems.addAll(DesignerPluginUtil.getRunPluginComboItems());
        ComboEdit leaveExecutionTime = (ComboEdit)this.getControl(OPERATION_DECISION);
        ComboEdit entryExecutionTime = (ComboEdit)this.getControl(ENTRY_EXECUTION_TIME);
        ComboEdit runExecutionTime = (ComboEdit)this.getControl("run_operation");
        JSONArray decisionOptions = null;
        String decisionStr = null;
        if (deciOperValue instanceof String && WfUtils.isNotEmpty((String)(decisionStr = deciOperValue.toString()))) {
            decisionOptions = new JSONArray();
            JSONObject option = new JSONObject();
            option.put("number", (Object)decisionStr);
            option.put("name", AliasConverterFactory.create("wf_formoperation").convert((Object)decisionStr));
            decisionOptions.add((Object)option);
        } else if (deciOperValue instanceof JSONArray) {
            decisionOptions = (JSONArray)deciOperValue;
        }
        Object value = DesignerModelUtil.getProperty((Map<String, Object>)properties, "taskListeners");
        JSONArray jSONArray = taskListeners = value instanceof JSONArray ? (JSONArray)value : new JSONArray();
        if (decisionOptions != null) {
            int size = decisionOptions.size();
            boolean compatible = false;
            JSONObject oper = null;
            String number = null;
            IPropertyConverter converter = null;
            for (int i = 0; i < size; ++i) {
                oper = decisionOptions.getJSONObject(i);
                number = oper.getString("number");
                if (oper.containsKey((Object)"operation") || oper.containsKey((Object)"recallOperation")) {
                    compatible = true;
                    converter = converter != null ? converter : this.createOperationConverter();
                    this.compatibleTaskListeners(oper, converter, taskListeners);
                }
                runItems.add(new ComboItem(new LocaleString(oper.getString("name")), number));
            }
            if (compatible) {
                this.setProperties("taskListeners", taskListeners, "decisionOptions", decisionOptions);
            }
        }
        runExecutionTime.setComboItems(runItems);
        leaveExecutionTime.setComboItems(leaveItems);
        entryExecutionTime.setComboItems(DesignerPluginUtil.getEntryPluginExecutionTime(this.modelType, this.stencilType));
        Object executionListeners = DesignerModelUtil.getProperty((Map<String, Object>)properties, "executionListeners");
        JSONArray entryPlugins = new JSONArray();
        JSONArray leavePlugins = new JSONArray();
        JSONArray taskPlugins = new JSONArray();
        this.fillEntryOrLeavePlugins(executionListeners, entryPlugins, leavePlugins, taskPlugins);
        this.fillEntryOrLeavePlugins(taskListeners, entryPlugins, leavePlugins, taskPlugins);
        this.initEntryGridValue((EntryGrid)this.getControl(GRID_ENTRY), entryPlugins);
        this.initEntryGridValue((EntryGrid)this.getControl(GRID_LEAVE), leavePlugins);
        this.initEntryGridValue((EntryGrid)this.getControl(GRID_RUN), taskPlugins);
    }

    protected IPropertyConverter createOperationConverter() {
        JSONObject properties = this.getCellProperties();
        Object entityId = DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_ENTITY_ID);
        IPropertyConverter converter = AliasConverterFactory.create("wf_formoperation");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(PROPERTY_ENTITY_ID, entityId);
        converter.setContext(context, this.itemId);
        return converter;
    }

    protected void compatibleTaskListeners(JSONObject oper, IPropertyConverter converter, JSONArray taskListeners) {
        String number = oper.getString("number");
        String forward = (String)oper.get((Object)"operation");
        String withdraw = (String)oper.get((Object)"recallOperation");
        oper.remove((Object)"operation");
        oper.remove((Object)"recallOperation");
        if (WfUtils.isNotEmpty((String)forward) || WfUtils.isNotEmpty((String)withdraw)) {
            String forwardName = (String)converter.convert((Object)forward);
            String withdrawName = (String)converter.convert((Object)withdraw);
            JSONObject taskListener = new JSONObject();
            taskListener.put("event", (Object)"complete");
            taskListener.put("operation", (Object)number);
            taskListener.put(LISTENER_IMPLEMENTATIONTYPE, (Object)"operation");
            taskListener.put("implementation", (Object)ExternalInterfaceUtil.buildExtItfOperationValue((String)forward, (String)forwardName, (String)withdraw, (String)withdrawName));
            taskListeners.add((Object)taskListener);
        }
    }

    public void fillEntryOrLeavePlugins(Object listeners, JSONArray entryPlugins, JSONArray leavePlugins, JSONArray taskPlugins) {
        if (listeners instanceof JSONArray) {
            JSONArray plugins = (JSONArray)listeners;
            int size = plugins.size();
            JSONObject plugin = null;
            if (size < 1) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                plugin = plugins.getJSONObject(i);
                String evt = plugin.getString("event");
                if (BaseTaskListener.getAllTaskEvts().contains(evt) || "complete".equals(evt)) {
                    taskPlugins.add((Object)plugin);
                    continue;
                }
                String implenentation = plugin.getString("implementation");
                if (!ExternalInterfaceUtil.isValidValue((String)implenentation)) continue;
                if (TYPE_ENTRY.equals(plugin.get((Object)"event"))) {
                    if (plugin.get((Object)"operation") == null) {
                        plugin.put("operation", (Object)"normal");
                    }
                    entryPlugins.add((Object)plugin);
                    continue;
                }
                if (plugin.get((Object)"operation") == null) {
                    plugin.put("operation", (Object)TYPE_LEAVE);
                }
                leavePlugins.add((Object)plugin);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (KEY_PLUGIN.equals(actionId)) {
            this.setPluginEntryValue(returnData);
        } else if ("externalInterface".equals(actionId)) {
            this.setCloseDataForFlowRecord(returnData);
        } else {
            super.closedCallBack(evt);
        }
    }

    private void setPluginEntryValue(Object returnData) {
        String id;
        if (!(returnData instanceof Map)) {
            return;
        }
        IDataModel model = this.getModel();
        Map data = (Map)returnData;
        String type = (String)data.get("type");
        String rowIndex = (String)data.get("rowIndex");
        String gridKey = TYPE_ENTRY.equals(type) ? GRID_ENTRY : (TYPE_LEAVE.equals(type) ? GRID_LEAVE : GRID_RUN);
        String extItf = (String)data.get("extItf");
        int index = -1;
        index = rowIndex != null ? Integer.parseInt(rowIndex) : model.createNewEntryRow(gridKey);
        String field = TYPE_ENTRY.equals(type) || TYPE_LEAVE.equals(type) ? "executionListeners" : "taskListeners";
        DynamicObject obj = model.getEntryRowEntity(gridKey, index);
        String string = id = obj != null ? obj.getString(this.getEntryFieldKey(gridKey, "id")) : null;
        if (WfUtils.isEmpty(id)) {
            id = BpmnDiffUtil.getListElementId((String)field);
        }
        model.setValue(this.getEntryFieldKey(gridKey, "id"), (Object)id, index);
        model.setValue(this.getEntryFieldKey(gridKey, "implementationtype"), (Object)ExternalInterfaceUtil.getExtItfType((String)extItf), index);
        model.setValue(this.getEntryFieldKey(gridKey, "implementation"), (Object)extItf, index);
        model.setValue(this.getEntryFieldKey(gridKey, "operation"), data.get("operation"), index);
    }

    private void setCloseDataForFlowRecord(Object returnData) {
        if (WfUtils.isNotEmptyString((Object)returnData)) {
            this.getModel().setValue(FLOWRECORDFORMATTER, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)((String)returnData)));
            this.setProperty(FLOWRECORDFORMATTER, returnData);
        }
    }

    @Override
    protected void setGridPropertyValue(String gridKey) {
        if (GRID_ENTRY.equals(gridKey) || GRID_LEAVE.equals(gridKey) || GRID_RUN.equals(gridKey)) {
            this.setListenersValue(gridKey);
            return;
        }
        super.setGridPropertyValue(gridKey);
    }

    private void addTaskHandleListenersValues(JSONArray taskListeners) {
        JSONArray runPlugins = this.getEntryGridValue((EntryGrid)this.getControl(GRID_RUN));
        int size = runPlugins.size();
        JSONObject plugin = null;
        String operation = null;
        for (int i = 0; i < size; ++i) {
            plugin = runPlugins.getJSONObject(i);
            operation = (String)plugin.get((Object)"operation");
            if (BaseTaskListener.getAllTaskEvts().contains(operation)) {
                plugin.put("event", (Object)operation);
                taskListeners.add((Object)plugin);
                continue;
            }
            plugin.put("event", (Object)"complete");
            taskListeners.add((Object)plugin);
        }
    }

    private void setListenersValue(String gridKey) {
        int i;
        JSONArray entryPlugins = this.getEntryGridValue((EntryGrid)this.getControl(GRID_ENTRY));
        JSONArray leavePlugins = this.getEntryGridValue((EntryGrid)this.getControl(GRID_LEAVE));
        JSONArray executionListeners = new JSONArray();
        JSONArray taskListeners = new JSONArray();
        int size = entryPlugins.size();
        JSONObject plugin = null;
        for (i = 0; i < size; ++i) {
            plugin = entryPlugins.getJSONObject(i);
            plugin.put("event", (Object)TYPE_ENTRY);
            executionListeners.add((Object)plugin);
        }
        size = leavePlugins.size();
        for (i = 0; i < size; ++i) {
            plugin = leavePlugins.getJSONObject(i);
            plugin.put("event", (Object)TYPE_LEAVE);
            executionListeners.add((Object)plugin);
        }
        this.addTaskHandleListenersValues(taskListeners);
        if (GRID_ENTRY.equals(gridKey) || GRID_LEAVE.equals(gridKey)) {
            this.setProperty("executionListeners", executionListeners);
        }
        if (GRID_RUN.equals(gridKey)) {
            this.setProperty("taskListeners", taskListeners);
        }
    }

    @Override
    protected Object getEntryFieldShowValue(String property, Object value) {
        if ("implementation".equals(property)) {
            return ExternalInterfaceUtil.getFormattedShowValue((String)((String)value));
        }
        return super.getEntryFieldShowValue(property, value);
    }
}

