/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WorkflowTaskSubjectPlugin
extends AbstractWorkflowPlugin {
    private static final String PARAM_ENTITY_NUMBER = "entityNumber";
    private static final String PARAM_ENTITY_ID = "entityId";
    private static final String PARAM_MODEL_JSON = "modelJson";
    private static final String PARAM_OPEN_TYPE = "openType";
    private static final String PARAM_VALUE = "value";
    private static final String SUBJECT = "subject";
    private static final String SUBJECT_TIMING = "timing";
    private static final String SUBJECT_RULE = "rule";
    private static final String SV_SUBJECT_RULE = "sv_rule";
    private static final String SUBJECT_TYPE = "type";
    private static final String SUBJECT_CONTENT = "customsubject";
    private static final String SUBJECT_CONTENT_XML = "customSubject";
    private static final String EXPRESSION = "expression";
    private static final String DESIGNER = "designer";
    private static final String BILLATTRIBUTE = "billAttribute";
    private static final String CONFIRM = "confirm";
    private static final String SUBJECT_SCENE = "scene";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, SV_SUBJECT_RULE, SUBJECT_CONTENT});
    }

    public void afterCreateNewData(EventObject e) {
        String openType;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object value = params.get(PARAM_VALUE);
        switch (openType = (String)params.get(PARAM_OPEN_TYPE)) {
            case "designer": {
                this.initTaskSubject(openType, value);
                break;
            }
            case "billAttribute": {
                this.initBillSubject(openType, value);
                break;
            }
        }
    }

    private void initTaskSubject(String openType, Object value) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SUBJECT_SCENE});
        this.wrapComboEditItems();
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if ("BizFlowModel".equals(modelType)) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(1);
            ComboItem comboItem = new ComboItem();
            comboItem.setValue("normal");
            comboItem.setCaption(new LocaleString(WFMultiLangConstants.getSentEvtInName()));
            items.add(comboItem);
            ComboEdit subjectTiming = (ComboEdit)this.getControl(SUBJECT_TIMING);
            subjectTiming.setComboItems(items);
        }
        if (value != null) {
            if (value instanceof String) {
                this.initSubjectEntryEntityForOld(openType, value);
            } else if (value instanceof JSONArray) {
                this.initTaskSubjectEntryEntity((JSONArray)value);
            }
        }
    }

    private void wrapComboEditItems() {
        Object isShowOtherSubjectTiming = this.getView().getFormShowParameter().getCustomParam("showothersubjecttiming");
        if (isShowOtherSubjectTiming != null && !((Boolean)isShowOtherSubjectTiming).booleanValue()) {
            ComboEdit subjectTiming = (ComboEdit)this.getControl(SUBJECT_TIMING);
            ComboProp property = (ComboProp)subjectTiming.getProperty();
            List items = property.getComboItems();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                if ("coordinate".equals(((ValueMapItem)items.get(i)).getValue())) continue;
                ComboItem item = new ComboItem(((ValueMapItem)items.get(i)).getName(), ((ValueMapItem)items.get(i)).getValue(), ((ValueMapItem)items.get(i)).getImageKey());
                comboItems.add(item);
            }
            subjectTiming.setComboItems(comboItems);
        }
    }

    private void initBillSubject(String openType, Object value) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SUBJECT_TIMING});
        if ("customsubject_mob".equals(this.getView().getFormShowParameter().getCustomParams().get("subjecttype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SUBJECT_SCENE});
        }
        Label label = (Label)this.getControl("title");
        Object title = this.getView().getFormShowParameter().getCustomParam("title");
        if (title instanceof String) {
            label.setText(title + "");
        }
        if (WfUtils.isNotEmpty((String)((String)value))) {
            if (((String)value).startsWith("[") && ((String)value).endsWith("]")) {
                try {
                    this.initBillSubjectEntryEntity(value);
                }
                catch (Exception ex) {
                    this.initSubjectEntryEntityForOld(openType, value);
                }
            } else {
                this.initSubjectEntryEntityForOld(openType, value);
            }
        }
    }

    private void initTaskSubjectEntryEntity(JSONArray subjectsArray) {
        if (subjectsArray != null && subjectsArray.size() > 0) {
            this.getModel().batchCreateNewEntryRow(SUBJECT, subjectsArray.size());
            int i = 0;
            for (Object subjectObject : subjectsArray) {
                JSONObject subject = (JSONObject)subjectObject;
                this.getModel().setValue(SUBJECT_TIMING, subject.get((Object)SUBJECT_TIMING), i);
                JSONObject subjectRule = (JSONObject)subject.get((Object)SUBJECT_RULE);
                if (subjectRule != null && !subjectRule.isEmpty()) {
                    this.getModel().setValue(SUBJECT_RULE, (Object)subjectRule, i);
                    this.getModel().setValue(SV_SUBJECT_RULE, ((JSONObject)subjectRule.get((Object)"showtext")).get((Object)Lang.get().toString()), i);
                }
                this.getModel().setValue(SUBJECT_TYPE, subject.get((Object)SUBJECT_TYPE), i);
                this.getModel().setValue(SUBJECT_CONTENT, subject.get((Object)SUBJECT_CONTENT_XML), i);
                this.getModel().setValue("id", subject.get((Object)"id"), i);
                ++i;
            }
        }
    }

    private void initBillSubjectEntryEntity(Object value) {
        JSONArray subjectArray = (JSONArray)SerializationUtils.fromJsonString((String)((String)value), JSONArray.class);
        if (subjectArray != null && subjectArray.size() > 0) {
            this.getModel().batchCreateNewEntryRow(SUBJECT, subjectArray.size());
            int i = 0;
            for (Object subjectObject : subjectArray) {
                HashMap subject = (HashMap)subjectObject;
                Object subjectRule = subject.get(SUBJECT_RULE);
                if (WfUtils.isNotEmptyString(subjectRule)) {
                    if (subjectRule instanceof String) {
                        this.getModel().setValue(SUBJECT_RULE, subjectRule, i);
                    } else {
                        this.getModel().setValue(SUBJECT_RULE, (Object)SerializationUtils.toJsonString(subjectRule), i);
                    }
                }
                this.getModel().setValue(SV_SUBJECT_RULE, subject.get(SV_SUBJECT_RULE), i);
                this.getModel().setValue(SUBJECT_TYPE, subject.get(SUBJECT_TYPE), i);
                this.getModel().setValue(SUBJECT_CONTENT, subject.get(SUBJECT_CONTENT_XML), i);
                if (StringUtils.isNotBlank(subject.get(SUBJECT_SCENE))) {
                    this.getModel().setValue(SUBJECT_SCENE, subject.get(SUBJECT_SCENE), i);
                } else {
                    this.getModel().setValue(SUBJECT_SCENE, (Object)"task", i);
                }
                ++i;
            }
        }
    }

    private void initSubjectEntryEntityForOld(String openType, Object value) {
        this.getModel().batchCreateNewEntryRow(SUBJECT, 1);
        if (DESIGNER.equals(openType)) {
            this.getModel().setValue(SUBJECT_TIMING, (Object)"normal", 0);
        }
        this.getModel().setValue(SUBJECT_TYPE, (Object)EXPRESSION, 0);
        this.getModel().setValue(SUBJECT_CONTENT, (Object)((String)value), 0);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "sv_rule": {
                this.showRule(SUBJECT, SV_SUBJECT_RULE);
                break;
            }
            case "customsubject": {
                this.showContent();
                break;
            }
            case "confirm": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void showRule(String entryId, String actionId) {
        int focusRow = this.getEntryEntityFocusRow(entryId);
        Map showParams = this.getView().getFormShowParameter().getCustomParams();
        String openType = (String)showParams.get(PARAM_OPEN_TYPE);
        String value = (String)this.getModel().getValue(SUBJECT_RULE, focusRow);
        JSONObject conditionRule = null;
        if (!WfUtils.isEmpty((String)value)) {
            conditionRule = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
        }
        ConditionalRuleType type = DESIGNER.equals(openType) ? ConditionalRuleType.taskSubjectRule : ConditionalRuleType.billSubjectRule;
        String typeStr = type.toString();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(SUBJECT_TYPE, typeStr);
        context.put("property", SUBJECT_RULE);
        if (DESIGNER.equals(openType)) {
            context.put("model", (String)showParams.get(PARAM_MODEL_JSON));
            HashMap<String, String> nodeProperties = new HashMap<String, String>();
            nodeProperties.put("itemId", (String)showParams.get("itemId"));
            context.put("nodeProperties", nodeProperties);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("context", context);
        customParams.put("needSourceElement", showParams.get("needSourceElement"));
        customParams.put(PARAM_VALUE, conditionRule != null ? conditionRule.toJSONString() : null);
        if (BILLATTRIBUTE.equals(openType)) {
            customParams.put(PARAM_OPEN_TYPE, "billRule");
            customParams.put(PARAM_ENTITY_ID, showParams.get(PARAM_ENTITY_ID));
            customParams.put(PARAM_ENTITY_NUMBER, showParams.get(PARAM_ENTITY_NUMBER));
        }
        String typeName = ConditionalRuleType.getTypeName((String)typeStr);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        parameter.setFormId("wf_conditionrule_update");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setCaption(typeName);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private int getEntryEntityFocusRow(String entryId) {
        EntryGrid grid = (EntryGrid)this.getControl(entryId);
        return grid.getEntryState().getFocusRow();
    }

    private void showContent() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        int focusRow = this.getEntryEntityFocusRow(SUBJECT);
        String type = (String)this.getModel().getValue(SUBJECT_TYPE, focusRow);
        if (EXPRESSION.equals(type)) {
            this.showCustomSubject(params, focusRow);
        } else {
            this.showPlugin(params, focusRow);
        }
    }

    private void showCustomSubject(Map<String, Object> showParams, int focusRow) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String entityNumber = "";
        String caption = "";
        String openType = (String)showParams.get(PARAM_OPEN_TYPE);
        if (DESIGNER.equals(openType)) {
            String stencilType = (String)showParams.get("stencilType");
            JSONObject properties = (JSONObject)showParams.get("properties");
            JSONObject processProps = (JSONObject)showParams.get("processProps");
            entityNumber = BpmnModelUtil.instanceofUserTask((String)stencilType) ? ("BillTask".equals(stencilType) ? (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "sourceEntityNumber") : (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, PARAM_ENTITY_NUMBER)) : (String)processProps.get((Object)"entraBill");
            caption = ResManager.loadKDString((String)"\u4efb\u52a1\u4e3b\u9898\u5185\u5bb9", (String)"WorkflowTaskSubjectPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            params.put(PARAM_MODEL_JSON, (String)showParams.get(PARAM_MODEL_JSON));
        } else {
            entityNumber = (String)showParams.get(PARAM_ENTITY_NUMBER);
            caption = ResManager.loadKDString((String)"\u5355\u636e\u4e3b\u9898\u5185\u5bb9", (String)"WorkflowTaskSubjectPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        params.put(PARAM_ENTITY_NUMBER, entityNumber);
        params.put("FROM", "MSG");
        if (focusRow > -1) {
            String value = (String)this.getModel().getValue(SUBJECT_CONTENT, focusRow);
            if (WfUtils.isNotEmpty((String)value)) {
                params.put(PARAM_VALUE, value);
            }
            this.showForm(SUBJECT_CONTENT, "wf_billsubject_light", caption, params);
        }
    }

    private void showPlugin(Map<String, Object> params, int focusRow) {
        HashMap<String, String> data = new HashMap<String, String>();
        String value = (String)this.getModel().getValue(SUBJECT_CONTENT, focusRow);
        data.put(PARAM_VALUE, value);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "externalInterface"));
        parameter.setFormId("wf_external_interface");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss style = new StyleCss();
        style.setWidth("780");
        style.setHeight("480");
        parameter.getOpenStyle().setInlineStyleCss(style);
        parameter.setCustomParam("showButtonPanel", (Object)Boolean.TRUE);
        String entityId = "";
        String openType = (String)params.get(PARAM_OPEN_TYPE);
        if (DESIGNER.equals(openType)) {
            JSONObject properties = (JSONObject)params.get("properties");
            entityId = properties.getString(PARAM_ENTITY_ID);
        } else {
            entityId = (String)params.get(PARAM_ENTITY_ID);
        }
        parameter.setCustomParam(PARAM_ENTITY_ID, (Object)entityId);
        parameter.setCustomParam("data", data);
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
        parameter.setCustomParam("types", (Object)types);
        this.getView().showForm(parameter);
    }

    private void returnDataToParent() {
        Map showParams = this.getView().getFormShowParameter().getCustomParams();
        String openType = (String)showParams.get(PARAM_OPEN_TYPE);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        DynamicObjectCollection billSubjects = this.getModel().getEntryEntity(SUBJECT);
        if (billSubjects != null && !billSubjects.isEmpty()) {
            switch (openType) {
                case "designer": {
                    this.returnDataForTaskSubject(returnData, billSubjects);
                    break;
                }
                case "billAttribute": {
                    this.returnDataForBillSubject(returnData, billSubjects);
                    break;
                }
            }
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void returnDataForTaskSubject(Map<String, Object> returnData, DynamicObjectCollection billSubjects) {
        String subjectShowtext = (String)((DynamicObject)billSubjects.get(0)).get(SUBJECT_CONTENT);
        returnData.put("subjectShowtext", subjectShowtext);
        ArrayList taskSubjectList = new ArrayList();
        for (DynamicObject taskSubject : billSubjects) {
            HashMap<String, Object> taskSubjectMap = new HashMap<String, Object>();
            String id = taskSubject.getString("id");
            if (WfUtils.isEmpty((String)id) || "0".equals(id)) {
                id = BpmnDiffUtil.getListElementId((String)SUBJECT);
            }
            taskSubjectMap.put("id", id);
            taskSubjectMap.put(SUBJECT_TIMING, taskSubject.get(SUBJECT_TIMING));
            String subjectRule = (String)taskSubject.get(SUBJECT_RULE);
            if (WfUtils.isNotEmpty((String)subjectRule)) {
                taskSubjectMap.put(SUBJECT_RULE, SerializationUtils.fromJsonString((String)subjectRule, Map.class));
            }
            taskSubjectMap.put(SUBJECT_TYPE, taskSubject.get(SUBJECT_TYPE));
            taskSubjectMap.put(SUBJECT_CONTENT_XML, taskSubject.get(SUBJECT_CONTENT));
            taskSubjectList.add(taskSubjectMap);
        }
        returnData.put("taskSubject", taskSubjectList);
    }

    private void returnDataForBillSubject(Map<String, Object> returnData, DynamicObjectCollection billSubjects) {
        String sample = "";
        for (DynamicObject billSubject : billSubjects) {
            String subjectType = billSubject.getString(SUBJECT_TYPE);
            String subjectContent = billSubject.getString(SUBJECT_CONTENT);
            if (!EXPRESSION.equals(subjectType) || !WfUtils.isNotEmpty((String)subjectContent)) continue;
            sample = billSubject.getString(SUBJECT_CONTENT);
            break;
        }
        String billSubjectName = "";
        ArrayList billSubjectList = new ArrayList();
        for (DynamicObject billSubject : billSubjects) {
            HashMap<String, String> billSubjectMap = new HashMap<String, String>();
            String type = billSubject.getString(SUBJECT_TYPE);
            billSubjectMap.put(SUBJECT_TYPE, type);
            billSubjectMap.put(SV_SUBJECT_RULE, billSubject.getString(SV_SUBJECT_RULE));
            String customsubject = (String)billSubject.get(SUBJECT_CONTENT);
            billSubjectMap.put(SUBJECT_CONTENT_XML, customsubject);
            String subjectRule = billSubject.getString(SUBJECT_RULE);
            billSubjectMap.put(SUBJECT_RULE, subjectRule);
            if (WfUtils.isEmpty((String)billSubjectName) && WfUtils.isNotEmpty((String)customsubject)) {
                billSubjectName = customsubject;
            }
            String subjectScene = billSubject.getString(SUBJECT_SCENE);
            billSubjectMap.put(SUBJECT_SCENE, subjectScene);
            billSubjectList.add(billSubjectMap);
        }
        returnData.put("subjectShowname", billSubjectName);
        returnData.put("billSubject", billSubjectList);
        returnData.put("sample", sample);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        switch (propertyName) {
            case "type": {
                this.getModel().setValue(SUBJECT_CONTENT, null, rowIndex);
                break;
            }
            case "sv_rule": {
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                this.getModel().setValue(SUBJECT_RULE, null, rowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "sv_rule": {
                this.updateRule(returnData);
                break;
            }
            case "customsubject": 
            case "externalInterface": {
                this.setContent(SUBJECT, returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void updateRule(Object returnData) {
        int focusRow = this.getEntryEntityFocusRow(SUBJECT);
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (data.isEmpty()) {
                this.getModel().setValue(SV_SUBJECT_RULE, null, focusRow);
                this.getModel().setValue(SUBJECT_RULE, null, focusRow);
                return;
            }
            if (focusRow > -1) {
                Object showTextObject = data.get("showtext");
                if (showTextObject != null) {
                    String lang = RequestContext.get().getLang().toString();
                    String subjectRuleSV = (String)((Map)showTextObject).get(lang);
                    this.getModel().setValue(SV_SUBJECT_RULE, (Object)subjectRuleSV, focusRow);
                }
                this.getModel().setValue(SUBJECT_RULE, (Object)SerializationUtils.toJsonString((Object)data), focusRow);
            }
        }
    }

    private void setContent(String entryId, Object returnData) {
        int focusRow = this.getEntryEntityFocusRow(entryId);
        String content = "";
        if (returnData instanceof Map) {
            Map customSubject = (Map)returnData;
            content = (String)customSubject.get(SUBJECT_CONTENT_XML);
        } else if (returnData instanceof String) {
            content = (String)returnData;
        }
        if (focusRow > -1) {
            this.getModel().setValue(SUBJECT_CONTENT, (Object)content, focusRow);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String key = e.getEntryProp().getName();
        RowDataEntity data = e.getRowDataEntities()[0];
        switch (key) {
            case "subject": {
                data.getDataEntity().set("id", (Object)BpmnDiffUtil.getListElementId((String)SUBJECT));
                break;
            }
        }
        super.afterAddRow(e);
    }
}

