/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowTripReqListPlugin
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String APPLY_DATE = "applydate";

    public void initialize() {
        this.addClickListeners(new String[]{"addnew", "addnew1"});
        this.addClickListeners(new String[]{"viewFlowchart"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"editap"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String formId = null;
        if ("viewFlowchart".equalsIgnoreCase(c.getKey())) {
            this.viewFlowchart();
            return;
        }
        boolean insert = "addnew".equalsIgnoreCase(c.getKey());
        if ("addnew".equalsIgnoreCase(c.getKey()) || "editap".equalsIgnoreCase(c.getKey())) {
            formId = "wf_tripreqbill_edit";
        } else if ("addnew1".equalsIgnoreCase(c.getKey())) {
            formId = "wf_tripreimbursebill";
        }
        BillShowParameter parameter = new BillShowParameter();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length > 0) {
            int row = rows[0];
            String id = (String)this.getModel().getValue("id", row);
            if (id != null) {
                parameter.setPkId((Object)id);
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setBillStatus(BillOperationStatus.EDIT);
            }
        } else if (!insert) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "refreshwindow");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("refreshwindow".equals(e.getActionId())) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.createNewData();
            this.getView().updateView();
            model.endInit();
        }
    }

    public void afterCreateNewData(EventObject evt) {
        this.renderListTable();
    }

    private void renderListTable() {
        ORM orm = ORM.create();
        String sql = "id, billno, applier, applydate, applyphone, reason, billstatus, applyway";
        DynamicObjectCollection doc = orm.query("wf_tripreqbill_edit", sql, new QFilter[0]);
        IDataModel model = this.getModel();
        if (doc.size() > 0) {
            model.batchCreateNewEntryRow("entryentity", doc.size());
            for (int i = 0; i < doc.size(); ++i) {
                DynamicObject obj = (DynamicObject)doc.get(i);
                model.setValue("id", obj.get("id"), i);
                model.setValue("applynumber", obj.get("billno"), i);
                model.setValue("applier", obj.get("applier"), i);
                if (obj.get(APPLY_DATE) != null) {
                    model.setValue(APPLY_DATE, obj.get(APPLY_DATE), i);
                }
                model.setValue("applyphone", obj.get("applyphone"), i);
                model.setValue("reason", obj.get("reason"), i);
                model.setValue("billstatus", obj.get("billstatus"), i);
                model.setValue("applyway", obj.get("applyway"), i);
            }
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    private Map<String, String> getCurrentSelector() {
        HashMap<String, String> sel = new HashMap<String, String>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int row = grid.getEntryState().getFocusRow();
        if (row >= 0) {
            sel.put("id", (String)this.getModel().getValue("id", row));
        }
        return sel;
    }

    private void openProcessSelectWindow(List<Map<String, Object>> process, String busKey, String operation) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("wf_processselect");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("process", process);
        para.setCustomParam("busKey", (Object)busKey);
        para.setCustomParam("operation", (Object)operation);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "processselect"));
        this.getView().showForm(para);
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    public void viewFlowchart() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length == 1) {
            String businessKey = (String)this.getModel().getValue("id", rows[0]);
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            Long procInstId = wfService.getRuntimeService().getProcInstIdByBusKey(businessKey);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wf_viewflowchart");
            parameter.setClientParam("procInstId", (Object)procInstId);
            parameter.getOpenStyle().setShowType(ShowType.NonModal);
            this.getView().showForm(parameter);
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }
}

