/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.workflow.api.NodeTemplate;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.plugin.model.StencilUIConfig;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.util.NodeTemplateLibraryUtil;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import org.apache.commons.lang.BooleanUtils;

public class WorkflowUsertaskPropConfPlugin
extends AbstractWorkflowConfigurePlugin
implements TabSelectListener {
    protected static final String NUMBER = "number";
    private final String ENTITY_NUMBER = "entityNumber";
    private final String ENTITY_NAME = "entityName";
    private final String ENTITY_ID = "entityId";
    private final String FORMKEY = "formkey";
    private final String MOBILFORMKEY = "mobilformkey";
    protected final String PARTICIPANT_OPERATION = "participant_operation";
    protected final String OPERATIONKEY = "operationKey";
    private final String DECISION_OPTIONS = "decisionOptions";
    protected final String OPERATION = "operation";
    private final String TAB_PLUGIN = "tab_plugin";
    private final String TAB_MESSAGE = "tab_msg";
    private final String TAB_NODE_CONTROL = "tab_nodecontrol";
    private final String TAB_BASIC_INFO = "tabpageap";
    private final String TAB_EXTENDEDATTRIBUTES = "tab_extendedattributes";
    private final String PLUGINS_PANEL = "task_plugins_panel";
    private final String MESSAGE_PANEL = "task_msg_panel";
    private final String NODE_CONTROL_PANEL = "task_nodecontrol_panel";
    private final String BASIC_INFO_PANEL = "task_basicinfo_panel";
    private final String EXPEND_PANEL = "task_expend_panel";
    private final String KEY_PLUGINS_PAGEID = "plugins_pageId";
    private final String KEY_MESSAGE_PAGEID = "message_pageId";
    private final String KEY_NODE_CONTROL_PAGEID = "node_control_pageId";
    private final String KEY_BASIC_INFO_PAGEID = "basic_info_pageId";
    private final String KEY_EXPEND_INFO_PAGEID = "expend_info_pageid";
    private final String OPERATION_DECISION_VALUE = "operation_decision_value";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty("participant_entryentity", "entryentity_condition", "radiogroup_participant", "participant_logicsignal", "participant_condition", "participant_picture", "participant_showvalue", "participant_showvaluepre", "displayinfo");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"participant_operation"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.stencilType == null) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getFormShowParameter() != null && "wf_nodeconfigview".equals(parentView.getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        try {
            this.beginInit();
            super.afterCreateNewData(e);
            JSONObject properties = this.getCellProperties();
            this.initEntityInfo(properties);
            this.initFormKeyAndMobileFormKey(properties);
            this.initOperationOrDecisionInfo(properties);
            this.processingCompatibility(properties);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            if ("wf_processconfig_scheme".equals(parameter.getCustomParam("designer_formId")) || "wf_nodeconfigview".equals(parameter.getCustomParam("designer_formId"))) {
                this.initControlInScheme(parameter);
            }
            this.initDefaultTab();
            BizFlowPluginUtil.addOrUpdateStartItemEntity(this.getModelType(), this.getIdeFormView(), properties);
            List<NodeTemplate> nodeTemplateExpendDatas = NodeTemplateLibraryUtil.getExtendNodeTemplateBystencilType(this.stencilType);
            if (nodeTemplateExpendDatas == null || nodeTemplateExpendDatas.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tab_extendedattributes"});
            }
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowUsertaskPropConfPlugin.class);
        }
    }

    protected void initDefaultTab() {
        StencilUIConfig uiConfig = DesignerModelUtil.getStencilUIConfig(this.stencilType);
        String tabKey = null;
        if ("BillTask".equalsIgnoreCase(this.stencilType)) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("tab_participant");
            this.tabSelected(new TabSelectEvent((Object)tab, "tab_participant"));
        } else if (uiConfig != null && WfUtils.isNotEmpty((String)(tabKey = (String)uiConfig.getOption("defaultTab")))) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(tabKey);
            this.tabSelected(new TabSelectEvent((Object)tab, tabKey));
        }
    }

    @Override
    protected void initPropertyValue(StencilProperty property, Control control, JSONObject properties, String propName, List<Object> updateProperties, Map<String, Object> isvPropsConfig) {
        String key;
        switch (key = property.getPropertyName().toLowerCase(Locale.getDefault())) {
            case "participant_entryentity": 
            case "entryentity_condition": 
            case "radiogroup_participant": 
            case "participant_logicsignal": 
            case "participant_condition": 
            case "participant_picture": 
            case "participant_showvalue": 
            case "participant_showvaluepre": 
            case "displayinfo": {
                break;
            }
            default: {
                super.initPropertyValue(property, control, properties, propName, updateProperties, isvPropsConfig);
            }
        }
    }

    private void initFormKeyAndMobileFormKey(JSONObject properties) {
        String mobilFormKey;
        String entityId = properties.getString("entityId");
        String formKey = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.formKey");
        if (WfUtils.isEmpty((String)formKey) && (formKey = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "formKey")) != null) {
            this.deleteProperty("formKey");
        }
        if (WfUtils.isEmpty((String)(mobilFormKey = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.mobilFormKey"))) && (mobilFormKey = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "mobilFormKey")) != null) {
            this.deleteProperty("mobilFormKey");
        }
        Map billPages = null;
        if (WfUtils.isEmpty((String)formKey)) {
            billPages = BillPagePluginUtil.getBillPagesForPC(null, (String)entityId);
            formKey = (String)billPages.get("selectedvalue");
        }
        if (WfUtils.isEmpty((String)mobilFormKey)) {
            String entityName = properties.getString("entityName");
            String entityNumber = properties.getString("entityNumber");
            if (billPages == null) {
                billPages = BillPagePluginUtil.getBillPagesForPC(null, (String)entityId);
            }
            billPages = BillPagePluginUtil.getBillPagesForMob((String)this.stencilType, (String)formKey, null, (String)entityId, (String)entityNumber, (String)entityName, (List)((List)billPages.get("dataitems")));
            mobilFormKey = (String)billPages.get("selectedvalue");
        }
        this.setProperties(properties, new Object[]{"formkey", formKey, "mobilformkey", mobilFormKey});
    }

    protected void initControlInScheme(FormShowParameter parameter) {
        try {
            BpmnModel bpmnModel;
            UserTask firstUser;
            String modelJson = this.getModelJsonString();
            if ("UserTask".equals(this.stencilType) && (firstUser = BpmnModelUtil.getFirstUserTask((Process)(bpmnModel = DesignerModelUtil.getBpmnModel(modelJson)).getMainProcess())) != null) {
                this.getView().setEnable(Boolean.valueOf(!this.itemId.equals(firstUser.getId())), new String[]{"participant_operation"});
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a7\u4ef6\u72b6\u6001\u521d\u59cb\u5316\u6a21\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"WorkflowUsertaskPropConfPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void initOperationOrDecisionInfo(JSONObject properties) {
        String operationOrDecisionName = this.getOperationOrDecision(properties);
        this.getModel().setValue("participant_operation", (Object)operationOrDecisionName);
    }

    protected String getOperationOrDecision(JSONObject properties) {
        String operationName = null;
        Object entityId = DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityId");
        Object value = DesignerModelUtil.getProperty((Map<String, Object>)properties, "operation");
        Object decisionOptions = DesignerModelUtil.getProperty((Map<String, Object>)properties, "decisionOptions");
        if (null != entityId) {
            if (null == value) {
                value = decisionOptions;
            }
            String operationKey = null;
            try {
                List valueList = (List)value;
                operationName = BillPagePluginUtil.getOperationInfosFromReturnValues((Object)valueList, (String)"name");
                operationKey = BillPagePluginUtil.getOperationInfosFromReturnValues((Object)valueList, (String)NUMBER);
            }
            catch (Exception e) {
                operationName = WfUtils.getOperationName((String)((String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityNumber")), (String)((String)value));
                operationKey = value.toString();
                JSONArray array = new JSONArray();
                JSONObject decision = new JSONObject();
                decision.put(NUMBER, (Object)operationKey);
                decision.put("name", (Object)operationName);
                array.add((Object)decision);
                this.setProperty("decisionOptions", array);
                this.deleteProperty("operation");
            }
            this.getPageCache().put("operationKey", operationKey);
        }
        return operationName;
    }

    protected void processingCompatibility(JSONObject properties) {
        Object control = DesignerModelUtil.getProperty((Map<String, Object>)properties, "control");
        if (control != null && this.stencilType.equals("UserTask")) {
            this.deleteProperty("control");
        }
    }

    protected void initEntityInfo(JSONObject properties) {
        Object entityId = DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityId");
        if (entityId != null && !entityId.toString().startsWith("$")) {
            return;
        }
        JSONObject processProps = this.getProcessProperties();
        entityId = processProps.get((Object)"entraBillId");
        if (entityId == null) {
            this.log.debug("NodeTemplate,There is't entityId");
            return;
        }
        String entityName = processProps.getString("entraBillName");
        String entityNumber = processProps.getString("entraBill");
        this.setProperties(properties, new Object[]{"entityId", entityId, "entityName", entityName, "entityNumber", entityNumber});
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if ("participant_operation".equals(propName)) {
            this.operationOrDecisionChanged(propName, newValue, oldValue, rowIndex);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    protected void operationOrDecisionChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty("decisionOptions", null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "participant_operation": {
                this.cacheOperOrDecisionValue();
                this.showOperationOrDecisionPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if (this.getCellProperties() == null) {
            this.showInitErrorMessage(null);
            return;
        }
        switch (key) {
            case "tab_plugin": {
                this.loadTaskPluginsPage();
                break;
            }
            case "tab_msg": {
                this.loadMessagePage();
                break;
            }
            case "tab_nodecontrol": {
                this.loadNodeControlPage();
                break;
            }
            case "tabpageap": {
                this.loadBasicInfoPage();
                break;
            }
            case "tab_extendedattributes": {
                this.loadExpendAttributesPage();
                break;
            }
        }
    }

    private void loadExpendAttributesPage() {
        String pageId = this.getPageCache().get("expend_info_pageid");
        if (pageId == null) {
            pageId = this.showFormInTabContainer(this.getExpendInfoFormId(), "task_expend_panel");
            this.getPageCache().put("expend_info_pageid", pageId);
        }
    }

    protected String getExpendInfoFormId() {
        return "wf_expendinfo_configure";
    }

    protected void showOperationOrDecisionPage() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        super.showOperationPage(this.getCellProperties(), parameter, Boolean.TRUE, this.getPageCache().get("operationKey"), "operation");
    }

    protected void loadBasicInfoPage() {
        String pageId = this.getPageCache().get("basic_info_pageId");
        if (pageId == null) {
            pageId = this.showFormInTabContainer(this.getBasicInfoFormId(), "task_basicinfo_panel");
            this.getPageCache().put("basic_info_pageId", pageId);
        } else {
            this.handleIfRefresh(pageId);
        }
    }

    private void handleIfRefresh(String pageId) {
        String isRefresh = this.getPageCache().get("basicInfoRefresh");
        if (!BooleanUtils.toBoolean((String)isRefresh)) {
            return;
        }
        this.getView().getView(pageId).close();
        this.getPageCache().remove("basicInfoRefresh");
        pageId = this.showFormInTabContainer(this.getBasicInfoFormId(), "task_basicinfo_panel");
        this.getPageCache().put("basic_info_pageId", pageId);
    }

    protected String getBasicInfoFormId() {
        return "wf_basicinfo_configure";
    }

    protected void loadNodeControlPage() {
        String pageId = this.getPageCache().get("node_control_pageId");
        if (pageId == null) {
            pageId = this.showFormInTabContainer(this.getNodeControlFormId(), "task_nodecontrol_panel");
            this.getPageCache().put("node_control_pageId", pageId);
        }
    }

    protected String getNodeControlFormId() {
        return "wf_nodecontrol_configure";
    }

    protected void loadTaskPluginsPage() {
        String pageId = this.getPageCache().get("plugins_pageId");
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_task_plugins", "task_plugins_panel");
            this.getPageCache().put("plugins_pageId", pageId);
        }
    }

    protected void loadMessagePage() {
        String pageId = this.getPageCache().get("message_pageId");
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_msgnotify_configure", "task_msg_panel");
            this.getPageCache().put("message_pageId", pageId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("operation".equals(actionId)) {
            this.setCloseDataForOperation(returnData);
        } else {
            super.closedCallBack(evt);
        }
    }

    private void setCloseDataForOperation(Object returnData) {
        if (returnData instanceof List) {
            int maxSize = 300;
            boolean overlength = false;
            List operations = (List)returnData;
            ArrayList<Map> data = new ArrayList<Map>(operations.size());
            if (!operations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map tmp : operations) {
                    sb.append(tmp.get(NUMBER));
                    if (sb.length() > maxSize) {
                        overlength = true;
                        break;
                    }
                    tmp.put("id", BpmnDiffUtil.getListElementId((String)"decisionOptions"));
                    data.add(tmp);
                    sb.append(",");
                }
            }
            this.getModel().setValue("participant_operation", (Object)BillPagePluginUtil.getOperationInfosFromReturnValues(data, (String)"name"));
            this.setProperty("decisionOptions", data);
            this.getPageCache().put("operationKey", BillPagePluginUtil.getOperationInfosFromReturnValues(data, (String)NUMBER));
            this.closePluginViewIfNecessary();
            String entityNumber = (String)this.getCellProperties().get((Object)"entityNumber");
            BizFlowPluginUtil.updateStartItemOperation(this.getModelType(), entityNumber, this.getIdeFormView(), data);
            if (overlength) {
                this.getView().showTipNotification(WFMultiLangConstants.getOperationOverlengthTip());
            }
        }
    }

    protected void cacheOperOrDecisionValue() {
        String value = (String)this.getModel().getValue("participant_operation");
        this.getPageCache().put("operation_decision_value", value);
    }

    protected void closePluginViewIfNecessary() {
        String value = this.getPageCache().get("operation_decision_value");
        if (WfUtils.isNotEmpty((String)value) && value.equals(this.getModel().getValue("participant_operation"))) {
            return;
        }
        String pageId = this.getPageCache().get("plugins_pageId");
        IFormView pluginView = null;
        if (WfUtils.isNotEmpty((String)pageId) && (pluginView = this.getView().getView(pageId)) != null) {
            this.getPageCache().remove("plugins_pageId");
            pluginView.close();
            this.getView().sendFormAction(pluginView);
        }
    }

    public void customEvent(CustomEventArgs e) {
        if ("updateOperation".equals(e.getEventName())) {
            String value = "";
            String SUBMIT = "submit";
            ArrayList data = null;
            try {
                Map operation = EntityMetadataCache.getDataEntityOperate((String)e.getEventArgs(), (String)"submit");
                if (operation != null && !operation.isEmpty()) {
                    value = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"WorkflowUsertaskPropConfPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    data = new ArrayList();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", value);
                    map.put(NUMBER, "submit");
                    map.put("id", BpmnDiffUtil.getListElementId((String)"decisionOptions"));
                    data.add(map);
                }
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage());
            }
            this.getModel().setValue("participant_operation", (Object)value);
            this.setProperty("decisionOptions", data);
            this.getPageCache().put("operationKey", BillPagePluginUtil.getOperationInfosFromReturnValues(data, (String)NUMBER));
            ((IFormView)e.getSource()).sendFormAction(this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("decisionOptions");
        this.getPageCache().remove("operationKey");
        this.getPageCache().remove("plugins_pageId");
        this.getPageCache().remove("message_pageId");
        this.getPageCache().remove("node_control_pageId");
        this.getPageCache().remove("basic_info_pageId");
        this.getPageCache().remove("operation_decision_value");
        this.getPageCache().remove("expend_info_pageid");
    }
}

