/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ExtItfPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowValidationExtItfPlugin
extends AbstractWorkflowPlugin {
    private static final String BUTTON_CONFIRM = "btnok";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_OPERATIONVALUE = "operationvalue";
    private static final String PANEL_EXTITF = "panel_extitf";
    private static final String PANEL_TYPE = "panel_type";
    private static final String PANEL_OPERATION = "panel_operation";
    private static final String EXTITF_PANEL_TYPE = "typepanel";
    private static final String EXTITF_FIELD_TYPE = "typefield";
    private static final String KEY_OPERATION = "operation";
    private static final int MAX_LENGTH = 245;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CONFIRM});
        TextEdit operation = (TextEdit)this.getControl("operation");
        operation.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entityId = (String)showParameter.getCustomParam("entityId");
        String entityNumber = (String)showParameter.getCustomParam("entityNumber");
        String value = (String)showParameter.getCustomParam("value");
        boolean isOperation = false;
        String type = "operation";
        if (!ExternalInterfaceUtil.isValidValue((String)value)) {
            isOperation = true;
            this.initOperationControl(entityNumber, value);
            value = null;
        } else {
            type = ExternalInterfaceUtil.getExtItfType((String)value);
        }
        this.getModel().setValue(FIELD_TYPE, (Object)type);
        this.openExtItfPageInContainer(entityId, value);
        this.switchPanelVisible(isOperation);
    }

    private void initOperationControl(String entityNumber, String value) {
        if (WfUtils.isEmpty((String)value)) {
            return;
        }
        this.getModel().setValue("operation", (Object)WfUtils.getOperationName((String)entityNumber, (String)value));
        this.getModel().setValue(FIELD_OPERATIONVALUE, (Object)value);
    }

    private void openExtItfPageInContainer(String entityId, String value) {
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
        IFormView view = this.getView();
        view.getFormShowParameter().setCustomParam("hideParameterConfig", (Object)Boolean.TRUE);
        String pageId = DesignerPluginUtil.openExtItfInContainer(view, (IFormPlugin)this, types, entityId, value, PANEL_EXTITF);
        this.getPageCache().put("pageId", pageId);
        IFormView subView = this.getView().getView(pageId);
        subView.setVisible(Boolean.FALSE, new String[]{EXTITF_PANEL_TYPE});
        this.getView().sendFormAction(subView);
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_TYPE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        if (FIELD_TYPE.equals(propName)) {
            this.switchType((String)newValue);
        }
    }

    private void switchType(String newValue) {
        boolean isOperation = "operation".equals(newValue);
        this.switchPanelVisible(isOperation);
        if (!isOperation) {
            String pageId = this.getPageCache().get("pageId");
            IFormView subView = this.getView().getView(pageId);
            subView.getModel().setValue(EXTITF_FIELD_TYPE, (Object)newValue);
            this.getView().sendFormAction(subView);
        }
    }

    private void switchPanelVisible(boolean isOperation) {
        this.getView().setVisible(Boolean.valueOf(!isOperation), new String[]{PANEL_EXTITF});
        this.getView().setVisible(Boolean.valueOf(isOperation), new String[]{PANEL_OPERATION});
    }

    public void click(EventObject evt) {
        String key;
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey().toLowerCase()) {
            case "btnok": {
                this.confirm();
                break;
            }
            case "operation": {
                this.openOperationPage();
            }
        }
    }

    private void confirm() {
        String value = null;
        String type = (String)this.getModel().getValue(FIELD_TYPE);
        if (!"operation".equals(type)) {
            value = ExtItfPluginUtil.invokeConfirmMethod(this.getView(), this.getPageCache().get("pageId"), new Object[]{this.getView()});
            if (WfUtils.isEmpty((String)value)) {
                return;
            }
        } else {
            value = (String)this.getModel().getValue(FIELD_OPERATIONVALUE);
            if (WfUtils.isEmpty((String)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowValidationExtItfPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().returnDataToParent((Object)value);
        this.getView().close();
    }

    private void openOperationPage() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        HashMap<String, String> processProperties = new HashMap<String, String>();
        processProperties.put("entraBill", entityNumber);
        HashMap<String, HashMap<String, String>> context = new HashMap<String, HashMap<String, String>>();
        context.put("processProperties", processProperties);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("context", context);
        params.put("selchexkbox", false);
        params.put("optionalActions", this.getView().getFormShowParameter().getCustomParam("optionalActions"));
        FormShowParameter showParameter = this.getShowParameter("operation", "wf_formoperation");
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("operation".equals(actionId)) {
            this.operationClosedCallBack(returnData);
        }
    }

    private void operationClosedCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String name = (String)data.get("name");
            String number = (String)data.get("number");
            if (!number.matches("[a-zA-Z_\\d]+")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u7f16\u7801\u5fc5\u987b\u662f\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\uff0c\u60a8\u9009\u62e9\u7684\u662f\uff1a%1s\uff08%2s\uff09\u3002", (String)"WorkflowValidationExtItfPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), name, number), Integer.valueOf(6000));
                return;
            }
            this.getModel().setValue("operation", (Object)name);
            this.getModel().setValue(FIELD_OPERATIONVALUE, (Object)number);
        }
    }
}

