/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.component.ApprovalRecord;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.bos.workflow.design.plugin.WorkflowViewFlowchartPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.util.ViewBizFlowChartUtil;
import kd.bos.workflow.service.archive.ArchiveFormService;

public class WorkflowViewBPMFlowchartPlugin
extends WorkflowViewFlowchartPlugin
implements IWorkflowDesigner {
    public static final String SUMMARYANDAPPROVAL = "summaryandapproval";
    private static final String ICONHIDE = "icon_hide";
    protected static final String BILLSUMMARY = "billsummary";
    protected static final String APPROVALRECORDAP = "approvalrecordap";
    protected String approvalRecordKey = "approvalrecordap";
    protected String billSummaryPanel = "billsummary";
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{ICONHIDE});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        this.getView().setVisible(Boolean.FALSE, new String[]{SUMMARYANDAPPROVAL});
    }

    @Override
    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        IPageCache pageCache = this.getView().getPageCache();
        String routekeyInCache = pageCache.get("routeKey");
        String archiveRouteKeyInCache = pageCache.get("archiveRouteKey");
        this.logger.debug(String.format("ViewWorkflow_routeKey[%s]_archiveRouteKey[%s] in cache", routekeyInCache, archiveRouteKeyInCache));
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String routeKey = (String)parameter.getCustomParam("routeKey");
        String archiveRouteKey = (String)parameter.getCustomParam("archiveRouteKey");
        this.logger.debug(String.format("ViewWorkflow_routeKey[%s]_archiveRouteKey[%s] in view", routeKey, archiveRouteKey));
        return super.getDesignerInitData(params);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (ICONHIDE.equals(key)) {
            this.hideSummaryAndApproval();
        }
    }

    private void hideSummaryAndApproval() {
        this.getView().setVisible(Boolean.FALSE, new String[]{SUMMARYANDAPPROVAL});
    }

    public void updateBillSummaryAndApprovalRecored(String procInstId, String historicActivityInstanceId) {
        this.updateBillSummaryAndApprovalRecored(procInstId, historicActivityInstanceId, null, null, false);
    }

    protected void updateBillSummaryAndApprovalRecored(String procInstId, String historicActivityInstanceId, String entityNumber, String businessKey, boolean openByBillCard) {
        this.getView().setVisible(Boolean.TRUE, new String[]{SUMMARYANDAPPROVAL});
        if (WfUtils.isEmpty((String)businessKey)) {
            HistoricActivityInstanceEntity hisActInstEntity = this.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityInstId(Long.valueOf(procInstId), Long.valueOf(historicActivityInstanceId));
            businessKey = hisActInstEntity.getBusinessKey();
        }
        Long callProcinstId = 0L;
        if (WfUtils.isNotEmpty((String)historicActivityInstanceId)) {
            callProcinstId = ViewBizFlowChartUtil.getCallProcInstIdByHiActInstId((String)procInstId, (String)historicActivityInstanceId);
        }
        this.updateBillSummary(procInstId, historicActivityInstanceId, entityNumber, businessKey, openByBillCard);
        this.updateApprovalRecord(businessKey, callProcinstId);
    }

    private void updateBillSummary(String procInstId, String historicActivityInstanceId, String entityNumber, String businessKey, boolean openByBillCard) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formShowParameter.setCustomParam("businessKey", (Object)businessKey);
        formShowParameter.setCustomParam("procInstId", (Object)procInstId);
        formShowParameter.setCustomParam("historicActivityInstanceId", (Object)historicActivityInstanceId);
        formShowParameter.setCustomParam("openByBillCard", (Object)openByBillCard);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(this.billSummaryPanel);
        formShowParameter.setFormId("bpm_nodebillinfo");
        this.getView().showForm(formShowParameter);
    }

    private void updateApprovalRecord(String businessKey, Long callProcinstId) {
        List allApprovalRecord = this.getTaskService().queryApprovalRecord(callProcinstId, businessKey);
        ApprovalRecord approvalRecord = (ApprovalRecord)this.getControl(this.approvalRecordKey);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hideMoreChat", "");
        parameters.put("hideChat", "");
        parameters.put("isPC", "true");
        parameters.put("approvalIsNew", Boolean.FALSE);
        approvalRecord.setParameters(parameters);
        approvalRecord.setArData(allApprovalRecord);
    }
}

