/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;

public class WorkflowViewFlowchartMobilePlugin
extends AbstractWorkflowPlugin
implements IWorkflowDesigner {
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        Object id = params.get("procInstId");
        boolean preComputator = params.get("preComputator") == null ? Boolean.FALSE : (Boolean)params.get("preComputator");
        Long procInstId = null;
        if (id == null) {
            id = params.get("billId");
            if (WfUtils.isNotEmptyString((Object)id)) {
                procInstId = this.getRuntimeService().getProcInstIdByBusKey(id.toString());
            }
        } else {
            procInstId = Long.valueOf(id.toString());
        }
        if (WfUtils.isEmpty((Long)procInstId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\u3002", (String)"WorkflowViewFlowchartMobilePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map<String, Object> data = null;
        try {
            data = this.getFlowchartInitData(procInstId, preComputator);
            if (data == null || data.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6240\u5728\u6d41\u7a0b\u65e0\u8282\u70b9\u6d41\u8f6c\u4fe1\u606f\u3002", (String)"WorkflowViewFlowchartMobilePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
        }
        catch (Exception e) {
            if (preComputator) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u9884\u6d4b\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartMobilePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u51fa\u9519\uff1a%s", (String)"WorkflowViewFlowchartMobilePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return data;
    }

    private Map<String, Object> getFlowchartInitData(Long procInstId, boolean preComputator) {
        HistoricProcessInstanceEntity hisProInst = (HistoricProcessInstanceEntity)this.getRepositoryService().findEntityById(procInstId, "wf_hiprocinst");
        return this.getRepositoryService().getFlowchartInitDataByProcInstId(hisProInst, Boolean.valueOf(true), Boolean.valueOf(preComputator), Boolean.valueOf(false));
    }
}

