/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.bos.workflow.design.plugin.ViewFlowChartPermComponent;
import kd.bos.workflow.design.plugin.record.AddressProcedureVo;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFPreComputorException;
import kd.bos.workflow.form.operate.util.OperateForWorkflowUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowViewFlowchartPlugin
extends AbstractWorkflowPlugin
implements IWorkflowDesigner {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String WF_APPHOME_NEW = "wf_apphome_new";
    private static final String CURSELPROCESSINSTANCEID = "CURSELPROCESSINSTANCEID";
    private static final String DESTNODEID = "DESTNODEID";
    private static final String SRCID = "SRCID";
    private static final String REASON = "reason";
    private static final String JUMPSUSPEND = "jumpSuspend";
    private static final String BAR_ERROR_MESSAGE = "barerrormessage";
    private static final String BAR_SUSPEND = "suspend";
    private static final String BAR_REVOKE_SUSPEND = "barrevokesuspend";
    private static final String DYNAMIC_UPDATE_PROCINST = "updateprocinst";
    private static final String ABANDON = "feiqi";
    private static final String CURTASK = "curtask";
    private static final String BAR_PROCESS_SALUTION = "barprocesssalution";
    private static final String TRANSFERLOG = "transferlog";
    private static final String SKIP = "skip";
    private static final String BTNBILL = "btnbill";
    protected static final String BTNPRECOMPUTATOR = "barprecomputator";
    private static final String BTNIMMEDIATE = "immediate";
    private static final String BTNOPERATELOG = "baroperatelog";
    private static final String CONFIRMABANDONFROMSHARED = "confirmAbandonFromShared";
    private static final String BTN_EXPORTIMAGE = "exportimage";
    private static final String BTN_REFRESH = "refresh";
    private static final String BTN_CLOSE = "close";
    private static final String TOOLBAR = "toolbarap";
    private static final String WORKFLOW_DESIGNER = "workflowdesigner";
    protected static final String PROCINSTID = "procinstid";
    private static final String ISPRECOMPUTATOR = "isPreComputator";
    private static final String ISIMMEDIATE = "isImmediate";
    private static final String PROCDEFID = "procDefId";
    private static final String KEY_OPENED_LOG_LIST_ID = "openedLogIds";
    private static final String VARIABLES = "variables";
    private static final String BACKTOPARENTPROCESS = "backtoparentprocess";
    protected static final String SHOWADMINBUTTONS = "showAdminButtons";
    private static final String BTN_ABANDONBILL = "abandonbill";
    protected static final String BTN_VIEWBILLRELATION = "viewbillrelation";
    Map<Long, HistoricProcessInstanceEntity> hisProInstMap = new HashMap<Long, HistoricProcessInstanceEntity>(2);
    private static final String BARITEMAP = "baritemap";
    protected static String[] BUTTONS = new String[]{"barerrormessage", "suspend", "barrevokesuspend", "updateprocinst", "feiqi", "curtask", "barprocesssalution", "transferlog", "skip", "baroperatelog", "baritemap"};
    protected static final String BARVIEWAPPROVALRECORD = "barviewapprovalrecord";
    private static final String PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD = "showViewApprovalRecord";
    private static final String PARTICIPANT_PARSELOG = "participantparselog";
    private static final String ADDRESS_PARSE_LOG = "addressparselog";
    private static final String COND_PARSE_PROCEDURE = "condparseprocedure";
    private ViewFlowChartPermComponent viewFlowChartPermComponent = new ViewFlowChartPermComponent();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{TOOLBAR});
        this.viewFlowChartPermComponent.setView(this.getView());
    }

    private void controlVisibleBizBillBtns(Long procInstId) {
        String workFlowType = this.getWorkFlowType(procInstId);
        boolean isBizFlow = ProcessType.BizFlow.name().equals(workFlowType);
        this.logger.debug(String.format("WorkflowViewFlowchartPlugin controlVisibleBizBillBtns isBizFlow is %s", workFlowType));
        if (isBizFlow) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ABANDONBILL});
            this.getView().setEnable(Boolean.FALSE, new String[]{SKIP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ABANDONBILL});
            this.getView().setEnable(Boolean.TRUE, new String[]{SKIP});
        }
        this.getPageCache().put("isBizFlow", String.valueOf(isBizFlow));
        this.getView().setVisible(Boolean.valueOf(isBizFlow), new String[]{BTN_VIEWBILLRELATION});
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (!WF_APPHOME_NEW.equals(parentFormId) && !"bpm_apphome_grid".equals(parentFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEMAP});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        String key = evt.getItemKey();
        if (BTN_EXPORTIMAGE.equals(key)) {
            this.exportImage();
            return;
        }
        ArrayList<Long> procInstIds = new ArrayList<Long>(1);
        if (WfUtils.isEmpty((String)((String)this.getModel().getValue(PROCINSTID)))) {
            return;
        }
        Long procInstId = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
        procInstIds.add(procInstId);
        switch (key) {
            case "barprecomputator": {
                this.getView().getFormShowParameter().setCustomParam(ISPRECOMPUTATOR, (Object)Boolean.TRUE);
                this.getView().getFormShowParameter().setCustomParam(ISIMMEDIATE, (Object)Boolean.FALSE);
                this.refreshPage();
                break;
            }
            case "immediate": {
                this.getView().getFormShowParameter().setCustomParam(ISPRECOMPUTATOR, (Object)Boolean.TRUE);
                this.getView().getFormShowParameter().setCustomParam(ISIMMEDIATE, (Object)Boolean.TRUE);
                this.refreshPage();
                break;
            }
            case "refresh": {
                this.getView().getFormShowParameter().setCustomParam(ISPRECOMPUTATOR, (Object)Boolean.FALSE);
                this.refreshPage();
                break;
            }
            case "barerrormessage": {
                ProcessInstancePluginUtil.openErrorMSGList(procInstIds, this.getView());
                break;
            }
            case "suspend": {
                ProcessInstancePluginUtil.suspend(this.getView(), procInstIds);
                break;
            }
            case "barrevokesuspend": {
                ProcessInstancePluginUtil.revokeSuspend(this.getView(), procInstIds);
                this.refreshPage();
                break;
            }
            case "updateprocinst": {
                ProcessInstancePluginUtil.updateProcInst(this.getView(), procInstIds);
                break;
            }
            case "feiqi": {
                ProcessInstancePluginUtil.abandon(this.getView(), procInstId, (IFormPlugin)this);
                break;
            }
            case "abandonbill": {
                ProcessInstancePluginUtil.abandonBill(this.getView(), procInstId, (IFormPlugin)this);
                break;
            }
            case "curtask": {
                ProcessInstancePluginUtil.viewCurrentTask(this.getView(), procInstIds);
                break;
            }
            case "barprocesssalution": {
                ProcessInstancePluginUtil.showProcessConfiguration(this.getView(), procInstId);
                break;
            }
            case "transferlog": {
                ProcessInstancePluginUtil.showTransferLog(this.getView(), procInstIds);
                break;
            }
            case "skip": {
                ProcessInstancePluginUtil.skip(this.getView(), procInstIds, (IFormPlugin)this);
                break;
            }
            case "backtoparentprocess": {
                this.gobackToParentProcess();
                this.changeButtonState();
                this.getView().setVisible(Boolean.valueOf(!"false".equals(this.getPageCache().get(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD))), new String[]{BARVIEWAPPROVALRECORD});
                break;
            }
            case "baroperatelog": {
                this.showOperateLog();
                break;
            }
            case "viewbillrelation": {
                BizFlowPluginUtil.openBillRelationGraph(procInstId, this.getView());
                break;
            }
            case "barviewapprovalrecord": {
                String entityNumber;
                FormShowParameter parameter;
                String businessKey = (String)this.getView().getFormShowParameter().getCustomParam("billId");
                if (WfUtils.isEmpty((String)businessKey)) {
                    WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                    HistoricProcessInstanceEntity processInstance = wfService.getHistoryService().getHistoricProcessInstance(procInstId);
                    if (null == processInstance) {
                        this.logger.debug("kd.bos.workflow.design.plugin.WorkflowViewFlowchartPlugin.itemClick viewapprovalrecord processInstanceentity is null and procInstId is : " + procInstId);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u6d41\u7a0b\u5ba1\u6279\u8bb0\u5f55\u3002", (String)"ViewApprovalRecordOp_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    businessKey = processInstance.getBusinessKey();
                    if (WfUtils.isEmpty((String)businessKey)) {
                        this.logger.debug("kd.bos.workflow.design.plugin.WorkflowViewFlowchartPlugin.itemClick viewapprovalrecord businessKey is null.");
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u6d41\u7a0b\u5ba1\u6279\u8bb0\u5f55\u3002", (String)"ViewApprovalRecordOp_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if (null == (parameter = OperateForWorkflowUtil.getApprovalRecordOpParameter(businessKey, entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityName"), this.getView()))) {
                    this.logger.debug("kd.bos.workflow.design.plugin.WorkflowViewFlowchartPlugin.itemClick viewapprovalrecord parameter is null.");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u6d41\u7a0b\u5ba1\u6279\u8bb0\u5f55\u3002", (String)"ViewApprovalRecordOp_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                ViewFlowchartUtil.showOperatePageForWorkflow((IFormView)this.getView(), (FormShowParameter)parameter, null);
                break;
            }
            case "participantparselog": {
                ProcessInstancePluginUtil.viewParticipantparseLogList(this.getView(), procInstIds);
                break;
            }
            case "addressparselog": {
                this.showAddressProcedureLog(procInstId);
                break;
            }
            case "condparseprocedure": {
                this.showCondParseLog(procInstId);
                break;
            }
        }
    }

    private void skipToAddressProcedureView() {
        this.toAddressProcedureView(new ArrayList<AddressProcedureVo>(0), "", "");
    }

    private void showAddressProcedureLog(Long id) {
        if (id == null) {
            this.skipToAddressProcedureView();
            return;
        }
        String billNo = "";
        String businessKey = "";
        String billNoOrBusinessKey = "";
        String entityNumber = "";
        ExecutionEntity processInstance = this.getRuntimeService().getProcessInstance(id);
        if (processInstance != null) {
            billNo = processInstance.getBillNo();
            businessKey = processInstance.getBusinessKey();
            entityNumber = processInstance.getEntityNumber();
        } else {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoryService().getHistoricProcessInstance(id);
            billNo = historicProcessInstance.getBillNo();
            businessKey = historicProcessInstance.getBusinessKey();
            entityNumber = historicProcessInstance.getEntitynumber();
        }
        billNoOrBusinessKey = StringUtils.isNotEmpty((CharSequence)billNo) ? billNo : businessKey;
        List result = this.getRuntimeService().findAddressParseLog(entityNumber, billNoOrBusinessKey);
        List<AddressProcedureVo> collect = result.stream().map(AddressProcedureVo::fromEntity).collect(Collectors.toList());
        this.toAddressProcedureView(collect, entityNumber, billNoOrBusinessKey);
    }

    private void toAddressProcedureView(List<AddressProcedureVo> vos, String entityNumber, String billNo) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_log_addressprocedure");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("vo", (Object)SerializationUtils.toJsonString(vos));
        param.setCustomParam("entitynumber", (Object)entityNumber);
        param.setCustomParam("billno", (Object)billNo);
        String caption = ResManager.loadKDString((String)"\u6d41\u7a0b\u5bfb\u5740\u8fc7\u7a0b", (String)"WorkflowProcessInstancePlugin_60", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        param.setCaption(caption);
        this.getView().showForm(param);
    }

    public void showCondParseLog(Long id) {
        if (id == null) {
            this.toConditionParseProcedureView("", "");
            return;
        }
        String businessKey = "";
        String entityNumber = "";
        String billNo = "";
        ExecutionEntity processInstance = this.getRuntimeService().getProcessInstance(id);
        if (processInstance == null) {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoryService().getHistoricProcessInstance(id);
            if (historicProcessInstance != null) {
                businessKey = historicProcessInstance.getBusinessKey();
                entityNumber = historicProcessInstance.getEntitynumber();
                billNo = historicProcessInstance.getBillNo();
            }
        } else {
            businessKey = processInstance.getBusinessKey();
            entityNumber = processInstance.getEntityNumber();
            billNo = processInstance.getBillNo();
        }
        String billNoOrBusinessKey = StringUtils.isEmpty((CharSequence)billNo) ? businessKey : billNo;
        this.toConditionParseProcedureView(entityNumber, billNoOrBusinessKey);
    }

    public void toConditionParseProcedureView(String entityNumber, String billNoOrBusinessKey) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_condparseprocedure");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("entitynumber", (Object)entityNumber);
        param.setCustomParam("billnoorbusinesskey", (Object)billNoOrBusinessKey);
        this.getView().showForm(param);
    }

    private void exportImage() {
        String procDefId;
        HistoricProcessInstanceEntity procInst;
        String fileName = ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe", (String)"WorkflowViewFlowchartPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String procInstId = (String)this.getModel().getValue(PROCINSTID);
        Long processDefinitionId = null;
        if (WfUtils.isNotEmpty((String)procInstId) && (procInst = (HistoricProcessInstanceEntity)this.getRepositoryService().findEntityById(Long.valueOf(procInstId), "wf_hiprocinst", "processDefinitionId")) != null) {
            processDefinitionId = procInst.getProcessDefinitionId();
        }
        if (processDefinitionId == null && WfUtils.isNotEmpty((String)(procDefId = (String)parameter.getCustomParam(PROCDEFID)))) {
            processDefinitionId = Long.valueOf(procDefId);
        }
        if (processDefinitionId != null) {
            ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(processDefinitionId, "wf_processdefinition", "key");
            fileName = procDef.getKey();
        }
        WorkflowDesigner designer = (WorkflowDesigner)this.getView().getControl(WORKFLOW_DESIGNER);
        designer.exportImage(this.getView(), fileName);
    }

    private void showOperateLog() {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u64cd\u4f5c\u65e5\u5fd7\u201d\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_31", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long procInstId = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
        String ids = this.getPageCache().get(KEY_OPENED_LOG_LIST_ID);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String idStr = String.valueOf(procInstId);
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)idsMap.get(idStr);
        if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        String openBillFormId = "wf_operationlog";
        if (QueryServiceHelper.exists((String)"wf_hiprocinst", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)procInstId), new QFilter("endtime", "is not null", null)})) {
            openBillFormId = "wf_hioperationlog";
        }
        QFilter qFilter = new QFilter(PROCINSTID, "=", (Object)procInstId);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(openBillFormId);
        parameter.setFormId("bos_list");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(qFilter);
        parameter.setListFilterParameter(listFilterParameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
        idsMap.put(idStr, parameter.getPageId());
        this.getPageCache().put(KEY_OPENED_LOG_LIST_ID, SerializationUtils.toJsonString(idsMap));
    }

    private void gobackToParentProcess() {
        Long procInstId = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
        HistoricProcessInstanceEntity hisProInst = this.getHisProInstById(procInstId);
        Long parentProcInstId = hisProInst.getSuperProcessInstanceId();
        if (!this.viewFlowChartPermComponent.processInstanceHasPerm(parentProcInstId)) {
            String tips = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u5bf9\u5e94\u6d41\u7a0b\u56fe\u7684\u6743\u9650", (String)"WorkflowViewFlowchartPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        this.switchButtonVisibility(parentProcInstId);
        this.controlVisibleBizBillBtns(parentProcInstId);
        this.getModel().setValue(PROCINSTID, (Object)parentProcInstId);
        Map<String, Object> data = null;
        try {
            data = this.getFlowchartInitData(parentProcInstId);
            if (data == null || data.isEmpty()) {
                this.getView().showTipNotification(WFMultiLangConstants.getProcessNodeNoInfo());
                return;
            }
            HistoricProcessInstanceEntity parentHisProInst = this.getHisProInstById(parentProcInstId);
            Long superProcInstId = parentHisProInst.getSuperProcessInstanceId();
            if (WfUtils.isEmpty((Long)superProcInstId)) {
                superProcInstId = null;
                this.getView().setVisible(Boolean.FALSE, new String[]{BACKTOPARENTPROCESS});
                this.setPageCacheForApprovalRecord("true");
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BACKTOPARENTPROCESS});
                this.setPageCacheForApprovalRecord("false");
            }
            data.put("updateProcInstId", Boolean.TRUE);
            data.put("superProcInstId", superProcInstId == null ? null : superProcInstId.toString());
            data.put("procInstId", String.valueOf(parentProcInstId));
            WorkflowDesigner designer = (WorkflowDesigner)this.getControl(WORKFLOW_DESIGNER);
            designer.open("WorkflowModel", data);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(WFMultiLangConstants.getViewFlowChartErrorInfo(), e.getMessage()));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void setPageCacheForApprovalRecord(String cacheValue) {
        boolean isBizFlow;
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        String isBizFlowObj = this.getPageCache().get("isBizFlow");
        boolean bl = isBizFlow = null == isBizFlowObj ? false : Boolean.parseBoolean(isBizFlowObj.toString());
        if (isBizFlow || WF_APPHOME_NEW.equals(parentFormId) || "bpm_apphome_grid".equals(parentFormId)) {
            this.getPageCache().put(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD, "false");
        } else {
            this.getPageCache().put(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD, cacheValue);
        }
    }

    @Override
    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        Object id = params.get("procInstId");
        Long procInstId = null;
        procInstId = WfUtils.isNotEmptyString((Object)id) && !"null".equals(id) ? Long.valueOf(id.toString()) : this.getLatestProcInstId(params.get("billId"));
        if (WfUtils.isNotEmpty((Long)procInstId)) {
            return this.getDesignerInitDataByProcInstId(procInstId, params);
        }
        if (WfUtils.isEmpty((Long)procInstId)) {
            Long procDefId = null;
            if (params.get(PROCDEFID) != null) {
                procDefId = Long.valueOf(params.get(PROCDEFID).toString());
            }
            if (procDefId == null || procDefId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u5b9a\u4e49\u6d41\u7a0b\u6216\u4e0d\u5728\u6d41\u7a0b\u4e2d\u3002", (String)"WorkflowViewFlowchartPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            return this.getDesignerInitDataByProcDefId(procDefId);
        }
        return null;
    }

    private void showBackToParentProcessButton() {
        Long procInstId = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
        HistoricProcessInstanceEntity hisProInst = this.getHisProInstById(procInstId);
        Long superProcInstId = hisProInst.getSuperProcessInstanceId();
        if (WfUtils.isEmpty((Long)superProcInstId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BACKTOPARENTPROCESS});
            this.setPageCacheForApprovalRecord("true");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BACKTOPARENTPROCESS});
            this.setPageCacheForApprovalRecord("false");
        }
    }

    private void changeButtonState() {
        Long procInstId = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
        ExecutionEntity entity = this.getRuntimeService().getProcessInstance(procInstId);
        if (entity != null && ManagementConstants.ACTIVE.getStateCode().equalsIgnoreCase(entity.getSuspensionState())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_REVOKE_SUSPEND, DYNAMIC_UPDATE_PROCINST});
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNPRECOMPUTATOR, BTNIMMEDIATE, BAR_SUSPEND});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_REVOKE_SUSPEND});
            QFilter qFilter1 = new QFilter("processinstanceid", "=", (Object)procInstId);
            QFilter qFilter2 = new QFilter("type", "=", (Object)SuspendType.MANUALSUSPEND.getCode());
            QFilter qFilter3 = new QFilter("undosuspendtime", "is null", null);
            Long durations = this.getRepositoryService().getEntityCountByFilter("wf_durationdetail", new QFilter[]{qFilter1, qFilter2, qFilter3});
            if (durations == 0L) {
                this.getView().setEnable(Boolean.TRUE, new String[]{DYNAMIC_UPDATE_PROCINST});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNPRECOMPUTATOR, BTNIMMEDIATE, BAR_SUSPEND});
        }
        this.setErrorMsgBtn(procInstId);
        if (entity != null && ProcessType.BizFlow.name().equals(entity.getProcessType())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SUSPEND});
        }
        ArrayList<Long> procInstIds = new ArrayList<Long>(1);
        procInstIds.add(procInstId);
        if (ProcessInstancePluginUtil.isSuspendParticipantAvailable(procInstIds)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
        }
    }

    private void setErrorMsgBtn(Long procInstId) {
        QFilter qFProcInstId = new QFilter("processInstanceId", "=", (Object)procInstId);
        QFilter qTypes = new QFilter("jobHandlerType", "in", Arrays.asList(RuntimeUtil.getRunningJobStr()));
        Long deadLetterJobs = this.getRepositoryService().getEntityCountByFilter("wf_deadletterjob", new QFilter[]{qFProcInstId, qTypes});
        if (deadLetterJobs == 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ERROR_MESSAGE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ERROR_MESSAGE});
        }
    }

    private void showAdminPermButton(Long procInstId) {
        Long userId = RequestContext.get().getCurrUserId();
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")), new String[]{BAR_ERROR_MESSAGE});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"0YS1GTBP53D6")), new String[]{BAR_SUSPEND});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/8M3MNJNJZE5")), new String[]{BAR_REVOKE_SUSPEND});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"018KF2ZNSR7J")), new String[]{DYNAMIC_UPDATE_PROCINST});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/8M3RG6213GO")), new String[]{ABANDON});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"05VKOWGDW44=")), new String[]{CURTASK});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"Gap3Udfv29")), new String[]{BARITEMAP});
        boolean hasPermision = PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/ENE0FKRAB0O");
        if (hasPermision) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_PROCESS_SALUTION});
            HistoricProcessInstanceEntity hisProInst = this.getHisProInstById(procInstId);
            Long procDefId = hisProInst.getProcessDefinitionId();
            if ("886006942529487872".equals(String.valueOf(procDefId)) || this.isAutoTestVersion(procInstId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_PROCESS_SALUTION});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_PROCESS_SALUTION});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PROCESS_SALUTION});
        }
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")), new String[]{TRANSFERLOG});
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)userId, (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/8M3P61RNHXZ")), new String[]{SKIP});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTNOPERATELOG});
    }

    public void refreshPage() {
        Long procInstId = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
        HistoricProcessInstanceEntity processInstance = this.getHisProInstById(procInstId);
        if (null == processInstance) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u5220\u9664\u3002 ", (String)"WorkflowViewFlowchartPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().updateView();
        WorkflowDesigner designer = (WorkflowDesigner)this.getControl(WORKFLOW_DESIGNER);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procInstId", this.getModel().getValue(PROCINSTID));
        try {
            designer.cleanRecordsState();
            Map<String, Object> initData = this.getDesignerInitData(params);
            if (initData != null) {
                String variables = this.getPageCache().get(VARIABLES);
                if (WfUtils.isNotEmpty((String)variables)) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)variables, Map.class);
                    initData.putAll(data);
                    initData.put("procInstId", this.getModel().getValue(PROCINSTID));
                }
                designer.open("WorkflowModel", initData);
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        block13: {
            super.closedCallBack(e);
            Object returnData = e.getReturnData();
            if ("wf_skipnode".equalsIgnoreCase(e.getActionId()) && returnData instanceof Map) {
                Map ret = (Map)returnData;
                if (ret != null && !ret.isEmpty()) {
                    Long pk = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
                    if (pk == null) {
                        return;
                    }
                    Map obj = ret;
                    String destId = (String)obj.get("id");
                    String srcId = (String)obj.get("srcId");
                    Map reason = (Map)ret.get(REASON);
                    WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                    try {
                        this.getPageCache().put(CURSELPROCESSINSTANCEID, String.valueOf(pk));
                        this.getPageCache().put(DESTNODEID, destId);
                        this.getPageCache().put(SRCID, srcId);
                        this.getPageCache().put(REASON, SerializationUtils.toJsonString((Object)reason));
                        wfService.getManagementService().jumpToNode(pk.longValue(), destId, false, srcId, (ILocaleString)LocaleString.fromMap((Map)reason));
                        WfUtils.addOpLogByAppId((String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)SKIP, (MultiLangEnumBridge)new MultiLangEnumBridge("\u8df3\u8f6c", "JumpToNodeCmd_4", "bos-wf-engine"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u5b9e\u4f8bId[%1$s]%2$s", "JumpToNodeCmd_5", "bos-wf-engine"), (Object[])new Object[]{pk, destId});
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u6210\u529f\u3002", (String)"WorkflowViewFlowchartPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                        this.getPageCache().remove(DESTNODEID);
                        this.getPageCache().remove(SRCID);
                    }
                    catch (Exception e1) {
                        if (e1 instanceof KDException) {
                            ErrorCode code = ((KDException)((Object)e1)).getErrorCode();
                            if (code != null) {
                                if (WFErrorCode.processSuspendSimple().equals((Object)code) || WFErrorCode.processSuspend().equals((Object)code)) {
                                    this.getView().showConfirm(e1.getMessage(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(JUMPSUSPEND));
                                } else {
                                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), e1.getMessage()));
                                    this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                                    this.getPageCache().remove(DESTNODEID);
                                }
                            }
                            break block13;
                        }
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), e1.getMessage()));
                        this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                        this.getPageCache().remove(DESTNODEID);
                    }
                }
            } else if ("wf_abandon".equalsIgnoreCase(e.getActionId()) && returnData != null) {
                this.getView().showSuccessNotification(WFMultiLangConstants.getAbandonCauseSuccess());
            } else if ("wf_adminabandon_option".equals(e.getActionId())) {
                String id = (String)this.getModel().getValue(PROCINSTID);
                ProcessInstancePluginUtil.adminAbandonOpionCallback(this.getView(), id, returnData);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = (String)this.getModel().getValue(PROCINSTID);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            switch (callBackId) {
                case "feiqi": {
                    ProcessInstancePluginUtil.realAbandon(this.getView(), id);
                    break;
                }
                case "jumpSuspend": {
                    ProcessInstancePluginUtil.skipSuspend(this.getView(), this.getPageCache());
                    break;
                }
                case "suspend": {
                    if (WfUtils.isEmpty((String)id)) break;
                    ArrayList<Long> pkValues = new ArrayList<Long>();
                    pkValues.add(Long.valueOf(id));
                    ProcessInstancePluginUtil.confirmSuspend(this.getView(), pkValues, false, (IFormPlugin)this);
                    break;
                }
                case "confirmAbandonFromShared": {
                    ProcessInstancePluginUtil.abandonConfirm((IFormPlugin)this, this.getView());
                    break;
                }
            }
        }
    }

    @Override
    public void updateProcInstId(String procInstId, Map<String, Object> data) {
        this.getModel().setValue(PROCINSTID, (Object)procInstId);
        this.getPageCache().put(VARIABLES, SerializationUtils.toJsonString(data));
        this.showBackToParentProcessButton();
        this.switchButtonVisibility(Long.valueOf(procInstId));
        this.changeButtonState();
        this.controlVisibleBizBillBtns(Long.valueOf(procInstId));
        this.getView().setVisible(Boolean.valueOf(!"false".equals(this.getPageCache().get(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD))), new String[]{BARVIEWAPPROVALRECORD});
        this.getPageCache().remove(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD);
    }

    private void showPrecomputatorButton(Long procInstId) {
        if (this.isAutoTest(procInstId) || this.isTerminate(procInstId) || ProcessType.BizFlow.name().equals(this.getWorkFlowType(procInstId))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNPRECOMPUTATOR});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTNPRECOMPUTATOR});
        }
    }

    protected void switchButtonVisibility(Long procInstId) {
        this.showPrecomputatorButton(procInstId);
        if ("true".equals(this.getPageCache().get(SHOWADMINBUTTONS))) {
            if (this.isTerminate(procInstId)) {
                this.getView().setVisible(Boolean.FALSE, BUTTONS);
            } else {
                this.getView().setVisible(Boolean.TRUE, BUTTONS);
            }
        }
    }

    @Override
    public void handleCustomEvent(String type, Map<String, Object> param) {
        if ("downloadFlowChart".equals(type)) {
            this.exportImage();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(SHOWADMINBUTTONS);
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    private String getPermissionEntity() {
        return ProcessInstancePluginUtil.getPermissionEntity(this.getView());
    }

    private HistoricProcessInstanceEntity getHisProInstById(Long procInstId) {
        HistoricProcessInstanceEntity hisProInst = this.hisProInstMap.get(procInstId);
        if (hisProInst == null) {
            hisProInst = (HistoricProcessInstanceEntity)this.getRepositoryService().findEntityById(procInstId, "wf_hiprocinst");
            this.hisProInstMap.put(procInstId, hisProInst);
        }
        return hisProInst;
    }

    private String getWorkFlowType(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = this.getHisProInstById(procInstId);
        if (procInstEntity == null) {
            return null;
        }
        return procInstEntity.getProcessType();
    }

    private boolean isAutoTestVersion(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = this.getHisProInstById(procInstId);
        if (procInstEntity == null) {
            return false;
        }
        Long defId = procInstEntity.getProcessDefinitionId();
        ProcessDefinitionEntity procDefEntiy = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(defId, "wf_processdefinition", "enable");
        return "testing".equals(procDefEntiy.getEnable());
    }

    private boolean isAutoTest(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = this.getHisProInstById(procInstId);
        if (procInstEntity == null) {
            return false;
        }
        return WfUtils.isNotEmpty((Long)procInstEntity.getTestingPlanId());
    }

    private boolean isTerminate(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = this.getHisProInstById(procInstId);
        if (procInstEntity == null) {
            return false;
        }
        return procInstEntity.getEndTime() != null;
    }

    private Map<String, Object> getFlowchartInitData(Long procInstId) {
        return this.getRepositoryService().getFlowchartInitDataByProcInstId(this.getHisProInstById(procInstId));
    }

    private Map<String, Object> getFlowchartInitData(Long procInstId, Boolean isPreComputator, Boolean isImmediate) {
        return this.getRepositoryService().getFlowchartInitDataByProcInstId(isPreComputator, isImmediate, this.getHisProInstById(procInstId));
    }

    private Map<String, Object> getFlowchartInitDataByProcDefId(Long procDefId) {
        return this.getRepositoryService().getFlowchartInitDataByProcDefId(procDefId);
    }

    private Map<String, Object> getFlowchartInitDataByProcDefId(Long procDefId, DynamicObject billObj) {
        return this.getRepositoryService().getFlowchartInitDataByProcDefId(procDefId, billObj);
    }

    private Long getLatestProcInstId(Object billId) {
        if (WfUtils.isNotEmptyString((Object)billId)) {
            QFilter[] hisProcInstfilters = new QFilter[]{new QFilter("businessKey", "=", (Object)billId.toString()), new QFilter("endType", "!=", (Object)"20"), new QFilter("superProcessInstanceId", "=", (Object)0)};
            String orderBy = String.format("%s desc", "createDate");
            List hisProcEntities = this.getRepositoryService().findEntitiesByFilters("wf_hiprocinst", hisProcInstfilters, null, orderBy);
            if (WfUtils.isEmptyForCollection((Collection)hisProcEntities)) {
                HistoricProcessInstanceEntity hisProcEntity = (HistoricProcessInstanceEntity)hisProcEntities.get(0);
                this.hisProInstMap.put(hisProcEntity.getProcessInstanceId(), hisProcEntity);
                return hisProcEntity.getProcessInstanceId();
            }
        }
        return null;
    }

    private Map<String, Object> getDesignerInitDataByProcInstId(Long procInstId, Map<String, Object> params) {
        this.getModel().setValue(PROCINSTID, (Object)procInstId);
        this.setUpShowButtons(procInstId, params);
        Map<String, Object> data = null;
        try {
            HistoricProcessInstanceEntity hisProInst;
            Long superProcInstId;
            Boolean isPreComputator = this.getView().getFormShowParameter().getCustomParam(ISPRECOMPUTATOR) == null ? Boolean.FALSE : (Boolean)this.getView().getFormShowParameter().getCustomParam(ISPRECOMPUTATOR);
            Boolean isImmediate = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISIMMEDIATE);
            data = this.getFlowchartInitData(procInstId, isPreComputator, isImmediate);
            if (data == null || data.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6240\u5728\u6d41\u7a0b\u6ca1\u6709\u8282\u70b9\u6d41\u8f6c\u4fe1\u606f\u3002", (String)"WorkflowViewFlowchartPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (data.get("tips") != null) {
                this.getView().showTipNotification((String)data.get("tips"), Integer.valueOf(3000));
            }
            if (WfUtils.isNotEmpty((Long)(superProcInstId = (hisProInst = this.getHisProInstById(procInstId)).getSuperProcessInstanceId()))) {
                data.put("superProcInstId", String.valueOf(superProcInstId));
            }
        }
        catch (WFPreComputorException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u7b97\u8fd0\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (data != null) {
            data.put(PROCINSTID, procInstId);
            data.put("flowType", this.getWorkFlowType(procInstId));
        }
        if (!Lang.zh_CN.name().equals(RequestContext.get().getLang().name()) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_ERROR_MESSAGE});
            this.getView().setVisible(Boolean.FALSE, new String[]{TRANSFERLOG});
        }
        return data;
    }

    private Map<String, Object> getDesignerInitDataByProcDefId(Long procDefId) {
        Map<String, Object> data = null;
        try {
            this.getView().setVisible(Boolean.FALSE, new String[]{BACKTOPARENTPROCESS, BARVIEWAPPROVALRECORD});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String entityName = (String)parameter.getCustomParam("entityname");
            String billNo = parameter.getCustomParam("billno").toString();
            DynamicObject billObj = null;
            if (WfUtils.isNotEmpty((String)billNo) && WfUtils.isNotEmpty((String)entityName)) {
                billObj = WfUtils.findBusinessObject((String)billNo, (String)entityName);
            } else {
                try {
                    String parentViewId = (String)parameter.getCustomParam("parentViewId");
                    IFormView parentView = this.getView().getView(parentViewId);
                    if (parentView instanceof IBillView) {
                        billObj = parentView.getModel().getDataEntity();
                    }
                }
                catch (KDException e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"WorkflowViewFlowchartPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                }
            }
            data = this.getFlowchartInitDataByProcDefId(procDefId, billObj);
            if (data.get("tips") != null) {
                this.getView().showTipNotification(String.valueOf(data.get("tips")), Integer.valueOf(3000));
            }
        }
        catch (WFPreComputorException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u7b97\u8fd0\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            return this.getFlowchartInitDataByProcDefId(procDefId);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowViewFlowchartPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return data;
    }

    private void setUpShowButtons(Long procInstId, Map<String, Object> params) {
        if ("true".equals(params.get("showButtons")) || "true".equals(this.getPageCache().get(SHOWADMINBUTTONS))) {
            if (this.isTerminate(procInstId)) {
                this.getView().setVisible(Boolean.FALSE, BUTTONS);
            } else {
                this.showAdminPermButton(procInstId);
            }
            this.getPageCache().put(SHOWADMINBUTTONS, "true");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REFRESH, BTN_CLOSE});
        this.showPrecomputatorButton(procInstId);
        this.controlVisibleBizBillBtns(procInstId);
        this.showSuspendErrorBtns();
        this.showBackToParentProcessButton();
        this.getView().setVisible(Boolean.valueOf(!"false".equals(this.getPageCache().get(PAGECACHEKEY_SHOW_VIEW_APPROVAL_RECORD))), new String[]{BARVIEWAPPROVALRECORD});
    }

    private void showSuspendErrorBtns() {
        Long procInstId = Long.valueOf((String)this.getModel().getValue(PROCINSTID));
        ExecutionEntity entity = (ExecutionEntity)this.getRepositoryService().findEntityById(procInstId, "wf_execution", String.format("%s,%s", "suspensionState", "processtype"));
        this.logger.debug(String.format("WorkflowViewFlowchartPlugin showSuspendErrorBtns's procInstId is %s", procInstId));
        if (entity != null && ManagementConstants.ACTIVE.getStateCode().equalsIgnoreCase(entity.getSuspensionState())) {
            this.logger.debug(String.format("WorkflowViewFlowchartPlugin showSuspendErrorBtns's suspensionState is %s", entity.getSuspensionState()));
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_REVOKE_SUSPEND, DYNAMIC_UPDATE_PROCINST});
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNIMMEDIATE, BTNPRECOMPUTATOR, BAR_SUSPEND});
        } else {
            this.logger.debug("WorkflowViewFlowchartPlugin showSuspendErrorBtns's suspensionState is null.else barch");
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_REVOKE_SUSPEND});
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNPRECOMPUTATOR, BTNIMMEDIATE, BAR_SUSPEND});
            this.getView().setEnable(Boolean.TRUE, new String[]{DYNAMIC_UPDATE_PROCINST});
            QFilter qFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
            List durations = this.getRepositoryService().findEntitiesByFilters("wf_durationdetail", new QFilter[]{qFilter}, String.format("%s,%s,%s", "type", "undosuspendtime", "errortype"), "");
            if (durations != null) {
                for (DurationDetailEntity durationEntity : durations) {
                    if (SuspendType.MANUALSUSPEND.getCode().equals(durationEntity.getType()) && durationEntity.getUndoSuspendTime() == null) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
                    }
                    if (!"suspendByUserId".equals(durationEntity.getErrorType())) continue;
                    this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SUSPEND, BAR_REVOKE_SUSPEND, SKIP, ABANDON});
                }
            }
        }
        this.setErrorMsgBtn(procInstId);
        if (entity != null && ProcessType.BizFlow.name().equals(entity.getProcessType())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SUSPEND});
        }
        ArrayList<Long> procInstIds = new ArrayList<Long>(1);
        procInstIds.add(procInstId);
        if (ProcessInstancePluginUtil.isSuspendParticipantAvailable(procInstIds)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
        }
    }
}

