/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowEventConfigurePlugin;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class WorkflowWaitTaskConfigurePlugin
extends AbstractWorkflowEventConfigurePlugin {
    private static final String DURATION = "duration";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DURATION = "duration";
    private static final String FIELD_CONDITION = "condition";
    private static final String FIELD_ALLOWSTARTPROCESS = "allowstartprocess";
    private static final String PANEL_WAITDURATION = "waitdurationpanel";
    private static final String FLEXPANELAPCONFIG = "flexpanelapconfig";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty("duration", FIELD_CONDITION);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELD_CONDITION});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.stencilType == null) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getFormShowParameter() != null && "wf_nodeconfigview".equals(parentView.getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        try {
            this.beginInit();
            super.afterCreateNewData(e);
            JSONObject properties = this.getCellProperties();
            this.initWaitTypeItems();
            JSONObject timingModel = properties.getJSONObject("timingModel");
            this.initByTimingModel(timingModel);
            if (timingModel != null) {
                this.initProcessEvent(timingModel.get((Object)"event"));
            }
            this.initEventParamsText();
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowWaitTaskConfigurePlugin.class);
        }
    }

    private void initWaitTypeItems() {
        if (!BizFlowPluginUtil.isBizFlow(this.getModelType())) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5ef6\u65f6\u7b49\u5f85", (String)"WorkflowWaitTaskConfigurePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0])), "delay"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6761\u4ef6\u7b49\u5f85", (String)"WorkflowWaitTaskConfigurePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])), "timing"));
            ComboEdit type = (ComboEdit)this.getView().getControl(FIELD_TYPE);
            type.setComboItems(items);
            HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
            data.put("tips", this.getWaitTypeTips());
            this.getView().updateControlMetadata(FIELD_TYPE, data);
        }
    }

    private Map<String, Object> getWaitTypeTips() {
        HashMap<String, Object> tips = new HashMap<String, Object>();
        HashMap<String, String> content = new HashMap<String, String>();
        String lang = RequestContext.get().getLang().toString();
        String tipA = ResManager.loadKDString((String)"\u7b49\u5f85\u65b9\u5f0f\u5206\u4e3a\u5ef6\u65f6\u7b49\u5f85\u548c\u6761\u4ef6\u7b49\u5f85\uff1a", (String)"WorkflowWaitTaskConfigurePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]) + "\n";
        String tipB = ResManager.loadKDString((String)"\u5ef6\u65f6\u7b49\u5f85\uff1a\u7b49\u5f85n\u65f6\u95f4\u540e\uff0c\u7ee7\u7eed\u5411\u4e0b\u6d41\u8f6c\uff1b", (String)"WorkflowWaitTaskConfigurePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]) + "\n";
        String tipC = ResManager.loadKDString((String)"\u6761\u4ef6\u7b49\u5f85\uff1a\u7b49\u5f85n\u65f6\u95f4\u540e\uff0c\u5224\u65ad\u662f\u5426\u6ee1\u8db3\u7b49\u5f85\u6761\u4ef6\uff0c\u6ee1\u8db3\u6761\u4ef6\u5219\u5f80\u4e0b\u6d41\u8f6c\uff0c\u4e0d\u6ee1\u8db3\u5219\u7ee7\u7eed\u7b49\u5f85n\u65f6\u95f4\u3002", (String)"WorkflowWaitTaskConfigurePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        content.put(lang, String.format("%s%s%s", tipA, tipB, tipC));
        tips.put("content", content);
        return tips;
    }

    private void initByTimingModel(JSONObject timingModel) {
        if (timingModel == null) {
            return;
        }
        String type = timingModel.getString(FIELD_TYPE);
        this.initVisibility(type);
        if ("event".equals(type)) {
            this.initEventControlVisible(timingModel.get((Object)"eventType"));
        }
    }

    @Override
    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (FIELD_CONDITION.equals(key)) {
            DesignerPluginUtil.openConditionalRule(this.getView(), (IFormPlugin)this, this.getCellProperties(), this.getModelJsonString(), this.itemId, ConditionalRuleType.timingWait, "timingModel.condition", FIELD_CONDITION);
        } else {
            super.click(evt);
        }
    }

    @Override
    protected void initPropertyValue(StencilProperty property, Control control, JSONObject properties, String propName, List<Object> updateProperties, Map<String, Object> isvPropsConfig) {
        Object value = null;
        String propertyName = property.getPropertyName();
        if ("duration".equals(propertyName) && (value = this.getInitPropValue(properties, propName)) != null) {
            this.getModel().setValue("duration", (Object)String.valueOf(value));
        } else if (FIELD_CONDITION.equals(propertyName)) {
            value = this.getInitPropValue(properties, propName);
            Object object = value = value != null ? value : this.getDefaultValue(properties, property, isvPropsConfig);
            if (value instanceof Map) {
                Map data = (Map)value;
                this.getModel().setValue(FIELD_CONDITION, (Object)DesignerPluginUtil.getLocaleValue(data.get("showtext")));
            } else {
                super.initPropertyValue(property, control, properties, propName, updateProperties, isvPropsConfig);
            }
        } else {
            super.initPropertyValue(property, control, properties, propName, updateProperties, isvPropsConfig);
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "type": {
                this.typeChanged(propName, (String)newValue, oldValue, rowIndex);
                break;
            }
            case "duration": {
                this.durationChanged(newValue);
                break;
            }
            case "condition": {
                this.conditionalChanged(newValue);
                break;
            }
            case "eventid": {
                Long eventId = 0L;
                if (newValue != null) {
                    eventId = ((DynamicObject)newValue).getLong("id");
                }
                this.setProperty(this.getCellProperties(), "eventParams", this.getRepositoryService().getProcessEventParams(eventId));
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void conditionalChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(FIELD_CONDITION, null);
        }
    }

    private void durationChanged(Object newValue) {
        this.setProperty("duration", String.valueOf(newValue));
    }

    private void typeChanged(String propName, String newType, Object oldValue, int rowIndex) {
        this.initVisibility(newType);
        super.propertyChanged(propName, newType, oldValue, rowIndex);
    }

    private void initVisibility(String type) {
        if (type == null) {
            this.log.debug("init visibility failed! type is null!");
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAPCONFIG});
        switch (type) {
            case "delay": {
                this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_WAITDURATION});
                this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_CONDITION, "eventname", "eventtype", "event", FIELD_ALLOWSTARTPROCESS, "evtparams", "eventid"});
                break;
            }
            case "timing": {
                this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_WAITDURATION, FIELD_CONDITION});
                this.getView().setVisible(Boolean.FALSE, new String[]{"eventname", "eventtype", "event", FIELD_ALLOWSTARTPROCESS, "evtparams", "eventid"});
                break;
            }
            case "event": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"eventtype", FIELD_CONDITION});
                this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_WAITDURATION});
                if ("cusevent".equals(this.getModel().getValue("eventtype"))) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"eventid"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"eventname"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"eventid"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"eventname"});
                break;
            }
        }
    }

    @Override
    protected Map<String, Object> getOpenEvtParamsCustomParams() {
        Map<String, Object> params = super.getOpenEvtParamsCustomParams();
        params.put("hideValueColumn", Boolean.TRUE);
        return params;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (FIELD_CONDITION.equals(actionId)) {
            this.conditionCallBack(returnData);
        } else {
            super.closedCallBack(evt);
        }
    }

    @Override
    protected void eventCallBack(Object returnData) {
        DynamicObject event;
        String entityNumber;
        super.eventCallBack(returnData);
        Long eventId = null;
        String KEY_ENTITYID = "entity";
        String EVENT_FORMID = "evt_event";
        if (returnData instanceof Map && WfUtils.isNotEmpty((Long)(eventId = (Long)((Map)returnData).get("id"))) && WfUtils.isNotEmpty((String)(entityNumber = (event = QueryServiceHelper.queryOne((String)"evt_event", (String)"entity", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)eventId)})).getString("entity"))) && !entityNumber.equals(this.getProperty("entityNumber"))) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String entityName = String.valueOf(entityType.getDisplayName());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity));
            data.put("name", entityName);
            data.put("number", entityNumber);
            this.entityCallBack(data);
        }
    }

    private void conditionCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(FIELD_CONDITION, (Object)DesignerPluginUtil.getLocaleValue(data.get("showtext")));
            this.setProperty(FIELD_CONDITION, data.size() == 0 ? null : data);
        }
    }
}

