/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.log;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.record.AddressProcedureVo;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.log.entity.RuntimeParseLogEntity;
import kd.bos.workflow.engine.impl.util.DynamicObjectSafeGetter;

public class AddressProcedureLogListPlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener {
    private final RuntimeService runtimeService = this.getRuntimeService();
    public static final String LOGENTITY = "logentity";
    public static final String BUTTON_SEARCH = "btnsearch";
    public static final String BUTTON_CLOSE = "btnclose";
    public static final String NUMBER = "number";
    public static final String ENTITY_NUMBER = "entitynumber";
    public static final String BILL_NO_OR_BUSINESS_KEY = "billno";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(LOGENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{BUTTON_SEARCH, BUTTON_CLOSE});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(LOGENTITY, currentRowIndex);
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("msg".equals(fieldName)) {
            this.showMessageDetails(entryRowEntity.getLong("id"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        String billnoOrBusinessKey = (String)this.getView().getFormShowParameter().getCustomParam(BILL_NO_OR_BUSINESS_KEY);
        List<AddressProcedureVo> vos = this.getVosFromParam();
        if (vos != null && !vos.isEmpty()) {
            this.forEach(vos);
            this.getModel().setValue(ENTITY_NUMBER, (Object)entityNumber);
            this.getModel().setValue(BILL_NO_OR_BUSINESS_KEY, (Object)billnoOrBusinessKey);
            return;
        }
        if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)billnoOrBusinessKey)) {
            return;
        }
        this.getModel().setValue(ENTITY_NUMBER, (Object)entityNumber);
        this.getModel().setValue(BILL_NO_OR_BUSINESS_KEY, (Object)billnoOrBusinessKey);
        List addressParseLog = this.runtimeService.findAddressParseLog(entityNumber.trim(), billnoOrBusinessKey.trim());
        List<AddressProcedureVo> list = this.buildList(addressParseLog);
        if (list == null || list.isEmpty()) {
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u8fdb\u884c\u6d41\u7a0b\u5bfb\u5740\u3002", (String)"AddressProcedureLogListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        this.forEach(list);
    }

    private List<AddressProcedureVo> getVosFromParam() {
        String voStr = (String)this.getView().getFormShowParameter().getCustomParam("vo");
        if (StringUtils.isBlank((CharSequence)voStr)) {
            return new ArrayList<AddressProcedureVo>();
        }
        ObjectMapper JSON2 = new ObjectMapper();
        try {
            return (List)JSON2.readValue(voStr, (TypeReference)new TypeReference<List<AddressProcedureVo>>(){});
        }
        catch (Throwable e) {
            this.logger.info(String.valueOf(e));
            return new ArrayList<AddressProcedureVo>();
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_SEARCH.equals(ctrl.getKey())) {
            List<AddressProcedureVo> list;
            String baseNumber;
            String billNo = (String)this.getModel().getValue(BILL_NO_OR_BUSINESS_KEY);
            DynamicObject object = (DynamicObject)this.getModel().getValue(ENTITY_NUMBER);
            if (object == null || StringUtils.isBlank((CharSequence)billNo)) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\uff0c\u8f93\u5165\u5355\u636e\u7f16\u53f7/\u4e1a\u52a1ID\u540e\u67e5\u8be2\u3002", (String)"AddressProcedureLogListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                this.forEach(new ArrayList<AddressProcedureVo>(0));
                return;
            }
            String entityNumber = (String)object.get(NUMBER);
            List addressParseLog = this.runtimeService.findAddressParseLog(entityNumber.trim(), billNo.trim());
            if (addressParseLog.isEmpty() && "BaseFormModel".equals(object.getString("modelType")) && StringUtils.isNotBlank((CharSequence)(baseNumber = this.findBaseNumber(entityNumber, billNo)))) {
                addressParseLog = this.runtimeService.findAddressParseLog(entityNumber, baseNumber);
            }
            if ((list = this.buildList(addressParseLog)) == null || list.isEmpty()) {
                String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u8fdb\u884c\u6d41\u7a0b\u5bfb\u5740\u3002", (String)"AddressProcedureLogListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                this.forEach(new ArrayList<AddressProcedureVo>(0));
                return;
            }
            this.forEach(list);
        }
        if (BUTTON_CLOSE.equals(ctrl.getKey())) {
            this.getView().close();
        }
    }

    public String findBaseNumber(String entityNumber, String billNo) {
        DynamicObject dynamicObject;
        try {
            dynamicObject = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)billNo)});
        }
        catch (Throwable error) {
            this.logger.warn(error);
            return "";
        }
        if (dynamicObject == null) {
            return "";
        }
        DynamicObjectSafeGetter dynamicObjectSafeGetter = new DynamicObjectSafeGetter(dynamicObject);
        String number = dynamicObjectSafeGetter.getString(NUMBER);
        String name = dynamicObjectSafeGetter.getString("name");
        return number + "/" + name;
    }

    public int forEach(List<AddressProcedureVo> entityDataList) {
        int i;
        this.getModel().deleteEntryData(LOGENTITY);
        if (entityDataList == null || entityDataList.isEmpty()) {
            return 0;
        }
        this.getModel().batchCreateNewEntryRow(LOGENTITY, entityDataList.size());
        String tips = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f\u3002", (String)"AddressProcedureLogListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String format = String.format(tips, entityDataList.size());
        this.getView().showSuccessNotification(format);
        for (i = 0; i < entityDataList.size(); ++i) {
            AddressProcedureVo item = entityDataList.get(i);
            this.getModel().setValue("addresstime", (Object)item.getParseTime(), i);
            this.getModel().setValue("entered", (Object)this.getEnteredMsg(item), i);
            this.getModel().setValue("name", (Object)this.getName(item), i);
            this.getModel().setValue("msg", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"AddressProcedureLogListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), i);
            this.getModel().setValue("subprocess", (Object)this.getSubMsg(item), i);
            this.getModel().setValue("id", (Object)item.getId(), i);
            this.getModel().setValue("bussinesskey", (Object)this.getBusinessKey(item), i);
        }
        EntryGrid entry = (EntryGrid)this.getControl(LOGENTITY);
        entry.setPageIndex(1);
        return i;
    }

    private List<AddressProcedureVo> buildList(List<RuntimeParseLogEntity> parseLog) {
        return parseLog.stream().map(AddressProcedureVo::fromEntity).collect(Collectors.toList());
    }

    public String getBusinessKey(AddressProcedureVo vo) {
        String bussinessKey = vo.getBussinessKey();
        if (bussinessKey.equals("0")) {
            return "";
        }
        return vo.getBussinessKey();
    }

    private void showMessageDetails(Long id) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wf_parselogdateils");
        String tips = ResManager.loadKDString((String)"\u6d41\u7a0b\u5bfb\u5740\u8be6\u60c5", (String)"AddressProcedureLogListPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        showParameter.setCaption(tips);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", (Object)id);
        this.getView().showForm(showParameter);
    }

    private String getName(AddressProcedureVo vo) {
        if (SceneType.JUST_ADDRESS_PROCEDURE.getType().equals(vo.getSceneType())) {
            return "";
        }
        return vo.getName();
    }

    private String getEnteredMsg(AddressProcedureVo vo) {
        if (vo.getProcessDefinitionId() != null && vo.getProcessDefinitionId() != 0L) {
            return ResManager.loadKDString((String)"\u662f", (String)"AddressProcedureLogListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5426", (String)"AddressProcedureLogListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    private String getSubMsg(AddressProcedureVo vo) {
        if (vo.getSubprocess()) {
            return ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b", (String)"AddressProcedureLogListPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

