/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.log;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.log.entity.RuntimeParseLogEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ParticipantLogListPlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener {
    private static final String BUTTON_SEARCH = "btnsearch";
    private static final String BUTTON_CLOSE = "btnclose";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String BILLNO = "billno";
    private static final String BUSINESSKEY = "businesskey";
    private static final String TABLE = "table";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String LOGMSG = "logmsg";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String LOGENTITY = "logentity";
    private static final String PARSETYPE = "parsetype";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(LOGENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{BUTTON_SEARCH, BUTTON_CLOSE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData(LOGENTITY);
        if (this.getView().getFormShowParameter().getCustomParam("appid") == null) {
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
            String billNo = (String)this.getView().getFormShowParameter().getCustomParam(BILLNO);
            String businessKey = (String)this.getView().getFormShowParameter().getCustomParam(BUSINESSKEY);
            if (WfUtils.isEmpty((String)entityNumber) || WfUtils.isEmpty((String)billNo) && WfUtils.isEmpty((String)businessKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b9e\u4f53\u6216\u4e1a\u52a1\u7f16\u7801/\u5355\u636eID\u4e0d\u5b58\u5728\u3002", (String)"ParticipantLogListPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (WfUtils.isEmpty((String)billNo)) {
                this.getModel().setValue(BILLNO, (Object)businessKey);
            } else {
                this.getModel().setValue(BILLNO, (Object)billNo);
            }
            this.getModel().setValue(ENTITYNUMBER, (Object)entityNumber);
            String re = this.getSchJobLogDataList(entityNumber, (String)this.getModel().getValue(BILLNO));
            if (re != null) {
                this.getView().showTipNotification(re);
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BUTTON_SEARCH.equals(ctrl.getKey())) {
            String billNo = (String)this.getModel().getValue(BILLNO);
            DynamicObject object = (DynamicObject)this.getModel().getValue(ENTITYNUMBER);
            if (billNo.isEmpty() && object == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5355\u636e\u201d\u3001\u201c\u5355\u636e\u7f16\u53f7/\u4e1a\u52a1ID\u201d\u3002", (String)"ParticipantLogListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (object == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5355\u636e\u201d\u3002", (String)"ParticipantLogListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (billNo.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5355\u636e\u7f16\u53f7/\u4e1a\u52a1ID\u201d\u3002", (String)"ParticipantLogListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = (String)object.get(NUMBER);
            this.getModel().deleteEntryData(LOGENTITY);
            String re = this.getSchJobLogDataList(entityNumber, billNo);
            if (re != null) {
                this.getView().showTipNotification(re);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f\u3002", (String)"ParticipantLogListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
        if (BUTTON_CLOSE.equals(ctrl.getKey())) {
            this.getView().close();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(LOGENTITY, currentRowIndex);
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (LOGMSG.equals(fieldName)) {
            this.showMessageDetails(entryRowEntity.getLong("id"));
        } else if (NAME.equalsIgnoreCase(fieldName)) {
            this.showProcessConfiguration(entryRowEntity.getLong(PROCESSINSTANCEID));
        }
    }

    private void showMessageDetails(Long pk) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5904\u7406\u4eba\u89e3\u6790\u8be6\u60c5", (String)"ParticipantLogListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("wf_parselogdateils");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", (Object)pk);
        this.getView().showForm(showParameter);
    }

    private void showProcessConfiguration(Long processInstanceId) {
        ProcessInstancePluginUtil.showProcessConfiguration(this.getView(), processInstanceId);
    }

    private String getSchJobLogDataList(String entityNumber, String billNo) {
        QFilter[] filters = new QFilter[]{new QFilter(PARSETYPE, "=", (Object)"ParticipantParseLog"), new QFilter(ENTITYNUMBER, "=", (Object)entityNumber), new QFilter(BILLNO, "=", (Object)billNo).or(new QFilter(BUSINESSKEY, "=", (Object)billNo))};
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List dataList = wfService.getRuntimeService().getParseLogListDataByEntityNumANdBillNo(0, this.getModel().getEntryPageSize(), filters, "orderBy");
        if (dataList.size() == 0) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u65e0\u53c2\u4e0e\u4eba\u89e3\u6790\u8fc7\u7a0b\u3002", (String)"ParticipantLogListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        this.getModel().batchCreateNewEntryRow(LOGENTITY, dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            RuntimeParseLogEntity logEntity = (RuntimeParseLogEntity)dataList.get(i);
            this.getModel().setValue("id", (Object)logEntity.getId(), i);
            this.getModel().setValue(NAME, (Object)logEntity.getName(), i);
            this.getModel().setValue("activityid", (Object)logEntity.getActivityId(), i);
            this.getModel().setValue("activityname", (Object)logEntity.getActivityName(), i);
            this.getModel().setValue("parsetime", (Object)logEntity.getParseTime(), i);
            this.getModel().setValue(PROCESSINSTANCEID, (Object)logEntity.getProcessInstanceId(), i);
            this.getModel().setValue(LOGMSG, (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"ParticipantLogListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), i);
        }
        return null;
    }
}

