/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.design.plugin.model.ShareConfig;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.util.DesignerModelUtil;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class StencilConfig {
    private String id;
    private String stencilName;
    private String stencilTime;
    private String image;
    private String formId;
    private String baseType;
    private String category;
    private boolean container;
    private boolean visible;
    private String template;
    private List<Property> properties;
    private Map<String, StencilProperty> propertiesMap = new CaseInsensitiveMap();
    private Map<String, ShareConfig> generalSharedProps = new HashMap<String, ShareConfig>();
    private Map<String, ShareConfig> advancedSharedProps = new HashMap<String, ShareConfig>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isContainer() {
        return this.container;
    }

    public void setContainer(boolean isContainer) {
        this.container = isContainer;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
        for (Property property : properties) {
            this.propertiesMap.put(property.getPropertyName(), this.getStencilProperty(property));
        }
    }

    public String getStencilName() {
        return this.stencilName;
    }

    public void setStencilName(String stencilName) {
        this.stencilName = stencilName;
    }

    public String getStencilTime() {
        return this.stencilTime;
    }

    public void setStencilTime(String stencilTime) {
        this.stencilTime = stencilTime;
    }

    public StencilProperty getStencilProperty(String name) {
        return this.propertiesMap.get(name);
    }

    public Map<String, StencilProperty> getPropertiesMap() {
        return this.propertiesMap;
    }

    public Map<String, ShareConfig> getGeneralSharedProps() {
        return this.generalSharedProps;
    }

    public Map<String, ShareConfig> getAdvancedSharedProps() {
        return this.advancedSharedProps;
    }

    private StencilProperty getStencilProperty(Property property) {
        StencilProperty prop = new StencilProperty();
        prop.setPropertyName(property.getPropertyName());
        if (property.getName() != null) {
            prop.setName(property.getName().getLocaleValue());
        }
        prop.setGroupId(property.getGroupId());
        if (property.getGroup() != null) {
            prop.setGroup(property.getGroup().getLocaleValue());
        }
        if (property.getDescription() != null) {
            prop.setDescription(property.getDescription().getLocaleValue());
        }
        prop.setReadOnly(property.isReadOnly());
        prop.setHide(DesignerModelUtil.isPropertyHide(property));
        Map config = property.getEditor();
        if (config != null) {
            String bizGroupName = (String)config.get("bizGroupName");
            if (prop.getGroup() == null && bizGroupName != null) {
                prop.setGroup(bizGroupName);
            }
            prop.setRequired(Boolean.TRUE.equals(config.get("required")));
            prop.setDefaultValue(config.get("default"));
            Map data = (Map)config.get("share");
            this.setShareInfo(prop, data);
            this.setManagementConfig(prop, config);
        }
        return prop;
    }

    private void setShareInfo(StencilProperty property, Map<String, Object> data) {
        if (data == null) {
            return;
        }
        String type = (String)data.get("type");
        Boolean sameStencil = (Boolean)data.get("sameStencil");
        Object stencilTypes = data.get("stencilTypes");
        if (type == null && (stencilTypes == null || sameStencil == null)) {
            return;
        }
        boolean validate = false;
        List shareToTypes = null;
        boolean isSameStencil = Boolean.TRUE.equals(sameStencil);
        if (stencilTypes instanceof List) {
            shareToTypes = (List)stencilTypes;
            validate = shareToTypes.contains(this.id);
        } else if (isSameStencil) {
            validate = true;
        }
        if (!validate) {
            return;
        }
        ShareConfig shareConfig = new ShareConfig();
        shareConfig.setType(type);
        shareConfig.setStencilType(this.id);
        shareConfig.setGroup(property.getGroupId());
        shareConfig.setGroupName(property.getGroup());
        shareConfig.setProperty(property.getPropertyName());
        shareConfig.setPropertyName(property.getName());
        shareConfig.setSameEntity(Boolean.TRUE.equals(data.get("sameEntity")));
        String displayGroup = (String)data.get("group");
        if (displayGroup != null) {
            shareConfig.setDisplayGroup(displayGroup);
        }
        if (shareToTypes != null) {
            shareConfig.getStencilTypes().addAll(shareToTypes);
        } else if (isSameStencil) {
            shareConfig.getStencilTypes().add(this.id);
        }
        if ("general".equals(type)) {
            this.generalSharedProps.put(property.getPropertyName(), shareConfig);
            this.advancedSharedProps.put(property.getPropertyName(), shareConfig);
        } else {
            this.advancedSharedProps.put(property.getPropertyName(), shareConfig);
        }
    }

    private void setManagementConfig(StencilProperty prop, Map<String, Object> config) {
        Object management = config.get("management");
        if (management instanceof Map) {
            prop.getManagementConfig().putAll((Map)management);
        }
    }

    public StencilConfig clone() {
        StencilConfig clone = new StencilConfig();
        clone.setImage(this.getImage());
        clone.setFormId(this.getFormId());
        clone.setBaseType(this.getBaseType());
        clone.setCategory(this.getCategory());
        clone.setContainer(this.isContainer());
        clone.setVisible(this.isVisible());
        if (!this.getProperties().isEmpty()) {
            ArrayList<Property> props = new ArrayList<Property>(this.getProperties().size());
            for (Property property : this.getProperties()) {
                Property prop = new Property();
                if (property.getEditor() != null) {
                    HashMap editor = new HashMap();
                    editor.putAll(property.getEditor());
                    prop.setEditor(editor);
                }
                prop.setGroup(property.getGroup());
                prop.setGroupId(property.getGroupId());
                if (property.getHide() != null) {
                    HashMap hide = new HashMap();
                    hide.putAll(property.getHide());
                    prop.setHide(hide);
                }
                prop.setName(property.getName());
                prop.setPropertyName(property.getPropertyName());
                prop.setReadOnly(property.isReadOnly());
                props.add(prop);
            }
            clone.setProperties(props);
        }
        return clone;
    }
}

