/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.design.plugin.model.StencilCtrlState;

public class StencilUIConfig
implements Serializable {
    private static final long serialVersionUID = 6108964508661687660L;
    private Map<String, Object> options = new HashMap<String, Object>();
    private StencilCtrlState designer;
    private Map<String, StencilCtrlState> designerState = new HashMap<String, StencilCtrlState>();
    private StencilCtrlState scheme;
    private Map<String, StencilCtrlState> schemeState = new HashMap<String, StencilCtrlState>();

    public Object getOption(String key) {
        return this.options.get(key);
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public StencilCtrlState getDesigner() {
        return this.designer;
    }

    public void setDesigner(StencilCtrlState designer) {
        this.designer = designer;
    }

    public StencilCtrlState getScheme() {
        return this.scheme;
    }

    public void setScheme(StencilCtrlState scheme) {
        this.scheme = scheme;
    }

    public StencilCtrlState getDesignerState(String modelType) {
        StencilCtrlState state = this.designerState.get(modelType);
        if (state == null) {
            state = new StencilCtrlState();
            this.designerState.put(modelType, state);
        }
        return state;
    }

    public StencilCtrlState getSchemeState(String modelType) {
        StencilCtrlState state = this.schemeState.get(modelType);
        if (state == null) {
            state = new StencilCtrlState();
            this.schemeState.put(modelType, state);
        }
        return state;
    }

    public StencilCtrlState getDesignerStencilCtrlState(String modelType) {
        StencilCtrlState newState;
        StencilCtrlState state = new StencilCtrlState();
        if (this.designer != null) {
            state.getHidden().addAll(this.designer.getHidden());
            state.getReadonly().addAll(this.designer.getReadonly());
        }
        if ((newState = this.designerState.get(modelType)) != null) {
            state.getHidden().addAll(newState.getHidden());
            state.getReadonly().addAll(newState.getReadonly());
        }
        return state;
    }

    public StencilCtrlState getSchemeStencilCtrlState(String modelType) {
        StencilCtrlState state = new StencilCtrlState();
        if (this.scheme != null) {
            state.getHidden().addAll(this.scheme.getHidden());
            state.getReadonly().addAll(this.scheme.getReadonly());
        } else if (this.designer != null) {
            state.getHidden().addAll(this.designer.getHidden());
            state.getReadonly().addAll(this.designer.getReadonly());
        }
        StencilCtrlState newState = this.schemeState.get(modelType);
        if (newState != null) {
            state.getHidden().addAll(newState.getHidden());
            state.getReadonly().addAll(newState.getReadonly());
        } else {
            newState = this.designerState.get(modelType);
            if (newState != null) {
                state.getHidden().addAll(newState.getHidden());
                state.getReadonly().addAll(newState.getReadonly());
            }
        }
        return state;
    }
}

