/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.NodeTemplateModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ImportExportUtil;

public class ImportNodeTemplatePlugin
extends AbstractWorkflowPlugin
implements UploadListener,
IConfirmCallBack {
    private static final String FILE_MAP = "_file_map_";
    private static final String FILE_LIST = "_file_list_";
    private static final String BTNOK = "btnok";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String NODETEMPLATEIMPORTINFO = "nodetTemplateImportInfo";
    private DcxmlSerializer serializer = new DcxmlSerializer(NodeTemplateModel.getDCBinder());

    public ImportNodeTemplatePlugin() {
        this.serializer.setColloctionIgnorePKValue(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        attach.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(FILE_LIST);
        List<String> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        String mapStr = this.getPageCache().get(FILE_MAP);
        Map<String, String> fileMap = WfUtils.isEmpty((String)mapStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
        for (Object url : evt.getUrls()) {
            Map map = (Map)url;
            String urlStr = (String)map.get("url");
            filelist.add(urlStr);
            fileMap.put(urlStr, (String)map.get("name"));
        }
        this.getPageCache().put(FILE_LIST, SerializationUtils.serializeToBase64(filelist));
        this.getPageCache().put(FILE_MAP, SerializationUtils.toJsonString(fileMap));
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(FILE_LIST);
        List filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        String mapStr = this.getPageCache().get(FILE_MAP);
        Map fileMap = WfUtils.isEmpty((String)mapStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
        for (Object url : evt.getUrls()) {
            Map map = (Map)url;
            String urlStr = (String)map.get("url");
            filelist.remove(urlStr);
            fileMap.remove(urlStr);
        }
        this.getPageCache().put(FILE_LIST, SerializationUtils.serializeToBase64(filelist));
        this.getPageCache().put(FILE_MAP, SerializationUtils.toJsonString(fileMap));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTNOK)) {
            this.importNodeTemplateData();
        }
    }

    private void importNodeTemplateData() {
        String cacheUrls = this.getPageCache().get(FILE_LIST);
        if (StringUtils.isBlank((CharSequence)cacheUrls)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u6216\u8005\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportNodetTemplatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        List filelist = (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        if (filelist == null || filelist.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u6216\u8005\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"ImportNodetTemplatePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            this.gatherData(filelist);
        }
        catch (Exception e) {
            this.logger.error(String.format("uoload is error : %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void gatherData(List<String> filelist) {
        String zipFileName = "";
        Map fileMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(FILE_MAP), Map.class);
        ArrayList<Map<String, Object>> nodeTemplateCheckResult = new ArrayList<Map<String, Object>>();
        HashMap<String, ILocaleString> nodeTemplateGroupAndNameMap = new HashMap<String, ILocaleString>(filelist.size());
        ArrayList<String> contentList = new ArrayList<String>(filelist.size());
        HashSet<String> nodeTemplateNumbers = new HashSet<String>();
        HashMap<String, String> nodeTemplateNameAndEntityMap = new HashMap<String, String>();
        HashMap<String, Long> nodeTemplateNameAndGroupMap = new HashMap<String, Long>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashMap<String, String> fileNameMap = new HashMap<String, String>();
        for (String url : filelist) {
            zipFileName = (String)fileMap.get(url);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream inputStream = null;
            try {
                inputStream = cache.getInputStream(url);
                ZipInputStream zipIn = new ZipInputStream((InputStream)new BufferedInputStream(inputStream), Charset.forName("GBK"));
                Throwable throwable = null;
                try {
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zipIn.getNextEntry()) != null) {
                        String fileName = zipEntry.getName();
                        if (!fileName.endsWith(".nodeTemplate")) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1s\u4e2d\u7684\u6587\u4ef6%2s\u4e0d\u5408\u6cd5\u3002", (String)"ImportNodetTemplatePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileName, fileName));
                        }
                        String content = ImportExportUtil.getNodeTemplateFileContent((ZipInputStream)zipIn);
                        this.checkErrorInfo(numberMap, fileNameMap, nodeTemplateNumbers, zipFileName, fileName, content, nodeTemplateNameAndEntityMap, nodeTemplateNameAndGroupMap);
                        this.checkAndGatherNodeTemplate(content, nodeTemplateCheckResult, nodeTemplateGroupAndNameMap, contentList);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipIn == null) continue;
                    if (throwable != null) {
                        try {
                            zipIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    zipIn.close();
                }
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ImportNodetTemplatePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
        }
        this.getPageCache().put("contentCache", SerializationUtils.toJsonString(contentList));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NODETEMPLATEIMPORTINFO));
        parameter.setFormId("wf_nodetemplateimportinfo");
        parameter.setCustomParam("nodeTemplateInfo", nodeTemplateCheckResult);
        parameter.setCustomParam("nodeTemplateGroupInfo", nodeTemplateGroupAndNameMap);
        this.getView().showForm(parameter);
    }

    private void checkErrorInfo(Map<String, String> zipFileNameMap, Map<String, String> fileNameMap, Set<String> nodeTemplateNumbers, String zipFileName, String fileName, String content, Map<String, String> nodeTemplateNameAndEntityMap, Map<String, Long> nodeTemplateNameAndGroupMap) {
        if (WfUtils.isEmpty((String)content)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportNodetTemplatePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileName, fileName));
        }
        NodeTemplateModel nodeTemplateModel = (NodeTemplateModel)this.serializer.deserializeFromString(content, null);
        if (nodeTemplateModel == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u89e3\u6790\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u662f\u5426\u6709\u6548\u3002", (String)"ImportNodetTemplatePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), fileName));
        }
        List templates = nodeTemplateModel.getTemplates();
        List groups = nodeTemplateModel.getGroups();
        if (templates == null || templates.isEmpty() || templates.get(0) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u7684\u8282\u70b9\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u7684\u6587\u4ef6\u3002", (String)"ImportNodetTemplatePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), fileName));
        }
        if (groups == null || groups.isEmpty() || groups.get(0) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u7684\u8282\u70b9\u6a21\u677f\u5206\u7ec4\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u7684\u6587\u4ef6\u3002", (String)"ImportNodetTemplatePlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), fileName));
        }
        DynamicObject template = (DynamicObject)templates.get(0);
        String entityNumber = template.getString("entityid");
        if (WfUtils.isNotEmpty((String)entityNumber) && !QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityNumber)})) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%1$s\u201d\u4e2d\u7684\u5355\u636e\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"ImportNodetTemplatePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), fileName, entityNumber));
        }
        String nodeTemplateNumber = template.getString("number");
        if (!nodeTemplateNumbers.add(nodeTemplateNumber)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u7684\u201c%2$s\u201d\u6587\u4ef6\u4e0e\u201c%3$s\u201d\u4e2d\u7684\u201c%4$s\u201d\u6587\u4ef6\u5b58\u5728\u201c\u7f16\u7801\u201d\u76f8\u540c\u7684\u8282\u70b9\u3002", (String)"ImportNodetTemplatePlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileNameMap.get(nodeTemplateNumber), fileNameMap.get(nodeTemplateNumber), zipFileName, fileName));
        }
        zipFileNameMap.put(nodeTemplateNumber, zipFileName);
        fileNameMap.put(nodeTemplateNumber, fileName);
        String nodeTemplateName = template.getString("name");
        String entityNodeTemplateName = String.format("entity_%s", nodeTemplateName);
        if (WfUtils.isNotEmpty((String)entityNumber) && nodeTemplateNameAndEntityMap.containsKey(nodeTemplateName) && entityNumber.equals(nodeTemplateNameAndEntityMap.get(nodeTemplateName))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u7684\u201c%2$s\u201d\u6587\u4ef6\u4e0e\u201c%3$s\u201d\u4e2d\u7684\u201c%4$s\u201d\u6587\u4ef6\u5b58\u5728\u5b9e\u4f53\u76f8\u540c\u4e14\u540d\u79f0\u76f8\u540c\u7684\u8282\u70b9\u3002", (String)"ImportNodetTemplatePlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileNameMap.get(entityNodeTemplateName), fileNameMap.get(entityNodeTemplateName), zipFileName, fileName));
        }
        zipFileNameMap.put(entityNodeTemplateName, zipFileName);
        fileNameMap.put(entityNodeTemplateName, fileName);
        nodeTemplateNameAndEntityMap.put(nodeTemplateName, entityNumber);
        Long groupId = template.getLong("groupid_id");
        String groupNodeTemplateName = String.format("group_%s", nodeTemplateName);
        if (WfUtils.isNotEmpty((Long)groupId) && nodeTemplateNameAndGroupMap.containsKey(nodeTemplateName) && groupId.equals(nodeTemplateNameAndGroupMap.get(nodeTemplateName))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u7684\u201c%2$s\u201d\u6587\u4ef6\u4e0e\u201c%3$s\u201d\u4e2d\u7684\u201c%4$s\u201d\u6587\u4ef6\u5b58\u5728\u5206\u7ec4\u76f8\u540c\u4e14\u540d\u79f0\u76f8\u540c\u7684\u8282\u70b9\u3002", (String)"ImportNodetTemplatePlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFileNameMap.get(groupNodeTemplateName), fileNameMap.get(groupNodeTemplateName), zipFileName, fileName));
        }
        zipFileNameMap.put(groupNodeTemplateName, zipFileName);
        fileNameMap.put(groupNodeTemplateName, fileName);
        nodeTemplateNameAndGroupMap.put(nodeTemplateName, groupId);
    }

    private void checkAndGatherNodeTemplate(String content, List<Map<String, Object>> nodeTemplateCheckResult, Map<String, ILocaleString> nodeTemplateGroupAndNameMap, List<String> contentList) {
        QFilter[] billQFilters;
        boolean isBillAndNameSame;
        NodeTemplateModel nodeTemplateModel = (NodeTemplateModel)this.serializer.deserializeFromString(content, null);
        List templates = nodeTemplateModel.getTemplates();
        List groups = nodeTemplateModel.getGroups();
        contentList.add(content);
        DynamicObject template = (DynamicObject)templates.get(0);
        DynamicObject group = (DynamicObject)groups.get(0);
        String templateNumber = template.getString("number");
        ILocaleString templateName = template.getLocaleString("name");
        String templateNameEntityId = template.getString("entityid");
        Long groupId = group.getLong("id");
        ILocaleString groupName = group.getLocaleString("name");
        nodeTemplateGroupAndNameMap.put(String.valueOf(groupId), groupName);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(6);
        resultMap.put("number", templateNumber);
        resultMap.put("name", templateName);
        resultMap.put("groupId", groupId);
        resultMap.put("groupName", groupName);
        nodeTemplateCheckResult.add(resultMap);
        QFilter[] numberQFilters = new QFilter[]{new QFilter("number", "=", (Object)templateNumber)};
        boolean isNumberSame = QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])numberQFilters);
        if (isNumberSame) {
            resultMap.put("errorType", "numberSame");
            resultMap.put("errorMessage", ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801", (String)"ImportNodetTemplatePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (WfUtils.isNotEmpty((String)templateNameEntityId) && (isBillAndNameSame = QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])(billQFilters = new QFilter[]{new QFilter("name", "=", (Object)templateName.getLocaleValue()), new QFilter("entityid", "=", (Object)templateNameEntityId)})))) {
            resultMap.put("errorType", "billAndNameSame");
            resultMap.put("errorMessage", ResManager.loadKDString((String)"\u76f8\u540c\u5b9e\u4f53\u4e0b\u5b58\u5728\u76f8\u540c\u540d\u79f0", (String)"ImportNodetTemplatePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String groupNumber = group.getString("number");
        QFilter[] sameGroupQFilters = new QFilter[]{new QFilter("name", "=", (Object)groupName.getLocaleValue()).or(new QFilter("number", "=", (Object)groupNumber))};
        DynamicObjectCollection sameGroups = QueryServiceHelper.query((String)"wf_nodetemplategroup", (String)"id", (QFilter[])sameGroupQFilters);
        Long sameGroupId = sameGroups == null || sameGroups.isEmpty() ? 0L : ((DynamicObject)sameGroups.get(0)).getLong("id");
        QFilter[] sameNameQFilters = new QFilter[]{new QFilter("name", "=", (Object)templateName.getLocaleValue()), new QFilter("groupid", "=", (Object)sameGroupId)};
        boolean isNameSame = QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])sameNameQFilters);
        if (isNameSame) {
            resultMap.put("errorType", "groupAndNameSame");
            resultMap.put("errorMessage", ResManager.loadKDString((String)"\u76f8\u540c\u5206\u7ec4\u4e0b\u5b58\u5728\u76f8\u540c\u540d\u79f0", (String)"ImportNodetTemplatePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (NODETEMPLATEIMPORTINFO.equals(key) && returnData instanceof Map) {
            String contentCache = this.getPageCache().get("contentCache");
            List contentList = SerializationUtils.fromJsonStringToList((String)contentCache, String.class);
            ArrayList<NodeTemplateModel> nodeTemplateModels = new ArrayList<NodeTemplateModel>(contentList.size());
            for (String content : contentList) {
                NodeTemplateModel nodeTemplateModel = (NodeTemplateModel)this.serializer.deserializeFromString(content, null);
                nodeTemplateModels.add(nodeTemplateModel);
            }
            Map treatmentStrategyMap = (Map)returnData;
            try {
                this.getRepositoryService().addNodeTemplateByImport(treatmentStrategyMap, nodeTemplateModels);
                HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
                resultMap.put("message", ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportNodetTemplatePlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                resultMap.put("result", Boolean.TRUE);
                this.getView().returnDataToParent(resultMap);
                this.getView().close();
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
                resultMap.put("message", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ImportNodetTemplatePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
                resultMap.put("result", Boolean.FALSE);
                this.getView().returnDataToParent(resultMap);
                this.getView().close();
            }
        }
    }
}

