/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntityConstants;

public class NodeTemplateAddPlugin
extends AbstractWorkflowPlugin
implements BeforeF7SelectListener {
    private static final String WF_NODETEMPLATE = "wf_nodetemplate";
    private static final String BTNOK = "btnok";
    private static final String NODENUMBER = "nodenumber";
    private static final String NODENAME = "nodename";
    private static final String INHERITNODE = "inheritnode";
    private static final String NODEGROUP = "nodegroup";
    private static final String CREATOR = "creator";
    private static final String ATTRIBUTEEXPEND = "attributeexpend";
    private static final String PLUGINEXPEND = "pluginexpend";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(NODEGROUP);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String number = (String)formShowParameter.getCustomParam("number");
        this.getView().setVisible(Boolean.FALSE, new String[]{ATTRIBUTEEXPEND, PLUGINEXPEND});
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NODENUMBER, NODENAME, INHERITNODE, NODEGROUP, CREATOR});
        } else if (OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{INHERITNODE, CREATOR});
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject nodetemplate = BusinessDataServiceHelper.loadSingle((String)WF_NODETEMPLATE, (String)"number,name,stenciltype,groupid,appid,creator", (QFilter[])filters);
        if (nodetemplate == null) {
            return;
        }
        this.getModel().setValue(NODENUMBER, (Object)nodetemplate.getString("number"));
        this.getModel().setValue(NODENAME, (Object)nodetemplate.getLocaleString("name"));
        QFilter[] stencilTypeFilters = new QFilter[]{new QFilter("number", "=", (Object)nodetemplate.getString("stenciltype"))};
        DynamicObject stencilTypeNodetemplate = QueryServiceHelper.queryOne((String)WF_NODETEMPLATE, (String)"id", (QFilter[])stencilTypeFilters);
        long stencilTypeId = stencilTypeNodetemplate == null ? 0L : stencilTypeNodetemplate.getLong("id");
        this.getModel().setValue(INHERITNODE, (Object)stencilTypeId);
        this.getModel().setValue(NODEGROUP, (Object)nodetemplate.getLong("groupid.id"));
        Object creator = nodetemplate.get(CREATOR);
        Long creatorValue = 0L;
        if (creator instanceof Long) {
            creatorValue = (Long)creator;
        } else if (creator instanceof DynamicObject) {
            creatorValue = ((DynamicObject)creator).getLong("id");
        }
        this.getModel().setValue(CREATOR, (Object)creatorValue);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTNOK.equals(key)) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)WF_NODETEMPLATE, (String)"4715a0df000000ac")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4fee\u6539\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.updateBasicInfo();
        }
    }

    private void updateBasicInfo() {
        try {
            if (!this.verifyData()) {
                return;
            }
            Map<String, Object> basicInformationMap = this.getBasicInformation();
            this.getRepositoryService().updateNodeTemplateBaiscInfo(basicInformationMap);
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"NodeTemplateAddPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.getView().sendFormAction(this.getView().getParentView());
            WfUtils.addOpLog((String)WF_NODETEMPLATE, (String)"updateBasicInfo", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fee\u6539\u57fa\u672c\u4fe1\u606f", "NodeTemplateAddPlugin_3", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u4fe1\u606f\u4e3a\uff1a%s", "NodeTemplateAddPlugin_4", "bos-wf-formplugin"), (Object[])new Object[]{basicInformationMap.toString()});
            this.getView().returnDataToParent(null);
            this.getView().close();
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a%s\u3002", (String)"NodeTemplateAddPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private boolean verifyData() {
        QFilter groupAndNameFilter2;
        QFilter entityNumberAndNameFilter2;
        QFilter entityNumberAndNameFilter1;
        QFilter[] entityNumberAndNameFilters;
        boolean existNodeTemplateName;
        String entityNumber;
        boolean result = true;
        IDataModel model = this.getModel();
        String nodeNumber = (String)model.getValue(NODENUMBER);
        ILocaleString nodeName = (ILocaleString)model.getValue(NODENAME);
        Object nodeGroupObject = model.getValue(NODEGROUP);
        if (WfUtils.isEmpty((String)nodeNumber) || WfUtils.isEmpty((ILocaleString)nodeName) || nodeGroupObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8282\u70b9\u7f16\u7801\u201d\u3001\u201c\u8282\u70b9\u540d\u79f0\u201d\u3001\u201c\u6240\u5c5e\u5206\u7ec4\u201d\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long nodeGroupId = 0L;
        if (model.getValue(NODEGROUP) instanceof DynamicObject) {
            DynamicObject nodeGroup = (DynamicObject)nodeGroupObject;
            nodeGroupId = nodeGroup.getLong("id");
        }
        if (!nodeNumber.matches("^[A-Za-z][A-Za-z0-9_]*$")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8282\u70b9\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter numberFilter1 = new QFilter("number", "=", (Object)nodeNumber);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String id = (String)parameter.getCustomParam("id");
        QFilter numberFilter2 = new QFilter("id", "!=", (Object)Long.valueOf(id));
        QFilter[] numberFilters = new QFilter[]{numberFilter1, numberFilter2};
        boolean existNodeTemplateNumber = QueryServiceHelper.exists((String)WF_NODETEMPLATE, (QFilter[])numberFilters);
        if (existNodeTemplateNumber) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        NodeTemplateEntity nodeTemplate = (NodeTemplateEntity)this.getRepositoryService().findEntityById(Long.valueOf(id), WF_NODETEMPLATE);
        String string = entityNumber = nodeTemplate == null ? null : nodeTemplate.getEntityId();
        if (WfUtils.isNotEmpty((String)entityNumber) && (existNodeTemplateName = QueryServiceHelper.exists((String)WF_NODETEMPLATE, (QFilter[])(entityNumberAndNameFilters = new QFilter[]{entityNumberAndNameFilter1 = new QFilter("name", "=", (Object)nodeName.toString()), entityNumberAndNameFilter2 = new QFilter("entityid", "=", (Object)entityNumber), numberFilter2})))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5b9e\u4f53\uff0c\u8282\u70b9\u6a21\u677f\u7684\u201c\u8282\u70b9\u540d\u79f0\u201d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter groupAndNameFilter1 = new QFilter("name", "=", (Object)nodeName.toString());
        QFilter[] groupAndNameFilters = new QFilter[]{groupAndNameFilter1, groupAndNameFilter2 = new QFilter("groupid", "=", (Object)nodeGroupId), numberFilter2};
        existNodeTemplateName = QueryServiceHelper.exists((String)WF_NODETEMPLATE, (QFilter[])groupAndNameFilters);
        if (existNodeTemplateName) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5206\u7ec4\u4e0b\uff0c\u8282\u70b9\u6a21\u677f\u7684\u201c\u8282\u70b9\u540d\u79f0\u201d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return result;
    }

    private Map<String, Object> getBasicInformation() {
        HashMap<String, Object> basicInformationMap = new HashMap<String, Object>(6);
        IDataModel model = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        basicInformationMap.put("id", parameter.getCustomParam("id"));
        basicInformationMap.put("nodeNumber", (String)model.getValue(NODENUMBER));
        basicInformationMap.put("nodeName", (ILocaleString)model.getValue(NODENAME));
        if (model.getValue(NODEGROUP) instanceof DynamicObject) {
            DynamicObject nodeGroup = (DynamicObject)model.getValue(NODEGROUP);
            String nodeGroupId = nodeGroup.getString("id");
            basicInformationMap.put("nodeGroup", nodeGroupId);
        }
        return basicInformationMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter("number", "!=", (Object)"nodeTemplate_SystemNode");
        qFilter1.and(new QFilter("id", "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID));
        qFilter1.and(new QFilter("parent", "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID));
        customQFilters.add(qFilter1);
        event.setCustomQFilters(customQFilters);
    }
}

