/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.NodeTemplateExpendSaveCustomEvent;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class NodeTemplateAttributeExpendPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    private static final String ATTRIBUTEEXTEENTRYENTITY = "attributeexteentryentity";
    private static final String KEY_ENTRYENTITY_ATTRIBUTENUMBER = "attributenumber";
    private static final String KEY_ENTRYENTITY_ATTRIBUTENAME = "attributename";
    private static final String KEY_ENTRYENTITY_ATTRIBUTETYPE = "attributetype";
    private static final String KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING = "attributecontentsetting";
    private static final String KEY_ENTRYENTITY_CONTENTSETTING_VIEW = "contentsetting_view";
    private static final String KEY_ENTRYENTITY_ATTRIBUTEDESCRIPTION = "attributedescription";
    private static final String KEY_ENTRYENTITY_ATTRIBUTEDEFAULT = "attributedefault";
    private static final String KEY_ENTRYENTITY_ATTRIBUTEDEFAULTSAVE = "attributedefaultsave";
    private static final String KEY_EXPENDSAVE = "expendSave";
    private static final String KEY_EXPENDINITIALIZE = "expendInitialize";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTENUMBER = "attributeNumber";
    private static final String ATTRIBUTENAME = "attributeName";
    private static final String ATTRIBUTETYPE = "attributeType";
    private static final String ATTRIBUTECONTENTSETTING = "attributeContentSetting";
    private static final String ATTRIBUTEDESCRIPTION = "attributedeScription";
    private static final String EXPENDCOMBO = "expendCombo";
    private static final String EXPENDDYNAMICFORM = "expendDynamicForm";
    private static final String ATTRIBUTECONTENT = "attributeContent";
    private static final String CLOSECALLBACKFOCUSROW = "closeCallBackFocusRow";
    private static final String ATTRDEFAULT = "attrDefault";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_ENTRYENTITY_CONTENTSETTING_VIEW, KEY_ENTRYENTITY_ATTRIBUTEDEFAULT});
    }

    public void customEvent(CustomEventArgs e) {
        if (KEY_EXPENDSAVE.equals(e.getKey())) {
            this.getAttributeSaveData((NodeTemplateExpendSaveCustomEvent)e);
        } else if (KEY_EXPENDINITIALIZE.equals(e.getKey())) {
            this.initializeExpendAttribute(e.getEventArgs());
        }
    }

    private void initializeExpendAttribute(String expendDataJson) {
        if (WfUtils.isEmpty((String)expendDataJson)) {
            return;
        }
        JSONObject expendData = JSONObject.parseObject((String)expendDataJson);
        JSONArray extendedAttributes = (JSONArray)expendData.get((Object)ATTRIBUTES);
        if (extendedAttributes == null || extendedAttributes.isEmpty()) {
            return;
        }
        if (!"zh_CN".equals(RequestContext.get().getLang().toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"previewlabel"});
        }
        this.getModel().deleteEntryData(ATTRIBUTEEXTEENTRYENTITY);
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(ATTRIBUTEEXTEENTRYENTITY, extendedAttributes.size());
        int rowIndex = 0;
        for (Object object : extendedAttributes) {
            DynamicObject obj;
            JSONObject extendedAttribut = (JSONObject)object;
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTENUMBER, (Object)extendedAttribut.getString(ATTRIBUTENUMBER), rowIndex);
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTENAME, (Object)WfMultiLangUtils.getMultiLangValue((Map)((Map)extendedAttribut.get((Object)ATTRIBUTENAME))), rowIndex);
            String attributeType = extendedAttribut.getString(ATTRIBUTETYPE);
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTETYPE, (Object)attributeType, rowIndex);
            String attributeContentSetting = extendedAttribut.getString(ATTRIBUTECONTENTSETTING);
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING, (Object)attributeContentSetting, rowIndex);
            if ("dynamicform".equals(attributeType)) {
                obj = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)attributeContentSetting)});
                if (obj != null) {
                    this.getModel().setValue(KEY_ENTRYENTITY_CONTENTSETTING_VIEW, (Object)obj.getString("name"), rowIndex);
                }
            } else if ("basedata".equals(attributeType)) {
                obj = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)attributeContentSetting)});
                if (obj != null) {
                    this.getModel().setValue(KEY_ENTRYENTITY_CONTENTSETTING_VIEW, (Object)obj.getString("name"), rowIndex);
                }
            } else {
                JSONObject attributeContent = JSONObject.parseObject((String)attributeContentSetting);
                if (attributeContent != null && "combo".equals(attributeType)) {
                    StringBuilder showDataSB = new StringBuilder();
                    Set attributeContentEntrySet = attributeContent.entrySet();
                    ArrayList<String> showDatas = new ArrayList<String>(attributeContentEntrySet.size());
                    for (Map.Entry entry : attributeContentEntrySet) {
                        showDatas.add(WfMultiLangUtils.getMultiLangValue((Map)((Map)entry.getValue())).toString());
                    }
                    Collections.sort(showDatas);
                    for (String showData : showDatas) {
                        showDataSB.append(showData).append(",");
                    }
                    String showDataString = showDataSB.toString().substring(0, showDataSB.toString().length() - 1);
                    this.getModel().setValue(KEY_ENTRYENTITY_CONTENTSETTING_VIEW, (Object)showDataString, rowIndex);
                }
            }
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTEDESCRIPTION, (Object)WfMultiLangUtils.getMultiLangValue((Map)((Map)extendedAttribut.get((Object)ATTRIBUTEDESCRIPTION))), rowIndex);
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTEDEFAULT, extendedAttribut.get((Object)ATTRDEFAULT), rowIndex);
            ++rowIndex;
        }
    }

    private void getAttributeSaveData(NodeTemplateExpendSaveCustomEvent e) {
        DynamicObjectCollection attributeDynamicObjectCollection = this.getModel().getEntryEntity(ATTRIBUTEEXTEENTRYENTITY);
        if (attributeDynamicObjectCollection == null || attributeDynamicObjectCollection.isEmpty()) {
            return;
        }
        ArrayList attributeVariables = new ArrayList(attributeDynamicObjectCollection.size());
        for (DynamicObject attribute : attributeDynamicObjectCollection) {
            HashMap<String, String> attributeVariable = new HashMap<String, String>(5);
            String attributeNumber = attribute.getString(KEY_ENTRYENTITY_ATTRIBUTENUMBER);
            ILocaleString attributeName = attribute.getLocaleString(KEY_ENTRYENTITY_ATTRIBUTENAME);
            String attributeType = attribute.getString(KEY_ENTRYENTITY_ATTRIBUTETYPE);
            String attributeContentSetting = attribute.getString(KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING);
            ILocaleString attributedeScription = attribute.getLocaleString(KEY_ENTRYENTITY_ATTRIBUTEDESCRIPTION);
            String attrDefault = attribute.getString(KEY_ENTRYENTITY_ATTRIBUTEDEFAULTSAVE);
            if (this.isVerifyfail(e, attributeNumber, attributeName, attributeType, attributeContentSetting, attributedeScription)) {
                return;
            }
            attributeVariable.put(ATTRIBUTENUMBER, attributeNumber);
            attributeVariable.put(ATTRIBUTENAME, (String)attributeName);
            attributeVariable.put(ATTRIBUTETYPE, attributeType);
            attributeVariable.put(ATTRIBUTECONTENTSETTING, attributeContentSetting);
            attributeVariable.put(ATTRIBUTEDESCRIPTION, (String)attributedeScription);
            attributeVariable.put(ATTRDEFAULT, attrDefault);
            attributeVariables.add(attributeVariable);
        }
        e.getExpendPropertiesMap().put(ATTRIBUTES, attributeVariables);
    }

    private boolean isVerifyfail(NodeTemplateExpendSaveCustomEvent e, String attributeNumber, ILocaleString attributeName, String attributeType, String attributeContentSetting, ILocaleString attributedeScription) {
        if (WfUtils.isEmpty((String)attributeNumber) || WfUtils.isEmpty((ILocaleString)attributeName) || WfUtils.isEmpty((String)attributeType) || WfUtils.isEmpty((ILocaleString)attributedeScription)) {
            e.setCancel(true);
            String message = WfUtils.isEmpty((String)e.getVerifyInformation()) ? ResManager.loadKDString((String)"\u9664\u201c\u5c5e\u6027\u6240\u9009\u5185\u5bb9\u8bbe\u7f6e\u201d\u5916\uff0c\u5176\u4ed6\u90fd\u662f\u5fc5\u586b\u9879\u3002", (String)"NodeTemplateAttributeExpendPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]) : e.getVerifyInformation() + " " + ResManager.loadKDString((String)"\u5c5e\u6027\u6269\u5c55\u6240\u6709\u6570\u636e\u90fd\u662f\u5fc5\u586b\u9879\u3002", (String)"NodeTemplateAttributeExpendPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            e.setVerifyInformation(message);
            return true;
        }
        if (!attributeNumber.matches("^[A-Za-z][A-Za-z0-9_]*$")) {
            e.setCancel(true);
            String message = WfUtils.isEmpty((String)e.getVerifyInformation()) ? ResManager.loadKDString((String)"\u201c\u5c5e\u6027\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplateAttributeExpendPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]) : e.getVerifyInformation() + " " + ResManager.loadKDString((String)"\u201c\u5c5e\u6027\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplateAttributeExpendPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            e.setVerifyInformation(message);
            return true;
        }
        if ("combo".equals(attributeType) && WfUtils.isEmpty((String)attributeContentSetting)) {
            e.setCancel(true);
            String message = WfUtils.isEmpty((String)e.getVerifyInformation()) ? ResManager.loadKDString((String)"\u63a7\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e0b\u62c9\u6846\u201d\u65f6\uff0c\u5c5e\u6027\u6240\u9009\u5185\u5bb9\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u3002", (String)"NodeTemplateAttributeExpendPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]) : e.getVerifyInformation() + " " + ResManager.loadKDString((String)"\u63a7\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e0b\u62c9\u6846\u201d\u65f6\uff0c\u5c5e\u6027\u6240\u9009\u5185\u5bb9\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u3002", (String)"NodeTemplateAttributeExpendPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            e.setVerifyInformation(message);
            return true;
        }
        if ("dynamicform".equals(attributeType) && WfUtils.isEmpty((String)attributeContentSetting)) {
            e.setCancel(true);
            String message = WfUtils.isEmpty((String)e.getVerifyInformation()) ? ResManager.loadKDString((String)"\u63a7\u4ef6\u7c7b\u578b\u4e3a\u201c\u52a8\u6001\u8868\u5355\u201d\u65f6\uff0c\u5c5e\u6027\u6240\u9009\u5185\u5bb9\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u3002", (String)"NodeTemplateAttributeExpendPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]) : e.getVerifyInformation() + " " + ResManager.loadKDString((String)"\u63a7\u4ef6\u7c7b\u578b\u4e3a\u201c\u52a8\u6001\u8868\u5355\u201d\u65f6\uff0c\u5c5e\u6027\u6240\u9009\u5185\u5bb9\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u3002", (String)"NodeTemplateAttributeExpendPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            e.setVerifyInformation(message);
            return true;
        }
        if ("basedata".equals(attributeType) && WfUtils.isEmpty((String)attributeContentSetting)) {
            e.setCancel(true);
            String message = WfUtils.isEmpty((String)e.getVerifyInformation()) ? ResManager.loadKDString((String)"\u63a7\u4ef6\u7c7b\u578b\u4e3a\u201c\u57fa\u7840\u8d44\u6599\u201d\u65f6\uff0c\u5c5e\u6027\u6240\u9009\u5185\u5bb9\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u3002", (String)"NodeTemplateAttributeExpendPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]) : e.getVerifyInformation() + " " + ResManager.loadKDString((String)"\u63a7\u4ef6\u7c7b\u578b\u4e3a\u201c\u57fa\u7840\u8d44\u6599\u201d\u65f6\uff0c\u5c5e\u6027\u6240\u9009\u5185\u5bb9\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u3002", (String)"NodeTemplateAttributeExpendPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            e.setVerifyInformation(message);
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (KEY_ENTRYENTITY_CONTENTSETTING_VIEW.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ATTRIBUTEEXTEENTRYENTITY);
            int rowIndex = entryGrid.getEntryState().getFocusRow();
            this.getPageCache().put(CLOSECALLBACKFOCUSROW, String.valueOf(rowIndex));
            DynamicObject data = this.getModel().getEntryRowEntity(ATTRIBUTEEXTEENTRYENTITY, rowIndex);
            String attributeType = data.getString(KEY_ENTRYENTITY_ATTRIBUTETYPE);
            if ("dynamicform".equals(attributeType)) {
                this.showDynamicFormList();
            } else if ("combo".equals(attributeType)) {
                this.showComboValuePage(data);
            } else if ("basedata".equals(attributeType)) {
                this.showBaseDatePage();
            }
        } else if (KEY_ENTRYENTITY_ATTRIBUTEDEFAULT.equals(key)) {
            this.showAttributeDefaultValuePage();
        }
    }

    private void showBaseDatePage() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("bos_entityobject");
        parameter.setFormId("bos_treelistf7");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "baseDate");
        parameter.setCloseCallBack(callBack);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.setLookUp(true);
        parameter.setMultiSelect(false);
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("modeltype", "=", (Object)"BaseFormModel"));
        filterParameter.setQFilters(qFilters);
        parameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showAttributeDefaultValuePage() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ATTRIBUTEEXTEENTRYENTITY);
        int rowIndex = entryGrid.getEntryState().getFocusRow();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("wf_nodeextattrdefault");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ATTRIBUTETYPE));
        DynamicObject data = this.getModel().getEntryRowEntity(ATTRIBUTEEXTEENTRYENTITY, rowIndex);
        String attributeType = data.getString(KEY_ENTRYENTITY_ATTRIBUTETYPE);
        String attrContentsetting = data.getString(KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING);
        formShowParameter.setCustomParam(ATTRIBUTETYPE, (Object)attributeType);
        formShowParameter.setCustomParam("attrContentsetting", (Object)attrContentsetting);
        formShowParameter.setCustomParam("default", this.getModel().getValue(KEY_ENTRYENTITY_ATTRIBUTEDEFAULTSAVE, rowIndex));
        this.getPageCache().put(CLOSECALLBACKFOCUSROW, String.valueOf(rowIndex));
        this.getView().showForm(formShowParameter);
    }

    private void showComboValuePage(DynamicObject data) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("wf_nodeexpendcombo");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPENDCOMBO));
        String attributeContent = data.getString(KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING);
        formShowParameter.setCustomParam(ATTRIBUTECONTENT, (Object)attributeContent);
        this.getView().showForm(formShowParameter);
    }

    private void showDynamicFormList() {
        ListShowParameter listParameter = new ListShowParameter();
        listParameter.setFormId("bos_listf7");
        listParameter.setBillFormId("bos_formmeta");
        listParameter.getOpenStyle().setShowType(ShowType.Modal);
        listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPENDDYNAMICFORM));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        listParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listParameter.setMultiSelect(false);
        listParameter.setShowTitle(false);
        listParameter.setLookUp(true);
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("parentid.number", "like", (Object)"wf_nodeextformtpl"));
        filterParameter.setQFilters(qFilters);
        listParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)listParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        Integer rowIndex = Integer.valueOf(this.getPageCache().get(CLOSECALLBACKFOCUSROW));
        if (EXPENDCOMBO.equals(key) && returnData instanceof Map) {
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING, (Object)SerializationUtils.toJsonString((Object)returnData), rowIndex.intValue());
            StringBuilder showDataSB = new StringBuilder();
            Map showData = (Map)returnData;
            Set showDataEntrySet = showData.entrySet();
            for (Map.Entry data : showDataEntrySet) {
                showDataSB.append(((ILocaleString)data.getValue()).toString()).append(",");
            }
            String showDataString = showDataSB.toString().substring(0, showDataSB.toString().length() - 1);
            this.getModel().setValue(KEY_ENTRYENTITY_CONTENTSETTING_VIEW, (Object)showDataString, rowIndex.intValue());
        } else if (ATTRIBUTETYPE.equals(key) && returnData instanceof Map) {
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTEDEFAULT, ((Map)returnData).get("caption"), rowIndex.intValue());
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTEDEFAULTSAVE, ((Map)returnData).get("key"), rowIndex.intValue());
        } else if ((EXPENDDYNAMICFORM.equals(key) || "baseDate".equals(key)) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING, (Object)selectedRow.getNumber(), rowIndex.intValue());
            this.getModel().setValue(KEY_ENTRYENTITY_CONTENTSETTING_VIEW, (Object)selectedRow.getName(), rowIndex.intValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (KEY_ENTRYENTITY_ATTRIBUTETYPE.equals(propertyName) && "combo".equals(oldValue)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ATTRIBUTEEXTEENTRYENTITY);
            int rowIndex = entryGrid.getEntryState().getFocusRow();
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTECONTENTSETTING, null, rowIndex);
            this.getModel().setValue(KEY_ENTRYENTITY_CONTENTSETTING_VIEW, null, rowIndex);
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTEDEFAULT, null, rowIndex);
            this.getModel().setValue(KEY_ENTRYENTITY_ATTRIBUTEDEFAULTSAVE, null, rowIndex);
        }
    }
}

