/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.NodeTemplateExpendSaveCustomEvent;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityImpl;

public class NodeTemplateBasicInfoExpendPlugin
extends AbstractWorkflowPlugin
implements TabSelectListener {
    private static final String KEY_BASICINFO_NODENUMBER = "nodenumber";
    private static final String KEY_BASICINFO_NODENAME = "nodename";
    private static final String KEY_BASICINFO_INHERITNODE = "inheritnode";
    private static final String KEY_BASICINFO_NODEGROUP = "nodegroup";
    private static final String KEY_BASICINFO_CREATOR = "creator";
    private static final String KEY_BUTTON_CONFIRM = "btnok";
    private static final String KEY_PREVIEW_PREVIEWFLEX = "previewflex";
    private static final String KEY_PREVIEW_PREVIEWLABEL = "previewlabel";
    private static final String KEY_EXPENDSAVE = "expendSave";
    private static final String KEY_EXPENDINITIALIZE = "expendInitialize";
    private static final String NODETEMPLATESELECTFIELD = "number,name,stenciltype,groupid,appid,creator,propsdefinition";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_CONFIRM, KEY_PREVIEW_PREVIEWLABEL});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        OperationStatus status = param.getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.setExpendNodeValue();
        } else {
            this.getModel().setValue(KEY_BASICINFO_INHERITNODE, param.getCustomParam("sourceNodeId"));
            this.getModel().setValue(KEY_BASICINFO_NODEGROUP, param.getCustomParam("groupid"));
            this.getModel().setValue(KEY_BASICINFO_CREATOR, (Object)1L);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PREVIEW_PREVIEWFLEX});
    }

    private void setExpendNodeValue() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String id = (String)param.getCustomParam("id");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(id))};
        DynamicObject nodetemplate = BusinessDataServiceHelper.loadSingle((String)"wf_nodetemplate", (String)NODETEMPLATESELECTFIELD, (QFilter[])filters);
        if (nodetemplate == null) {
            return;
        }
        this.getModel().setValue(KEY_BASICINFO_NODENUMBER, param.getCustomParam("number"));
        this.getModel().setValue(KEY_BASICINFO_NODENAME, (Object)nodetemplate.getLocaleString("name"));
        QFilter[] stencilTypeFilters = new QFilter[]{new QFilter("number", "=", (Object)nodetemplate.getString("stenciltype"))};
        DynamicObject stencilTypeNodetemplate = QueryServiceHelper.queryOne((String)"wf_nodetemplate", (String)"id", (QFilter[])stencilTypeFilters);
        Long stencilTypeId = stencilTypeNodetemplate == null ? 0L : stencilTypeNodetemplate.getLong("id");
        this.getModel().setValue(KEY_BASICINFO_INHERITNODE, (Object)stencilTypeId);
        this.getModel().setValue(KEY_BASICINFO_NODEGROUP, (Object)nodetemplate.getLong("groupid.id"));
        Object creator = nodetemplate.get(KEY_BASICINFO_CREATOR);
        Long creatorValue = 0L;
        if (creator instanceof Long) {
            creatorValue = (Long)creator;
        } else if (creator instanceof DynamicObject) {
            creatorValue = ((DynamicObject)creator).getLong("id");
        }
        this.getModel().setValue(KEY_BASICINFO_CREATOR, (Object)creatorValue);
        CustomEventArgs customEvent = new CustomEventArgs((Object)this.getView(), KEY_EXPENDINITIALIZE, KEY_EXPENDINITIALIZE, nodetemplate.getString("propsdefinition"));
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent(customEvent);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (KEY_PREVIEW_PREVIEWLABEL.equals(key)) {
            this.showPreview();
        } else {
            this.saveExpendNodeTemplate();
        }
    }

    private void showPreview() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wf_nodeexpendpreview");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void saveExpendNodeTemplate() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String type = (String)param.getCustomParam("type");
        NodeTemplateExpendSaveCustomEvent saveData = this.getAllSaveData();
        String nodeNumber = (String)this.getModel().getValue(KEY_BASICINFO_NODENUMBER);
        ILocaleString nodeName = (ILocaleString)this.getModel().getValue(KEY_BASICINFO_NODENAME);
        if (WfUtils.isEmpty((String)nodeNumber) || WfUtils.isEmpty((ILocaleString)nodeName)) {
            String message = WfUtils.isEmpty((String)saveData.getVerifyInformation()) ? ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NodeTemplateBasicInfoExpendPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NodeTemplateBasicInfoExpendPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]) + " " + saveData.getVerifyInformation();
            this.getView().showTipNotification(message);
            return;
        }
        if (!nodeNumber.matches("^[A-Za-z][A-Za-z0-9_]*$")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8282\u70b9\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] numberFilters = new QFilter[]{new QFilter("number", "=", (Object)nodeNumber)};
        boolean existNodeTemplateNumber = QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])numberFilters);
        if (existNodeTemplateNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("expend".equals(type)) {
            this.saveExpendNode(saveData, nodeNumber, nodeName);
        }
    }

    private void saveExpendNode(NodeTemplateExpendSaveCustomEvent saveData, String nodeNumber, ILocaleString nodeName) {
        if (saveData.isCancel()) {
            this.getView().showTipNotification(saveData.getVerifyInformation());
            return;
        }
        NodeTemplateEntityImpl nodeTemplateEntity = new NodeTemplateEntityImpl();
        nodeTemplateEntity.setNumber(nodeNumber);
        nodeTemplateEntity.setILocaleStringName(nodeName);
        DynamicObject inheritNodeDynamicObject = (DynamicObject)this.getModel().getValue(KEY_BASICINFO_INHERITNODE);
        String inheritNodeNumber = inheritNodeDynamicObject.getString("number");
        nodeTemplateEntity.setStencilType(inheritNodeNumber);
        DynamicObject nodeGroupDynamicObject = (DynamicObject)this.getModel().getValue(KEY_BASICINFO_NODEGROUP);
        nodeTemplateEntity.setGroupId(nodeGroupDynamicObject.getString("id"));
        DynamicObject creator = (DynamicObject)this.getModel().getValue(KEY_BASICINFO_CREATOR);
        nodeTemplateEntity.setCreatorId(Long.valueOf(creator.getLong("id")));
        Map<String, Object> expendPropertiesMap = saveData.getExpendPropertiesMap();
        nodeTemplateEntity.setPropsDefinition(SerializationUtils.toJsonString(expendPropertiesMap));
        try {
            this.getRepositoryService().addNodeTemplateByStrategy("expend", (NodeTemplateEntity)nodeTemplateEntity);
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>(2);
            returnDataMap.put("result", Boolean.TRUE);
            returnDataMap.put("inheritNodeNumber", inheritNodeNumber);
            WfUtils.addOpLog((String)"wf_nodetemplatelibrary", (String)"extendbutton", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6269\u5c55", "NodeTemplateLibraryTablePlugin_38", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8282\u70b9\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6269\u5c55\u8282\u70b9\u6269\u5c55\u6210\u529f\uff0c\u6269\u5c55\u81ea\u201c%2$s\u201d\u8282\u70b9\u3002", "NodeTemplateLibraryTablePlugin_39", "bos-wf-formplugin"), (Object[])new Object[]{inheritNodeNumber, nodeNumber});
            this.getView().returnDataToParent(returnDataMap);
            this.getView().close();
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6269\u5c55\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private NodeTemplateExpendSaveCustomEvent getAllSaveData() {
        NodeTemplateExpendSaveCustomEvent customEvent = new NodeTemplateExpendSaveCustomEvent(this.getView(), KEY_EXPENDSAVE, KEY_EXPENDSAVE, null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)customEvent);
        return customEvent;
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if ("attributeextension".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_PREVIEW_PREVIEWFLEX});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PREVIEW_PREVIEWFLEX});
        }
    }
}

