/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigPlugin;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.NodeTemplateBasicInformationPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.NodeTemplateMessagePlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.NodeTemplateNoBillPropertyControlPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.NodeTemplateNodeControlPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;

public class NodeTemplateConfigPlugin
extends AbstractWorkflowConfigPlugin {
    private GraphModel graphModel = null;
    private static final String CONTENTPANEL = "contentpanel";
    private static final String NODENUMBER = "nodenumber";
    private static final String BTNOK = "btnok";
    protected DynamicObject nodeTemplateInfo;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    @Override
    public void initialize() {
        this.nodeTemplateInfo = this.getNodeTemplateInfo();
        JSONObject jSONObject = new JSONObject();
        String stencilType = this.getStencilType(this.nodeTemplateInfo.getString("stenciltype"));
        jSONObject.put("id", (Object)stencilType);
        jSONObject.put("type", (Object)stencilType);
        jSONObject.put("number", (Object)this.nodeTemplateInfo.getString("number"));
        this.getPageCache().put("selection_cell", JSON.toJSONString((Object)jSONObject));
        String processType = this.nodeTemplateInfo.getString("processtype");
        this.modelType = GraphCodecUtils.getModelTypeByProcessType((String)processType);
        super.initialize();
    }

    private String getStencilType(String stencilType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String number = (String)formShowParameter.getCustomParam("number");
        switch (stencilType = WfUtils.isEmpty((String)stencilType) ? number : stencilType) {
            case "Gateway": {
                stencilType = "InclusiveGateway";
                break;
            }
            case "BoundaryEvent": {
                stencilType = "BoundaryErrorEvent";
                break;
            }
        }
        return stencilType;
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (BTNOK.equals(key)) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_nodetemplate", (String)"4715a0df000000ac")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4fee\u6539\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> nodeInformationMap = new HashMap<String, Object>();
            String number = this.nodeTemplateInfo.getString("number");
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(NODENUMBER, number);
            resultMap.put("isNewAdd", false);
            Boolean isRetainBillInfo = Boolean.TRUE;
            resultMap.put("isRetainBillInfo", isRetainBillInfo);
            nodeInformationMap.put("basicInformation", resultMap);
            Map<String, Object> newestProperties = this.graphModel.getCellProperties(number);
            nodeInformationMap.put("newestProperties", newestProperties);
            nodeInformationMap.put("modelType", this.modelType);
            String stencilType = this.getStencilType(this.nodeTemplateInfo.getString("stenciltype"));
            nodeInformationMap.put("stenciltype", stencilType);
            String entityId = null;
            if (!"WaitTask".equals(stencilType) && !"AutoTask".equals(stencilType) || !WfUtils.isEmpty((String)((String)DesignerModelUtil.getProperty(newestProperties, "entityName")))) {
                entityId = (String)DesignerModelUtil.getProperty(newestProperties, "entityNumber");
            }
            nodeInformationMap.put("entityid", entityId);
            String processType = (String)this.getView().getFormShowParameter().getCustomParam("processType");
            nodeInformationMap.put("processType", processType);
            String result = this.getRepositoryService().addNodeTemplateByStrategy("copy", nodeInformationMap);
            if (WfUtils.isEmpty((String)result)) {
                DesignerModelUtil.removeModelExtendedMapByNumber(number, this.modelType);
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"NodeTemplateConfigPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), result));
            }
        }
    }

    private DynamicObject getNodeTemplateInfo() {
        if (this.nodeTemplateInfo == null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String number = (String)formShowParameter.getCustomParam("number");
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
            this.nodeTemplateInfo = BusinessDataServiceHelper.loadSingle((String)"wf_nodetemplate", (String)"number,name,stenciltype,processtype,properties,entityid", (QFilter[])filters);
        }
        return this.nodeTemplateInfo;
    }

    public void afterCreateNewData(EventObject e) {
        this.nodeTemplateInfo = this.getNodeTemplateInfo();
        String processType = this.nodeTemplateInfo.getString("processtype");
        this.modelType = GraphCodecUtils.getModelTypeByProcessType((String)processType);
        String number = this.nodeTemplateInfo.getString("number");
        String stencilType = this.getStencilType(this.nodeTemplateInfo.getString("stenciltype"));
        StencilConfig config = DesignerModelUtil.getStencilConfig(this.modelType, number);
        if (config == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5bf9\u5e94\u6a21\u578b\u3002", (String)"NodeTemplateConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = config.getFormId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(CONTENTPANEL);
        parameter.setCustomParam("designer_formId", (Object)"wf_nodeconfigview");
        parameter.setCustomParam("model_type", (Object)this.modelType);
        parameter.setCustomParam("stencil_type", (Object)stencilType);
        parameter.setCustomParam("itemId", (Object)number);
        parameter.setCustomParam("node_template_number", (Object)number);
        parameter.setCustomParam("entityid", (Object)this.nodeTemplateInfo.getString("entityid"));
        parameter.addCustPlugin(NodeTemplateNoBillPropertyControlPlugin.class.getCanonicalName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wf_basicinfo_configure", NodeTemplateBasicInformationPlugin.class.getCanonicalName());
        map.put("wf_audittask_basicinfo", NodeTemplateBasicInformationPlugin.class.getCanonicalName());
        map.put("wf_msgnotify_configure", NodeTemplateMessagePlugin.class.getCanonicalName());
        map.put("wf_nodecontrol_configure", NodeTemplateNodeControlPlugin.class.getCanonicalName());
        map.put("wf_audittask_nodecontrol", NodeTemplateNodeControlPlugin.class.getCanonicalName());
        parameter.setCustomParam("dynamic_config_plugin", map);
        String modelJson = this.getModelJson();
        this.getPageCache().put("model_json", modelJson);
        this.showForm(parameter);
    }

    private String getModelJson() {
        String modelJson = "";
        this.nodeTemplateInfo = this.getNodeTemplateInfo();
        String stencilType = this.getStencilType(this.nodeTemplateInfo.getString("stenciltype"));
        String number = this.nodeTemplateInfo.getString("number");
        String process = "Process";
        ArrayList configs = new ArrayList(1);
        HashMap<String, String> processConfig = new HashMap<String, String>();
        processConfig.put("type", process);
        processConfig.put("number", process);
        processConfig.put("itemId", process);
        processConfig.put("ModelType", "WorkflowModel");
        configs.add(processConfig);
        HashMap<String, String> nodeConfig = new HashMap<String, String>();
        nodeConfig.put("type", stencilType);
        nodeConfig.put("number", number);
        nodeConfig.put("itemId", number);
        nodeConfig.put("ModelType", this.getModelType(stencilType));
        nodeConfig.put("nodeId", number);
        nodeConfig.put("name", this.nodeTemplateInfo.getString("name"));
        configs.add(nodeConfig);
        BpmnModel bpmnModel = GraphCodecUtils.getDefaultBpmnModel((String)this.getModelType(stencilType), configs);
        modelJson = GraphCodecUtils.convertBpmnModelToJSON((BpmnModel)bpmnModel);
        JSONObject modelJsonJsonObject = JSON.parseObject((String)modelJson);
        JSONArray childShapes = modelJsonJsonObject.getJSONArray("childShapes");
        if (childShapes != null && !childShapes.isEmpty()) {
            JSONObject childShape = (JSONObject)childShapes.get(0);
            if (WfUtils.isNotEmpty((String)((String)this.getNodeTemplateInfo().get("properties")))) {
                childShape.put("properties", (Object)JSON.parseObject((String)((String)this.getNodeTemplateInfo().get("properties"))));
            }
        }
        modelJson = SerializationUtils.toJsonString((Object)modelJsonJsonObject);
        return modelJson;
    }

    private String getModelType(String stencilType) {
        String modelType = "WorkflowModel";
        if ("SSCApprove".equals(stencilType) || "SSCImageUploadNew".equals(stencilType)) {
            modelType = "SSCModel";
        }
        if ("HRActivity".equals(stencilType)) {
            modelType = "HRModel";
        }
        return modelType;
    }

    @Override
    protected void initGraphModel(String modelJson) {
        if (this.modelType == null) {
            String processType = this.nodeTemplateInfo.getString("processtype");
            this.modelType = GraphCodecUtils.getModelTypeByProcessType((String)processType);
        }
        this.setGraphModel(new GraphModel(this.modelType, modelJson));
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    @Override
    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    @Override
    protected String getType() {
        return "nodeTemplate";
    }
}

