/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntityConstants;

public class NodeTemplateCopyBasicInfoPlugin
extends AbstractWorkflowPlugin
implements BeforeF7SelectListener {
    private static final String NODETEMPALTENUMBER = "nodeTempalteNumber";
    private static final String CREATOR = "creator";
    private static final String NODENUMBER = "nodenumber";
    private static final String NODENAME = "nodename";
    private static final String NODEGROUP = "nodegroup";
    private static final String CONFIRM = "btnok";
    private static final String ISNEWADD = "isNewAdd";
    private static final String NUMBER = "number";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(NODEGROUP);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String nodeTempalateNumber = (String)parameter.getCustomParam(NODETEMPALTENUMBER);
        if (WfUtils.isNotEmpty((String)nodeTempalateNumber)) {
            QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)nodeTempalateNumber)};
            String fields = String.format("%s,%s,%s", NUMBER, "name", "groupid");
            List nodeTemplates = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", filters, fields, null);
            if (nodeTemplates != null && !nodeTemplates.isEmpty()) {
                NodeTemplateEntity nodeTemplate = (NodeTemplateEntity)nodeTemplates.get(0);
                this.getModel().setValue(NODENUMBER, (Object)nodeTemplate.getNumber());
                this.getModel().setValue(NODENAME, (Object)nodeTemplate.getName());
                this.getModel().setValue(NODEGROUP, (Object)nodeTemplate.getGroupId());
            }
        }
        Label label = (Label)this.getControl("explainlabel");
        String labelText = ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u9ed8\u8ba4\u4e0d\u52fe\u9009\uff0c\u5728\u4fdd\u5b58\u65f6\u5c06\u6e05\u9664\u8282\u70b9\u4e0a\u5355\u636e\u76f8\u5173\u7684\u5c5e\u6027\uff0c\u6b64\u8282\u70b9\u6a21\u677f\u53ef\u5728\u4efb\u610f\u6d41\u7a0b\u4e2d\u4f7f\u7528\uff1b\u52fe\u9009\u540e\uff0c\u5728\u4fdd\u5b58\u65f6\u5c06\u4fdd\u7559\u8282\u70b9\u4e0a\u5355\u636e\u76f8\u5173\u7684\u5c5e\u6027\uff0c\u6b64\u8282\u70b9\u6a21\u677f\u53ef\u5728\u76f8\u540c\u5355\u636e\u7684\u6d41\u7a0b\u4e2d\u4f7f\u7528\u3002", (String)"WorkflowNodeTemplatePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        label.setText(labelText);
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (CONFIRM.equals(key)) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_nodetemplate", (String)"0=KX5+QVF5+R")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fdd\u5b58\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowNodeTemplatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String nodeNumber = (String)this.getModel().getValue(NODENUMBER);
            ILocaleString nodeName = (ILocaleString)this.getModel().getValue(NODENAME);
            DynamicObject nodeGroupDynamicObject = (DynamicObject)this.getModel().getValue(NODEGROUP);
            if (WfUtils.isEmpty((String)nodeNumber) || WfUtils.isEmpty((ILocaleString)nodeName) || nodeGroupDynamicObject == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8282\u70b9\u7f16\u7801\u201d\u3001\u201c\u8282\u70b9\u540d\u79f0\u201d\u3001\u201c\u6240\u5c5e\u5206\u7ec4\u201d\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!nodeNumber.matches("^[A-Za-z][A-Za-z0-9_]*$")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8282\u70b9\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            boolean isNewAdd = (Boolean)parameter.getCustomParam(ISNEWADD);
            if (isNewAdd) {
                QFilter groupAndNameFilter2;
                QFilter entityNumberAndNameFilter2;
                QFilter entityNumberAndNameFilter1;
                QFilter[] entityNumberAndNameFilters;
                boolean existNodeTemplateName;
                QFilter[] numberFilters = new QFilter[]{new QFilter(NUMBER, "=", (Object)nodeNumber)};
                boolean existNodeTemplateNumber = QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])numberFilters);
                if (existNodeTemplateNumber) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                String entityNumber = (String)parameter.getCustomParam("entityNumber");
                if (WfUtils.isNotEmpty((String)entityNumber) && (existNodeTemplateName = QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])(entityNumberAndNameFilters = new QFilter[]{entityNumberAndNameFilter1 = new QFilter("name", "=", (Object)nodeName.toString()), entityNumberAndNameFilter2 = new QFilter("entityid", "=", (Object)entityNumber)})))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5b9e\u4f53\uff0c\u8282\u70b9\u6a21\u677f\u7684\u201c\u8282\u70b9\u540d\u79f0\u201d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter groupAndNameFilter1 = new QFilter("name", "=", (Object)nodeName.toString());
                QFilter[] groupAndNameFilters = new QFilter[]{groupAndNameFilter1, groupAndNameFilter2 = new QFilter("groupid", "=", (Object)nodeGroupDynamicObject.getLong("id"))};
                existNodeTemplateName = QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])groupAndNameFilters);
                if (existNodeTemplateName) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5206\u7ec4\u4e0b\uff0c\u8282\u70b9\u6a21\u677f\u7684\u201c\u8282\u70b9\u540d\u79f0\u201d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"NodeTemplateCopyBasicInfoPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.saveNodeTemplateInfo();
        }
    }

    private void saveNodeTemplateInfo() {
        String nodeNumber = (String)this.getModel().getValue(NODENUMBER);
        ILocaleString nodeName = (ILocaleString)this.getModel().getValue(NODENAME);
        DynamicObject nodeGroupDynamicObject = (DynamicObject)this.getModel().getValue(NODEGROUP);
        String nodeGroup = nodeGroupDynamicObject.getString("id");
        DynamicObject creatorDynamicObject = (DynamicObject)this.getModel().getValue(CREATOR);
        Long creator = creatorDynamicObject.getLong("id");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(NODENUMBER, nodeNumber);
        resultMap.put(NODENAME, nodeName);
        resultMap.put(NODEGROUP, nodeGroup);
        resultMap.put(CREATOR, creator);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean isNewAdd = (Boolean)parameter.getCustomParam(ISNEWADD);
        resultMap.put(ISNEWADD, isNewAdd);
        boolean isRetainBillInfo = (Boolean)this.getModel().getValue("retainbill");
        resultMap.put("isRetainBillInfo", isRetainBillInfo);
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter(NUMBER, "!=", (Object)"nodeTemplate_SystemNode");
        qFilter1.and(new QFilter("id", "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID));
        qFilter1.and(new QFilter("parent", "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID));
        qFilter1.and(new QFilter("enable", "=", (Object)"1"));
        customQFilters.add(qFilter1);
        event.setCustomQFilters(customQFilters);
    }
}

