/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.util.NodeTemplateLibraryUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntityConstants;

public class NodeTemplateGroupPlugin
extends AbstractWorkflowPlugin
implements BeforeF7SelectListener {
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String PARENT = "parent";
    private static final String SELECTEDID = "selectedId";
    private static final String WF_NODETEMPLATEGROUP = "wf_nodetemplategroup";

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(PARENT);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
        this.getPageCache().put(NUMBER, (String)this.getModel().getValue(NUMBER));
        if (name != null) {
            this.getPageCache().put(NAME, name.getLocaleValue());
        }
    }

    public void afterCreateNewData(EventObject e) {
        QFilter[] filters;
        DynamicObjectCollection sequenceDynamicObjectCollection;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String selectedId = (String)formShowParameter.getCustomParam(SELECTEDID);
        if (!NodeTemplateLibraryUtil.isSystemNodeGroup(selectedId) && NodeTemplateLibraryUtil.isSecondaryGroup(selectedId)) {
            this.getModel().setValue(PARENT, (Object)selectedId);
        }
        if ((sequenceDynamicObjectCollection = QueryServiceHelper.query((String)WF_NODETEMPLATEGROUP, (String)"sequence", (QFilter[])(filters = new QFilter[]{new QFilter(NUMBER, "is not null", null)}), (String)"sequence desc")) != null) {
            this.getModel().setValue("sequence", (Object)(((DynamicObject)sequenceDynamicObjectCollection.get(0)).getInt("sequence") + 1));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        QFilter[] nameQFilters;
        QFilter[] numberQFilters;
        boolean nameChange;
        Object source = event.getSource();
        if (!(source instanceof Save)) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        String number = (String)this.getModel().getValue(NUMBER);
        String name = this.getModel().getValue(NAME).toString();
        if (!number.matches("^[A-Za-z][A-Za-z0-9_]+$")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplateGroupPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (WfUtils.isEmpty((String)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"NodeTemplateGroupPlugin_5", (String)"bos-wf-engine", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        boolean numberChange = !number.equals(this.getPageCache().get(NUMBER));
        boolean bl = nameChange = !name.equals(this.getPageCache().get(NAME));
        if ((OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status) && numberChange) && QueryServiceHelper.exists((String)WF_NODETEMPLATEGROUP, (QFilter[])(numberQFilters = new QFilter[]{new QFilter(NUMBER, "=", (Object)number)}))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"NodeTemplateGroupPlugin_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if ((OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status) && nameChange) && QueryServiceHelper.exists((String)WF_NODETEMPLATEGROUP, (QFilter[])(nameQFilters = new QFilter[]{new QFilter(NAME, "=", (Object)name)}))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u91cd\u590d\u3002", (String)"NodeTemplateGroupPlugin_4", (String)"bos-wf-engine", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter(PARENT, "=", (Object)0L).or(PARENT, "is null", null);
        customQFilters.add(qFilter1);
        QFilter qFilter2 = new QFilter(NUMBER, "!=", (Object)"nodeTemplate_SystemNode");
        customQFilters.add(qFilter2);
        QFilter noNoCodeFilter = new QFilter("id", "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID).and(new QFilter(PARENT, "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID));
        customQFilters.add(noNoCodeFilter);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String selectedId = (String)formShowParameter.getCustomParam(SELECTEDID);
        if (WfUtils.isNotEmpty((String)selectedId) && !"0".equals(selectedId)) {
            QFilter qFilter3 = new QFilter("id", "!=", (Object)Long.valueOf(selectedId));
            customQFilters.add(qFilter3);
            if (QueryServiceHelper.exists((String)WF_NODETEMPLATEGROUP, (QFilter[])new QFilter[]{new QFilter(PARENT, "=", (Object)Long.valueOf(selectedId))})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u5206\u7ec4\uff0c\u56e0\u4e3a\u4e8c\u7ea7\u8282\u70b9\u5b58\u5728\u5b50\u8282\u70b9\u3002", (String)"NodeTemplateGroupPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
        }
        event.setCustomQFilters(customQFilters);
    }
}

