/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;

public class NodeTemplateLibraryFilterPlugin
extends AbstractWorkflowPlugin {
    @Override
    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setBillFormId("wf_nodetemplate");
            filterContainer.addFilterContainerInitListener(event -> {});
            filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
        }
    }

    private void filterSearchClickEvent(SearchClickEvent searchClickEvent) {
        Map conditionMap = searchClickEvent.getFilterValues();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        List<String> qFilterStrList = this.collectSearchQFilter(searchClickEvent, conditionMap, qFilterList);
        this.getPageCache().put("searchQFilter", SerializationUtils.toJsonString(qFilterStrList));
        CustomEventArgs customEvent = new CustomEventArgs((Object)this.getView(), "search", "search", null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent(customEvent);
    }

    private List<String> collectSearchQFilter(SearchClickEvent searchClickEvent, Map<String, List<Map<String, List<Object>>>> conditionMap, List<QFilter> qFilterList) {
        ArrayList<String> qFilterStrList = new ArrayList<String>();
        List<Map<String, List<Object>>> customlist = conditionMap.get("customfilter");
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        if (commonQFilterList != null && !commonQFilterList.isEmpty()) {
            for (QFilter qFilter : commonQFilterList) {
                qFilterStrList.add(qFilter.toSerializedString());
            }
        }
        List<Map<String, List<Object>>> schemelist = conditionMap.get("schemefilter");
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        if (schemaQFilterList != null && !schemaQFilterList.isEmpty()) {
            for (QFilter qFilter : schemaQFilterList) {
                List nests;
                if (qFilter.getValue() instanceof QEmptyValue) {
                    String propertyName = qFilter.getProperty();
                    if ("creator.name".equals(propertyName) || "modifier.name".equals(propertyName)) {
                        qFilter = new QFilter("creator.name", "is null", null);
                    } else {
                        qFilter.__setValue((Object)" ");
                    }
                }
                if ((nests = qFilter.getNests(true)) != null && !nests.isEmpty()) {
                    for (QFilter.QFilterNest qFilterNest : nests) {
                        qFilterList.add(qFilterNest.getFilter());
                    }
                }
                qFilterStrList.add(qFilter.toSerializedString());
            }
        }
        List<Map<String, List<Object>>> fastlist = conditionMap.get("fastfilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterlist = fastFilterParameter.getQFilters();
        if (fastQFilterlist != null && !fastQFilterlist.isEmpty()) {
            for (QFilter qFilter : fastQFilterlist) {
                qFilterStrList.add(qFilter.toSerializedString());
            }
        }
        this.logger.debug("NodeTemplateLibraryFilterPlugin,qFilterStrList:" + ((Object)qFilterStrList).toString());
        return qFilterStrList;
    }
}

