/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.util.ExportNodeTemplateSql;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.util.NodeTemplateLibraryUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntityConstants;

public class NodeTemplateLibraryTablePlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    protected static Log log = LogFactory.getLog(NodeTemplateLibraryTablePlugin.class);
    public static final String TOOLBARAP = "toolbarap";
    public static final String TOOLBARAP_REFRESH = "refresh";
    public static final String TOOLBARAP_ADDNEWBUTTON = "addnewbutton";
    public static final String TOOLBARAP_EXTENDBUTTON = "extendbutton";
    public static final String TOOLBARAP_DELETEBUTTON = "deletebutton";
    public static final String TOOLBARAP_APPLYTOBUTTON = "applytobutton";
    public static final String TOOLBARAP_ENABLEBUTTON = "enablebutton";
    public static final String TOOLBARAP_DISABLEDBUTTON = "disabledbutton";
    public static final String TOOLBARAP_NODEWORKBOX = "nodeworkbox";
    public static final String TOOLBARAP_IMPORTBUTTON = "importbutton";
    public static final String TOOLBARAP_EXPORTBUTTON = "exportbutton";
    public static final String TOOLBARAP_CHANGELOG = "changelog";
    public static final String TOOLBARAP_EXPORTSQL = "exportsql";
    private static final String ENABLE_CALL_BACK_CONFIRM = "enableCallBackConfirm";
    private static final String DELETE_CALL_BACK_CONFIRM = "deleteCallBackConfirm";
    private static final String DISABLE_CALL_BACK = "disableCallBack";
    public static final String SELECTFILEDS = "id,number,name,stenciltype,groupid,appid,entityid,isinitialization,isextend,creator,createtime,developmenttype,enable,modifier,modifytime";
    public static final String TREEENTRYKEY_NODETEMPLATELIST = "nodetemplatelist";
    public static final String WF_NODETEMPLATE = "wf_nodetemplate";
    public static final String SELECTNODETEMPLATENUMBER = "selectNodeTemplateNumber";
    public static final String SEARCHQFILTER = "searchQFilter";
    public static final String TREEQFILTER = "treeQFilter";
    public static final String NODETEMPLATENUMBER = "nodeTemplateNumber";
    public static final String DEVELOPMENTTYPE = "developmenttype";
    public static final String CACHE_NODETEMPLATEMODIFYLOGIDS = "nodeTemplateModifyLogIds";
    public static final String CALLBACK_KEY_EXPORTNODETEMPLATE = "exportNodeTemplate";
    public static final String CALLBACK_KEY_NODETOOLBOX = "nodeToolBox";
    public static final String CALLBACK_KEY_NODETEMPLATEADD = "nodeTemplateAdd";
    public static final String CALLBACK_KEY_MODIFYPROPERTIES = "modifyProperties";
    public static final String CALLBACK_KEY_IMPORTNODETEMPLATE = "importNodeTemplate";
    public static final String CALLBACK_KEY_EXPEND = "expend";

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u5217\u8868", (String)"NodeTemplateLibraryTablePlugin_33", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYKEY_NODETEMPLATELIST);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        if (!Lang.zh_CN.equals((Object)RequestContext.get().getLang()) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TOOLBARAP_CHANGELOG});
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYKEY_NODETEMPLATELIST);
        entryGrid.setColumnProperty("appid", "filter", (Object)false);
        entryGrid.setColumnProperty("appid", "sort", (Object)false);
        this.cacheDefaultSchemeQFilter();
        this.setValueForNodeTemplateList();
    }

    private void cacheDefaultSchemeQFilter() {
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        SchemeQuery schemeQuery = new SchemeQuery();
        List filterSchemeList = schemeQuery.getScheme(WF_NODETEMPLATE, userId);
        QFilter qfilter = null;
        for (FilterScheme fs : filterSchemeList) {
            if (!fs.isDefault()) continue;
            qfilter = FilterServiceHelper.getQFilterByFilterScheme((FilterScheme)fs, (String)WF_NODETEMPLATE, null);
        }
        ArrayList<String> qFilterList = new ArrayList<String>();
        if (qfilter != null) {
            qFilterList.add(qfilter.toSerializedString());
        }
        this.getPageCache().put(SEARCHQFILTER, SerializationUtils.toJsonString(qFilterList));
    }

    private void setValueForNodeTemplateList() {
        DynamicObject[] nodeTemplateDynamicObjects = this.getNodeTemplateData();
        this.setValueForNodeTemplateList(nodeTemplateDynamicObjects);
    }

    private DynamicObject[] getNodeTemplateData() {
        String treeQFilterStr;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        String searchQFilterStr = this.getPageCache().get(SEARCHQFILTER);
        if (WfUtils.isNotEmpty((String)searchQFilterStr)) {
            List qFilterStrList = SerializationUtils.fromJsonStringToList((String)searchQFilterStr, String.class);
            for (String qFilterStr : qFilterStrList) {
                qFilterList.add(QFilter.fromSerializedString((String)qFilterStr));
            }
            this.logger.debug("NodeTemplateLibraryTablePlugin\uff1asearchQFilterStr," + WfUtils.listToString(qFilterList, (String)","));
        }
        if (WfUtils.isNotEmpty((String)(treeQFilterStr = this.getPageCache().get(TREEQFILTER)))) {
            QFilter treeQFilter = (QFilter)SerializationUtils.fromJsonString((String)treeQFilterStr, QFilter.class);
            this.logger.debug("NodeTemplateLibraryTablePlugin\uff1atreeQFilterStr\uff0c" + treeQFilterStr);
            qFilterList.add(treeQFilter);
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("parent", "=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID)};
            List groups = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplategroup", filters, "id", null);
            ArrayList<Long> noCodeGroupIds = new ArrayList<Long>(groups.size() + 1);
            for (NodeTemplateGroupEntity group : groups) {
                noCodeGroupIds.add(group.getId());
            }
            noCodeGroupIds.add(NodeTemplateGroupEntityConstants.NOCODEGROUPID);
            qFilterList.add(new QFilter("groupid", "not in", noCodeGroupIds));
        }
        this.logger.debug("NodeTemplateLibraryTablePlugin\uff1aqFilterList\uff0c" + WfUtils.listToString(qFilterList, (String)","));
        QFilter[] qFilters = new QFilter[qFilterList.size()];
        qFilters = qFilterList.toArray(qFilters);
        DynamicObjectCollection nodeTemplateDynamicObjectCollection = QueryServiceHelper.query((String)WF_NODETEMPLATE, (String)SELECTFILEDS, (QFilter[])qFilters, (String)"createtime asc");
        LinkedHashSet<String> nodeTemplateParentNumber = new LinkedHashSet<String>(nodeTemplateDynamicObjectCollection.size());
        for (DynamicObject dynamicObject : nodeTemplateDynamicObjectCollection) {
            if ("B".equals(dynamicObject.getString(DEVELOPMENTTYPE))) {
                nodeTemplateParentNumber.add(dynamicObject.getString("stenciltype"));
                continue;
            }
            if (!NodeTemplateLibraryUtil.isScalableNodes(dynamicObject.getString("number"))) continue;
            nodeTemplateParentNumber.add(dynamicObject.getString("number"));
        }
        DynamicObjectCollection parentAndSonNode = QueryServiceHelper.query((String)WF_NODETEMPLATE, (String)SELECTFILEDS, (QFilter[])new QFilter[]{new QFilter("number", "in", nodeTemplateParentNumber).or(new QFilter("stenciltype", "in", nodeTemplateParentNumber).and(new QFilter(DEVELOPMENTTYPE, "=", (Object)"B")))});
        LinkedHashSet<DynamicObject> nodeSet = new LinkedHashSet<DynamicObject>();
        LinkedHashSet<String> nodeNumberSet = new LinkedHashSet<String>();
        for (DynamicObject dynamicObject : nodeTemplateDynamicObjectCollection) {
            nodeNumberSet.add(dynamicObject.getString("number"));
            nodeSet.add(dynamicObject);
        }
        for (DynamicObject dynamicObject : parentAndSonNode) {
            if (nodeNumberSet.contains(dynamicObject.getString("number"))) continue;
            nodeSet.add(dynamicObject);
        }
        DynamicObject[] nodeTemplateDynamicObjects = new DynamicObject[nodeSet.size()];
        nodeTemplateDynamicObjects = nodeSet.toArray(nodeTemplateDynamicObjects);
        return nodeTemplateDynamicObjects;
    }

    private void setValueForNodeTemplateList(DynamicObject[] nodeTemplates) {
        IDataModel model = this.getModel();
        model.deleteEntryData(TREEENTRYKEY_NODETEMPLATELIST);
        if (nodeTemplates == null || nodeTemplates.length == 0) {
            return;
        }
        ArrayList<DynamicObject> firstNodeList = new ArrayList<DynamicObject>();
        HashMap<Object, DynamicObject> secondNodeMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, Set<String>> nodeLinkMap = new HashMap<Object, Set<String>>();
        NodeTemplateLibraryTablePlugin.getHierarchicalData(nodeTemplates, firstNodeList, secondNodeMap, nodeLinkMap);
        HashSet<String> billIdSet = new HashSet<String>(nodeTemplates.length);
        HashSet<String> sourceNodeSet = new HashSet<String>(nodeTemplates.length);
        for (DynamicObject dynamicObject : nodeTemplates) {
            billIdSet.add(dynamicObject.getString("entityid"));
            sourceNodeSet.add(dynamicObject.getString("stenciltype"));
        }
        QFilter[] billFilters = new QFilter[]{new QFilter("id", "in", billIdSet)};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,name", (QFilter[])billFilters);
        HashMap<String, String> billMap = new HashMap<String, String>(bills.length);
        for (DynamicObject bill : bills) {
            billMap.put(bill.getString("id"), bill.getLocaleString("name") + "(" + bill.getString("id") + ")");
        }
        QFilter[] qFilterArray = new QFilter[]{new QFilter("number", "in", sourceNodeSet)};
        List nodeTemplateList = this.getRepositoryService().findEntitiesByFilters(WF_NODETEMPLATE, qFilterArray);
        HashMap<String, String> sourceNodeMap = new HashMap<String, String>(nodeTemplateList.size());
        for (NodeTemplateEntity nodeTemplateEntity : nodeTemplateList) {
            sourceNodeMap.put(nodeTemplateEntity.getNumber(), nodeTemplateEntity.getName());
        }
        model.beginInit();
        model.batchCreateNewEntryRow(TREEENTRYKEY_NODETEMPLATELIST, nodeTemplates.length);
        int index = 0;
        for (DynamicObject nodeTemplateDynamicObject : firstNodeList) {
            NodeTemplateLibraryTablePlugin.setTreeEntryValue(model, nodeTemplateDynamicObject, index, "parent", sourceNodeMap, billMap);
            String number = nodeTemplateDynamicObject.getString("number");
            if (nodeLinkMap.get(number) != null && !((Set)nodeLinkMap.get(number)).isEmpty()) {
                Set linkSet = (Set)nodeLinkMap.get(number);
                for (String childrenNumber : linkSet) {
                    DynamicObject childrenNodeTemplateDynamicObject = (DynamicObject)secondNodeMap.get(childrenNumber);
                    NodeTemplateLibraryTablePlugin.setTreeEntryValue(model, childrenNodeTemplateDynamicObject, ++index, "children", sourceNodeMap, billMap);
                }
            }
            ++index;
        }
        model.endInit();
        this.getView().updateView(TREEENTRYKEY_NODETEMPLATELIST);
    }

    private static void getHierarchicalData(DynamicObject[] nodeTemplates, List<DynamicObject> firstNodeList, Map<Object, DynamicObject> secondNodeMap, Map<Object, Set<String>> nodeLinkMap) {
        ArrayList<String> firstNodeNumberList = new ArrayList<String>(nodeTemplates.length);
        for (DynamicObject nodeTemplate : nodeTemplates) {
            if (nodeTemplate == null) continue;
            String developmenttype = nodeTemplate.getString(DEVELOPMENTTYPE);
            if (!"B".equals(developmenttype)) {
                firstNodeList.add(nodeTemplate);
                firstNodeNumberList.add(nodeTemplate.getString("number"));
                continue;
            }
            String stencilType = nodeTemplate.getString("stenciltype");
            String number = nodeTemplate.getString("number");
            secondNodeMap.put(number, nodeTemplate);
            Set<String> linkSet = nodeLinkMap.get(stencilType);
            if (linkSet == null) {
                linkSet = new HashSet<String>(10);
            }
            linkSet.add(number);
            nodeLinkMap.put(stencilType, linkSet);
        }
        log.debug(String.format("firstNodeNumberList is:%s;", firstNodeNumberList));
    }

    private static void setTreeEntryValue(IDataModel gridModel, DynamicObject nodeTemplateDynamicObject, int i, String type, Map<String, String> sourceNodeMap, Map<String, String> billMap) {
        String number = nodeTemplateDynamicObject.getString("number");
        if ("children".equals(type)) {
            number = "   " + number;
        } else {
            String patch = UrlService.getDomainContextUrl() + "/icons/pc/other/lcfwb_gzlfw_24_24.png";
            gridModel.setValue("properties", (Object)patch, i);
        }
        gridModel.setValue("number", (Object)number, i);
        gridModel.setValue("id", (Object)nodeTemplateDynamicObject.getLong("id"), i);
        String name = nodeTemplateDynamicObject.getString("name");
        gridModel.setValue("name", (Object)name, i);
        gridModel.setValue("stenciltype", (Object)sourceNodeMap.get(nodeTemplateDynamicObject.getString("stenciltype")), i);
        Long groupIdValue = 0L;
        Object groupId = nodeTemplateDynamicObject.get("groupid");
        if (groupId instanceof Long) {
            groupIdValue = (Long)groupId;
        } else if (groupId instanceof DynamicObject) {
            groupIdValue = ((DynamicObject)groupId).getLong("id");
        }
        gridModel.setValue("groupid", (Object)groupIdValue, i);
        gridModel.setValue("entityid", (Object)billMap.get(nodeTemplateDynamicObject.getString("entityid")), i);
        String isInitialization = nodeTemplateDynamicObject.getString("isinitialization");
        gridModel.setValue("isinitialization", (Object)isInitialization, i);
        String isExtend = nodeTemplateDynamicObject.getString("isextend");
        gridModel.setValue("isextend", (Object)isExtend, i);
        gridModel.setValue(DEVELOPMENTTYPE, nodeTemplateDynamicObject.get(DEVELOPMENTTYPE), i);
        gridModel.setValue("enable", (Object)nodeTemplateDynamicObject.getString("enable"), i);
        Long creatorValue = 0L;
        Object creator = nodeTemplateDynamicObject.get("creator");
        if (creator instanceof Long) {
            creatorValue = (Long)creator;
        } else if (creator instanceof DynamicObject) {
            creatorValue = ((DynamicObject)creator).getLong("id");
        }
        gridModel.setValue("creator", (Object)creatorValue, i);
        gridModel.setValue("createtime", (Object)nodeTemplateDynamicObject.getDate("createtime"), i);
        Long modifierValue = 0L;
        Object modifier = nodeTemplateDynamicObject.get("modifier");
        if (modifier instanceof Long) {
            modifierValue = (Long)modifier;
        } else if (modifier instanceof DynamicObject) {
            modifierValue = ((DynamicObject)modifier).getLong("id");
        }
        gridModel.setValue("modifier", (Object)modifierValue, i);
        gridModel.setValue("modifytime", (Object)nodeTemplateDynamicObject.getDate("modifytime"), i);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYKEY_NODETEMPLATELIST);
        int[] rows = entryGrid.getSelectRows();
        switch (key) {
            case "deletebutton": {
                if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"4715e1f1000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5220\u9664\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.deleteNodeTemplate(rows);
                break;
            }
            case "nodeworkbox": {
                if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"2QY6K1GEB8LR")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8282\u70b9\u5de5\u5177\u7bb1\u914d\u7f6e\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showNodeWorkBoxPage();
                break;
            }
            case "importbutton": {
                this.showImportForm();
                break;
            }
            case "exportbutton": {
                this.exportNodeTemplate(rows);
                break;
            }
            case "enablebutton": {
                if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"4730fc5d000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u542f\u7528\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.activeOrDisableNodeTemplate(rows, true);
                break;
            }
            case "disabledbutton": {
                if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"47160c2b000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7981\u7528\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.activeOrDisableNodeTemplate(rows, false);
                break;
            }
            case "refresh": {
                this.setValueForNodeTemplateList();
                break;
            }
            case "extendbutton": {
                this.extendPropertyForTargetNode();
                break;
            }
            case "exportsql": {
                this.exportNodeTemplateSql(rows);
                break;
            }
            case "changelog": {
                this.viewChangeLog(rows);
                break;
            }
        }
    }

    private void exportNodeTemplateSql(int[] rows) {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"39DZNN+5RFT/")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bfc\u51fasql\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_55", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows == null || rows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"NodeTemplateLibraryTablePlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> numberList = new ArrayList<String>(rows.length);
        ArrayList<Long> idList = new ArrayList<Long>(rows.length);
        for (int rowIndex : rows) {
            DynamicObject row = this.getEntrtyEntityData(rowIndex);
            numberList.add(row.getString("number"));
            idList.add(row.getLong("id"));
        }
        ExportNodeTemplateSql exportNodeTemplateSql = new ExportNodeTemplateSql(this.getView());
        exportNodeTemplateSql.exportNodeTemplateSql(numberList, idList);
        ArrayList<String> logNumbers = new ArrayList<String>(numberList.size());
        for (String number : numberList) {
            logNumbers.add(number.trim());
        }
        WfUtils.addOpLog((String)"wf_nodetemplatelibrary", (String)TOOLBARAP_EXPORTBUTTON, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u51faSQL ", "NodeTemplateLibraryTablePlugin_40", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8282\u70b9\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8282\u70b9\u5bfc\u51faSQL\u6210\u529f\u3002", "NodeTemplateLibraryTablePlugin_41", "bos-wf-formplugin"), (Object[])new Object[]{logNumbers});
    }

    private void viewChangeLog(int[] rows) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (int rowIndex : rows) {
            DynamicObject row = this.getEntrtyEntityData(rowIndex);
            ids.add(row.getLong("id"));
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillFormId("wf_nodetemplatelog");
        parameter.setCustomParam("id", ids);
        IFormView parentView = DesignerModelUtil.getTabControlView(this.getView());
        if (parentView != null) {
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        } else {
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void showImportForm() {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)ProcessInstancePluginUtil.getPermissionAppId(this.getView()), (String)"wf_nodetemplatelibrary", (String)"4730fc9f000003ae")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bfc\u5165\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_importnodetemplate");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_IMPORTNODETEMPLATE));
        this.getView().showForm(parameter);
    }

    private void activeOrDisableNodeTemplate(int[] rows, boolean isEnable) {
        if (rows == null || rows.length <= 0) {
            this.getView().showTipNotification(this.getPromptMessageFirst());
            return;
        }
        ArrayList<String> selectNumbers = new ArrayList<String>(rows.length);
        for (int i : rows) {
            DynamicObject selectData = this.getEntrtyEntityData(i);
            if (selectData == null) continue;
            DynamicObject group = (DynamicObject)selectData.get("groupid");
            Long groupId = group == null ? 0L : group.getLong("id");
            if (NodeTemplateEntityConstants.SYSTEMNODEID.equals(groupId) && !"B".equals(selectData.get(DEVELOPMENTTYPE))) {
                if (isEnable) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u8282\u70b9\u4e0d\u80fd\u542f\u7528\u3002", (String)"NodeTemplateLibraryTablePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u8282\u70b9\u4e0d\u80fd\u7981\u7528\u3002", (String)"NodeTemplateLibraryTablePlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            selectNumbers.add(selectData.getString("number"));
        }
        this.getPageCache().put(SELECTNODETEMPLATENUMBER, SerializationUtils.toJsonString(selectNumbers));
        if (isEnable) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u542f\u7528?", (String)"WorkflowManageCenterPlugin_37", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ENABLE_CALL_BACK_CONFIRM));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u540e\uff0c\u5728\u201c\u8282\u70b9\u5de5\u5177\u7bb1\u914d\u7f6e\u201d\u65f6\u5c06\u4e0d\u80fd\u9009\u62e9\u6b64\u8282\u70b9\uff0c\u5728\u8bbe\u8ba1\u5668\u5de6\u4fa7\u8282\u70b9\u4e2d\u4e5f\u4e0d\u4f1a\u663e\u793a\u6b64\u8282\u70b9\uff0c\u786e\u8ba4\u8981\u7981\u7528\u5417\uff1f", (String)"NodeTemplateLibraryTablePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DISABLE_CALL_BACK));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((ENABLE_CALL_BACK_CONFIRM.equals(callBackId) || DISABLE_CALL_BACK.equals(callBackId)) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Boolean isEnabled = ENABLE_CALL_BACK_CONFIRM.equals(callBackId);
            if (!isEnabled.booleanValue() && !PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"47160c2b000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7981\u7528\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (isEnabled.booleanValue() && !PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"4730fc5d000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u542f\u7528\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String selectNodeTemplateNumberStr = this.getPageCache().get(SELECTNODETEMPLATENUMBER);
            List selectNodeTemplateNumberList = SerializationUtils.fromJsonStringToList((String)selectNodeTemplateNumberStr, String.class);
            ArrayList<String> selectNodeTemplateNumbers = new ArrayList<String>(selectNodeTemplateNumberList.size());
            for (String selectNodeTemplateNumber : selectNodeTemplateNumberList) {
                selectNodeTemplateNumbers.add(selectNodeTemplateNumber.trim());
            }
            String result = this.getRepositoryService().switchNodeTemplateEnable(selectNodeTemplateNumbers, isEnabled);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYKEY_NODETEMPLATELIST);
            int[] rows = entryGrid.getSelectRows();
            String enableValue = isEnabled != false ? "1" : "0";
            for (int i = 0; i < rows.length; ++i) {
                this.getModel().setValue("enable", (Object)enableValue, rows[i]);
            }
            this.getView().showSuccessNotification(result, Integer.valueOf(3000));
            String opKey = isEnabled != false ? "enable" : "disable";
            WfUtils.addOpLog((String)"wf_nodetemplatelibrary", (String)opKey, (MultiLangEnumBridge)(isEnabled != false ? new MultiLangEnumBridge("\u542f\u7528", "NodeTemplateLibraryTablePlugin_27", "bos-wf-formplugin") : new MultiLangEnumBridge("\u7981\u7528", "NodeTemplateLibraryTablePlugin_28", "bos-wf-formplugin")), (MultiLangEnumBridge)(isEnabled != false ? new MultiLangEnumBridge("%1$s\u542f\u7528\u6210\u529f", "NodeTemplateLibraryTablePlugin_29", "bos-wf-formplugin") : new MultiLangEnumBridge("%1$s\u7981\u7528\u6210\u529f", "NodeTemplateLibraryTablePlugin_30", "bos-wf-formplugin")), (Object[])new Object[]{((Object)selectNodeTemplateNumbers).toString()});
            this.getPageCache().remove(SELECTNODETEMPLATENUMBER);
        } else if (DELETE_CALL_BACK_CONFIRM.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"4715e1f1000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5220\u9664\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String nodeTemplateNumberPageCache = this.getPageCache().get(NODETEMPLATENUMBER);
            List nodeTemplateNumbers = SerializationUtils.fromJsonStringToList((String)nodeTemplateNumberPageCache, String.class);
            ArrayList<String> nodeTemplateNumberList = new ArrayList<String>(nodeTemplateNumbers.size());
            for (String nodeTemplateNumber : nodeTemplateNumbers) {
                nodeTemplateNumberList.add(nodeTemplateNumber.trim());
            }
            try {
                this.getRepositoryService().deleteNodeTemplateByNumber(nodeTemplateNumberList);
                this.setValueForNodeTemplateList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"NodeTemplateLibraryTablePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                WfUtils.addOpLog((String)WF_NODETEMPLATE, (String)"delete", (String)ResManager.getLocaleString((String)"\u5220\u9664", (String)"NodeTemplateLibraryTablePlugin_19", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u7f16\u7801\u4e3a\uff1a%s \u7684\u8282\u70b9\u6a21\u677f\u6210\u529f\u3002", "NodeTemplateLibraryTablePlugin_42", "bos-wf-formplugin"), (Object[])new Object[]{nodeTemplateNumbers.toString()});
                this.getPageCache().remove(NODETEMPLATENUMBER);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private void exportNodeTemplate(int[] rows) {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)ProcessInstancePluginUtil.getPermissionAppId(this.getView()), (String)"wf_nodetemplatelibrary", (String)"4730fc9f000004ae")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows == null || rows.length <= 0) {
            this.getView().showTipNotification(this.getPromptMessageFirst());
            return;
        }
        ArrayList<String> selectNumber = new ArrayList<String>();
        int[] indexs = ((EntryGrid)this.getControl(TREEENTRYKEY_NODETEMPLATELIST)).getSelectRows();
        DynamicObject selectDataFirst = null;
        for (int index : indexs) {
            DynamicObject selectData = this.getEntrtyEntityData(index);
            if (selectData == null) continue;
            if (Boolean.parseBoolean(selectData.getString("isinitialization")) || !"D".equals(selectData.getString(DEVELOPMENTTYPE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u51fa\u975e\u7cfb\u7edf\u9884\u7f6e\u7684\u8282\u70b9\u3002", (String)"NodeTemplateLibraryTablePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            selectNumber.add(selectData.getString("number"));
            if (selectDataFirst != null) continue;
            selectDataFirst = selectData;
        }
        this.getPageCache().put(SELECTNODETEMPLATENUMBER, SerializationUtils.toJsonString(selectNumber));
        String nodeTemplateName = selectDataFirst != null ? selectDataFirst.getString("name") : "";
        String fileName = "";
        if (rows.length > 1) {
            int size = rows.length;
            fileName = String.format("%s(%s)", nodeTemplateName, String.valueOf(size));
        } else {
            fileName = nodeTemplateName;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_modifyexportfilename");
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u8282\u70b9\u6a21\u677f", (String)"NodeTemplateLibraryTablePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("key", (Object)fileName);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_EXPORTNODETEMPLATE));
        this.getView().showForm(parameter);
    }

    private void deleteNodeTemplate(int[] rows) {
        if (rows == null || rows.length <= 0) {
            this.getView().showTipNotification(this.getPromptMessageFirst());
            return;
        }
        ArrayList<String> selectNumbers = new ArrayList<String>(rows.length);
        for (int i : rows) {
            DynamicObject selectData = this.getEntrtyEntityData(i);
            if (selectData == null) continue;
            selectNumbers.add(selectData.getString("number"));
        }
        this.getPageCache().put(NODETEMPLATENUMBER, SerializationUtils.toJsonString(selectNumbers));
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"NodeTemplateLibraryTablePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), rows.length), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_CALL_BACK_CONFIRM));
    }

    private void showNodeWorkBoxPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_nodeworkboxconfig");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_NODETOOLBOX));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(Boolean.FALSE.booleanValue());
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (key) {
            case "exportNodeTemplate": {
                this.packedZipAndExportFile(closedCallBackEvent);
                break;
            }
            case "nodeToolBox": {
                if (!(returnData instanceof Map)) break;
                Map returnMap = (Map)returnData;
                String result = (String)returnMap.get("result");
                String resultMessage = (String)returnMap.get("resultMessage");
                if ("success".equals(result)) {
                    this.getView().showSuccessNotification(resultMessage, Integer.valueOf(3000));
                    break;
                }
                if (!"failed".equals(result)) break;
                this.getView().showErrorNotification(resultMessage);
                break;
            }
            case "nodeTemplateAdd": {
                this.setValueForNodeTemplateList();
                break;
            }
            case "modifyProperties": {
                if (!(returnData instanceof Boolean) || !((Boolean)returnData).booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"NodeTemplateConfigPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                WfUtils.addOpLog((String)"wf_nodetemplatelibrary", (String)CALLBACK_KEY_MODIFYPROPERTIES, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c5e\u6027\u4fee\u6539", "NodeTemplateLibraryTablePlugin_31", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c5e\u6027\u4fee\u6539\u6210\u529f", "NodeTemplateLibraryTablePlugin_32", "bos-wf-formplugin"), (Object[])new Object[0]);
                this.setValueForNodeTemplateList();
                break;
            }
            case "importNodeTemplate": {
                if (!(returnData instanceof Map)) break;
                Map reslutMap = (Map)returnData;
                Boolean result = (Boolean)reslutMap.get("result");
                String message = (String)reslutMap.get("message");
                if (result.booleanValue()) {
                    this.getView().showSuccessNotification(message);
                    this.setValueForNodeTemplateList();
                } else {
                    this.getView().showErrorNotification(message);
                }
                WfUtils.addOpLog((String)"wf_nodetemplatelibrary", (String)TOOLBARAP_IMPORTBUTTON, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165", "NodeTemplateLibraryTablePlugin_26", "bos-wf-formplugin"), null, (Object[])new Object[]{message});
                break;
            }
            case "expend": {
                Map reslutMap;
                if (!(returnData instanceof Map) || !((Boolean)(reslutMap = (Map)returnData).get("result")).booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6269\u5c55\u6210\u529f\u3002", (String)"NodeTemplateLibraryTablePlugin_35", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                this.setValueForNodeTemplateList();
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void packedZipAndExportFile(ClosedCallBackEvent closedCallBackEvent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void extendPropertyForTargetNode() {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"39DYSNBAI96I")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6269\u5c55\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_54", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(TREEENTRYKEY_NODETEMPLATELIST);
        int[] rows = grid.getSelectRows();
        if (rows == null || rows.length != 1) {
            this.getView().showTipNotification(this.getPromptMessageFirst());
            return;
        }
        DynamicObject entryData = this.getEntrtyEntityData(rows[0]);
        if (!NodeTemplateLibraryUtil.isScalableNodes(entryData.getString("number"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8282\u70b9\u4e0d\u53ef\u6269\u5c55\u3002", (String)"NodeTemplateLibraryTablePlugin_34", (String)"bos-wf-formplugin", (Object[])new Object[0]), entryData.getString("name")));
            return;
        }
        Long sourceNodeId = entryData.getLong("id");
        DynamicObject groupDynamicObject = entryData.getDynamicObject("groupid");
        Long groupId = groupDynamicObject.getLong("id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("groupid", (Object)groupId);
        formShowParameter.setCustomParam("sourceNodeId", (Object)sourceNodeId);
        formShowParameter.setCustomParam("type", (Object)CALLBACK_KEY_EXPEND);
        formShowParameter.setFormId("wf_nodetemplateexpend");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_EXPEND));
        this.getView().showForm(formShowParameter);
    }

    private DynamicObject getEntrtyEntityData(int index) {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(TREEENTRYKEY_NODETEMPLATELIST);
        return (DynamicObject)entryDatas.get(index);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String fieldName = hyperLinkClickEvent.getFieldName();
        EntryGrid dynamictObject = (EntryGrid)hyperLinkClickEvent.getSource();
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = dynamictObject.getModel().getEntryRowEntity(TREEENTRYKEY_NODETEMPLATELIST, currentRowIndex);
        String number = entryRowEntity.getString("number");
        number = WfUtils.isEmpty((String)number) ? "" : number.trim();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String developmentType = entryRowEntity.getString(DEVELOPMENTTYPE);
        String isInitialization = entryRowEntity.getString("isinitialization");
        OperationStatus status = "D".equals(developmentType) && "false".equals(isInitialization) ? OperationStatus.EDIT : OperationStatus.VIEW;
        formShowParameter.setStatus(status);
        formShowParameter.setCustomParam("number", (Object)number);
        formShowParameter.setCustomParam("id", (Object)entryRowEntity.getString("id"));
        if ("properties".equals(fieldName)) {
            String name = entryRowEntity.getString("name");
            formShowParameter.setCaption(name);
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
            List nodeTemplate = this.getRepositoryService().findEntitiesByFilters(WF_NODETEMPLATE, filters);
            String processType = nodeTemplate == null || nodeTemplate.isEmpty() ? "AuditFlow" : ((NodeTemplateEntity)nodeTemplate.get(0)).getProcessType();
            formShowParameter.setCustomParam("processType", (Object)processType);
            formShowParameter.setCustomParam("model_type", (Object)GraphCodecUtils.getModelTypeByProcessType((String)processType));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_MODIFYPROPERTIES));
            formShowParameter.setFormId("wf_nodeconfigview");
        } else if ("number".equals(fieldName) && "B".equals(entryRowEntity.getString(DEVELOPMENTTYPE))) {
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "nodeTemplateExpend"));
            formShowParameter.setFormId("wf_nodetemplateexpend");
        } else if ("number".equals(fieldName)) {
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_NODETEMPLATEADD));
            formShowParameter.setFormId("wf_nodetemplateadd");
        }
        this.getView().showForm(formShowParameter);
    }

    public void customEvent(CustomEventArgs e) {
        this.setValueForNodeTemplateList();
    }

    private String getPromptMessageFirst() {
        return StandardTips.notSelectRowTips();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYKEY_NODETEMPLATELIST);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Boolean> selectResult = new ArrayList<Boolean>(selectRows.length);
        if (selectRows.length > 0) {
            for (int row : selectRows) {
                selectResult.add(Boolean.valueOf((String)this.getModel().getValue("isinitialization", row)));
            }
        }
        if (!selectResult.isEmpty() && selectResult.contains(true)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{TOOLBARAP_DELETEBUTTON});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{TOOLBARAP_DELETEBUTTON});
        }
        if (selectRows.length == 1 && NodeTemplateLibraryUtil.isScalableNodes(this.getEntrtyEntityData(selectRows[0]).getString("number"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{TOOLBARAP_EXTENDBUTTON});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{TOOLBARAP_EXTENDBUTTON});
        }
    }
}

