/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.util.NodeTemplateLibraryUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntityConstants;

public class NodeTemplateLibraryTreePlugin
extends AbstractWorkflowPlugin
implements TreeNodeClickListener {
    private static final String PARENT = "parent";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String BTN_ADDDIM = "btn_adddim";
    private static final String BTN_DELDIM = "btn_deldim";
    private static final String BTN_EDITDIM = "btn_editdim";
    private static final String SELECTNODEID = "selectNodeId";
    private static final String WF_NODETEMPLATEGROUP = "wf_nodetemplategroup";
    private static final String TREEVIEWAP = "treeviewap";
    public static final String TOOLBARAP = "toolbarap";
    public static final String TOOLBARAP_REFRESH = "refresh";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_ADDDIM, BTN_DELDIM, BTN_EDITDIM});
        TreeView dimtree = (TreeView)this.getControl(TREEVIEWAP);
        dimtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.constructorData("initialize");
    }

    private void constructorData(String type) {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEWAP);
        treeView.deleteAllNodes();
        String rootId = "0";
        TreeNode rootNode = new TreeNode(null, "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"NodeTemplateLibraryTreePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), true);
        rootNode.setIsOpened(true);
        QFilter filter1 = new QFilter("enable", "=", (Object)"1");
        filter1.and(new QFilter(ID, "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID));
        filter1.and(new QFilter(PARENT, "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID));
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObject[] nodeTemplateGroups = BusinessDataServiceHelper.load((String)WF_NODETEMPLATEGROUP, (String)"id,number,name,parent,isinitialization", (QFilter[])filters, (String)"sequence");
        HashMap<String, String> nodeTemplateGroupParentAndChildren = new HashMap<String, String>();
        HashMap<String, TreeNode> treeNodesMap = new HashMap<String, TreeNode>();
        if (nodeTemplateGroups == null || nodeTemplateGroups.length == 0) {
            this.logger.debug("Select the nodeTemplateGroup by t_wf_nodetemplategroup is null.Data is abnormal");
            return;
        }
        for (DynamicObject firstNodeTemplateGroup : nodeTemplateGroups) {
            Object groupDynamicObject = firstNodeTemplateGroup.get(PARENT);
            if (groupDynamicObject != null) continue;
            ArrayList<Long> parentAndChildrenIdList = new ArrayList<Long>();
            Long primaryNodeGroupId = 0L;
            Long primaryNodeId = firstNodeTemplateGroup.getLong(ID);
            parentAndChildrenIdList.add(primaryNodeId);
            String primaryNodeKey = primaryNodeGroupId + "-" + primaryNodeId;
            ILocaleString primaryNodeName = firstNodeTemplateGroup.getLocaleString(NAME);
            String primaryNodeText = firstNodeTemplateGroup.getString(NAME);
            if (WfUtils.isNotEmpty((ILocaleString)primaryNodeName)) {
                primaryNodeText = WfUtils.isEmpty((String)primaryNodeName.getLocaleValue()) ? (String)primaryNodeName.getDefaultItem() : primaryNodeName.getLocaleValue();
            }
            TreeNode primaryNode = new TreeNode("0", primaryNodeKey, primaryNodeText, false);
            treeNodesMap.put(String.valueOf(primaryNodeId), primaryNode);
            primaryNode.setIsOpened(false);
            for (DynamicObject secNodeTemplateGroup : nodeTemplateGroups) {
                DynamicObject secGroupDynamicObject;
                DynamicObject dynamicObject = secGroupDynamicObject = secNodeTemplateGroup.get(PARENT) == null ? null : (DynamicObject)secNodeTemplateGroup.get(PARENT);
                if (secGroupDynamicObject == null || secGroupDynamicObject.getLong(ID) != primaryNodeId.longValue()) continue;
                parentAndChildrenIdList.add(secNodeTemplateGroup.getLong(ID));
                String p2 = primaryNodeKey + "-" + secNodeTemplateGroup.getLong(ID);
                ILocaleString secNodeName = secNodeTemplateGroup.getLocaleString(NAME);
                String secNodeTemplateText = secNodeTemplateGroup.getString(NAME);
                if (WfUtils.isNotEmpty((ILocaleString)secNodeName)) {
                    secNodeTemplateText = WfUtils.isEmpty((ILocaleString)secNodeTemplateGroup.getLocaleString(NAME)) || WfUtils.isEmpty((String)secNodeTemplateGroup.getLocaleString(NAME).getLocaleValue()) ? (String)secNodeName.getDefaultItem() : secNodeTemplateGroup.getLocaleString(NAME).getLocaleValue();
                }
                TreeNode tn2 = new TreeNode(primaryNodeKey, p2, secNodeTemplateText, false);
                treeNodesMap.put(p2, tn2);
                primaryNode.addChild(tn2);
            }
            rootNode.addChild(primaryNode);
            nodeTemplateGroupParentAndChildren.put(String.valueOf(primaryNodeId), SerializationUtils.toJsonString(parentAndChildrenIdList));
        }
        treeView.addNode(rootNode);
        if ("ADDNEW".equals(type)) {
            String selectNodeId = this.getPageCache().get(SELECTNODEID);
            TreeNode tageTreeNode = null;
            if (treeNodesMap.containsKey(selectNodeId)) {
                tageTreeNode = (TreeNode)treeNodesMap.get(selectNodeId);
            }
            if (tageTreeNode == null) {
                tageTreeNode = rootNode;
            }
            treeView.focusNode(tageTreeNode);
        } else {
            treeView.focusNode(rootNode);
        }
        this.getPageCache().put(nodeTemplateGroupParentAndChildren);
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_adddim": {
                this.addGroup();
                break;
            }
            case "btn_deldim": {
                this.deleteGroup();
                break;
            }
            case "btn_editdim": {
                this.changeGroup();
                break;
            }
        }
    }

    private void changeGroup() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)WF_NODETEMPLATEGROUP, (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8282\u70b9\u6a21\u677f\u5206\u7ec4\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"NodeTemplateLibraryTreePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectNodeIdStr = this.getPageCache().get(SELECTNODEID);
        if (WfUtils.isEmpty((String)selectNodeIdStr) || "0".equals(selectNodeIdStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"NodeTemplateLibraryTreePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(selectNodeIdStr))};
        DynamicObject nodeTemplateGroup = QueryServiceHelper.queryOne((String)WF_NODETEMPLATEGROUP, (String)"isinitialization", (QFilter[])filters);
        Long selectNodeId = Long.valueOf(selectNodeIdStr);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId((Object)selectNodeId);
        parameter.setFormId(WF_NODETEMPLATEGROUP);
        if (nodeTemplateGroup != null && "A".equals(nodeTemplateGroup.getString("isinitialization"))) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.setCustomParam("selectedId", (Object)selectNodeIdStr);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "EDIT"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void deleteGroup() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)WF_NODETEMPLATEGROUP, (String)"4715e1f1000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8282\u70b9\u6a21\u677f\u5206\u7ec4\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", (String)"NodeTemplateLibraryTreePlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectNodeIdStr = this.getPageCache().get(SELECTNODEID);
        if (WfUtils.isEmpty((String)selectNodeIdStr) || "0".equals(selectNodeIdStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u53ef\u5220\u9664\u3002", (String)"NodeTemplateLibraryTreePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(selectNodeIdStr))};
        DynamicObject nodeTemplate = QueryServiceHelper.queryOne((String)WF_NODETEMPLATEGROUP, (String)NAME, (QFilter[])filters);
        String name = nodeTemplate.getString(NAME);
        if (NodeTemplateLibraryUtil.isSystemInitializationGroup(selectNodeIdStr)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u9884\u7f6e\u5206\u7ec4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"NodeTemplateLibraryTreePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), name));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u5206\u7ec4%s\uff1f", (String)"NodeTemplateLibraryTreePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), name), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delete"));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("delete".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            QFilter nodeTemplateFilter;
            QFilter[] nodeTemplateFilters;
            List<Long> parentAndChildrenIdList;
            String selectNodeIdStr = this.getPageCache().get(SELECTNODEID);
            String parentAndChildrenIdListStr = this.getPageCache().get(selectNodeIdStr);
            List list = parentAndChildrenIdList = WfUtils.isEmpty((String)parentAndChildrenIdListStr) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)parentAndChildrenIdListStr, List.class);
            if (parentAndChildrenIdList.isEmpty()) {
                parentAndChildrenIdList.add(Long.valueOf(selectNodeIdStr));
            }
            if (QueryServiceHelper.exists((String)"wf_nodetemplate", (QFilter[])(nodeTemplateFilters = new QFilter[]{nodeTemplateFilter = new QFilter("groupid", "in", parentAndChildrenIdList)}))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u5206\u7ec4\u3002\u9009\u4e2d\u7684\u5206\u7ec4\u6216\u5176\u5b50\u5206\u7ec4\u5b58\u5728\u8282\u70b9\u6a21\u677f\uff0c\u8bf7\u5148\u5220\u9664\u8282\u70b9\u6a21\u677f\uff0c\u518d\u5220\u9664\u5206\u7ec4\u3002", (String)"NodeTemplateLibraryTreePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter groupFilter = new QFilter(ID, "in", parentAndChildrenIdList);
            QFilter[] groupFilters = new QFilter[]{groupFilter};
            DeleteServiceHelper.delete((String)WF_NODETEMPLATEGROUP, (QFilter[])groupFilters);
            this.getPageCache().remove(SELECTNODEID);
            this.getPageCache().remove("treeQFilter");
            this.constructorData("delete");
            CustomEventArgs customEvent = new CustomEventArgs((Object)this.getView(), "tree", "tree", null);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent(customEvent);
        }
    }

    private void addGroup() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)WF_NODETEMPLATEGROUP, (String)"47156aff000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8282\u70b9\u6a21\u677f\u5206\u7ec4\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"NodeTemplateLibraryTreePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectNodeId = this.getPageCache().get(SELECTNODEID);
        if (NodeTemplateLibraryUtil.isSystemNodeGroup(selectNodeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5728\u201c\u7cfb\u7edf\u8282\u70b9\u201d\u5206\u7ec4\u4e0b\u65b0\u589e\u5206\u7ec4\u3002", (String)"NodeTemplateLibraryTreePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(WF_NODETEMPLATEGROUP);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParam("selectedId", (Object)this.getPageCache().get(SELECTNODEID));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ADDNEW"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if ("ADDNEW".equals(key)) {
            this.constructorData("ADDNEW");
        } else if ("EDIT".equals(key)) {
            this.getPageCache().remove(SELECTNODEID);
            this.constructorData("EDIT");
            CustomEventArgs customEvent = new CustomEventArgs((Object)this.getView(), "tree", "tree", null);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent(customEvent);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree = (TreeView)evt.getSource();
        TreeView.TreeState state = tree.getTreeState();
        Map focusNode = state.getFocusNode();
        String selectNodeIdStr = "";
        if (focusNode != null && !focusNode.isEmpty()) {
            String id = focusNode.get(ID).toString();
            String parentId = focusNode.get("parentid").toString();
            selectNodeIdStr = id.replace(parentId + "-", "");
            this.getPageCache().put(SELECTNODEID, selectNodeIdStr);
        }
        String parentAndChildrenIdListStr = this.getPageCache().get(selectNodeIdStr);
        if (WfUtils.isNotEmpty((String)selectNodeIdStr) && !"0".equals(selectNodeIdStr)) {
            List<Long> parentAndChildrenIdList;
            List list = parentAndChildrenIdList = WfUtils.isEmpty((String)parentAndChildrenIdListStr) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)parentAndChildrenIdListStr, List.class);
            if (parentAndChildrenIdList.isEmpty()) {
                parentAndChildrenIdList.add(Long.valueOf(selectNodeIdStr));
            }
            QFilter qFilter = new QFilter("groupid", "in", parentAndChildrenIdList);
            this.getPageCache().put("treeQFilter", SerializationUtils.toJsonString((Object)qFilter));
        } else if ("0".equals(selectNodeIdStr)) {
            this.getPageCache().put("treeQFilter", null);
        }
        CustomEventArgs customEvent = new CustomEventArgs((Object)this.getView(), "tree", "tree", null);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent(customEvent);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (TOOLBARAP_REFRESH.equals(key)) {
            this.constructorData("initialize");
        }
    }
}

