/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.nodetemplatelibrary.NodeTemplateExpendSaveCustomEvent;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class NodeTemplatePluginExpendPlugin
extends AbstractWorkflowPlugin {
    private static final String PLUGINEXPENDENTRYENTITY = "pluginexpendentryentity";
    private static final String KEY_ENTRYENTITY_PLUGINNUMBER = "pluginnumber";
    private static final String KEY_ENTRYENTITY_PLUGINNAME = "pluginname";
    private static final String KEY_ENTRYENTITY_PLUGINSCENE = "pluginscene";
    private static final String KEY_ENTRYENTITY_EXECUITONTIME = "execuitontime";
    private static final String KEY_ENTRYENTITY_PLUGINTYPE = "plugintype";
    private static final String KEY_ENTRYENTITY_PLUGINVALUE = "pluginvalue";
    private static final String KEY_ENTRYENTITY_PLUGINTYPEANDVALUE = "plugintypeandvalue";
    private static final String KEY_ENTRYENTITY_PLUGINDESCRIPTION = "plugindescription";
    private static final String KEY_EXPENDSAVE = "expendSave";
    private static final String KEY_EXPENDINITIALIZE = "expendInitialize";
    private static final String PLUGINS = "plugins";
    private static final String EXECUTIONLISTENERS = "executionListeners";
    private static final String AUDITLISTENERS = "auditListeners";
    private static final String PLUGINNUMBER = "pluginNumber";
    private static final String PLUGINNAME = "pluginName";
    private static final String PLUGINSCENE = "pluginScene";
    private static final String EVENT = "event";
    private static final String IMPLEMENTATIONTYPE = "implementationtype";
    private static final String PLUGINTYPEANDVALUE = "pluginTypeAndValue";
    private static final String PLUGINDESCRIPTION = "plugindeScription";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit outmsgRule = (TextEdit)this.getControl(KEY_ENTRYENTITY_PLUGINVALUE);
        outmsgRule.addButtonClickListener((ClickListener)this);
    }

    public void customEvent(CustomEventArgs e) {
        if (KEY_EXPENDSAVE.equals(e.getKey())) {
            this.getPluginSaveData((NodeTemplateExpendSaveCustomEvent)e);
        } else if (KEY_EXPENDINITIALIZE.equals(e.getKey())) {
            this.initializeExpendPlugin(e.getEventArgs());
        }
    }

    private void initializeExpendPlugin(String expendDataJson) {
        if (WfUtils.isEmpty((String)expendDataJson)) {
            return;
        }
        JSONObject expendData = JSONObject.parseObject((String)expendDataJson);
        JSONObject extendedplugins = WfUtils.isEmpty((String)expendData.getString(PLUGINS)) ? new JSONObject() : (JSONObject)expendData.get((Object)PLUGINS);
        JSONArray executionListeners = extendedplugins.getJSONArray(EXECUTIONLISTENERS);
        JSONArray auditListeners = extendedplugins.getJSONArray(AUDITLISTENERS);
        int size = executionListeners == null ? 0 : executionListeners.size();
        int n = size = auditListeners == null ? size : size + auditListeners.size();
        if (size != 0) {
            this.getModel().deleteEntryData(PLUGINEXPENDENTRYENTITY);
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(PLUGINEXPENDENTRYENTITY, size);
        }
        int rowIndex = this.setEntryEntityValue(executionListeners, 0);
        this.setEntryEntityValue(auditListeners, rowIndex);
    }

    private int setEntryEntityValue(JSONArray listeners, int rowIndex) {
        if (listeners != null && !listeners.isEmpty()) {
            for (Object object : listeners) {
                JSONObject executionListener = (JSONObject)object;
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINNUMBER, (Object)executionListener.getString(PLUGINNUMBER), rowIndex);
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINNAME, (Object)WfMultiLangUtils.getMultiLangValue((Map)((Map)executionListener.get((Object)PLUGINNAME))), rowIndex);
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINSCENE, (Object)executionListener.getString(PLUGINSCENE), rowIndex);
                this.getModel().setValue(KEY_ENTRYENTITY_EXECUITONTIME, (Object)executionListener.getString(EVENT), rowIndex);
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINTYPE, (Object)executionListener.getString(IMPLEMENTATIONTYPE), rowIndex);
                String pluginTypeAndValue = executionListener.getString(PLUGINTYPEANDVALUE);
                if (WfUtils.isNotEmpty((String)pluginTypeAndValue)) {
                    this.getModel().setValue(KEY_ENTRYENTITY_PLUGINVALUE, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)pluginTypeAndValue), rowIndex);
                }
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINTYPEANDVALUE, (Object)executionListener.getString(PLUGINTYPEANDVALUE), rowIndex);
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINDESCRIPTION, (Object)WfMultiLangUtils.getMultiLangValue((Map)((Map)executionListener.get((Object)PLUGINDESCRIPTION))), rowIndex);
                ++rowIndex;
            }
        }
        return rowIndex;
    }

    private void getPluginSaveData(NodeTemplateExpendSaveCustomEvent e) {
        DynamicObjectCollection pluginDynamicObjectCollection = this.getModel().getEntryEntity(PLUGINEXPENDENTRYENTITY);
        if (pluginDynamicObjectCollection == null || pluginDynamicObjectCollection.isEmpty()) {
            return;
        }
        HashMap executionAndAuditTaskMap = new HashMap(2);
        ArrayList executionListenersList = new ArrayList();
        ArrayList auditListenersList = new ArrayList();
        for (DynamicObject plugin : pluginDynamicObjectCollection) {
            HashMap<String, Object> pluginVariable = new HashMap<String, Object>(8);
            String pluginNumber = plugin.getString(KEY_ENTRYENTITY_PLUGINNUMBER);
            ILocaleString pluginName = plugin.getLocaleString(KEY_ENTRYENTITY_PLUGINNAME);
            String pluginScene = plugin.getString(KEY_ENTRYENTITY_PLUGINSCENE);
            String execuitontTime = plugin.getString(KEY_ENTRYENTITY_EXECUITONTIME);
            String pluginType = plugin.getString(KEY_ENTRYENTITY_PLUGINTYPE);
            String pluginValue = plugin.getString(KEY_ENTRYENTITY_PLUGINVALUE);
            String pluginTypeAndValue = plugin.getString(KEY_ENTRYENTITY_PLUGINTYPEANDVALUE);
            ILocaleString plugindeScription = plugin.getLocaleString(KEY_ENTRYENTITY_PLUGINDESCRIPTION);
            if (this.isVerifyfail(e, pluginNumber, pluginName, pluginScene, execuitontTime, pluginType, pluginValue, plugindeScription)) {
                return;
            }
            pluginVariable.put(PLUGINDESCRIPTION, plugindeScription);
            pluginVariable.put(PLUGINNAME, pluginName);
            pluginVariable.put(PLUGINNUMBER, pluginNumber);
            pluginVariable.put(IMPLEMENTATIONTYPE, pluginType);
            pluginVariable.put(PLUGINTYPEANDVALUE, pluginTypeAndValue);
            JSONObject pluginFull = JSONObject.parseObject((String)pluginTypeAndValue);
            pluginVariable.put("implementation", pluginFull.getString("value"));
            pluginVariable.put(EVENT, execuitontTime);
            if ("runtime".equals(pluginScene)) {
                pluginVariable.put(PLUGINSCENE, pluginScene);
                executionListenersList.add(pluginVariable);
                continue;
            }
            pluginVariable.put(PLUGINSCENE, pluginScene);
            auditListenersList.add(pluginVariable);
        }
        executionAndAuditTaskMap.put(EXECUTIONLISTENERS, executionListenersList);
        executionAndAuditTaskMap.put(AUDITLISTENERS, auditListenersList);
        e.getExpendPropertiesMap().put(PLUGINS, executionAndAuditTaskMap);
    }

    private boolean isVerifyfail(NodeTemplateExpendSaveCustomEvent e, String pluginNumber, ILocaleString pluginName, String pluginScene, String execuitontTime, String pluginType, String pluginValue, ILocaleString plugindeScription) {
        if (this.isAllDataValid(pluginScene, pluginName, pluginType, pluginValue, pluginNumber, execuitontTime, plugindeScription)) {
            e.setCancel(true);
            String message = WfUtils.isEmpty((String)e.getVerifyInformation()) ? ResManager.loadKDString((String)"\u63d2\u4ef6\u6269\u5c55\u6240\u6709\u6570\u636e\u90fd\u662f\u5fc5\u586b\u9879\u3002", (String)"NodeTemplatePluginExpendPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]) : e.getVerifyInformation() + " " + ResManager.loadKDString((String)"\u63d2\u4ef6\u6269\u5c55\u6240\u6709\u6570\u636e\u90fd\u662f\u5fc5\u586b\u9879\u3002", (String)"NodeTemplatePluginExpendPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            e.setVerifyInformation(message);
            return true;
        }
        if (!pluginNumber.matches("^[A-Za-z][A-Za-z0-9_]*$")) {
            e.setCancel(true);
            String message = WfUtils.isEmpty((String)e.getVerifyInformation()) ? ResManager.loadKDString((String)"\u201c\u63d2\u4ef6\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplatePluginExpendPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]) : e.getVerifyInformation() + " " + ResManager.loadKDString((String)"\u201c\u63d2\u4ef6\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"NodeTemplatePluginExpendPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            e.setVerifyInformation(message);
            return true;
        }
        return false;
    }

    private boolean isAllDataValid(String pluginScene, ILocaleString pluginName, String pluginType, String pluginValue, String pluginNumber, String execuitontTime, ILocaleString plugindeScription) {
        return WfUtils.isEmpty((String)pluginNumber) || WfUtils.isEmpty((String)execuitontTime) || WfUtils.isEmpty((String)pluginScene) || WfUtils.isEmpty((ILocaleString)pluginName) || WfUtils.isEmpty((String)pluginType) || WfUtils.isEmpty((String)pluginValue) || WfUtils.isEmpty((ILocaleString)plugindeScription);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (KEY_ENTRYENTITY_PLUGINVALUE.equals(key)) {
            this.showAddPlugin();
        }
    }

    private void showAddPlugin() {
        IFormView view = this.getView();
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class"});
        view.getFormShowParameter().setCustomParam("hideParameterConfig", (Object)Boolean.TRUE);
        String value = "";
        DesignerPluginUtil.openExternalInterface(view, (IFormPlugin)this, types, "", value);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("externalInterface".equals(key) && WfUtils.isNotEmptyString((Object)returnData)) {
            this.getModel().setValue(KEY_ENTRYENTITY_PLUGINTYPEANDVALUE, (Object)((String)returnData));
            this.getModel().setValue(KEY_ENTRYENTITY_PLUGINVALUE, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)((String)returnData)));
            this.getModel().setValue(KEY_ENTRYENTITY_PLUGINTYPE, (Object)ExternalInterfaceUtil.getExtItfType((String)((String)returnData)));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (KEY_ENTRYENTITY_EXECUITONTIME.equals(propertyName)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(PLUGINEXPENDENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            if ("approvalpageplugin".equals(newValueObj)) {
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINSCENE, (Object)"approvaltime", rows[0]);
            } else {
                this.getModel().setValue(KEY_ENTRYENTITY_PLUGINSCENE, (Object)"runtime", rows[0]);
            }
        }
    }
}

