/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TransferContainer;
import kd.bos.form.transfer.TransferTreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntityConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeToolBoxEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeToolBoxEntityConstants;

public class NodeToolBoxConfigPlugin
extends AbstractWorkflowPlugin {
    private static final String CONFIRM = "btnok";
    private static final String NUMBER = "number";
    private static final String PREVIEW = "preview";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM, PREVIEW});
    }

    public void afterCreateNewData(EventObject e) {
        if (!"zh_CN".equals(RequestContext.get().getLang().toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PREVIEW});
        }
        TransferContainer transferContainer = (TransferContainer)this.getControl("nodeselection");
        QFilter[] nodeGroupFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("id", "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID), new QFilter("parent", "!=", (Object)NodeTemplateGroupEntityConstants.NOCODEGROUPID)};
        DynamicObject[] nodeGroups = BusinessDataServiceHelper.load((String)"wf_nodetemplategroup", (String)"number,name,id", (QFilter[])nodeGroupFilters, (String)"sequence");
        LinkedHashMap<Long, DynamicObject> nodeGroupMap = new LinkedHashMap<Long, DynamicObject>(nodeGroups.length);
        ArrayList<Long> nodeGroupIdList = new ArrayList<Long>(nodeGroups.length);
        for (DynamicObject nodeGroup : nodeGroups) {
            Long groupId = nodeGroup.getLong("id");
            nodeGroupMap.put(groupId, nodeGroup);
            nodeGroupIdList.add(groupId);
        }
        QFilter[] nodeTemplateFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("groupid", "in", nodeGroupIdList), new QFilter("ishidden", "!=", (Object)"1"), new QFilter("developmenttype", "!=", (Object)"B")};
        List includeHrNodeTemplates = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", nodeTemplateFilters);
        ArrayList<Object> enableNodeTemplates = new ArrayList<Object>(includeHrNodeTemplates.size());
        for (Object nodeTemplateEntity : includeHrNodeTemplates) {
            if ("HRActivity".equals(nodeTemplateEntity.getStencilType()) && WfUtils.isNotEmpty((String)nodeTemplateEntity.getBizIdentification())) continue;
            enableNodeTemplates.add(nodeTemplateEntity);
        }
        LinkedHashMap<Long, ArrayList<Object>> enableNodeTemplateAndGroupMap = new LinkedHashMap<Long, ArrayList<Object>>();
        for (Object enableNodeTemplate : enableNodeTemplates) {
            long groupId = enableNodeTemplate.getGroupId();
            ArrayList<Object> enableNodeTemplateList = (ArrayList<Object>)enableNodeTemplateAndGroupMap.get(groupId);
            if (enableNodeTemplateList == null) {
                enableNodeTemplateList = new ArrayList<Object>();
                enableNodeTemplateAndGroupMap.put(groupId, enableNodeTemplateList);
            }
            enableNodeTemplateList.add(enableNodeTemplate);
        }
        LinkedHashMap orderEnableNodeTemplateAndGroupMap = new LinkedHashMap(enableNodeTemplateAndGroupMap.size());
        for (Long nodeGroupId : nodeGroupIdList) {
            orderEnableNodeTemplateAndGroupMap.put(nodeGroupId, enableNodeTemplateAndGroupMap.get(nodeGroupId));
        }
        Set entrySet = orderEnableNodeTemplateAndGroupMap.entrySet();
        ArrayList<TransferTreeNode> transferTreeNodes = new ArrayList<TransferTreeNode>(orderEnableNodeTemplateAndGroupMap.size());
        for (Map.Entry entry : entrySet) {
            Long groupId = (Long)entry.getKey();
            List childrenNodes = (List)entry.getValue();
            if (childrenNodes == null || childrenNodes.isEmpty()) continue;
            DynamicObject nodeGroupDynamicObject = (DynamicObject)nodeGroupMap.get(groupId);
            String groupNumber = String.format("%s_%s", "group", nodeGroupDynamicObject.getString(NUMBER));
            TransferTreeNode groupNode = new TransferTreeNode(groupNumber, nodeGroupDynamicObject.getString("name"), Boolean.valueOf(true));
            groupNode.setIsOpened(Boolean.TRUE);
            for (NodeTemplateEntity childrenNode : childrenNodes) {
                TransferTreeNode childNode = new TransferTreeNode(childrenNode.getNumber(), childrenNode.getName(), Boolean.valueOf(false));
                groupNode.addChild(childNode);
            }
            transferTreeNodes.add(groupNode);
        }
        ArrayList selectList = new ArrayList();
        QFilter[] selectedNodeTemplateFilters = new QFilter[]{new QFilter("id", "=", (Object)NodeToolBoxEntityConstants.DEFAULTID)};
        List nodeToolBoxEntitys = this.getRepositoryService().findEntitiesByFilters("wf_nodetoolbox", selectedNodeTemplateFilters);
        DynamicObjectCollection nodeToolBoxConfigs = null;
        if (nodeToolBoxEntitys != null && !nodeToolBoxEntitys.isEmpty()) {
            nodeToolBoxConfigs = ((NodeToolBoxEntity)nodeToolBoxEntitys.get(0)).getNodeTemplateEntry();
            ArrayList<Long> nodeTemplateIds = new ArrayList<Long>(16);
            for (DynamicObject nodeToolBoxConfig : nodeToolBoxConfigs) {
                DynamicObject nodeTemplate = nodeToolBoxConfig.getDynamicObject("nodetemplate");
                if (nodeTemplate == null) continue;
                nodeTemplateIds.add(nodeTemplate.getLong("id"));
            }
            QFilter selectedNodeFilter1 = new QFilter("id", "in", nodeTemplateIds);
            QFilter selectedNodeFilter2 = new QFilter("enable", "=", (Object)"1");
            QFilter[] selectedNodeFilters = new QFilter[]{selectedNodeFilter1, selectedNodeFilter2};
            List selectedNodeTemplates = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", selectedNodeFilters);
            int size = selectedNodeTemplates == null ? 1 : selectedNodeTemplates.size();
            HashMap<Long, String> selectedNodeTemplateMap = new HashMap<Long, String>(size);
            if (selectedNodeTemplates != null) {
                for (NodeTemplateEntity nodeTemplateEntity : selectedNodeTemplates) {
                    selectedNodeTemplateMap.put(nodeTemplateEntity.getId(), nodeTemplateEntity.getNumber());
                }
                selectList = new ArrayList(selectedNodeTemplates.size());
            }
            for (Long nodeTemplateId : nodeTemplateIds) {
                if (!WfUtils.isNotEmpty((String)((String)selectedNodeTemplateMap.get(nodeTemplateId)))) continue;
                selectList.add(selectedNodeTemplateMap.get(nodeTemplateId));
            }
        }
        transferContainer.setTransferListData(transferTreeNodes, selectList);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CONFIRM.equals(key)) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_nodetemplatelibrary", (String)"2QY6K1GEB8LR")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8282\u70b9\u5de5\u5177\u7bb1\u914d\u7f6e\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> resultMap = new HashMap<String, String>();
            try {
                TransferContainer transferContainer = (TransferContainer)this.getControl("nodeselection");
                List selectedDatas = transferContainer.getSelectedData();
                if (selectedDatas == null) {
                    this.getView().close();
                    return;
                }
                if (selectedDatas.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"NodeToolBoxConfigPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.saveNodeToolboxConfiguration(selectedDatas);
                resultMap.put("result", "success");
                resultMap.put("resultMessage", ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"NodeToolBoxConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                this.getView().returnDataToParent(resultMap);
                WfUtils.addOpLog((String)"wf_nodetemplate", (String)"nodeToolBoxConfig", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8282\u70b9\u5de5\u5177\u7bb1\u914d\u7f6e", "NodeToolBoxConfigPlugin_4", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8282\u70b9\u5de5\u5177\u7bb1\u91cd\u65b0\u914d\u7f6e\u6210\u529f,\u914d\u7f6e\u8282\u70b9\u4e3a\uff1a%s", "NodeToolBoxConfigPlugin_5", "bos-wf-formplugin"), (Object[])new Object[]{selectedDatas.toString()});
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                resultMap.put("result", "failed");
                resultMap.put("resultMessage", String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"NodeToolBoxConfigPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
                this.getView().returnDataToParent(resultMap);
            }
            this.getView().close();
        } else if (PREVIEW.equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wf_nodeworkboxpreview");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    private void saveNodeToolboxConfiguration(List<Object> selectedDatas) {
        ArrayList<String> selectedNumbers = new ArrayList<String>(selectedDatas.size());
        for (Object selectedData : selectedDatas) {
            Map map = (Map)selectedData;
            selectedNumbers.add((String)map.get("id"));
        }
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "in", selectedNumbers)};
        List nodeTemplatesOutOfOrder = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", filters);
        int size = nodeTemplatesOutOfOrder == null ? 1 : nodeTemplatesOutOfOrder.size();
        HashMap<String, NodeTemplateEntity> nodeTemplateMap = new HashMap<String, NodeTemplateEntity>(size);
        if (nodeTemplatesOutOfOrder != null) {
            for (NodeTemplateEntity nodeTemplateEntity : nodeTemplatesOutOfOrder) {
                nodeTemplateMap.put(nodeTemplateEntity.getNumber(), nodeTemplateEntity);
            }
        }
        ArrayList nodeTemplates = new ArrayList(16);
        for (String selectedNumber : selectedNumbers) {
            nodeTemplates.add(nodeTemplateMap.get(selectedNumber));
        }
        QFilter[] nodeToolBoxFilters = new QFilter[]{new QFilter("id", "=", (Object)NodeToolBoxEntityConstants.DEFAULTID)};
        DynamicObject nodeToolBox = BusinessDataServiceHelper.loadSingle((String)"wf_nodetoolbox", (QFilter[])nodeToolBoxFilters);
        DynamicObjectCollection nodeTemplateEntry = nodeToolBox.getDynamicObjectCollection("nodetemplateentryentity");
        nodeTemplateEntry.clear();
        ArrayList<String> nodeTemplateNames = new ArrayList<String>(nodeTemplates.size());
        for (int i = 0; i < nodeTemplates.size(); ++i) {
            NodeTemplateEntity nodeTemplate = (NodeTemplateEntity)nodeTemplates.get(i);
            DynamicObject dynamicObject = nodeTemplateEntry.addNew();
            dynamicObject.set("nodetemplate", (Object)nodeTemplate.getId());
            dynamicObject.set("seq", (Object)i);
            nodeTemplateNames.add(nodeTemplate.getName());
        }
        DynamicObject[] nodeToolBoxs = new DynamicObject[]{nodeToolBox};
        SaveServiceHelper.save((DynamicObject[])nodeToolBoxs);
        WfUtils.addOpLog((String)"wf_nodetemplate", (String)"modify", (String)ResManager.getLocaleString((String)"\u4fee\u6539", (String)"NodeToolBoxConfigPlugin_6", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fee\u6539\u540e\u7684\u8282\u70b9\u6a21\u677f\u5de5\u5177\u7bb1\u4e3a\uff1a%s", "NodeToolBoxConfigPlugin_7", "bos-wf-formplugin"), (Object[])new Object[]{nodeTemplateNames});
    }
}

