/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class NodetTemplateImportInfoPlugin
extends AbstractWorkflowPlugin {
    private static final String KEY_MYFIELDCONTAINER = "contentpanel";
    private static final String BTNOK = "btnok";
    private static final String NODETEMPLATEINFO = "nodeTemplateInfo";
    private static final String NODETEMPLATEGROUPINFO = "nodeTemplateGroupInfo";
    private static final String BORDERSTYLR = "1px #cccccc solid";
    private static final String OUTERMOSTFLEXKEY = "flex_%s";
    private static final String SINGLEFLEXKEY = "flex2_%s";
    private static final String FIRSTLABLEKEY = "label1_%s";
    private static final String SECONDLABLEKEY = "label2_%s";
    private static final String COMBOKEY = "combo_%s";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        List nodeTemplateInfos = (List)parameter.getCustomParam(NODETEMPLATEINFO);
        Map nodeTemplateGroupInfos = (Map)parameter.getCustomParam(NODETEMPLATEGROUPINFO);
        if (nodeTemplateInfos == null || nodeTemplateInfos.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u3002", (String)"NodetTemplateImportInfoPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, List<Map<String, Object>>> groupAndNodesMap = this.getGroupAndNodesMap(nodeTemplateInfos);
        HashMap<String, String> flexApMap = new HashMap<String, String>();
        FlexPanelAp flexPanelAp = this.creatFlexAndEntryEntity(groupAndNodesMap, nodeTemplateGroupInfos);
        flexApMap.put("id", KEY_MYFIELDCONTAINER);
        flexApMap.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(flexApMap);
    }

    /*
     * Could not resolve type clashes
     */
    private FlexPanelAp creatFlexAndEntryEntity(Map<String, List<Map<String, Object>>> groupAndNodesMap, Map<String, ILocaleString> nodeTemplateGroupInfos) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        Set<Map.Entry<String, List<Map<String, Object>>>> groupAndNodesMapEntyrSet = groupAndNodesMap.entrySet();
        for (Map.Entry<String, List<Map<String, Object>>> groupAndNode : groupAndNodesMapEntyrSet) {
            String defaultName;
            String key = groupAndNode.getKey();
            List<Map<String, Object>> nodeTemplates = groupAndNode.getValue();
            FlexPanelAp flexPanel = new FlexPanelAp();
            flexPanel.setKey(String.format(OUTERMOSTFLEXKEY, key));
            LocaleString nodeTemplateGroup = LocaleString.fromMap((Map)((Map)nodeTemplateGroupInfos.get(key)));
            String string = defaultName = WfUtils.isEmpty((String)nodeTemplateGroup.getLocaleValue_zh_CN()) ? nodeTemplateGroup.getLocaleValue_en() : nodeTemplateGroup.getLocaleValue_zh_CN();
            if (WfUtils.isEmpty((String)defaultName)) {
                for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                    if (!WfUtils.isNotEmpty((String)((String)nodeTemplateGroup.get((Object)lang.toString())))) continue;
                    defaultName = (String)nodeTemplateGroup.get((Object)lang.toString());
                    break;
                }
            }
            LocaleString groupName = new LocaleString();
            for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                String groupNameLang = (String)nodeTemplateGroup.get((Object)lang.toString());
                groupNameLang = WfUtils.isEmpty((String)groupNameLang) ? defaultName : groupNameLang;
                groupName.setItem(lang.toString(), (Object)groupNameLang);
            }
            flexPanel.setName(groupName);
            flexPanel.setGrow(0);
            flexPanel.setShrink(0);
            flexPanel.setCollapsible(true);
            for (Map nodeTemplate : nodeTemplates) {
                String templateNameSupportLang;
                String templateNumber = (String)nodeTemplate.get("number");
                LocaleString templateName = LocaleString.fromMap((Map)((Map)nodeTemplate.get("name")));
                FlexPanelAp flexPanel2 = new FlexPanelAp();
                flexPanel2.setKey(String.format(SINGLEFLEXKEY, templateNumber));
                flexPanel2.setName(LocaleString.fromMap((Map)((Map)nodeTemplateGroupInfos.get(key))));
                Style style = new Style();
                Border border = new Border();
                border.setBottom(BORDERSTYLR);
                border.setLeft(BORDERSTYLR);
                border.setRight(BORDERSTYLR);
                border.setTop(BORDERSTYLR);
                style.setBorder(border);
                Padding padding = new Padding();
                padding.setLeft("36px");
                padding.setRight("0px");
                style.setPadding(padding);
                int index = nodeTemplates.indexOf(nodeTemplate);
                if (index > 0) {
                    Margin margin = new Margin();
                    margin.setTop("-1px");
                    style.setMargin(margin);
                }
                flexPanel2.setStyle(style);
                flexPanel2.setAlignContent("center");
                flexPanel2.setAlignItems("center");
                flexPanel2.setWidth(new LocaleString("796px"));
                flexPanel2.setHeight(new LocaleString("40px"));
                LabelAp nameAndNumberLabel = new LabelAp();
                nameAndNumberLabel.setId(String.format(FIRSTLABLEKEY, templateNumber));
                nameAndNumberLabel.setKey(String.format(FIRSTLABLEKEY, templateNumber));
                LocaleString name = new LocaleString();
                String glName = templateName.toString();
                if (WfUtils.isEmpty((String)glName)) {
                    if (WfUtils.isNotEmpty((String)((String)templateName.getItem("zh_CN")))) {
                        glName = (String)templateName.getItem("zh_CN");
                    } else {
                        for (Lang supportLang : WfUtils.getSupportLangs()) {
                            templateNameSupportLang = WfMultiLangUtils.getValueFromLocalString((ILocaleString)templateName, (String)supportLang.toString());
                            if (!WfUtils.isNotEmpty((String)templateNameSupportLang)) continue;
                            glName = templateNameSupportLang;
                            break;
                        }
                    }
                }
                for (Lang supportLang : WfUtils.getSupportLangs()) {
                    templateNameSupportLang = WfMultiLangUtils.getValueFromLocalString((ILocaleString)templateName, (String)supportLang.toString());
                    templateNameSupportLang = WfUtils.isEmpty((String)templateNameSupportLang) ? glName : templateNameSupportLang;
                    name.put((Object)supportLang.toString(), (Object)String.format("%s(%s)", templateNameSupportLang, templateNumber));
                }
                nameAndNumberLabel.setName(LocaleString.fromMap((Map)name));
                nameAndNumberLabel.setWidth(new LocaleString("32%"));
                nameAndNumberLabel.setFontSize(12);
                flexPanel2.getItems().add(nameAndNumberLabel);
                LabelAp errorInfoLabel = new LabelAp();
                errorInfoLabel.setId(String.format(SECONDLABLEKEY, templateNumber));
                errorInfoLabel.setKey(String.format(SECONDLABLEKEY, templateNumber));
                errorInfoLabel.setWidth(new LocaleString("45%"));
                errorInfoLabel.setAutoTextWrap(true);
                errorInfoLabel.setFontSize(12);
                String errorMessage = nodeTemplate.get("errorMessage") == null ? "" : (String)nodeTemplate.get("errorMessage");
                errorInfoLabel.setName(new LocaleString(errorMessage));
                errorInfoLabel.setForeColor("#FFAB43");
                Style style2 = new Style();
                Margin margin2 = new Margin();
                margin2.setLeft("22px");
                margin2.setRight("22px");
                style2.setMargin(margin2);
                errorInfoLabel.setStyle(style2);
                flexPanel2.getItems().add(errorInfoLabel);
                this.logger.debug(String.format("NodetTemplateImportInfoPlugin:number is %s", nodeTemplate.get("number")));
                if (nodeTemplate.get("number") != null) {
                    ComboItem ignoreComboItem;
                    ArrayList<ComboItem> items;
                    FieldAp strategyField = new FieldAp();
                    strategyField.setId(String.format(COMBOKEY, templateNumber));
                    strategyField.setKey(String.format(COMBOKEY, templateNumber));
                    strategyField.setFieldStyle(2);
                    strategyField.setHeight(new LocaleString("25px"));
                    strategyField.setWidth(new LocaleString("15%"));
                    strategyField.setFireUpdEvt(true);
                    strategyField.setShowTitle(Boolean.FALSE.booleanValue());
                    Style style3 = new Style();
                    Margin margin3 = new Margin();
                    margin3.setBottom("0px");
                    margin3.setLeft("0px");
                    margin3.setRight("0px");
                    margin3.setTop("0px");
                    style3.setMargin(margin3);
                    strategyField.setStyle(style3);
                    ComboField strategyCombo = new ComboField();
                    strategyCombo.setId(String.format(COMBOKEY, templateNumber));
                    strategyCombo.setKey(String.format(COMBOKEY, templateNumber));
                    strategyCombo.setMustInput(Boolean.TRUE.booleanValue());
                    String errorType = (String)nodeTemplate.get("errorType");
                    LocaleString ignoreMessage = new LocaleString(ResManager.loadKDString((String)"\u5ffd\u7565", (String)"NodetTemplateImportInfoPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    String ignore = "ignore";
                    if ("numberSame".equals(errorType)) {
                        items = new ArrayList<ComboItem>(2);
                        ComboItem coverComboItem = new ComboItem(0, new LocaleString(ResManager.loadKDString((String)"\u8986\u76d6", (String)"NodetTemplateImportInfoPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])), "cover");
                        items.add(coverComboItem);
                        ignoreComboItem = new ComboItem(1, ignoreMessage, ignore);
                        items.add(ignoreComboItem);
                        strategyCombo.setItems(items);
                    } else if ("groupAndNameSame".equals(errorType) || "billAndNameSame".equals(errorType)) {
                        items = new ArrayList(2);
                        ComboItem ignoreComboItem2 = new ComboItem(0, ignoreMessage, ignore);
                        items.add(ignoreComboItem2);
                        strategyCombo.setItems(items);
                    } else {
                        items = new ArrayList(2);
                        ComboItem addComboItem = new ComboItem(0, new LocaleString(ResManager.loadKDString((String)"\u65b0\u589e", (String)"NodetTemplateImportInfoPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0])), "add");
                        items.add(addComboItem);
                        ignoreComboItem = new ComboItem(1, ignoreMessage, ignore);
                        items.add(ignoreComboItem);
                        strategyCombo.setItems(items);
                    }
                    strategyField.setField((Field)strategyCombo);
                    flexPanel2.getItems().add(strategyField);
                }
                flexPanel.getItems().add(flexPanel2);
            }
            headPanelAp.getItems().add(flexPanel);
        }
        return headPanelAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List nodeTemplateInfos = (List)parameter.getCustomParam(NODETEMPLATEINFO);
        Map<String, List<Map<String, Object>>> groupAndNodesMap = this.getGroupAndNodesMap(nodeTemplateInfos);
        Set<Map.Entry<String, List<Map<String, Object>>>> groupAndNodesMapEntrySet = groupAndNodesMap.entrySet();
        for (Map.Entry<String, List<Map<String, Object>>> groupAndNodes : groupAndNodesMapEntrySet) {
            List<Map<String, Object>> nodeTemplates = groupAndNodes.getValue();
            for (Map<String, Object> nodeTemplate : nodeTemplates) {
                String number = (String)nodeTemplate.get("number");
                this.registDynamicProps(newMainType, number);
            }
        }
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, String number) {
        TextProp nameAndNumberText = new TextProp();
        nameAndNumberText.setName(String.format(FIRSTLABLEKEY, number));
        newMainType.registerSimpleProperty((DynamicSimpleProperty)nameAndNumberText);
        TextProp errorInfoText = new TextProp();
        errorInfoText.setName(String.format(SECONDLABLEKEY, number));
        newMainType.registerSimpleProperty((DynamicSimpleProperty)errorInfoText);
        ComboProp strategyCombo = new ComboProp();
        strategyCombo.setName(String.format(COMBOKEY, number));
        newMainType.registerSimpleProperty((DynamicSimpleProperty)strategyCombo);
    }

    private Map<String, List<Map<String, Object>>> getGroupAndNodesMap(List<Map<String, Object>> nodeTemplateInfos) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(nodeTemplateInfos.size());
        for (Map<String, Object> nodeTemplateInfo : nodeTemplateInfos) {
            String groupId = String.valueOf(nodeTemplateInfo.get("groupId"));
            ArrayList<Map<String, Object>> nodeTemplates = (ArrayList<Map<String, Object>>)result.get(groupId);
            if (nodeTemplates == null) {
                nodeTemplates = new ArrayList<Map<String, Object>>();
                result.put(groupId, nodeTemplates);
            }
            nodeTemplates.add(nodeTemplateInfo);
        }
        return result;
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List nodeTemplateInfos = (List)parameter.getCustomParam(NODETEMPLATEINFO);
        Map nodeTemplateGroupInfos = (Map)parameter.getCustomParam(NODETEMPLATEGROUPINFO);
        Map<String, List<Map<String, Object>>> groupAndNodesMap = this.getGroupAndNodesMap(nodeTemplateInfos);
        FlexPanelAp dynamicPanel = this.creatFlexAndEntryEntity(groupAndNodesMap, nodeTemplateGroupInfos);
        Container myFldPanel = (Container)this.getView().getControl(KEY_MYFIELDCONTAINER);
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith("combo_")) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(key);
            comboEdit.setView(this.getView());
            e.setControl((Control)comboEdit);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List nodeTemplateInfos = (List)parameter.getCustomParam(NODETEMPLATEINFO);
        Map<String, List<Map<String, Object>>> groupAndNodesMap = this.getGroupAndNodesMap(nodeTemplateInfos);
        Set<Map.Entry<String, List<Map<String, Object>>>> groupAndNodesMapEntyrSet = groupAndNodesMap.entrySet();
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        for (Map.Entry<String, List<Map<String, Object>>> groupAndNode : groupAndNodesMapEntyrSet) {
            List<Map<String, Object>> nodeTemplates = groupAndNode.getValue();
            for (Map<String, Object> nodeTemplate : nodeTemplates) {
                String templateNumber = (String)nodeTemplate.get("number");
                String errorType = (String)nodeTemplate.get("errorType");
                if ("numberSame".equals(errorType)) {
                    dataEntity.set(String.format(COMBOKEY, templateNumber), (Object)"cover");
                    continue;
                }
                if (WfUtils.isEmpty((String)errorType)) {
                    dataEntity.set(String.format(COMBOKEY, templateNumber), (Object)"add");
                    continue;
                }
                if (!"groupAndNameSame".equals(errorType) && !"billAndNameSame".equals(errorType)) continue;
                dataEntity.set(String.format(COMBOKEY, templateNumber), (Object)"ignore");
            }
        }
        e.setDataEntity((Object)dataEntity);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTNOK)) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)ProcessInstancePluginUtil.getPermissionAppId(this.getView()), (String)"wf_nodetemplatelibrary", (String)"4730fc9f000003ae")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bfc\u5165\u201d\u7684\u6743\u9650\u3002", (String)"NodeTemplateLibraryTablePlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            List nodeTemplateInfos = (List)parameter.getCustomParam(NODETEMPLATEINFO);
            HashMap<String, String> resultMap = new HashMap<String, String>(nodeTemplateInfos.size());
            HashSet<String> treatmentStrategys = new HashSet<String>(nodeTemplateInfos.size());
            for (Map nodeTemplateInfo : nodeTemplateInfos) {
                String templateNumber = (String)nodeTemplateInfo.get("number");
                if (WfUtils.isEmpty((String)templateNumber)) continue;
                String treatmentStrategy = this.getModel().getValue(String.format(COMBOKEY, templateNumber)) == null ? null : (String)this.getModel().getValue(String.format(COMBOKEY, templateNumber));
                treatmentStrategys.add(treatmentStrategy);
                resultMap.put(templateNumber, treatmentStrategy);
            }
            treatmentStrategys.remove("ignore");
            if (treatmentStrategys.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u65b0\u5efa\u6216\u8986\u76d6\u7684\u8282\u70b9\u6a21\u677f\u3002", (String)"NodetTemplateImportInfoPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
    }
}

