/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.nodetemplatelibrary.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.ExportModelSQLUtil;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.io.FilenameUtils;

public class ExportNodeTemplateSql
extends ExportModelSQLUtil {
    protected static Log logger = LogFactory.getLog(ExportModelSQLUtil.class);

    public ExportNodeTemplateSql(IFormView formView) {
        this.view = formView;
    }

    public void exportNodeTemplateSql(List<String> numberList, List<Long> idList) {
        StringBuilder sb = new StringBuilder();
        String filelds = "FID,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fstenciltype,fproperties,fbizidentification,fappid,fcloudid,fprocesstype,fversion,fdevelopmenttype,fisinitialization,fisextend,fissystemnode,fentityid,fgroupid,forg,fishidden,fpropsdefinition";
        StringBuilder sqlSB = new StringBuilder("SELECT ").append(filelds).append(" FROM t_wf_nodetemplate WHERE fnumber in ( ");
        for (String number : numberList) {
            sqlSB.append("'").append(number.trim()).append("'").append(",");
        }
        String sql = sqlSB.toString().substring(0, sqlSB.toString().length() - 1) + ")";
        List<Map<String, String>> list = this.getTableCloumnsInfo(sql);
        if (WfUtils.isEmptyForCollection(list) || WfUtils.isEmptyForMap(list.get(0))) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\u7684\u8282\u70b9\u6a21\u677f\u5bfc\u51fa\u9519\u8bef\u3002", (String)"NodeTemplateLibraryTablePlugin_37", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"SQL\u5bfc\u51fa", (String)"WorkflowModelManagePlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeName = list.get(0).get("fnumber");
        nodeName = WfUtils.isEmpty((String)nodeName) ? list.get(0).get("FNUMBER") : nodeName;
        String returnSQL = this.createTableInsertSQL("t_wf_nodetemplate", list);
        sb.append(returnSQL);
        filelds = "FPKID,fid,flocaleid,fname";
        for (Long nodeId : idList) {
            sql = "SELECT " + filelds + " FROM t_wf_nodetemplate_l WHERE fid='" + nodeId + "'";
            list = this.getTableCloumnsInfo(sql);
            returnSQL = this.createTableInsertSQL("t_wf_nodetemplate_l", list);
            sb.append(returnSQL);
        }
        this.packeZipAndExportSQLFile(sb.toString(), nodeName);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packeZipAndExportSQLFile(String sqlContent, String filename) {
        String path = System.getProperty("user.home") + File.separator + "ExportModelSQL";
        String localPath = path + File.separator + RequestContext.get().getTraceId();
        File localFile = new File(FilenameUtils.getName((String)localPath));
        if (!localFile.exists()) {
            localFile.mkdirs();
        }
        String zipFilename = filename + ".zip";
        String fullPath = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
        File zipFile = new File(FilenameUtils.getName((String)fullPath));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            String fileDirectory = String.format("preinsdata%s%s.sql", File.separator, filename);
            this.putFilesToZipPackage(new ByteArrayInputStream(sqlContent.getBytes()), fileDirectory, out);
            this.putWfConfigToZipPackage(filename, out);
        }
        catch (IOException e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"SQL\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a%s", (String)"WorkflowModelManagePlugin_46", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            return;
        }
        String downloadFile = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
        try (FileInputStream in = new FileInputStream(FilenameUtils.getName((String)downloadFile));){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFilename, (InputStream)in, 5000);
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            if (localFile.exists()) {
                ExportNodeTemplateSql.deleteFile(localFile);
            }
        }
    }
}

