/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.operation;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.operation.IWfOperationPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WfPluginPlugin
extends AbstractWorkflowPlugin
implements IWfOperationPlugin {
    private static final String PLUGIN = "plugin";
    private static final String FIELD_TYPE = "typefield";
    private static final String FIELD_PLUGIN = "pluginfield";
    private static final String FIELD_SCRIPT = "scriptfield";
    private static final String FIELD_PLUGIN_PARAMS = "pluginparamsfield";
    private static final String FIELD_MICROSERVICE = "microservice";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object value = parameter.getCustomParam("openParams");
        String extItfVal = null;
        if (value != null) {
            HashMap valMap = ExternalInterfaceUtil.castJSONToMap((Object)((String)value));
            extItfVal = (String)valMap.get(PLUGIN);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityId = (String)formShowParameter.getCustomParam("entityId");
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
        String pageId = DesignerPluginUtil.openExtItfInContainer(this.getView(), (IFormPlugin)this, types, entityId, extItfVal, "extitfpanel");
        this.getPageCache().put("pageId", pageId);
    }

    @Override
    public Map<String, Object> returnData() {
        String pageId = this.getPageCache().get("pageId");
        IFormView view = this.getView().getView(pageId);
        IDataModel model = view.getModel();
        String ret = this.validate(model);
        if (WfUtils.isNotEmpty((String)ret)) {
            this.getView().getParentView().showTipNotification(ret, Integer.valueOf(3000));
            return null;
        }
        String value = this.getValue(model);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(PLUGIN, value);
        HashMap<String, Object> returnData = new HashMap<String, Object>(5);
        returnData.put("name", ResManager.loadKDString((String)"\u6267\u884c\u63d2\u4ef6", (String)"WfPluginPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        returnData.put("operationNumber", "pluginExpire");
        returnData.put("config", SerializationUtils.toJsonString(map));
        return returnData;
    }

    private String getValue(IDataModel model) {
        String type = (String)model.getValue(FIELD_TYPE);
        String value = null;
        switch (type) {
            case "class": {
                String pluginValue = (String)model.getValue(FIELD_PLUGIN);
                String paramsValue = (String)model.getValue(FIELD_PLUGIN_PARAMS);
                if (WfUtils.isEmpty((String)paramsValue)) {
                    value = ExternalInterfaceUtil.getFormattedPluginValue((String)type, (Boolean)((Boolean)model.getValue(FIELD_MICROSERVICE)), (String)pluginValue);
                    break;
                }
                value = ExternalInterfaceUtil.getFormattedPluginValueWithParams((String)type, (Boolean)((Boolean)model.getValue(FIELD_MICROSERVICE)), (String)pluginValue, (String)paramsValue);
                break;
            }
            case "script": {
                value = ExternalInterfaceUtil.getFormattedValue((String)type, (String)((String)model.getValue(FIELD_SCRIPT)));
                break;
            }
        }
        return value;
    }

    private String validate(IDataModel model) {
        String type = (String)model.getValue(FIELD_TYPE);
        String msg = null;
        if (WfUtils.isEmpty((String)type)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5916\u90e8\u63a5\u53e3\u7c7b\u578b\u3002", (String)"WorkflowExternalInterfacePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        switch (type) {
            case "class": {
                Object plugin = model.getValue(FIELD_PLUGIN);
                if (WfUtils.isEmptyString((Object)plugin)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u63d2\u4ef6\u7c7b\u201d\u3002", (String)"WorkflowExternalInterfacePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    break;
                }
                if (this.pathMatch(plugin.toString())) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u63d2\u4ef6\u7c7b\u201d\u3002", (String)"WorkflowExternalInterfacePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
            case "script": {
                if (!WfUtils.isEmptyString((Object)model.getValue(FIELD_SCRIPT))) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u811a\u672c\u201d\u3002", (String)"WorkflowExternalInterfacePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    private boolean pathMatch(String input) {
        String[] strs;
        if (input.matches("[\\w\\.]+\\.+$")) {
            return false;
        }
        String regex = "^[a-zA-Z_][a-zA-Z0-9_]*$";
        for (String str : strs = input.split("\\.")) {
            if (str.matches(regex)) continue;
            return false;
        }
        return true;
    }
}

