/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.operation;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.lang.Lang;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.operation.IWfOperationPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.util.MessageUtils;

public class WfSimpleMsgPlugin
extends AbstractWorkflowPlugin
implements IWfOperationPlugin {
    public static final String NOTIFYTYPE = "notifytype";
    public static final String MSGCONTENT = "msgcontent";
    public static final String SV_MSGCONTENT = "sv_msgcontent";
    public static final String SV_MSGRECEIVER = "sv_msgreceiver";
    public static final String SV_PLUGIN = "sv_plugin";
    public static final String SV_MSGCHANNEL = "sv_msgchannel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SV_MSGCONTENT, SV_MSGRECEIVER, SV_MSGCHANNEL, SV_PLUGIN});
    }

    public void afterCreateNewData(EventObject e) {
        Object params = this.getView().getFormShowParameter().getCustomParam("openParams");
        Map m = null;
        if (params != null && WfUtils.isNotEmptyString((Object)params)) {
            m = params instanceof Map ? (Map)params : (Map)SerializationUtils.fromJsonString((String)params.toString(), Map.class);
            Object msgContent = m.get("msgContent");
            if (null != msgContent) {
                if (WfUtils.isJSONObject(msgContent)) {
                    this.getModel().setValue(MSGCONTENT, msgContent);
                    this.getModel().setValue(SV_MSGCONTENT, (Object)MessageUtils.spliceData((JSONObject)JSONObject.parseObject((String)msgContent.toString())));
                } else {
                    LocaleString content = new LocaleString();
                    content.setItem(Lang.get().toString(), (Object)((String)msgContent));
                    JSONObject conObj = new JSONObject();
                    conObj.put("content", (Object)content);
                    JSONObject svConObj = new JSONObject();
                    svConObj.put("content", msgContent);
                    this.getModel().setValue(SV_MSGCONTENT, (Object)svConObj);
                    this.getModel().setValue(MSGCONTENT, (Object)conObj);
                }
            } else {
                this.getModel().setValue(MSGCONTENT, null);
                this.getModel().setValue(SV_MSGCONTENT, null);
            }
        }
        this.initMsgChannelValue(m);
        this.initMsgReceiver(m);
    }

    private void initMsgReceiver(Map<String, Object> map) {
        if (map == null) {
            this.getModel().setValue(SV_MSGRECEIVER, (Object)"curparticipant");
            this.getModel().setValue(SV_PLUGIN, null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SV_PLUGIN});
            return;
        }
        String reveiver = (String)map.get("msgReceiver");
        if (WfUtils.isEmpty((String)reveiver)) {
            reveiver = "curparticipant";
        }
        this.getModel().setValue(SV_MSGRECEIVER, (Object)reveiver);
        if (reveiver != null && reveiver.contains("plugin")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SV_PLUGIN});
            this.getModel().setValue(SV_PLUGIN, map.get("msgReceiverPlugin"));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SV_PLUGIN});
        }
    }

    private void initMsgChannelValue(Map<String, Object> m) {
        List configs = this.getRepositoryService().getMessageConfigs();
        LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>();
        StringBuilder chan = new StringBuilder();
        if (configs != null && configs.size() > 0) {
            for (MessageServiceConfig config : configs) {
                items.put(config.getServiceName(), config.getServiceKey());
                if (m == null || m.get("msgChannel") == null || ((String)m.get("msgChannel")).indexOf(config.getServiceKey()) == -1) continue;
                chan.append(config.getServiceKey()).append(",");
            }
        }
        PluginUtil.setComboForControl(items, (ComboEdit)this.getControl(SV_MSGCHANNEL));
        this.getModel().setValue(SV_MSGCHANNEL, (Object)chan);
    }

    private boolean isOnlyEmailChannel() {
        Object channel = this.getModel().getValue(SV_MSGCHANNEL);
        return channel == null ? false : MessageChannelUtils.isOnlyEmailChannel((String)((String)channel));
    }

    private JSONObject dealMsgJson(Object content) {
        JSONObject jsonObject = new JSONObject();
        if (content == null) {
            return jsonObject;
        }
        JSONObject msg = JSONObject.parseObject((String)((String)content));
        if (msg == null) {
            return jsonObject;
        }
        Object title = msg.get((Object)"title");
        Object conent = msg.get((Object)"content");
        String lang = Lang.get().toString();
        if (WfUtils.isJSONObject((Object)title)) {
            JSONObject titleObj = JSONObject.parseObject((String)title.toString());
            if (this.isOnlyEmailChannel()) {
                jsonObject.put("emailTitle", (Object)titleObj);
            } else {
                jsonObject.put("title", (Object)titleObj);
            }
        } else {
            LocaleString titleStr = new LocaleString();
            if (WfUtils.isNotEmpty((String)((String)title))) {
                titleStr.setItem(lang, (Object)((String)title));
            }
            if (this.isOnlyEmailChannel()) {
                jsonObject.put("emailTitle", (Object)titleStr);
            } else {
                jsonObject.put("title", (Object)titleStr);
            }
        }
        if (WfUtils.isJSONObject((Object)conent)) {
            JSONObject contentObj = JSONObject.parseObject((String)conent.toString());
            if (this.isOnlyEmailChannel()) {
                jsonObject.put("emailContent", (Object)contentObj);
            } else {
                jsonObject.put("content", (Object)contentObj);
            }
        } else {
            LocaleString contentStr = new LocaleString();
            if (WfUtils.isNotEmpty((String)((String)conent))) {
                contentStr.setItem(lang, (Object)((String)conent));
            }
            if (this.isOnlyEmailChannel()) {
                jsonObject.put("emailContent", (Object)contentStr);
            } else {
                jsonObject.put("content", (Object)contentStr);
            }
        }
        return jsonObject;
    }

    public void click(EventObject evt) {
        String key;
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "sv_msgcontent": {
                HashMap<String, Object> content = new HashMap<String, Object>();
                Object svgConten = this.getModel().getValue(MSGCONTENT);
                if (svgConten != null) {
                    content.put("value", this.dealMsgJson(svgConten).toString());
                }
                String formId = this.isOnlyEmailChannel() ? "wf_emailcontent" : "wf_msgcontent";
                content.put("modelJson", this.getView().getFormShowParameter().getCustomParam("modelJson"));
                content.put("entityNumber", this.getView().getFormShowParameter().getCustomParam("entityNumber"));
                content.put("FROM", "MSG");
                content.put("showTitle", Boolean.TRUE);
                content.put("operationSource", "flowNodeTimeLimit");
                content.put("type", "expiresendmsg");
                this.showForm(MSGCONTENT, formId, ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9", (String)"WfSimpleMsgPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), content);
                break;
            }
            case "sv_plugin": {
                Map map = this.getView().getFormShowParameter().getCustomParams();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("entityId", map.get("entityId"));
                params.put("modelJson", map.get("modelJson"));
                params.put("model_type", map.get("model_type"));
                Object plugin = this.getModel().getValue(SV_PLUGIN);
                if (plugin != null) {
                    JSONObject jSONObject = JSONObject.parseObject((String)((String)plugin));
                }
                params.put("value", plugin);
                this.showForm("externalInterface", "wf_expireplugin", params);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            switch (evt.getActionId()) {
                case "msgcontent": {
                    this.returnMsgContent(returnData);
                    break;
                }
                case "externalInterface": {
                    this.returnMsgReceiverPlugin(returnData);
                }
            }
        }
    }

    private void returnMsgContent(Object data) {
        if (data != null && ((Map)data).size() > 0) {
            JSONObject obj = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)data));
            if (obj.containsKey((Object)"emailContent")) {
                obj.put("content", obj.get((Object)"emailContent"));
                obj.remove((Object)"emailContent");
            }
            if (obj.containsKey((Object)"emailTitle")) {
                obj.put("title", obj.get((Object)"emailTitle"));
                obj.remove((Object)"emailTitle");
            }
            this.getModel().setValue(MSGCONTENT, (Object)obj.toString());
            this.getModel().setValue(SV_MSGCONTENT, (Object)MessageUtils.spliceData((JSONObject)obj));
        } else {
            this.getModel().setValue(MSGCONTENT, null);
            this.getModel().setValue(SV_MSGCONTENT, null);
        }
    }

    private void returnMsgReceiverPlugin(Object data) {
        if (data != null && ((Map)data).size() > 0) {
            JSONObject obj = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)data));
            this.getModel().setValue(SV_PLUGIN, (Object)obj.get((Object)"plugin").toString());
        } else {
            this.getModel().setValue(SV_PLUGIN, null);
        }
    }

    @Override
    public Map<String, Object> returnData() {
        String controlType = (String)this.getView().getFormShowParameter().getCustomParam("controlType");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        String name = ResManager.loadKDString((String)"\u53d1\u9001\u9884\u8b66\u6d88\u606f", (String)"WfSimpleMsgPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        if ("afterDuration".equals(controlType)) {
            name = ResManager.loadKDString((String)"\u53d1\u9001\u62a5\u8b66\u6d88\u606f", (String)"WfSimpleMsgPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        returnData.put("name", name);
        returnData.put("operationNumber", "sendMessageExpire");
        Object msgContent = this.getModel().getValue(MSGCONTENT);
        Object receiver = this.getModel().getValue(SV_MSGRECEIVER);
        String checkMessage = this.checkMessage(msgContent, receiver);
        if (checkMessage != null) {
            this.getView().getParentView().showTipNotification(checkMessage, Integer.valueOf(3000));
            return null;
        }
        String msgChannel = this.getStringData(this.getModel().getValue(SV_MSGCHANNEL));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("notifyType", controlType);
        m.put("msgContent", msgContent);
        m.put("msgChannel", msgChannel);
        String receivers = this.getStringData(receiver);
        if (receivers != null && receivers.contains("plugin")) {
            Object plugin = this.getModel().getValue(SV_PLUGIN);
            if (plugin == null || plugin.equals("")) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6d88\u606f\u63a5\u6536\u4eba\u5916\u90e8\u63a5\u53e3\u201d\u3002", (String)"WfSimpleMsgPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return null;
            }
            m.put("msgReceiverPlugin", plugin);
        }
        m.put("msgReceiver", receivers);
        returnData.put("config", SerializationUtils.toJsonString(m));
        return returnData;
    }

    private String getStringData(Object data) {
        if (data == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        String[] s = ((String)data).split(",");
        if (s.length == 0) {
            return null;
        }
        for (int i = 0; i < s.length; ++i) {
            if (s[i].isEmpty()) continue;
            str.append(s[i]).append(",");
        }
        return str.deleteCharAt(str.length() - 1).toString();
    }

    private String checkMessage(Object msgContent, Object msgReceiver) {
        String field;
        boolean msgContentNull = WfUtils.isEmptyString((Object)msgContent);
        boolean msgReceiverNull = WfUtils.isEmptyString((Object)msgReceiver);
        if (!msgContentNull && !msgReceiverNull) {
            return null;
        }
        ArrayList<String> fields = new ArrayList<String>();
        String tips = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"WfSimpleMsgPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        if (msgContentNull) {
            field = ResManager.loadKDString((String)"\u201c\u6d88\u606f\u5185\u5bb9\u201d", (String)"WfSimpleMsgPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            fields.add(field);
        }
        if (msgReceiverNull) {
            field = ResManager.loadKDString((String)"\u201c\u6d88\u606f\u63a5\u6536\u4eba\u201d", (String)"WfSimpleMsgPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            fields.add(field);
        }
        String splitter = ResManager.loadKDString((String)"\u3001", (String)"WfSimpleMsgPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String join = Joiner.on((String)splitter).join(fields);
        return String.format(tips, join);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        IDataEntityProperty property = e.getProperty();
        switch (propName = property.getName()) {
            case "sv_msgreceiver": {
                if (newValue != null && ((String)newValue).contains("plugin")) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SV_PLUGIN});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SV_PLUGIN});
                this.getModel().setValue(SV_PLUGIN, null);
            }
        }
    }
}

