/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.operation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.operation.IWfOperationPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class WfTransferPlugin
extends AbstractWorkflowPlugin
implements IWfOperationPlugin {
    public static final String DELETEPART = "deletepart";
    public static final String TYPE_ITEM_RELATION = "relation";
    public static final String TYPE_ITEM_ROLE = "role";
    public static final String TYPE_ITEM_PERSON = "person";
    public static final String TYPE_ITEM_PLUGIN = "plugin";
    public static final String RD_KEY_PART = "part";
    public static final String RD_KEY_CONTEXT = "context";
    private static final String VALUE_SHOWTEXT = "valueshowtext";
    public static final String SHOWVALUE = "showvalue";
    public static final String PERSON_VALUE = "personValue";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"transferpersion", DELETEPART});
    }

    public void afterCreateNewData(EventObject e) {
        Object params = this.getView().getFormShowParameter().getCustomParam("openParams");
        if (params != null && WfUtils.isNotEmptyString((Object)params)) {
            Map m = null;
            m = params instanceof Map ? (Map)params : (Map)SerializationUtils.fromJsonString((String)params.toString(), Map.class);
            this.getModel().setValue("transferpersion", m.get(VALUE_SHOWTEXT));
            this.getModel().setValue("opinion", m.remove("opinion"));
            this.getPageCache().put(PERSON_VALUE, SerializationUtils.toJsonString((Object)m));
        }
    }

    private FormShowParameter getFormShowParameter(String openFormId, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_participant_assist");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        if (null != openFormId) {
            parameter.setCustomParam("openpagebyformid", (Object)openFormId);
        }
        Object context = this.getView().getFormShowParameter().getCustomParam(RD_KEY_CONTEXT);
        parameter.setCustomParam(RD_KEY_CONTEXT, context);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        return parameter;
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if ("transferpersion".equals(ctrl.getKey())) {
            String s = this.getPageCache().get(PERSON_VALUE);
            if (WfUtils.isNotEmpty((String)s)) {
                Map partMap = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
                String formId = (String)partMap.get("openpagebyformid");
                FormShowParameter parameter = this.getFormShowParameter(formId, "transferpersion");
                parameter.setCustomParam(RD_KEY_PART, (Object)partMap);
                Object selectedType = partMap.get("selectedType");
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("model", this.getView().getFormShowParameter().getCustomParam("modelJson"));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)parameter.getCustomParam("itemId")))) {
                    HashMap<String, Object> nodeProperties = new HashMap<String, Object>();
                    nodeProperties.put("itemId", parameter.getCustomParam("itemId"));
                    context.put("nodeProperties", nodeProperties);
                }
                parameter.getCustomParams().put(RD_KEY_CONTEXT, context);
                parameter.setCustomParam("selectedType", WfUtils.isEmptyString(selectedType) ? partMap.get("type") : selectedType);
                parameter.setCustomParam("value", partMap.get("value"));
                parameter.setCustomParam(SHOWVALUE, partMap.get(VALUE_SHOWTEXT));
                parameter.setCustomParam("type", partMap.get("type"));
                this.showForm(parameter);
            } else {
                FormShowParameter parameter = this.getFormShowParameter(null, "transferpersion");
                Map customerParams = this.getView().getFormShowParameter().getCustomParams();
                HashMap context = new HashMap();
                context.put("model", customerParams.get("modelJson"));
                if (StringUtils.isNotBlank(customerParams.get("itemId"))) {
                    HashMap nodeProperties = new HashMap();
                    nodeProperties.put("itemId", customerParams.get("itemId"));
                    context.put("nodeProperties", nodeProperties);
                }
                parameter.getCustomParams().put(RD_KEY_CONTEXT, context);
                this.showForm(parameter);
            }
        } else {
            this.getModel().setValue("transferpersion", (Object)"");
            this.getPageCache().remove(PERSON_VALUE);
        }
    }

    @Override
    public Map<String, Object> returnData() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("name", WfConfigurationUtil.getTransferName());
        returnData.put("operationNumber", "transferExpire");
        String opinion = WfUtils.isEmptyString((Object)this.getModel().getValue("opinion")) ? "" : this.getModel().getValue("opinion");
        String person = this.getPageCache().get(PERSON_VALUE);
        if (WfUtils.isEmptyString((Object)person)) {
            this.getView().getParentView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9%2$s\u4eba\u3002", (String)"WfTransferPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName(), WfConfigurationUtil.getTransferName()), Integer.valueOf(3000));
            return null;
        }
        Map m = (Map)SerializationUtils.fromJsonString((String)person, Map.class);
        m.put("opinion", opinion);
        returnData.put("config", SerializationUtils.toJsonString((Object)m));
        return returnData;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object o = evt.getReturnData();
        if (o instanceof Map) {
            Map returnData = (Map)o;
            String type = returnData.get("type").toString();
            String showText = null;
            Object value = returnData.get("value");
            if (value == null) {
                return;
            }
            if (TYPE_ITEM_RELATION.equals(type)) {
                showText = String.format(ResManager.loadKDString((String)"\u5173\u7cfb\uff1a%s", (String)"WfTransferPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), value);
            } else if (TYPE_ITEM_ROLE.equals(type)) {
                showText = String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a%s", (String)"WfTransferPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), value);
            } else if (TYPE_ITEM_PERSON.equals(type)) {
                String[] ids = value.toString().split(",");
                showText = String.format(ResManager.loadKDString((String)"\u4eba\u5458\uff1a%s", (String)"WfTransferPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), this.getNamesByIds(ids));
            } else if (TYPE_ITEM_PLUGIN.equals(type)) {
                showText = String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\uff1a%s", (String)"WfTransferPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), value);
            } else if ("extend".equals(type)) {
                showText = String.format(ResManager.loadKDString((String)"\u6269\u5c55\uff1a%s", (String)"WfTransferPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), value);
            } else if ("position".equals(type)) {
                String[] ids = value.toString().split(",");
                showText = String.format(ResManager.loadKDString((String)"\u5c97\u4f4d\uff1a%s", (String)"WfTransferPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), this.getPositionNameById(ids));
            }
            returnData.put(VALUE_SHOWTEXT, showText);
            this.getModel().setValue("transferpersion", (Object)showText);
            this.getPageCache().put(PERSON_VALUE, SerializationUtils.toJsonString((Object)returnData));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        String propertyName = e.getProperty().getName();
        if ("transferpersion".equals(propertyName) && WfUtils.isEmptyString((Object)(value = this.getModel().getValue("transferpersion").toString()))) {
            this.getPageCache().remove(PERSON_VALUE);
        }
    }

    private String getPositionNameById(String[] ids) {
        DynamicObject[] positions;
        LocaleString names = new LocaleString();
        if (WfUtils.isEmptyForArrays((Object[])ids)) {
            return names.toString();
        }
        HashSet<Long> idSet = new HashSet<Long>(ids.length);
        for (String id : ids) {
            idSet.add(Long.valueOf(id));
        }
        for (DynamicObject position : positions = BusinessDataServiceHelper.load((String)"bos_position", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
            names = WfMultiLangUtils.jointILocaleString((ILocaleString)names, (ILocaleString)position.getLocaleString("name"), (String)",");
        }
        return names.toString();
    }

    private String getNamesByIds(String[] ids) {
        ArrayList<Long> idsLong = new ArrayList<Long>();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null || "".equals(ids[i].trim())) continue;
            idsLong.add(Long.valueOf(ids[i]));
        }
        if (idsLong.size() == 0) {
            return null;
        }
        ORM orm = ORM.create();
        DynamicObjectCollection dos = orm.query("bos_user", "id,name", new QFilter[]{new QFilter("id", "in", (Object)idsLong.toArray())});
        StringBuilder names = new StringBuilder();
        if (0 != dos.size()) {
            for (DynamicObject obj : dos) {
                names.append(obj.get("name")).append(',');
            }
        }
        if (names.length() > 0) {
            return names.substring(0, names.length() - 1);
        }
        return names.toString();
    }
}

