/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.rpa;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class RPAProcessListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String BTN_CONFIRM = "btnconfirm";
    private static final String ENTRY_RPAPROCESS = "entryentity";
    private static final String KEY_ID = "id";
    private static final String KEY_PROCCODE = "procCode";
    private static final String KEY_PROCNAME = "procName";
    private static final String KEY_CURORGNAME = "curOrgName";
    private static final String KEY_PROCLABEL = "procLabel";
    private static final String KEY_PROCVER = "procVer";
    private static final String KEY_PUBLISHTIME = "publishTime";
    private static final String KEY_DEVELOPERUSER = "developerUser";
    private static final String KEY_PROCDESC = "procDesc";
    private static final String FIELD_ID = "id";
    private static final String FIELD_PROCCODE = "proccode";
    private static final String FIELD_PROCNAME = "procname";
    private static final String FIELD_CURORGNAME = "curorgname";
    private static final String FIELD_PROCLABEL = "proclabel";
    private static final String FIELD_PROCVER = "procver";
    private static final String FIELD_PUBLISHTIME = "publishtime";
    private static final String FIELD_DEVELOPERUSER = "developeruser";
    private static final String FIELD_PROCDESC = "procdesc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_RPAPROCESS);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initRPAProcessList();
    }

    private void initRPAProcessList() {
        try {
            String userId = RequestContext.get().getUserId();
            this.log.debug(String.format("invoke rpaService getProcessList, userId: %s", userId));
            List processes = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessList", (Object[])new Object[]{userId, null});
            if (processes != null && !processes.isEmpty()) {
                int size = processes.size();
                IDataModel model = this.getModel();
                Map process = null;
                model.batchCreateNewEntryRow(ENTRY_RPAPROCESS, size);
                for (int i = 0; i < size; ++i) {
                    process = (Map)processes.get(i);
                    model.setValue("id", process.get("id"), i);
                    model.setValue(FIELD_PROCCODE, process.get(KEY_PROCCODE), i);
                    model.setValue(FIELD_PROCNAME, process.get(KEY_PROCNAME), i);
                    model.setValue(FIELD_CURORGNAME, process.get(KEY_CURORGNAME), i);
                    model.setValue(FIELD_PROCLABEL, process.get(KEY_PROCLABEL), i);
                    model.setValue(FIELD_PROCVER, process.get(KEY_PROCVER), i);
                    model.setValue(FIELD_PUBLISHTIME, process.get(KEY_PUBLISHTIME), i);
                    model.setValue(FIELD_DEVELOPERUSER, process.get(KEY_DEVELOPERUSER), i);
                    model.setValue(FIELD_PROCDESC, process.get(KEY_PROCDESC), i);
                }
            } else {
                this.log.debug("no rpa process.");
            }
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            String msg = e.getMessage();
            Throwable cause = e.getCause();
            if (cause != null) {
                cause = cause.getCause() == null ? cause : cause.getCause();
                msg = cause.getMessage();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"RPA\u5fae\u670d\u52a1\u83b7\u53d6\u6d41\u7a0b\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"RPAProcessListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), msg));
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_RPAPROCESS);
        int[] selRows = grid.getSelectRows();
        if (selRows.length != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(selRows.length);
            return;
        }
        this.returnDataToParent(selRows[0]);
    }

    private void returnDataToParent(int rowIndex) {
        DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_RPAPROCESS, rowIndex);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", row.getString("id"));
        data.put(KEY_PROCCODE, row.getString(FIELD_PROCCODE));
        data.put(KEY_PROCNAME, row.getString(FIELD_PROCNAME));
        data.put(KEY_PROCVER, row.getString(FIELD_PROCVER));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnDataToParent(evt.getRow());
    }
}

