/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.rpa;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class RPARobotListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String BTN_CONFIRM = "btnconfirm";
    private static final String ENTRY_ROBOT = "entryentity";
    private static final String KEY_ID = "id";
    private static final String KEY_AGENTALIAS = "agentAlias";
    private static final String KEY_AGENTNAME = "agentName";
    private static final String KEY_CURORGNAME = "curOrgName";
    private static final String KEY_STATUS = "status";
    private static final String KEY_LICSTATUS = "licStatus";
    private static final String KEY_AGENTOS = "agentOs";
    private static final String KEY_AGENTNO = "agentNo";
    private static final String FIELD_ID = "id";
    private static final String FIELD_AGENTALIAS = "agentalias";
    private static final String FIELD_AGENTNAME = "agentname";
    private static final String FIELD_CURORGNAME = "curorgname";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_LICSTATUS = "licstatus";
    private static final String FIELD_AGENTOS = "agentos";
    private static final String FIELD_AGENTNO = "agentno";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ROBOT);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initRPARobotList();
    }

    private void initRPARobotList() {
        try {
            String processId = (String)this.getView().getFormShowParameter().getCustomParam("rpa_proc_id");
            this.log.debug(String.format("invoke rpaService getRobotList, processId: %s", processId));
            List robots = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getRobotList", (Object[])new Object[]{processId});
            if (robots != null && !robots.isEmpty()) {
                int size = robots.size();
                IDataModel model = this.getModel();
                Map robot = null;
                model.batchCreateNewEntryRow(ENTRY_ROBOT, size);
                for (int i = 0; i < size; ++i) {
                    robot = (Map)robots.get(i);
                    model.setValue("id", robot.get("id"), i);
                    model.setValue(FIELD_AGENTALIAS, robot.get(KEY_AGENTALIAS), i);
                    model.setValue(FIELD_AGENTNAME, robot.get(KEY_AGENTNAME), i);
                    model.setValue(FIELD_CURORGNAME, robot.get(KEY_CURORGNAME), i);
                    model.setValue("status", robot.get("status"), i);
                    model.setValue(FIELD_LICSTATUS, robot.get(KEY_LICSTATUS), i);
                    model.setValue(FIELD_AGENTOS, robot.get(KEY_AGENTOS), i);
                    model.setValue(FIELD_AGENTNO, robot.get(KEY_AGENTNO), i);
                }
            } else {
                this.log.debug("no rpa robots.");
            }
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            String msg = e.getMessage();
            Throwable cause = e.getCause();
            if (cause != null) {
                cause = cause.getCause() == null ? cause : cause.getCause();
                msg = cause.getMessage();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528RPA\u5fae\u670d\u52a1\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"RPARobotListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), msg));
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ROBOT);
        int[] selRows = grid.getSelectRows();
        if (selRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u673a\u5668\u4eba\u201d\u3002", (String)"RPARobotListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.returnDataToParent(selRows[0]);
    }

    private void returnDataToParent(int rowIndex) {
        DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_ROBOT, rowIndex);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", row.getString("id"));
        data.put(KEY_AGENTNO, row.getString(FIELD_AGENTNO));
        data.put(KEY_AGENTALIAS, row.getString(FIELD_AGENTALIAS));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnDataToParent(evt.getRow());
    }
}

