/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.rpa;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowRPATaskConfigurePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESC = "desc";
    private static final String TYPE = "type";
    private static final String REQUIRED = "required";
    private static final String CONSTANT = "constant";
    private static final String EXPRTEXT = "exprtext";
    private static final String EXPRESSION = "expression";
    private static final String FIELD_ENTITYNAME = "entityname";
    private static final String FIELD_RPAPROCESS = "rpaprocname";
    private static final String FIELD_RPAROBOT = "rparobotalias";
    private static final String FIELD_RPAPROCVERSION = "rpaprocver";
    private static final String ENTRY_PARAMS = "params";
    private static final String FIELD_PARAMS_ID = "params_id";
    private static final String FIELD_PARAMS_NAME = "params_name";
    private static final String FIELD_PARAMS_DESC = "params_desc";
    private static final String FIELD_PARAMS_TYPE = "params_type";
    private static final String FIELD_PARAMS_REQUIRED = "params_required";
    private static final String FIELD_PARAMS_CONSTANT = "params_constant";
    private static final String FIELD_PARAMS_EXPRTEXT = "params_exprtext";
    private static final String FIELD_PARAMS_EXPRESSION = "params_expression";
    private static final String KEY_NAME = "Name";
    private static final String KEY_DESC = "Desc";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_ISEMPTY = "IsEmpty";
    private static final String KEY_VALUE = "Value";
    private static final String PROPERTY_RPAPROCID = "rpaProcId";
    private static final String PROPERTY_RPAPROCCODE = "rpaProcCode";
    private static final String PROPERTY_RPAPROCVER = "rpaProcVer";
    private static final String PROPERTY_RPAPROCNAME = "rpaProcName";
    private static final String PROPERTY_RPAROBOTID = "rpaRobotId";
    private static final String PROPERTY_RPAROBOTALIAS = "rpaRobotAlias";
    private static final String PROPERTY_RPAPROCPARAMS = "rpaProcParams";
    private static final String DATA_KEY_ID = "id";
    private static final String DATA_KEY_NAME = "name";
    private static final String DATA_KEY_NUMBER = "number";
    private static final String ENTITYID = "entityId";
    private static final String ENTITYNAME = "entityName";
    private static final String ENTITYNUMBER = "entityNumber";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELD_ENTITYNAME, FIELD_RPAPROCESS, FIELD_RPAROBOT, FIELD_PARAMS_EXPRTEXT});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        try {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && "wf_nodeconfigview".equals(parentView.getFormShowParameter().getFormId())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            }
            this.beginInit();
            this.initRPAProcParams();
            super.afterCreateNewData(e);
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowRPATaskConfigurePlugin.class);
        }
    }

    private void initRPAProcParams() {
        IDataModel model = this.getModel();
        JSONObject props = this.getCellProperties();
        Object rpaProcParams = props.get((Object)PROPERTY_RPAPROCPARAMS);
        if (rpaProcParams == null) {
            rpaProcParams = this.getDefaultValueByName(props, PROPERTY_RPAPROCPARAMS);
        }
        if (!(rpaProcParams instanceof JSONArray)) {
            return;
        }
        JSONArray params = (JSONArray)rpaProcParams;
        if (!params.isEmpty()) {
            int size = params.size();
            JSONObject param = null;
            model.batchCreateNewEntryRow(ENTRY_PARAMS, size);
            for (int i = 0; i < size; ++i) {
                param = params.getJSONObject(i);
                model.setValue(FIELD_PARAMS_ID, param.get((Object)"id"), i);
                model.setValue(FIELD_PARAMS_NAME, param.get((Object)"name"), i);
                model.setValue(FIELD_PARAMS_DESC, param.get((Object)DESC), i);
                model.setValue(FIELD_PARAMS_TYPE, param.get((Object)TYPE), i);
                model.setValue(FIELD_PARAMS_REQUIRED, param.get((Object)REQUIRED), i);
                model.setValue(FIELD_PARAMS_CONSTANT, param.get((Object)CONSTANT), i);
                model.setValue(FIELD_PARAMS_EXPRTEXT, param.get((Object)EXPRTEXT), i);
                model.setValue(FIELD_PARAMS_EXPRESSION, param.get((Object)EXPRESSION), i);
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "entityname": {
                this.entityChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "rpaprocname": {
                this.rpaProcessChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "rparobotalias": {
                this.rpaRobotChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void entityChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.setProperties(ENTITYID, null, ENTITYNUMBER, null, ENTITYNAME, null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void rpaProcessChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.getModel().setValue(FIELD_RPAPROCVERSION, null);
            this.getModel().deleteEntryData(ENTRY_PARAMS);
            this.setProperties(PROPERTY_RPAPROCID, null, PROPERTY_RPAPROCCODE, null, PROPERTY_RPAPROCNAME, null, PROPERTY_RPAPROCPARAMS, null);
            this.getModel().setValue(FIELD_RPAROBOT, null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void rpaRobotChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.setProperties(PROPERTY_RPAROBOTID, null, PROPERTY_RPAROBOTALIAS, null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "entityname": {
                DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, FIELD_ENTITYNAME);
                break;
            }
            case "rpaprocname": {
                this.openRPAProcessList();
                break;
            }
            case "rparobotalias": {
                this.openRPARobotsList();
                break;
            }
            case "params_exprtext": {
                this.openParamExpression();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void openRPAProcessList() {
        FormShowParameter parameter = this.getShowParameter(FIELD_RPAPROCESS, "wf_rpa_process");
        this.getView().showForm(parameter);
    }

    private void openRPARobotsList() {
        FormShowParameter parameter = this.getShowParameter(FIELD_RPAROBOT, "wf_rpa_robot");
        String rpaProcId = (String)this.getProperty(PROPERTY_RPAPROCID);
        if (WfUtils.isEmpty((String)rpaProcId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9RPA\u6d41\u7a0b\u3002", (String)"WorkflowRPATaskConfigurePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("rpa_proc_id", (Object)rpaProcId);
        this.getView().showForm(parameter);
    }

    private void openParamExpression() {
        JSONObject props = this.getCellProperties();
        String entityNumber = props.getString(ENTITYNUMBER);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_PARAMS);
        int focusRow = grid.getEntryState().getFocusRow();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_PARAMS_EXPRTEXT));
        parameter.setFormId("wf_valueexpression");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(ENTITYNUMBER, (Object)entityNumber);
        parameter.setCustomParam("bpmnModel", (Object)this.getModelJsonString());
        parameter.setCustomParam("ruleType", (Object)"RPAProcessParamExpression");
        Object value = this.getModel().getValue(FIELD_PARAMS_EXPRESSION, focusRow);
        parameter.setCustomParam(EXPRESSION, value);
        this.getView().showForm(parameter);
    }

    @Override
    protected void setGridPropertyValue(String gridKey) {
        if (ENTRY_PARAMS.equals(gridKey)) {
            EntryGrid grid = (EntryGrid)this.getControl(gridKey);
            this.setProperty(PROPERTY_RPAPROCPARAMS, this.getEntryGridValue(grid));
            return;
        }
        super.setGridPropertyValue(gridKey);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            switch (actionId) {
                case "entityname": {
                    this.entityCallBack(data);
                    break;
                }
                case "rpaprocname": {
                    this.processCallBack(data);
                    break;
                }
                case "rparobotalias": {
                    this.robotCallBack(data);
                    break;
                }
                case "params_exprtext": {
                    this.paramExpressionCallBack(data);
                    break;
                }
            }
        }
    }

    private void entityCallBack(Map<String, Object> data) {
        Object id = data.get("id");
        Object name = data.get("name");
        this.getModel().setValue(FIELD_ENTITYNAME, name);
        this.setProperty(ENTITYID, id);
        this.setProperty(ENTITYNUMBER, data.get(DATA_KEY_NUMBER));
    }

    private void processCallBack(Map<String, Object> data) {
        IDataModel model = this.getModel();
        Object procId = data.get("id");
        Object procName = data.get("procName");
        Object procCode = data.get("procCode");
        Object procVer = data.get("procVer");
        this.setProperties(PROPERTY_RPAPROCID, procId, PROPERTY_RPAPROCCODE, procCode, PROPERTY_RPAPROCVER, procVer, PROPERTY_RPAPROCNAME, procName);
        model.setValue(FIELD_RPAPROCESS, procName);
        model.setValue(FIELD_RPAPROCVERSION, procVer);
        model.setValue(FIELD_RPAROBOT, null);
        this.setProperty(PROPERTY_RPAROBOTID, null);
        try {
            this.log.debug(String.format("RpaService getProcessParms, procCode\uff1a %1$s, procVer: %2$s", procCode, procVer));
            List params = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessParms", (Object[])new Object[]{procCode, procVer});
            model.deleteEntryData(ENTRY_PARAMS);
            if (params != null && !params.isEmpty()) {
                int size = params.size();
                Map param = null;
                model.batchCreateNewEntryRow(ENTRY_PARAMS, size);
                for (int i = 0; i < size; ++i) {
                    param = (Map)params.get(i);
                    model.setValue(FIELD_PARAMS_ID, (Object)BpmnDiffUtil.getListElementId((String)PROPERTY_RPAPROCPARAMS), i);
                    model.setValue(FIELD_PARAMS_NAME, param.get(KEY_NAME), i);
                    model.setValue(FIELD_PARAMS_DESC, param.get(KEY_DESC), i);
                    model.setValue(FIELD_PARAMS_TYPE, param.get(KEY_TYPE), i);
                    model.setValue(FIELD_PARAMS_REQUIRED, param.get(KEY_ISEMPTY), i);
                    model.setValue(FIELD_PARAMS_CONSTANT, param.get(KEY_VALUE), i);
                }
            } else {
                this.log.debug("no rpa params.");
                this.setProperty(PROPERTY_RPAPROCPARAMS, null);
            }
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528RPA\u5fae\u670d\u52a1\u83b7\u53d6\u8f93\u5165\u53c2\u6570\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"WorkflowRPATaskConfigurePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void robotCallBack(Map<String, Object> data) {
        Object alias = data.get("agentAlias");
        this.setProperty(PROPERTY_RPAROBOTID, data.get("id"));
        this.getModel().setValue(FIELD_RPAROBOT, alias);
    }

    private void paramExpressionCallBack(Map<String, Object> data) {
        Map prop;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_PARAMS);
        String expression = (String)data.get(EXPRESSION);
        String propStr = (String)data.get("prop");
        String fullName = "";
        if (propStr != null && WfUtils.isEmpty((String)(fullName = (String)(prop = (Map)SerializationUtils.fromJsonString((String)propStr, Map.class)).get("fullName")))) {
            fullName = (String)prop.get("name");
        }
        int rowIndex = grid.getSelectRows()[0];
        this.getModel().setValue(FIELD_PARAMS_EXPRTEXT, (Object)fullName, rowIndex);
        this.getModel().setValue(FIELD_PARAMS_EXPRESSION, (Object)expression, rowIndex);
    }
}

