/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.validate;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.validate.IValidateResult;
import kd.bos.workflow.validation.ValidationError;

public class WorkflowValidateInfoPlugin
extends AbstractWorkflowPlugin {
    public static final String INFOTYPE = "infotype";
    private String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData("entryentity");
        List vErrors = null;
        Object messages = this.getView().getFormShowParameter().getCustomParam("messages");
        if (null != messages) {
            vErrors = SerializationUtils.fromJsonStringToList((String)messages.toString(), ValidationError.class);
        }
        if (null != vErrors && vErrors.size() > 0) {
            for (int i = 0; i < vErrors.size(); ++i) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("wfname", (Object)((ValidationError)vErrors.get(i)).getTitle(), index);
                this.getModel().setValue("wfremark", (Object)((ValidationError)vErrors.get(i)).getSecondTitle(), index);
                this.getModel().setValue("objname", (Object)((ValidationError)vErrors.get(i)).getObjName(), index);
                this.getModel().setValue("objtype", (Object)((ValidationError)vErrors.get(i)).getObjType(), index);
                this.getModel().setValue("info", (Object)((ValidationError)vErrors.get(i)).getInfo(), index);
                String infoType = ((ValidationError)vErrors.get(i)).getInfoType();
                if (null != infoType && "systemError".equals(infoType)) {
                    this.getModel().setValue(INFOTYPE, (Object)ResManager.loadKDString((String)"\u91cd\u8981\u9519\u8bef", (String)"WorkflowValidateInfoPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), index);
                }
                if (null != infoType && "error".equals(infoType)) {
                    this.getModel().setValue(INFOTYPE, (Object)ResManager.loadKDString((String)"\u9519\u8bef", (String)"WorkflowValidateInfoPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), index);
                }
                if (null == infoType || !"warning".equals(infoType)) continue;
                this.getModel().setValue(INFOTYPE, (Object)ResManager.loadKDString((String)"\u8b66\u544a", (String)"WorkflowValidateInfoPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), index);
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (this.BTN_OK.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        IValidateResult plugin = this.getPlugin();
        if (plugin != null) {
            plugin.confirmResult(this.getView());
        } else {
            this.getView().returnDataToParent((Object)"true");
            this.getView().close();
        }
    }

    private IValidateResult getPlugin() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String pluginClass = (String)parameter.getCustomParam("plugin");
        String pageId = (String)parameter.getCustomParam("pageId");
        IFormView view = this.getView().getView(pageId);
        if (view == null) {
            return null;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        IFormPlugin plugin = pluginProxy.getPlugin(pluginClass);
        if (plugin instanceof IValidateResult) {
            return (IValidateResult)plugin;
        }
        return null;
    }
}

