/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin.validate;

import java.util.EventObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.validate.IValidateResult;

public class WorkflowValidateSuccessedPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_OK.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        IValidateResult plugin = this.getPlugin();
        if (plugin != null) {
            plugin.confirmResult(this.getView());
        } else {
            this.getView().close();
        }
    }

    private IValidateResult getPlugin() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String pluginClass = (String)parameter.getCustomParam("plugin");
        String pageId = (String)parameter.getCustomParam("pageId");
        IFormView view = this.getView().getView(pageId);
        if (view == null) {
            return null;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        IFormPlugin plugin = pluginProxy.getPlugin(pluginClass);
        if (plugin instanceof IValidateResult) {
            return (IValidateResult)plugin;
        }
        return null;
    }
}

