/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.graph.model.GraphItem;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.WorkflowDesignerIDEPlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.proctpl.plugin.WorkflowProcTemplateNodePropConfPlugin;
import kd.bos.workflow.design.proctpl.plugin.WorkflowProcTemplateNodeTabPropConfPlugin;
import kd.bos.workflow.design.proctpl.plugin.WorkflowProcTemplatePropConfPlugin;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.DesignerEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ProcTemplateDesigner {
    private WorkflowDesignerIDEPlugin idePlugin;
    private Log log = LogFactory.getLog(this.getClass());
    private WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);

    public ProcTemplateDesigner(WorkflowDesignerIDEPlugin idePlugin) {
        this.idePlugin = idePlugin;
    }

    protected DesignerEntity getDesignerEntity() {
        String fields = String.format("%s,%s,%s", "number", "entity", "resourceid");
        return this.getProcTemplateEntity(fields);
    }

    private String getTemplateId() {
        return (String)this.idePlugin.getView().getFormShowParameter().getCustomParam("templateId");
    }

    private ProcTemplateEntity getProcTemplateEntity(String fields) {
        Long templateId = Long.valueOf(this.getTemplateId());
        return (ProcTemplateEntity)this.service.getRepositoryService().findEntityById(templateId, "wf_proctemplate", fields);
    }

    protected void afterCreateNewData(EventObject e) {
        String fields;
        ProcTemplateEntity template;
        IFormView view = this.idePlugin.getView();
        if (this.hasPermission(view, "0=KX5+QVF5+R")) {
            view.setVisible(Boolean.TRUE, new String[]{"save"});
            view.setVisible(Boolean.TRUE, new String[]{"item_save"});
        }
        if ((template = this.getProcTemplateEntity(fields = String.format("%s,%s", "status", "preset"))).isEnable() || template.isPreset() || Lang.zh_CN != Lang.get() && !WfConfigurationUtil.isEnableOtherLang().booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{"save"});
            view.setVisible(Boolean.FALSE, new String[]{"item_save"});
        }
        if (this.hasPermission(this.idePlugin.getView(), "1MUVJAJ6G/B6")) {
            view.setVisible(Boolean.TRUE, new String[]{"checkbtn"});
            view.setVisible(Boolean.TRUE, new String[]{"item_checkbtn"});
        }
    }

    protected Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String templateId = (String)params.get("templateId");
        RepositoryService repositoryService = this.service.getRepositoryService();
        String fields = String.format("%s,%s", "resourceid", "processtype");
        ProcTemplateEntity template = (ProcTemplateEntity)repositoryService.findEntityById(Long.valueOf(templateId), "wf_proctemplate", fields);
        ResourceEntity resource = repositoryService.getResourceById(template.getResourceId());
        String lang = RequestContext.get().getLang().toString();
        String modelJson = ExtractMultiLanguageWordsUtil.getMultiLanguageResourceData((ResourceEntity)resource, (String)lang);
        this.idePlugin.cacheModelJson(modelJson);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)modelJson);
        String graphXml = GraphCodecUtils.convertBpmnModelToXML((BpmnModel)bpmnModel);
        result.put("graph_xml", graphXml);
        result.put("flowType", template.getProcessType());
        return result;
    }

    protected boolean checkVerificationPermission() {
        if (this.hasPermission(this.idePlugin.getView(), "1MUVJAJ6G/B6")) {
            return true;
        }
        this.idePlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6a21\u677f\u201d\u7684\u201c\u6821\u9a8c\u201d\u6743\u9650\u3002", (String)"ProcTemplateDesigner_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        return false;
    }

    protected DesignerEntity save(boolean showNotification, String selectionCellType, String selectionCellId) {
        IFormView view = this.idePlugin.getView();
        try {
            if (!this.hasPermission(view, "0=KX5+QVF5+R")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6a21\u677f\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\u3002", (String)"ProcTemplateDesigner_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            RepositoryService repositoryService = this.service.getRepositoryService();
            Long templateId = Long.valueOf(this.getTemplateId());
            String fields = String.format("%s,%s", "id", "status");
            ProcTemplateEntity template = (ProcTemplateEntity)repositoryService.findEntityById(templateId, "wf_proctemplate", fields);
            if (template == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6a21\u677f\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"ProcTemplateDesigner_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (template.isEnable()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6a21\u677f\u5df2\u88ab\u542f\u7528\uff0c\u8bf7\u5148\u7981\u7528\u540e\u518d\u4fdd\u5b58\u3002", (String)"ProcTemplateDesigner_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            GraphModel graphModel = this.idePlugin.getGraphModel();
            this.idePlugin.updateGeometry(graphModel);
            this.idePlugin.updateNodeSequence(graphModel);
            this.idePlugin.cacheModelJson();
            repositoryService.updateProcTemplate(templateId, graphModel.getBpmnModelJson());
            this.idePlugin.clearDataChanged();
            this.clearConfigurePageCache(selectionCellType, selectionCellId);
            this.idePlugin.showBlock(false, view);
            if (showNotification) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ProcTemplateDesigner_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            String error = WfUtils.getExceptionStacktrace((Throwable)e);
            this.log.error(error);
            view.showErrMessage(e.getMessage(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ProcTemplateDesigner_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return null;
    }

    private boolean hasPermission(IFormView view, String permItem) {
        String appId = "a479ec06000000ac";
        if ("bpm".equalsIgnoreCase(view.getFormShowParameter().getAppId())) {
            appId = "194JD185SVFC";
        }
        return PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wf_proctemplate", (String)permItem);
    }

    private void clearConfigurePageCache(String selectionCellType, String selectionCellId) {
        String types = this.idePlugin.getPageCache().get("allType");
        if (WfUtils.isNotEmpty((String)types)) {
            Set stencilTypes = (Set)SerializationUtils.fromJsonString((String)types, Set.class);
            for (String type : stencilTypes) {
                if ("Diagram".equals(type) || "SequenceFlow".equals(type)) continue;
                this.idePlugin.clearNodeConfigPageCache(type);
            }
            if (WfUtils.isNotEmpty((String)selectionCellType) && WfUtils.isNotEmpty((String)selectionCellId)) {
                this.idePlugin.change(selectionCellType, selectionCellId, new HashMap<String, Object>());
            }
        }
    }

    protected void initNodeConfigureShowParameter(FormShowParameter parameter, String formId) {
        parameter.setCustomParam("dynamic_config_plugin", this.getDynamicPropConfPagePlugin());
        if ("wf_process_propconf".equals(formId)) {
            parameter.addCustPlugin(WorkflowProcTemplatePropConfPlugin.class.getCanonicalName());
        } else {
            parameter.addCustPlugin(WorkflowProcTemplateNodePropConfPlugin.class.getCanonicalName());
        }
    }

    private Map<String, String> getDynamicPropConfPagePlugin() {
        String clazz = WorkflowProcTemplateNodeTabPropConfPlugin.class.getCanonicalName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wf_basicinfo_configure", clazz);
        map.put("wf_audittask_basicinfo", clazz);
        return map;
    }

    protected void beforeRemoveCells(List<GraphCell> cells) {
        if (cells != null && !cells.isEmpty()) {
            for (GraphCell cell : cells) {
                if (!"SequenceFlow".equals(cell.getStencil().getId())) continue;
                this.beforeRemoveSequenceFlow(cell);
            }
        }
    }

    private void beforeRemoveSequenceFlow(GraphCell cell) {
        String type3;
        GraphItem target;
        boolean bindToNext;
        String prevCellId;
        String type2;
        HashSet<String> types = new HashSet<String>();
        GraphModel graphModel = this.idePlugin.getGraphModel();
        GraphCell edge = graphModel.getGraphCell(cell.getResourceId());
        Map props = edge.getProperties();
        boolean bindToPrev = Boolean.TRUE.equals(ProcTemplatePluginUtil.getControlIntensityProperty(props, "bindToPrevNode"));
        if (bindToPrev && (type2 = this.cancelCellMandatory(graphModel, prevCellId = ProcTemplatePluginUtil.getPrevCellId(graphModel.getBpmnModelJson(), edge.getResourceId()))) != null) {
            types.add(type2);
        }
        if ((bindToNext = Boolean.TRUE.equals(ProcTemplatePluginUtil.getControlIntensityProperty(props, "bindToNextNode"))) && (target = edge.getTarget()) != null && target.getResourceId() != null && (type3 = this.cancelCellMandatory(graphModel, target.getResourceId())) != null) {
            types.add(type3);
        }
        if (!types.isEmpty()) {
            this.idePlugin.cacheModelJson();
            for (String type3 : types) {
                this.idePlugin.clearNodeConfigPageCache(type3);
            }
        }
    }

    private String cancelCellMandatory(GraphModel graphModel, String cellId) {
        GraphCell cell;
        if (cellId != null && (cell = graphModel.getGraphCell(cellId)) != null) {
            Map cellProps = cell.getProperties();
            ProcTemplatePluginUtil.setMandatoryProperty(cellProps, false);
            ProcTemplatePluginUtil.setMandatorySignProperty(cellProps, null);
            return cell.getStencil().getId();
        }
        return null;
    }
}

