/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ProcTemplatePluginUtil {
    private static final String KEY_GROUP_PROPERTY = "%s.%s";
    private static final String REGEX_LIST_STRING = "\\[.+\\]";

    private ProcTemplatePluginUtil() {
    }

    protected static boolean isNotEmptyNode(String nodeId) {
        return WfUtils.isNotEmpty((String)nodeId) && !"0".equals(nodeId);
    }

    protected static String openProcTemplateDesigner(Long templateId, IFormView view) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ProcTemplateEntity template = (ProcTemplateEntity)service.getRepositoryService().findEntityById(templateId, "wf_proctemplate", "processtype");
        String modelType = GraphCodecUtils.getModelTypeByProcessType((String)template.getProcessType());
        return ProcTemplatePluginUtil.openProcTemplateDesigner(modelType, templateId, view);
    }

    protected static String openProcTemplateDesigner(String type, Long templateId, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        String id = String.valueOf(templateId);
        parameter.setCustomParam("model_type", (Object)type);
        parameter.setCustomParam("templateId", (Object)id);
        parameter.setClientParam("templateId", (Object)id);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        if ("BizFlowModel".equals(type)) {
            parameter.setFormId("bpm_proctemplatedesigner");
        } else {
            parameter.setFormId("wf_proctemplatedesigner");
        }
        IFormView parentView = DesignerModelUtil.getTabControlView(view);
        if (parentView != null) {
            parentView.showForm(parameter);
            view.sendFormAction(parentView);
        } else {
            view.showForm(parameter);
        }
        return parameter.getPageId();
    }

    protected static String generateTemplateNumber(DynamicObject dataEntity) {
        return CodeRuleServiceHelper.getNumber((String)"wf_proctemplate", (DynamicObject)dataEntity, (String)String.valueOf(RequestContext.get().getOrgId()));
    }

    protected static void addOrgFilter(List<QFilter> filters, String field) {
        if (!WfConfigurationUtil.isFilterDataByOrg() || filters == null) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        Map orgSet = WfAdminUtil.getWfOrgUnitsByUserId((Long)userId);
        if (orgSet != null) {
            HashSet orgIds = (HashSet)orgSet.get("withSubordinateByConf");
            if (orgIds == null || orgIds.isEmpty()) {
                filters.add(new QFilter("1", "!=", (Object)1));
            } else {
                filters.add(new QFilter(field, "in", (Object)orgIds));
            }
        }
    }

    protected static void enableFields(IFormView view, Set<String> fields) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("l", 52);
        for (String field : fields) {
            view.updateControlMetadata(field, data);
        }
    }

    protected static String getUpdatedCellMandatoryStyle(String style, Object mandatory) {
        return GraphCodecUtils.updateStyleProperty((String)style, (String)"deletable", (String)(Boolean.TRUE.equals(mandatory) ? "0" : "1"));
    }

    public static void setSequenceProperty(Map<String, Object> properties, int index) {
        DesignerModelUtil.setProperty(properties, String.format(KEY_GROUP_PROPERTY, "controlIntensity", "sequence"), index);
    }

    protected static void setMandatoryProperty(Map<String, Object> properties, boolean value) {
        DesignerModelUtil.setProperty(properties, String.format(KEY_GROUP_PROPERTY, "controlIntensity", "mandatory"), value);
    }

    protected static void setMandatorySignProperty(Map<String, Object> properties, String sign) {
        DesignerModelUtil.setProperty(properties, String.format(KEY_GROUP_PROPERTY, "controlIntensity", "mandatorySign"), sign);
    }

    public static Object getControlIntensityProperty(Map<String, Object> properties, String key) {
        return DesignerModelUtil.getProperty(properties, String.format(KEY_GROUP_PROPERTY, "controlIntensity", key));
    }

    protected static String getPrevCellId(String modelJson, String edgeId) {
        String regex = String.format("\"outgoing\":\\[.*?\\{\"resourceId\":\"%s\"\\}.*?\\],\"properties\":\\{.+?\\},\"resourceId\":\"(.+?)\"", edgeId);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(modelJson);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected static boolean isLatestControlIntensitySign(String value, String sign) {
        if (WfUtils.isEmpty((String)value) || WfUtils.isEmpty((String)sign)) {
            return false;
        }
        if (value.matches(REGEX_LIST_STRING)) {
            List signs = (List)SerializationUtils.fromJsonString((String)value, ArrayList.class);
            if (signs.isEmpty()) {
                return false;
            }
            return ((String)signs.get(signs.size() - 1)).equals(sign);
        }
        return value.equals(sign);
    }

    protected static boolean isEmptyControlIntensitySign(String sign) {
        return WfUtils.isEmpty((String)sign) || "[]".equals(sign);
    }

    protected static String getAddedControlIntensitySign(String value, String sign) {
        if (WfUtils.isEmpty((String)value)) {
            return sign;
        }
        List<String> signs = ProcTemplatePluginUtil.getControlIntensitySignsList(value);
        signs.add(sign);
        return SerializationUtils.toJsonString(signs);
    }

    protected static String getRemovedControlIntensitySign(String value, String sign) {
        if (WfUtils.isEmpty((String)value) || value.equals(sign)) {
            return null;
        }
        int index = -1;
        List<String> signs = ProcTemplatePluginUtil.getControlIntensitySignsList(value);
        for (int i = signs.size() - 1; i >= 0; --i) {
            if (!sign.equals(signs.get(i))) continue;
            index = i;
            break;
        }
        if (index > -1) {
            signs.remove(index);
        }
        if (signs.isEmpty()) {
            return null;
        }
        return SerializationUtils.toJsonString(signs);
    }

    private static List<String> getControlIntensitySignsList(String value) {
        List<String> signs = null;
        if (value.matches(REGEX_LIST_STRING)) {
            signs = (List)SerializationUtils.fromJsonString((String)value, ArrayList.class);
        } else {
            signs = new ArrayList();
            signs.add(value);
        }
        return signs;
    }

    public static List<Map<String, Object>> getOptionalOperations(Map<String, Object> properties) {
        String key = String.format(KEY_GROUP_PROPERTY, "optionalActions", "optionalOperations");
        return (List)DesignerModelUtil.getProperty(properties, key);
    }

    public static List<Map<String, Object>> getOptionalDecisionItems(Map<String, Object> properties) {
        String key = String.format(KEY_GROUP_PROPERTY, "optionalActions", "optionalDecisionItems");
        return (List)DesignerModelUtil.getProperty(properties, key);
    }

    public static Collection<String> getOptionalOperationNumbers(Map<String, Object> properties) {
        return ProcTemplatePluginUtil.getOptionalActions(properties, true);
    }

    public static Collection<String> getOptionalDecisionItemNumbers(Map<String, Object> properties) {
        return ProcTemplatePluginUtil.getOptionalActions(properties, false);
    }

    private static Collection<String> getOptionalActions(Map<String, Object> properties, boolean isOperation) {
        List<Map<String, Object>> actions = null;
        actions = isOperation ? ProcTemplatePluginUtil.getOptionalOperations(properties) : ProcTemplatePluginUtil.getOptionalDecisionItems(properties);
        if (actions != null && !actions.isEmpty()) {
            HashSet<String> numbers = new HashSet<String>(actions.size());
            for (Map<String, Object> optionalItem : actions) {
                numbers.add((String)optionalItem.get("number"));
            }
            return numbers;
        }
        return new HashSet<String>();
    }

    @Deprecated
    public static List<ComboItem> getDecisionTypes(Collection<String> optionalItems) {
        boolean filter = optionalItems != null && !optionalItems.isEmpty();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (!filter || optionalItems.contains("approve")) {
            ComboItem approve = new ComboItem();
            approve.setCaption(new LocaleString(ResManager.loadKDString((String)"\u540c\u610f", (String)"ProcTemplatePluginUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            approve.setValue("approve");
            items.add(approve);
        }
        if (!filter || optionalItems.contains("reject")) {
            ComboItem reject = new ComboItem();
            reject.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de", (String)"ProcTemplatePluginUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            reject.setValue("reject");
            items.add(reject);
        }
        if (!filter || optionalItems.contains("terminate")) {
            ComboItem terminate = new ComboItem();
            terminate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"ProcTemplatePluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            terminate.setValue("terminate");
            items.add(terminate);
        }
        return items;
    }

    public static List<ComboItem> getDecisionTypes(Collection<String> optionalItems, String stencilType, String businessModel) {
        ComboItem terminate;
        boolean filter = optionalItems != null && !optionalItems.isEmpty();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (!filter || optionalItems.contains("approve")) {
            ComboItem approve = new ComboItem();
            approve.setCaption(new LocaleString(ResManager.loadKDString((String)"\u540c\u610f", (String)"ProcTemplatePluginUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            approve.setValue("approve");
            items.add(approve);
        }
        if (!filter || optionalItems.contains("reject")) {
            ComboItem reject = new ComboItem();
            reject.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de", (String)"ProcTemplatePluginUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            reject.setValue("reject");
            items.add(reject);
        }
        if (("oneVoteVeto".equals(businessModel) && BpmnModelUtil.instanceofYunzhijiaTask((String)stencilType) || BpmnModelUtil.instanceofAuditTask((String)stencilType)) && (!filter || optionalItems.contains("terminate"))) {
            terminate = new ComboItem();
            terminate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"ProcTemplatePluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            terminate.setValue("terminate");
            items.add(terminate);
        }
        if (BpmnModelUtil.instanceofYunzhijiaTask((String)stencilType) && (!filter || optionalItems.contains("forceReject"))) {
            terminate = new ComboItem();
            terminate.setCaption((LocaleString)WFMultiLangConstants.getForceRejectName());
            terminate.setValue("forceReject");
            items.add(terminate);
        }
        return items;
    }

    public static List<ComboItem> getDecisionScene(Collection<String> optionalItems, String stencilType, String businessModel, List<FlowElement> nodes) {
        return ProcTemplatePluginUtil.getDecisionScene(optionalItems, stencilType, businessModel, nodes, new HashMap<String, Object>());
    }

    public static List<ComboItem> getDecisionScene(Collection<String> optionalItems, String stencilType, String businessModel, List<FlowElement> nodes, Map<String, Object> variables) {
        ComboItem terminate;
        boolean filter = optionalItems != null && !optionalItems.isEmpty();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (!filter || optionalItems.contains("approve")) {
            ComboItem approve = new ComboItem();
            approve.setCaption(new LocaleString(ResManager.loadKDString((String)"\u540c\u610f", (String)"ProcTemplatePluginUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            approve.setValue("approve");
            items.add(approve);
        }
        if (!filter || optionalItems.contains("reject")) {
            ComboItem rejectToAllNode = new ComboItem();
            rejectToAllNode.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u5df2\u9009\u8282\u70b9", (String)"ProcTemplatePluginUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            rejectToAllNode.setValue("rejectToAllAuditNode");
            items.add(rejectToAllNode);
            ComboItem rejectToPreNode = new ComboItem();
            rejectToPreNode.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9", (String)"ProcTemplatePluginUtil_5", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            rejectToPreNode.setValue("rejectToPreAuditNode");
            items.add(rejectToPreNode);
            if (nodes == null || ProcTemplatePluginUtil.isFirstUserTask(nodes)) {
                ComboItem rejecttoedit = new ComboItem();
                rejecttoedit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u63d0\u4ea4\u8282\u70b9", (String)"ProcTemplatePluginUtil_6", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                rejecttoedit.setValue("rejectToEditNode");
                items.add(rejecttoedit);
            }
            if (WfUtils.isNotEmptyForMap(variables) && Boolean.TRUE.equals(variables.get("isSubProcess")) && !BpmnModelUtil.instanceofSSCApprover((String)stencilType)) {
                ComboItem rejectToParentProcEditNode = new ComboItem();
                rejectToParentProcEditNode.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u7236\u6d41\u7a0b\u63d0\u4ea4\u8282\u70b9", (String)"ProcTemplatePluginUtil_7", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                rejectToParentProcEditNode.setValue("rejectToParentProcEditNode");
                items.add(rejectToParentProcEditNode);
                ComboItem rejectToParentProcPreNode = new ComboItem();
                rejectToParentProcPreNode.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u7236\u6d41\u7a0b\u524d\u5e8f\u8282\u70b9", (String)"ProcTemplatePluginUtil_8", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                rejectToParentProcPreNode.setValue("rejectToParentProcPreNode");
                items.add(rejectToParentProcPreNode);
            }
        }
        if (("oneVoteVeto".equals(businessModel) && BpmnModelUtil.instanceofYunzhijiaTask((String)stencilType) || BpmnModelUtil.instanceofAuditTask((String)stencilType) && !BpmnModelUtil.instanceofYunzhijiaTask((String)stencilType)) && (!filter || optionalItems.contains("terminate"))) {
            if (WfUtils.isNotEmptyForMap(variables) && Boolean.TRUE.equals(variables.get("isSubProcess")) && !BpmnModelUtil.instanceofSSCApprover((String)stencilType)) {
                ComboItem terminateMainProcess = new ComboItem();
                terminateMainProcess.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ec8\u6b62\u5168\u90e8", (String)"ProcTemplatePluginUtil_10", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                terminateMainProcess.setValue("terminateMainProcess");
                items.add(terminateMainProcess);
                if (WfConfigurationUtil.subProcDisplayTerminateDecisionScene()) {
                    ComboItem terminate2 = new ComboItem();
                    terminate2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"ProcTemplatePluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                    terminate2.setValue("terminate");
                    items.add(terminate2);
                }
            } else {
                terminate = new ComboItem();
                terminate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"ProcTemplatePluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                terminate.setValue("terminate");
                items.add(terminate);
            }
        }
        if (BpmnModelUtil.instanceofYunzhijiaTask((String)stencilType) && (!filter || optionalItems.contains("forceReject"))) {
            terminate = new ComboItem();
            terminate.setCaption((LocaleString)WFMultiLangConstants.getForceRejectName());
            terminate.setValue("forceReject");
            items.add(terminate);
        }
        return items;
    }

    public static Object initDecisionOptionsScene(JSONArray decisionOptions) {
        JSONArray objects = new JSONArray();
        for (int i = 0; i < decisionOptions.size(); ++i) {
            JSONObject object = decisionOptions.getJSONObject(i);
            if (object.get((Object)"decisionScene") == null && object.get((Object)"auditType") != null) {
                switch ((String)object.get((Object)"auditType")) {
                    case "approve": {
                        object.put("decisionScene", (Object)"approve");
                        break;
                    }
                    case "reject": {
                        object.put("decisionScene", (Object)"rejectToAllAuditNode");
                        break;
                    }
                    case "forceReject": {
                        object.put("decisionScene", (Object)"forceReject");
                        break;
                    }
                    case "terminate": {
                        object.put("decisionScene", (Object)"terminate");
                    }
                }
            }
            objects.add((Object)object);
        }
        return objects;
    }

    private static boolean isFirstUserTask(List<FlowElement> nodes) {
        for (FlowElement f : nodes) {
            FlowNode flowNode = (FlowNode)f;
            if (!BpmnModelUtil.isFirstNodeByModel((FlowNode)flowNode) || !(flowNode instanceof UserTask) || flowNode instanceof BillTask || flowNode instanceof AuditTask || flowNode instanceof YunzhijiaTask) continue;
            return true;
        }
        return false;
    }

    public static <T> void filterOptionalDatas(List<T> datas, Collection<String> optionalNumbers) {
        if (datas == null || datas.isEmpty() || optionalNumbers == null || optionalNumbers.isEmpty()) {
            return;
        }
        Iterator<T> iterator = datas.iterator();
        while (iterator.hasNext()) {
            T data = iterator.next();
            String number = null;
            if (data instanceof Operation) {
                number = ((Operation)data).getKey();
            } else if (data instanceof Map) {
                number = (String)((Map)data).get("auditType");
            }
            if (number == null || optionalNumbers.contains(number)) continue;
            iterator.remove();
        }
    }
}

