/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.bpmn.model.deploy.ProcTemplateExportModel;
import kd.bos.workflow.design.plugin.ImportModelPlugin;
import kd.bos.workflow.design.plugin.model.ImportDataInfo;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowImportProcessTemplatePlugin
extends ImportModelPlugin {
    @Override
    protected DcBinder getDCBinder() {
        return ProcTemplateExportModel.getDCBinder();
    }

    @Override
    protected boolean isValidFileSuffix(String fileName) {
        return fileName.endsWith(".proctpl");
    }

    @Override
    protected List<DynamicObject> getMainModels(DeployModel deployModel) {
        return ((ProcTemplateExportModel)deployModel).getTemplates();
    }

    @Override
    protected String getEntityFormId() {
        return "wf_proctemplate";
    }

    @Override
    protected String getNumberField() {
        return "number";
    }

    @Override
    protected String getEntityNumberField() {
        return "entity";
    }

    @Override
    protected String getProcessTypeField() {
        return "processtype";
    }

    @Override
    protected String getEntraBill(DynamicObject mainModel) {
        return mainModel.getString("entity_id");
    }

    @Override
    protected void checkAndDeployModels(List<ImportDataInfo> datas, List<String> processNumbers) {
        ProcTemplateExportModel exportModel = null;
        HashMap<Long, ImportDataInfo> infoMap = new HashMap<Long, ImportDataInfo>(datas.size());
        HashMap<Long, List<Long>> tplMap = new HashMap<Long, List<Long>>(datas.size());
        for (ImportDataInfo data : datas) {
            exportModel = (ProcTemplateExportModel)data.getDeployModel();
            List templates = exportModel.getTemplates();
            DynamicObject template = (DynamicObject)templates.get(0);
            long templateId = template.getLong("id");
            long parentId = template.getLong("parent_id");
            infoMap.put(templateId, data);
            ArrayList<Long> children = (ArrayList<Long>)tplMap.get(parentId);
            if (children == null) {
                children = new ArrayList<Long>();
                tplMap.put(parentId, children);
            }
            children.add(templateId);
        }
        ArrayList<Long> orderedTplIds = new ArrayList<Long>(datas.size());
        ArrayList tplIds = (ArrayList)tplMap.get(0L);
        if (tplIds == null) {
            tplIds = new ArrayList();
            tplIds.addAll(tplMap.keySet());
        }
        for (Long tplId : tplIds) {
            this.addChildren(tplId, orderedTplIds, tplMap);
        }
        datas.clear();
        for (Long tplId : orderedTplIds) {
            ImportDataInfo data = (ImportDataInfo)infoMap.get(tplId);
            if (data == null) continue;
            datas.add(data);
        }
        super.checkAndDeployModels(datas, processNumbers);
    }

    private void addChildren(Long tplId, List<Long> orderedTplIds, Map<Long, List<Long>> tplMap) {
        List<Long> children;
        if (!orderedTplIds.contains(tplId)) {
            orderedTplIds.add(tplId);
        }
        if ((children = tplMap.get(tplId)) != null && !children.isEmpty()) {
            for (Long id : children) {
                this.addChildren(id, orderedTplIds, tplMap);
            }
        }
    }

    @Override
    protected void importModel(DeployModel deployModel, boolean isCover) {
        if (deployModel instanceof ProcTemplateExportModel) {
            this.getRepositoryService().importProcTemplate((ProcTemplateExportModel)deployModel, isCover, this.isCoverSummaryCfg);
        } else {
            this.logger.error(String.format("deserialized DeployModel is not ProcTemplateExportModel. %s", deployModel.getClass()));
        }
    }

    @Override
    protected void recordImportLog(DynamicObject model) {
        WfUtils.addOpLog((String)"wf_proctemplate", (String)"importtpl", (String)ResManager.getLocaleString((String)"\u5bfc\u5165\u6d41\u7a0b\u6a21\u677f", (String)"WorkflowImportProcessTemplatePlugin_1", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6a21\u677fID: %1$s \u6a21\u677f\u7f16\u7801: %2$s", "WorkflowImportProcessTemplatePlugin_2", "bos-wf-formplugin"), (Object[])new Object[]{String.valueOf(model.getPkValue()), model.getString(this.getNumberField())});
    }

    @Override
    protected String getEntraBillId(DynamicObject mainModel) {
        return "";
    }
}

