/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.WorkflowModelWizardBaseInfoPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;

public class WorkflowModelWizardByTemplatePlugin
extends WorkflowModelWizardBaseInfoPlugin
implements BeforeF7SelectListener {
    private static final String FIELD_TEMPLATE = "template";
    private static final String KEY_PROCESSTYPE = "processType";

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit templateF7 = (BasedataEdit)this.getControl(FIELD_TEMPLATE);
        templateF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if ("bpm".equalsIgnoreCase(parameter.getAppId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"issubprocess"});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Object source = e.getSource();
        if (source instanceof FormShowParameter) {
            FormShowParameter parameter = (FormShowParameter)source;
            if ("bpm".equalsIgnoreCase(parameter.getAppId())) {
                parameter.setCustomParam(KEY_PROCESSTYPE, (Object)ModelType.BizFlow.name());
                parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u4e1a\u52a1\u6d41", (String)"WorkflowModelWizardByTemplatePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                parameter.setCustomParam(KEY_PROCESSTYPE, (Object)ModelType.AuditFlow.name());
                parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5ba1\u6279\u6d41", (String)"WorkflowModelWizardByTemplatePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        String propName = property.getName();
        if (FIELD_TEMPLATE.equals(propName)) {
            this.beforeTemplateF7Select(beforeF7SelectEvent);
        }
    }

    private void beforeTemplateF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String processType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PROCESSTYPE);
        beforeF7SelectEvent.getCustomQFilters().add(new QFilter("processtype", "=", (Object)processType));
    }

    @Override
    protected void confirm() {
        if (this.getTemplate() == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u6d41\u7a0b\u6a21\u677f\u201d\u3002", (String)"WorkflowModelWizardByTemplatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        super.confirm();
    }

    @Override
    protected void saveModelAndOpenDesigner(ModelEntityImpl model) {
        BillList list;
        String processType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PROCESSTYPE);
        model.setType(processType);
        DynamicObject template = this.getTemplate();
        if (ModelType.AuditFlow.name().equals(processType)) {
            Object isSubProcess = this.getModel().getValue("issubprocess");
            String primarySubprocessTag = "main";
            if (Boolean.TRUE.equals(isSubProcess)) {
                primarySubprocessTag = "sub";
            }
            model.setPrimarySubprocess(primarySubprocessTag);
        }
        Long modelId = this.getRepositoryService().createModelByTemplate((Long)template.getPkValue(), (ModelEntity)model);
        if (ModelType.BizFlow.name().equals(processType)) {
            DesignerModelUtil.openBizFlowDesigner(modelId, this.getView());
        } else {
            DesignerModelUtil.openAuditFlowDesigner(modelId, this.getView());
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (list = (BillList)parentView.getControl("billlistap")) != null) {
            list.refreshData();
            this.getView().sendFormAction(parentView);
        }
    }

    private DynamicObject getTemplate() {
        return (DynamicObject)this.getModel().getValue(FIELD_TEMPLATE);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (FIELD_TEMPLATE.equals(propName)) {
            this.templateChanged((DynamicObject)newValue);
        } else {
            super.propertyChanged(e);
        }
    }

    private void templateChanged(DynamicObject newValue) {
        if (newValue == null) {
            this.getModel().setValue("entrabillname", (Object)"");
            this.getPageCache().remove("entrabillid");
            this.getPageCache().remove("entrabill");
        } else {
            String fields = String.format("%s,%s,%s", "entity", "org", "description");
            ProcTemplateEntity template = (ProcTemplateEntity)this.getRepositoryService().findEntityById((Long)newValue.getPkValue(), "wf_proctemplate", fields);
            this.getModel().setValue("orgunitid", (Object)template.getOrgId());
            DynamicObject entity = template.getEntity();
            this.getPageCache().put("entrabillid", entity.getString("dentityid"));
            this.getPageCache().put("entrabill", entity.getString("number"));
            this.getModel().setValue("entrabillname", (Object)entity.getString("name"));
            this.getModel().setValue("description", (Object)template.getDescription());
        }
    }

    @Override
    protected void fillingCategoryValue(String billId) {
    }
}

