/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;

public class WorkflowProcTemplateCategoryPlugin
extends AbstractWorkflowPlugin {
    private static final String FIELD_PARENT = "parent";
    private static final String BUTTON_CANCEL = "buttoncancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CANCEL});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            this.getModel().setDataChanged(false);
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        OperationResult result;
        List ids;
        super.afterDoOperation(evtArgs);
        Object source = evtArgs.getSource();
        if (source instanceof Save && (ids = (result = evtArgs.getOperationResult()).getSuccessPkIds()) != null && !ids.isEmpty()) {
            this.getView().returnDataToParent(ids.get(0));
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter instanceof BaseShowParameter) {
            BaseShowParameter parameter = (BaseShowParameter)showParameter;
            BillOperationStatus status = parameter.getBillStatus();
            if (BillOperationStatus.ADDNEW.equals((Object)status)) {
                String parentId = (String)parameter.getCustomParam("focusedId");
                if (ProcTemplatePluginUtil.isNotEmptyNode(parentId)) {
                    this.getModel().setValue(FIELD_PARENT, (Object)Long.valueOf(parentId));
                    this.getModel().setDataChanged(false);
                }
            } else if (BillOperationStatus.EDIT.equals((Object)status)) {
                BasedataEdit parent = (BasedataEdit)this.getControl(FIELD_PARENT);
                ArrayList<QFilter> filters = parent.getQFilters();
                if (filters == null) {
                    filters = new ArrayList<QFilter>();
                    parent.setQFilters(filters);
                }
                DynamicObject data = this.getModel().getDataEntity();
                Object id = data.getPkValue();
                filters.add(new QFilter("id", "!=", id));
                if (data.get(FIELD_PARENT) == null) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_PARENT});
                }
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BUTTON_CANCEL.equals(key)) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }
}

