/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntity;

public class WorkflowProcTemplateChangeRecordsPlugin
extends AbstractWorkflowPlugin {
    private static final String ENTRYENTITY = "diffentryentity";
    private static final String FIELD_PROCNUM = "procnum";
    private static final String FIELD_PROCNAME = "procname";
    private static final String FIELD_ELEMENTNAME = "elementname";
    private static final String FIELD_GROUP = "group";
    private static final String FIELD_PROPNAME = "propname";
    private static final String FIELD_MANAGEPROP = "manageprop";
    private static final String FIELD_DESIGNPROP = "designprop";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long releaseLogId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        FieldEdit fieldEdit = (FieldEdit)this.getControl(FIELD_MANAGEPROP);
        fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4fee\u6539\u524d\u5c5e\u6027", (String)"WorkflowProcTemplateChangeRecordsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        fieldEdit = (FieldEdit)this.getControl(FIELD_DESIGNPROP);
        fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u5c5e\u6027", (String)"WorkflowProcTemplateChangeRecordsPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        TextEdit number = (TextEdit)this.getControl(FIELD_PROCNUM);
        number.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801", (String)"WorkflowProcTemplateChangeRecordsPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        TextEdit name = (TextEdit)this.getControl(FIELD_PROCNAME);
        name.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"WorkflowProcTemplateChangeRecordsPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        ProcTemplateReleaseLogEntity releaseLog = (ProcTemplateReleaseLogEntity)this.getRepositoryService().findEntityById(releaseLogId, "wf_proctemplatereleaselog", "proctpl");
        DynamicObject procTpl = releaseLog.getProcTpl();
        if (procTpl != null) {
            this.getModel().setValue(FIELD_PROCNUM, (Object)procTpl.getString("number"));
            this.getModel().setValue(FIELD_PROCNAME, (Object)procTpl.getString("name"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"refresh"});
        this.initChangeRecordsList(releaseLogId);
    }

    private void initChangeRecordsList(Long releaseLogId) {
        List records = this.getRepositoryService().getProcTemplateChangeRecords(releaseLogId);
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        if (records.isEmpty()) {
            return;
        }
        boolean disableControl = !"true".equals(WfConfigurationUtil.getConfigCenterVal((String)"workflow.procTemplate.controlIntensity"));
        for (ModelModifyLogEntity record : records) {
            if (disableControl && "controlIntensity".equals(record.getGroup())) continue;
            ILocaleString group = WfUtils.isEmpty((ILocaleString)record.getGroupName()) ? null : record.getGroupName();
            ILocaleString name = WfUtils.isEmpty((ILocaleString)record.getPropertyName()) ? null : record.getPropertyName();
            int i = model.createNewEntryRow(ENTRYENTITY);
            model.setValue(FIELD_ELEMENTNAME, (Object)record.getElementName(), i);
            if ("node_1".equals(record.getElementId())) {
                switch (record.getProperty()) {
                    case "name": {
                        name = group = new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"WorkflowProcTemplateChangeRecordsPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "businessId": {
                        name = group = new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u6807\u8bc6", (String)"WorkflowProcTemplateChangeRecordsPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "documentation": {
                        name = group = new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u63cf\u8ff0", (String)"WorkflowProcTemplateChangeRecordsPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
            }
            model.setValue(FIELD_GROUP, (Object)group, i);
            model.setValue(FIELD_PROPNAME, (Object)name, i);
            model.setValue(FIELD_MANAGEPROP, (Object)record.getOldval(), i);
            model.setValue(FIELD_DESIGNPROP, (Object)record.getContent(), i);
        }
    }
}

