/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.proctpl.plugin.WorkflowCopyProcTemplatePlugin;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.io.FilenameUtils;

public class WorkflowProcTemplateListPlugin
extends AbstractWorkflowListPlugin {
    private static final String BTN_EXPORTPRESETSQL = "exportpresetsqlbtn";
    private static final String BTN_VIEWRELEASELOG = "viewreleaselogbtn";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_IMPORT = "import";
    private static final String KEY_EXPORT = "export";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_DISABLE = "disable";
    private static final String KEY_COPY = "copy";
    private static final String OPERATION_IMPORTTEMPLATE = "importtpl";
    private static final String OPERATION_EXPORTEMPLATE = "exporttpl";
    private static final String OPERATION_COPYTEMPLATE = "copytpl";
    private static final String OPERATION_VIEWRELEASELOG = "viewtplreleaselog";
    private static final String OPENED_TEMPLATE_IDS = "pageIds";
    private static final String OPENED_RELEASELOG_PAGEIDS = "releaseLogPageIds";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        IListColumn numberColumn = args.getListColumn(KEY_NUMBER);
        if (!this.isListF7()) {
            numberColumn.setHyperlink(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "exportpresetsqlbtn": {
                this.exportPresetSQL();
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportPresetSQL() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        int size = rows.size();
        if (size > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6700\u591a\u53ef\u5bfc\u51fa20\u6761\u6d41\u7a0b\u6a21\u677f\u3002", (String)"WorkflowProcTemplateListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> templateIds = new ArrayList<Long>(size);
        for (ListSelectedRow row : rows) {
            templateIds.add((Long)row.getPrimaryKeyValue());
        }
        String number = rows.get(0).getNumber();
        String fileName = size == 1 ? number : String.format("%s(%s)", number, size);
        String zipFileName = String.format("SQL_%s.zip", fileName);
        String app = this.getView().getFormShowParameter().getAppId();
        File zipFile = this.getRepositoryService().exportProcTemplatePresetSQL(app, FilenameUtils.getName((String)zipFileName), templateIds);
        try {
            try (FileInputStream in = new FileInputStream(zipFile);){
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFileName, (InputStream)in, 5000);
                this.getView().openUrl(url);
            }
            if (!zipFile.exists() || !zipFile.delete()) return;
        }
        catch (Exception e) {
            try {
                this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u9884\u7f6e\u811a\u672c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowProcTemplateListPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
                if (!zipFile.exists() || !zipFile.delete()) return;
            }
            catch (Throwable throwable) {
                if (!zipFile.exists() || !zipFile.delete()) throw throwable;
                this.log.debug(String.format("%s file deleted.", zipFile.getPath()));
                throw throwable;
            }
            this.log.debug(String.format("%s file deleted.", zipFile.getPath()));
            return;
        }
        this.log.debug(String.format("%s file deleted.", zipFile.getPath()));
        return;
    }

    private void viewReleaseLog(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.size() != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0).intValue());
            evt.setCancel(true);
            return;
        }
        ListSelectedRow row = rows.get(0);
        Long templateId = (Long)row.getPrimaryKeyValue();
        String templateIdKey = String.valueOf(templateId);
        String pageIds = this.getPageCache().get(OPENED_RELEASELOG_PAGEIDS);
        Map<String, String> pageIdMap = pageIds != null ? (Map)SerializationUtils.fromJsonString((String)pageIds, Map.class) : new HashMap();
        String pageId = (String)pageIdMap.get(templateIdKey);
        IFormView openedView = this.getView().getView(pageId);
        if (pageId != null && openedView != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setMultiSelect(false);
        parameter.setBillFormId("wf_proctemplatereleaselog");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("proctpl", (Object)templateId);
        this.getView().showForm((FormShowParameter)parameter);
        pageIdMap.put(templateIdKey, parameter.getPageId());
        this.getPageCache().put(OPENED_RELEASELOG_PAGEIDS, SerializationUtils.toJsonString(pageIdMap));
    }

    private boolean hasPermission(String permItem) {
        String appId = "a479ec06000000ac";
        if (this.isBizFlow()) {
            appId = "194JD185SVFC";
        }
        return PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wf_proctemplate", (String)permItem);
    }

    private boolean isBizFlow() {
        return "bpm".equalsIgnoreCase(this.getView().getFormShowParameter().getAppId());
    }

    private void showCopyTemplatePage(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.size() != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0).intValue());
            evt.setCancel(true);
            return;
        }
        Long templateId = (Long)rows.get(0).getPrimaryKeyValue();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_proctemplate");
        parameter.addCustPlugin(WorkflowCopyProcTemplatePlugin.class.getCanonicalName());
        parameter.setCaption(ResManager.loadKDString((String)"\u590d\u5236\u6a21\u677f", (String)"WorkflowProcTemplateListPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("id", (Object)templateId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_COPY));
        this.getView().showForm(parameter);
    }

    private void showImportPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_proctemplate_import");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_IMPORT));
        this.getView().showForm(parameter);
    }

    private void showExportPage(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            evt.setCancel(true);
            return;
        }
        int size = rows.size();
        if (size > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6700\u591a\u53ef\u5bfc\u51fa20\u6761\u6d41\u7a0b\u6a21\u677f\u3002", (String)"WorkflowProcTemplateListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(size);
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        StringBuilder msg = new StringBuilder();
        String fields = String.format("%s,%s,%s,%s", "id", "name", KEY_NUMBER, "preset");
        List templates = this.getRepositoryService().findEntitiesByFilters("wf_proctemplate", new QFilter[]{new QFilter("id", "in", ids)}, fields, null);
        for (int i = 0; i < size; ++i) {
            ProcTemplateEntity template = (ProcTemplateEntity)templates.get(i);
            if (!template.isPreset()) continue;
            msg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6d41\u7a0b\u6a21\u677f\u4e3a\u9884\u7f6e\u6a21\u677f\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"WorkflowProcTemplateListPlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[0]), template.getNumber()));
            if (i >= size - 1) continue;
            msg.append("\n");
        }
        if (msg.length() > 1) {
            this.getView().showTipNotification(msg.toString());
            return;
        }
        String number = rows.get(0).getNumber();
        String fileName = size == 1 ? number : String.format("%s(%s)", number, size);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_modifyexportfilename");
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u6d41\u7a0b\u6a21\u677f", (String)"WorkflowProcTemplateListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("key", (Object)fileName);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_EXPORT));
        this.getView().showForm(parameter);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent evt) {
        super.filterContainerBeforeF7Select(evt);
        evt.getCustomParams().put("orgFuncId", "01");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ProcTemplatePluginUtil.addOrgFilter(e.getQFilters(), "org");
        e.getQFilters().add(new QFilter("processtype", "=", (Object)(this.isBizFlow() ? ModelType.BizFlow.name() : ModelType.AuditFlow.name())));
        if (this.isListF7()) {
            BaseShowParameter parameter;
            Long pkId;
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && parentView.getFormShowParameter() instanceof BaseShowParameter && (pkId = (Long)(parameter = (BaseShowParameter)parentView.getFormShowParameter()).getPkId()) != null) {
                QFilter f7Filter = new QFilter("id", "!=", (Object)pkId);
                e.getQFilters().add(f7Filter);
            }
        } else {
            String nodeId = this.getPageCache().get("focusedId");
            QFilter filter = null;
            if (ProcTemplatePluginUtil.isNotEmptyNode(nodeId)) {
                Long categoryId = Long.valueOf(nodeId);
                QFilter[] filters = new QFilter[]{new QFilter("parent", "=", (Object)categoryId)};
                List categories = this.getRepositoryService().findEntitiesByFilters("wf_proctemplatecategory", filters, "id", null);
                if (!categories.isEmpty()) {
                    HashSet<Long> ids = new HashSet<Long>(categories.size() + 1);
                    ids.add(categoryId);
                    for (ProcTemplateCategoryEntity category : categories) {
                        ids.add(category.getId());
                    }
                    filter = new QFilter("category", "in", ids);
                } else {
                    filter = new QFilter("category", "=", (Object)categoryId);
                }
                e.getQFilters().add(filter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        if (evt.getSource() instanceof AbstractOperate) {
            String key;
            switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
                case "modify": {
                    this.beforeModify(evt);
                    break;
                }
                case "delete": {
                    this.delete();
                    break;
                }
                case "enable": 
                case "disable": {
                    this.beforeChangeStatus(evt);
                    break;
                }
                case "copytpl": {
                    this.showCopyTemplatePage(evt);
                    break;
                }
                case "importtpl": {
                    this.showImportPage();
                    break;
                }
                case "exporttpl": {
                    this.showExportPage(evt);
                    break;
                }
                case "viewtplreleaselog": {
                    this.viewReleaseLog(evt);
                    break;
                }
            }
        }
    }

    private void beforeModify(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection datas = evt.getListSelectedData();
        if (datas.size() != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(datas.size());
            evt.setCancel(true);
        } else {
            String fields = String.format("%s,%s", "status", "preset");
            ProcTemplateEntity template = (ProcTemplateEntity)this.getRepositoryService().findEntityById((Long)datas.get(0).getPrimaryKeyValue(), "wf_proctemplate", fields);
            if (template.isPreset()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u9884\u7f6e\u6a21\u677f\u3002", (String)"WorkflowProcTemplateListPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (template.isEnable()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u5df2\u542f\u7528\u7684\u6a21\u677f\u3002", (String)"WorkflowProcTemplateListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void delete() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (this.validateOnDelete(rows)) {
            String tip = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"WorkflowProcTemplateListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), rows.size());
            this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this));
        }
    }

    private boolean validateOnDelete(ListSelectedRowCollection rows) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService repositoryService = service.getRepositoryService();
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        StringBuilder msg = new StringBuilder();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        String fields = String.format("%s,%s,%s,%s,%s", "id", "name", KEY_NUMBER, "status", "preset");
        List templates = repositoryService.findEntitiesByFilters("wf_proctemplate", filters, fields, null);
        int size = templates.size();
        String newline = "\n";
        HashMap<Long, String> numberMap = new HashMap<Long, String>(size);
        for (int i = 0; i < size; ++i) {
            ProcTemplateEntity template = (ProcTemplateEntity)templates.get(i);
            numberMap.put(template.getId(), template.getNumber());
            if (template.isPreset()) {
                msg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6d41\u7a0b\u6a21\u677f\u4e3a\u9884\u7f6e\u6a21\u677f\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"WorkflowProcTemplateListPlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]), template.getNumber()));
                if (i >= size - 1) continue;
                msg.append(newline);
                continue;
            }
            if (!template.isEnable()) continue;
            msg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6d41\u7a0b\u6a21\u677f\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"WorkflowProcTemplateListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), template.getNumber()));
            if (i >= size - 1) continue;
            msg.append(newline);
        }
        if (msg.length() > 1) {
            this.getView().showTipNotification(msg.toString());
            return false;
        }
        List procTplIds = repositoryService.getReferencedProcTplIds(ids);
        size = procTplIds.size();
        for (int i = 0; i < size; ++i) {
            Long procTplId = (Long)procTplIds.get(i);
            String number = (String)numberMap.get(procTplId);
            msg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6d41\u7a0b\u6a21\u677f\u5df2\u88ab\u5176\u4ed6\u6d41\u7a0b\u6216\u6d41\u7a0b\u6a21\u677f\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"WorkflowProcTemplateListPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0]), number));
            if (i >= size - 1) continue;
            msg.append(newline);
        }
        if (msg.length() > 1) {
            this.getView().showTipNotification(msg.toString());
            return false;
        }
        return true;
    }

    private void beforeChangeStatus(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection rows = evt.getListSelectedData();
        if (rows.isEmpty()) {
            this.getView().showTipNotification(WFMultiLangConstants.getNoDataSelectedTip());
            evt.setCancel(true);
        } else {
            ArrayList<Long> ids = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
            StringBuilder msg = new StringBuilder();
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
            List templates = this.getRepositoryService().findEntitiesByFilters("wf_proctemplate", filters, "preset", null);
            int size = templates.size();
            for (int i = 0; i < size; ++i) {
                ProcTemplateEntity template = (ProcTemplateEntity)templates.get(i);
                if (!template.isPreset()) continue;
                msg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6d41\u7a0b\u6a21\u677f\u4e3a\u9884\u7f6e\u6a21\u677f\uff0c\u4e0d\u80fd\u542f\u7528\u6216\u7981\u7528\u3002", (String)"WorkflowProcTemplateListPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]), template.getNumber()));
                if (i >= size - 1) continue;
                msg.append("\n");
            }
            if (msg.length() > 1) {
                evt.setCancel(true);
                this.getView().showTipNotification(msg.toString());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (KEY_ENABLE.equals(operateKey)) {
            this.refreshList(false);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        if (KEY_NUMBER.equals(evt.getFieldName())) {
            this.openProcTemplateDesignPage();
            args.setCancel(true);
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
        this.refreshList(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (KEY_DELETE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.confirmDelete();
        }
    }

    private void confirmDelete() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        ArrayList<Long> templateIds = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            templateIds.add((Long)row.getPrimaryKeyValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", templateIds)};
        List templates = this.getRepositoryService().findEntitiesByFilters("wf_proctemplate", filters, KEY_NUMBER, null);
        this.getRepositoryService().deleteProcTemplates(templateIds);
        if (!templates.isEmpty()) {
            for (ProcTemplateEntity template : templates) {
                WfUtils.addOpLog((String)"wf_proctemplate", (String)KEY_DELETE, (String)ResManager.getLocaleString((String)"\u5220\u9664", (String)"WorkflowProcTemplateListPlugin_5", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c\u5220\u9664\u6210\u529f", "WorkflowProcTemplateListPlugin_4", "bos-wf-formplugin"), (Object[])new Object[]{template.getNumber()});
            }
        }
        this.refreshList(true);
    }

    private void refreshList(boolean clearSelection) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (clearSelection) {
            list.clearSelection();
        }
        list.refreshData();
    }

    private boolean isListF7() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)showParameter;
            return "bos_listf7".equals(parameter.getFormId());
        }
        return false;
    }

    private void openProcTemplateDesignPage() {
        if (!this.hasPermission("4715a0df000000ac")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6a21\u677f\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"WorkflowProcTemplateListPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long rowId = (Long)((IListView)this.getView()).getFocusRowPkId();
        String ids = this.getPageCache().get(OPENED_TEMPLATE_IDS);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String id = String.valueOf(rowId);
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)idsMap.get(id);
        if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        pageId = ProcTemplatePluginUtil.openProcTemplateDesigner(rowId, this.getView());
        idsMap.put(id, pageId);
        this.getPageCache().put(OPENED_TEMPLATE_IDS, SerializationUtils.toJsonString(idsMap));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "import": {
                this.importCallBack(returnData);
                break;
            }
            case "export": {
                this.exportProcTemplate(returnData);
                break;
            }
            case "copy": {
                this.copyTemplateCallBack(returnData);
                break;
            }
        }
    }

    private void copyTemplateCallBack(Object returnData) {
        this.refreshList(false);
    }

    private void importCallBack(Object returnData) {
        if (returnData instanceof List) {
            List numbers = (List)returnData;
            if (!numbers.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"WorkflowProcTemplateListPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.refreshList(true);
            } else {
                this.getView().showErrorNotification(String.valueOf(returnData));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportProcTemplate(Object returnData) {
        StringBuilder fileNames;
        block47: {
            if (!(returnData instanceof String)) {
                this.log.debug("filename is invalid.");
                return;
            }
            fileNames = new StringBuilder();
            String fileName = (String)returnData;
            String zipFileName = String.format("%s.zip", fileName);
            File zipFile = new File(FilenameUtils.getName((String)zipFileName));
            try {
                RepositoryService service = this.getRepositoryService();
                try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
                    ListSelectedRowCollection rows = this.getSelectedRows();
                    int size = rows.size();
                    for (int i = 0; i < size; ++i) {
                        ListSelectedRow row = rows.get(i);
                        Long templateId = (Long)row.getPrimaryKeyValue();
                        DeployFile deployFile = service.getProcTemplateExportFile(templateId);
                        String content = deployFile.getFileContent();
                        String templateFileName = deployFile.getFileName();
                        try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));){
                            ZipEntry entry = new ZipEntry(templateFileName);
                            entry.setMethod(8);
                            out.putNextEntry(entry);
                            int len = 0;
                            byte[] buf = new byte[1024];
                            while ((len = in.read(buf)) != -1) {
                                out.write(buf, 0, len);
                            }
                            out.closeEntry();
                        }
                        fileNames.append(templateFileName);
                        if (i >= size - 1) continue;
                        fileNames.append("\u3001");
                    }
                }
                var8_9 = null;
                try (FileInputStream in = new FileInputStream(zipFile);){
                    String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFileName, (InputStream)in, 5000);
                    this.getView().openUrl(url);
                }
                catch (Throwable throwable) {
                    var8_9 = throwable;
                    throw throwable;
                }
                if (!zipFile.exists() || !zipFile.delete()) break block47;
            }
            catch (Exception e) {
                try {
                    this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WorkflowProcTemplateListPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
                catch (Throwable throwable) {
                    if (zipFile.exists() && zipFile.delete()) {
                        this.log.debug(String.format("%s file deleted.", zipFile.getPath()));
                    }
                    throw throwable;
                }
            }
            this.log.debug(String.format("%s file deleted.", zipFile.getPath()));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"WorkflowProcTemplateListPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        WfUtils.addOpLog((String)"wf_proctemplate", (String)OPERATION_EXPORTEMPLATE, (String)ResManager.getLocaleString((String)"\u5bfc\u51fa\u6d41\u7a0b\u6a21\u677f", (String)"WorkflowProcTemplateListPlugin_12", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), null, (Object[])new Object[]{fileNames.toString()});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(OPENED_TEMPLATE_IDS);
        this.getPageCache().remove(OPENED_RELEASELOG_PAGEIDS);
    }

    public void afterCreateNewData(EventObject e) {
        if (!Lang.zh_CN.equals((Object)RequestContext.get().getLang()) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VIEWRELEASELOG});
        }
    }
}

