/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.graph.model.GraphItem;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;

public class WorkflowProcTemplateNodePropConfPlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String FIELD_MANDATORY = "mandatory";
    private static final String FIELD_STATIONARY = "stationary";
    private static final String FIELD_BINDTOPREVNODE = "bindtoprevnode";
    private static final String FIELD_BINDTONEXTNODE = "bindtonextnode";
    private static final String PANEL_CONTROLINTENSITY = "controlintensitypanel";
    private static final String PANEL_OPTIONALACTIONS = "optionalactionspanel";

    @Override
    public void initialize() {
        super.initialize();
        this.addHandleProperties(FIELD_MANDATORY, FIELD_STATIONARY, FIELD_BINDTOPREVNODE, FIELD_BINDTONEXTNODE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        boolean init = false;
        String parentFormId = parentView.getFormShowParameter().getFormId();
        if (this.isProcessTemplateDesigner(parentFormId)) {
            init = true;
        } else if ((parentView = parentView.getParentView()) != null && this.isProcessTemplateDesigner(parentView.getFormShowParameter().getFormId())) {
            init = true;
        }
        if (init && this.isEnableControlIntensity()) {
            this.initProcTemplateProp();
        }
    }

    private boolean isProcessTemplateDesigner(String formId) {
        return "wf_proctemplatedesigner".equals(formId) || "bpm_proctemplatedesigner".equals(formId);
    }

    protected void initProcTemplateProp() {
        HashSet<String> enableFields = new HashSet<String>();
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_OPTIONALACTIONS});
        if (!"StartSignalEvent".equals(this.stencilType) && !"EndNoneEvent".equals(this.stencilType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_CONTROLINTENSITY});
        }
        JSONObject props = this.getCellProperties();
        this.initControlIntensityProperty(enableFields, props, FIELD_MANDATORY, "mandatorySign", FIELD_MANDATORY);
        if ("SequenceFlow".equals(this.stencilType)) {
            this.initSequenceFlowProcTplProp(enableFields, props);
        } else {
            this.initNodeProcTplProp(enableFields, props);
        }
        ProcTemplatePluginUtil.enableFields(this.getView(), enableFields);
    }

    private void initControlIntensityProperty(Set<String> enableFields, JSONObject props, String property, String signProperty, String field) {
        String procNumber = this.getProcessNumber();
        Boolean value = (Boolean)ProcTemplatePluginUtil.getControlIntensityProperty((Map<String, Object>)props, property);
        String sign = (String)ProcTemplatePluginUtil.getControlIntensityProperty((Map<String, Object>)props, signProperty);
        if (Boolean.TRUE.equals(value)) {
            if (sign == null) {
                this.setProperty(signProperty, procNumber);
            } else if (!ProcTemplatePluginUtil.isLatestControlIntensitySign(sign, procNumber)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{field});
            } else {
                enableFields.add(field);
            }
        } else {
            enableFields.add(field);
        }
    }

    private void initSequenceFlowProcTplProp(Set<String> enableFields, JSONObject props) {
        this.initControlIntensityProperty(enableFields, props, "bindToPrevNode", "bindToPrevNodeSign", FIELD_BINDTOPREVNODE);
        this.initControlIntensityProperty(enableFields, props, "bindToNextNode", "bindToNextNodeSign", FIELD_BINDTONEXTNODE);
    }

    private void initNodeProcTplProp(Set<String> enableFields, JSONObject props) {
        this.initControlIntensityProperty(enableFields, props, FIELD_STATIONARY, "stationarySign", FIELD_STATIONARY);
        if (Boolean.TRUE.equals(ProcTemplatePluginUtil.getControlIntensityProperty((Map<String, Object>)props, FIELD_STATIONARY))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"sequence"});
        }
    }

    @Override
    protected void afterSetProperty(String name, Object value) {
        switch (name) {
            case "mandatory": {
                this.afterSetMandatoryProperty(name, value);
                break;
            }
            case "bindtoprevnode": {
                this.afterSetBindToNodeProperty("bindToPrevNode", value, true);
                break;
            }
            case "bindtonextnode": {
                this.afterSetBindToNodeProperty("bindToNextNode", value, false);
                break;
            }
            default: {
                super.afterSetProperty(name, value);
            }
        }
    }

    protected void afterSetMandatoryProperty(String name, Object value) {
        GraphCell cell = this.getGraphCell();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        String newStyle = ProcTemplatePluginUtil.getUpdatedCellMandatoryStyle(cell.getStyle(), value);
        cell.setStyle(newStyle);
        styleMap.put(cell.getResourceId(), newStyle);
        super.afterSetProperty(name, value);
        for (Map.Entry entry : styleMap.entrySet()) {
            this.getWorkflowDesignerPlugin().changeStyle((String)entry.getKey(), this.getView(), (String)entry.getValue());
        }
    }

    private void afterSetBindToNodeProperty(String name, Object value, boolean isPrevious) {
        if (value == null) {
            return;
        }
        GraphCell cell = this.getGraphCell();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        boolean bindToPrevNode = Boolean.TRUE.equals(ProcTemplatePluginUtil.getControlIntensityProperty(cell.getProperties(), "bindToPrevNode"));
        boolean bindToNextNode = Boolean.TRUE.equals(ProcTemplatePluginUtil.getControlIntensityProperty(cell.getProperties(), "bindToNextNode"));
        String movable = "1";
        if (bindToPrevNode || bindToNextNode) {
            movable = "0";
        }
        String newStyle = GraphCodecUtils.updateStyleProperty((String)cell.getStyle(), (String)"movable", (String)movable);
        cell.setStyle(newStyle);
        styleMap.put(cell.getResourceId(), newStyle);
        this.setPrevOrNextCellMandatory(Boolean.TRUE.equals(value), isPrevious, cell, styleMap);
        super.afterSetProperty(name, value);
        this.getWorkflowDesignerPlugin().updateBindToNodeProperty(isPrevious, this.itemId, this.getView(), Boolean.TRUE.equals(value));
        for (Map.Entry entry : styleMap.entrySet()) {
            this.getWorkflowDesignerPlugin().changeStyle((String)entry.getKey(), this.getView(), (String)entry.getValue());
        }
    }

    private void setPrevOrNextCellMandatory(boolean bind, boolean isPrevious, GraphCell cell, Map<String, String> styleMap) {
        if (isPrevious) {
            this.setPrevCellMandatory(bind, cell, styleMap);
        } else {
            this.setNextCellMandatory(bind, cell, styleMap);
        }
    }

    private void setPrevCellMandatory(boolean bind, GraphCell edge, Map<String, String> styleMap) {
        GraphCell prevCell;
        String prevCellId = ProcTemplatePluginUtil.getPrevCellId(this.getModelJsonString(), edge.getResourceId());
        if (prevCellId != null && (prevCell = this.getGraphCell(prevCellId)) != null) {
            Map prevCellProps = prevCell.getProperties();
            boolean prevCellMandatory = Boolean.TRUE.equals(ProcTemplatePluginUtil.getControlIntensityProperty(prevCellProps, FIELD_MANDATORY));
            String prevCellMandatorySign = (String)ProcTemplatePluginUtil.getControlIntensityProperty(prevCellProps, "mandatorySign");
            if (bind) {
                if (!prevCellMandatory) {
                    ProcTemplatePluginUtil.setMandatoryProperty(prevCellProps, true);
                    String prevCellNewStyle = ProcTemplatePluginUtil.getUpdatedCellMandatoryStyle(prevCell.getStyle(), true);
                    prevCell.setStyle(prevCellNewStyle);
                    styleMap.put(prevCell.getResourceId(), prevCellNewStyle);
                }
                String sign = ProcTemplatePluginUtil.getAddedControlIntensitySign(prevCellMandatorySign, edge.getResourceId());
                ProcTemplatePluginUtil.setMandatorySignProperty(prevCellProps, sign);
                this.clearConfigurePageCache(prevCell.getStencil().getId());
            } else if (prevCellMandatorySign != null && prevCellMandatorySign.contains(edge.getResourceId())) {
                String sign = ProcTemplatePluginUtil.getRemovedControlIntensitySign(prevCellMandatorySign, edge.getResourceId());
                ProcTemplatePluginUtil.setMandatorySignProperty(prevCellProps, sign);
                if (ProcTemplatePluginUtil.isEmptyControlIntensitySign(sign)) {
                    ProcTemplatePluginUtil.setMandatoryProperty(prevCellProps, false);
                    String prevCellNewStyle = ProcTemplatePluginUtil.getUpdatedCellMandatoryStyle(prevCell.getStyle(), false);
                    prevCell.setStyle(prevCellNewStyle);
                    styleMap.put(prevCell.getResourceId(), prevCellNewStyle);
                }
                this.clearConfigurePageCache(prevCell.getStencil().getId());
            }
        }
    }

    private void setNextCellMandatory(boolean bind, GraphCell edge, Map<String, String> styleMap) {
        GraphItem target = edge.getTarget();
        if (target == null || target.getResourceId() == null) {
            return;
        }
        GraphCell nextCell = this.getGraphCell(target.getResourceId());
        if (nextCell != null) {
            Map nextCellProps = nextCell.getProperties();
            boolean nextCellMandatory = Boolean.TRUE.equals(ProcTemplatePluginUtil.getControlIntensityProperty(nextCellProps, FIELD_MANDATORY));
            String nextCellMandatorySign = (String)ProcTemplatePluginUtil.getControlIntensityProperty(nextCellProps, "mandatorySign");
            if (bind) {
                if (!nextCellMandatory) {
                    ProcTemplatePluginUtil.setMandatoryProperty(nextCellProps, true);
                    String nextCellNewStyle = ProcTemplatePluginUtil.getUpdatedCellMandatoryStyle(nextCell.getStyle(), true);
                    nextCell.setStyle(nextCellNewStyle);
                    styleMap.put(nextCell.getResourceId(), nextCellNewStyle);
                }
                String sign = ProcTemplatePluginUtil.getAddedControlIntensitySign(nextCellMandatorySign, edge.getResourceId());
                ProcTemplatePluginUtil.setMandatorySignProperty(nextCellProps, sign);
                this.clearConfigurePageCache(nextCell.getStencil().getId());
            } else if (nextCellMandatorySign != null && nextCellMandatorySign.contains(edge.getResourceId())) {
                String sign = ProcTemplatePluginUtil.getRemovedControlIntensitySign(nextCellMandatorySign, edge.getResourceId());
                ProcTemplatePluginUtil.setMandatorySignProperty(nextCellProps, sign);
                if (ProcTemplatePluginUtil.isEmptyControlIntensitySign(sign)) {
                    ProcTemplatePluginUtil.setMandatoryProperty(nextCellProps, false);
                    String prevCellNewStyle = ProcTemplatePluginUtil.getUpdatedCellMandatoryStyle(nextCell.getStyle(), false);
                    nextCell.setStyle(prevCellNewStyle);
                    styleMap.put(nextCell.getResourceId(), prevCellNewStyle);
                }
                this.clearConfigurePageCache(nextCell.getStencil().getId());
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "stationary": {
                this.stationaryChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "mandatory": {
                this.mandatoryChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "bindtoprevnode": {
                this.bindToPrevNodeChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "bindtonextnode": {
                this.bindToNextNodeChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
        }
    }

    private void stationaryChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        if (Boolean.TRUE.equals(newValue)) {
            this.setProperty("stationarySign", this.getProcessNumber());
            this.getView().setEnable(Boolean.FALSE, new String[]{"sequence"});
        } else {
            this.setProperty("stationarySign", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"sequence"});
        }
    }

    private void mandatoryChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        if (Boolean.TRUE.equals(newValue)) {
            this.setProperty("mandatorySign", this.getProcessNumber());
        } else {
            this.setProperty("mandatorySign", null);
        }
    }

    private void bindToPrevNodeChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        GraphCell edge = this.getGraphCell();
        if (Boolean.TRUE.equals(newValue) && ProcTemplatePluginUtil.getPrevCellId(this.getModelJsonString(), edge.getResourceId()) == null) {
            this.cancelPropertyChange(propName);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ebf\u6761\u672a\u8fde\u63a5\u524d\u7eed\u8282\u70b9\u3002", (String)"WorkflowProcTemplateNodePropConfPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        if (Boolean.TRUE.equals(newValue)) {
            this.setProperty("bindToPrevNodeSign", this.getProcessNumber());
        } else {
            this.setProperty("bindToPrevNodeSign", null);
        }
    }

    private void bindToNextNodeChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        GraphCell edge = this.getGraphCell();
        if (Boolean.TRUE.equals(newValue) && (edge.getTarget() == null || edge.getTarget().getResourceId() == null)) {
            this.cancelPropertyChange(propName);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ebf\u6761\u672a\u8fde\u63a5\u540e\u7eed\u8282\u70b9\u3002", (String)"WorkflowProcTemplateNodePropConfPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        if (Boolean.TRUE.equals(newValue)) {
            this.setProperty("bindToNextNodeSign", this.getProcessNumber());
        } else {
            this.setProperty("bindToNextNodeSign", null);
        }
    }

    private void cancelPropertyChange(String propName) {
        this.getModel().beginInit();
        this.getModel().setValue(propName, null);
        this.getModel().endInit();
    }

    private String getProcessNumber() {
        JSONObject props = this.getProcessProperties();
        return props.getString("process_id");
    }

    protected boolean isEnableControlIntensity() {
        return "true".equals(WfConfigurationUtil.getConfigCenterVal((String)"workflow.procTemplate.controlIntensity"));
    }
}

