/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.proctpl.plugin.WorkflowProcTemplateNodePropConfPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowProcTemplateNodeTabPropConfPlugin
extends WorkflowProcTemplateNodePropConfPlugin {
    private static final String OPTIONALOPERS = "optionalopers";
    private static final String OPTIONALDECISIONS = "optionaldecisions";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OPTIONALOPERS, OPTIONALDECISIONS});
    }

    @Override
    protected void initProcTemplateProp() {
        super.initProcTemplateProp();
        HashSet<String> fields = new HashSet<String>();
        fields.add(OPTIONALOPERS);
        fields.add(OPTIONALDECISIONS);
        ProcTemplatePluginUtil.enableFields(this.getView(), fields);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "optionalopers": {
                this.showOptionalOperationsPage();
                break;
            }
            case "optionaldecisions": {
                this.showOptionalDecisionItemsPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showOptionalOperationsPage() {
        JSONObject props = this.getCellProperties();
        String key = String.format("%s.%s", "optionalActions", "optionalOperations");
        List operations = (List)DesignerModelUtil.getProperty((Map<String, Object>)props, key);
        String numbers = "";
        if (operations != null && !operations.isEmpty()) {
            numbers = BillPagePluginUtil.getOperationInfosFromReturnValues((Object)operations, (String)"number");
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        super.showOperationPage(props, parameter, Boolean.TRUE, numbers, OPTIONALOPERS);
    }

    private void showOptionalDecisionItemsPage() {
        JSONObject props = this.getCellProperties();
        FormShowParameter parameter = this.getShowParameter(OPTIONALDECISIONS, "wf_optionaldecisionitems");
        JSONArray decisionOptions = props.getJSONArray("decisionOptions");
        parameter.setCustomParam("decisionOptions", (Object)decisionOptions);
        String key = String.format("%s.%s", "optionalActions", "optionalDecisionItems");
        parameter.setCustomParam("datas", DesignerModelUtil.getProperty((Map<String, Object>)props, key));
        parameter.setCustomParam("stencilType", (Object)this.stencilType);
        if ("YunzhijiaTask".equals(this.stencilType)) {
            parameter.setCustomParam("businessModel", DesignerModelUtil.getProperty((Map<String, Object>)props, "dountersign.businessModel"));
        }
        this.getView().showForm(parameter);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "optionalopers": {
                this.optionalOpersChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "optionaldecisions": {
                this.optionalDecisionsChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void optionalOpersChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty("optionalOperations", null);
        }
    }

    private void optionalDecisionsChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty("optionalDecisionItems", null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "optionalopers": {
                this.optionalOperationsCallBack(returnData);
                break;
            }
            case "optionaldecisions": {
                this.optionalDecisionItemsCallBack(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void optionalOperationsCallBack(Object returnData) {
        if (returnData instanceof List) {
            String idField = "id";
            String numberField = "number";
            List operations = (List)returnData;
            Object oriValue = this.getProperty("optionalOperations");
            HashMap<String, String> idMap = new HashMap<String, String>(16);
            if (oriValue instanceof List) {
                List oriOperations = (List)oriValue;
                Iterator iterator = oriOperations.iterator();
                while (iterator.hasNext()) {
                    Map oriOperation = (Map)iterator.next();
                    idMap.put((String)oriOperation.get(numberField), (String)oriOperation.get(idField));
                }
            }
            for (Map operation : operations) {
                String id = (String)idMap.get(operation.get(numberField));
                if (WfUtils.isEmpty((String)id)) {
                    id = BpmnDiffUtil.getListElementId((String)"decisionOptions");
                }
                operation.put(idField, id);
            }
            this.getModel().setValue(OPTIONALOPERS, (Object)BillPagePluginUtil.getOperationInfosFromReturnValues((Object)operations, (String)"name"));
            this.setProperty("optionalOperations", operations);
            if (operations.isEmpty()) {
                return;
            }
            HashSet<String> optionalOpers = new HashSet<String>(operations.size());
            for (Map operation : operations) {
                optionalOpers.add((String)operation.get("number"));
            }
            this.clearNotOptionalOperations(optionalOpers);
        }
    }

    private void clearNotOptionalOperations(Set<String> optionalOpers) {
        Map props = this.getGraphCell().getProperties();
        this.clearNotOptionalOperationsOrDecisions(props, optionalOpers, "number");
        this.checkBillSettingOperation(props, optionalOpers);
        this.clearNotOptionalExtendBtns(props, optionalOpers);
        this.clearPluginOperation(props, optionalOpers);
        this.updateModelInCache();
    }

    private void checkBillSettingOperation(Map<String, Object> props, Set<String> optionalOpers) {
        String saveOperation;
        Object operationWhenSave;
        String rejectOperation;
        Object operationWhenReject;
        Map billSetting = (Map)props.get("billSetting");
        if (billSetting == null || billSetting.isEmpty()) {
            return;
        }
        String submitOperation = "operationWhenSubmit";
        Object operationWhenSubmit = billSetting.get(submitOperation);
        if (operationWhenSubmit instanceof String && !optionalOpers.contains(operationWhenSubmit)) {
            billSetting.put(submitOperation, null);
            this.getModel().setValue("operationwhensubmit", null);
        }
        if ((operationWhenReject = billSetting.get(rejectOperation = "operationWhenReject")) instanceof String && !optionalOpers.contains(operationWhenReject)) {
            billSetting.put(rejectOperation, null);
            this.getModel().setValue("operationwhenreject", null);
        }
        if ((operationWhenSave = billSetting.get(saveOperation = "operationWhenSave")) instanceof String && !optionalOpers.contains(operationWhenSave)) {
            billSetting.put(saveOperation, null);
            this.getModel().setValue("operationwhensave", null);
        }
    }

    private void clearNotOptionalExtendBtns(Map<String, Object> props, Set<String> optionalOpers) {
        List extendBtns = (List)DesignerModelUtil.getProperty(props, "btnModel.extendBtns");
        if (extendBtns == null || extendBtns.isEmpty()) {
            return;
        }
        boolean changed = this.removeNotOptionalItems(extendBtns, optionalOpers, "operationNumber");
        if (changed) {
            this.removeTabPageIdCache("node_control_pageId");
        }
    }

    private void clearPluginOperation(Map<String, Object> props, Set<String> optionalOpers) {
        List taskListeners = (List)props.get("taskListeners");
        this.clearListenerOperation(taskListeners, optionalOpers);
        List executionListeners = (List)props.get("executionListeners");
        this.clearListenerOperation(executionListeners, optionalOpers);
    }

    private void clearListenerOperation(List<Map<String, Object>> listeners, Set<String> optionalOpers) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        boolean changed = false;
        Iterator<Map<String, Object>> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            String value;
            String implementation;
            Map<String, Object> listener = iterator.next();
            String type = (String)listener.get("implementationtype");
            if (!"operation".equals(type) || !ExternalInterfaceUtil.isValidValue((String)(implementation = (String)listener.get("implementation"))) || WfUtils.isEmpty((String)(value = ExternalInterfaceUtil.getExtItfValue((String)implementation)))) continue;
            HashMap operation = ExternalInterfaceUtil.castJSONToMap((Object)value);
            String forwardOperation = (String)operation.get("forward");
            String withdrawOperation = (String)operation.get("withdraw");
            if ((!WfUtils.isNotEmpty((String)forwardOperation) || optionalOpers.contains(forwardOperation)) && (!WfUtils.isNotEmpty((String)withdrawOperation) || optionalOpers.contains(withdrawOperation))) continue;
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.removeTabPageIdCache("plugins_pageId");
        }
    }

    private void optionalDecisionItemsCallBack(Object returnData) {
        if (returnData instanceof List) {
            List items = (List)returnData;
            this.getModel().setValue(OPTIONALDECISIONS, (Object)BillPagePluginUtil.getOperationInfosFromReturnValues((Object)items, (String)"name"));
            this.setProperty("optionalDecisionItems", items);
            if (items.isEmpty()) {
                return;
            }
            HashSet<String> optionalTypes = new HashSet<String>(items.size());
            for (Map item : items) {
                optionalTypes.add((String)item.get("number"));
            }
            this.clearNotOptionalDecisions(optionalTypes);
        }
    }

    private void clearNotOptionalDecisions(Set<String> optionalTypes) {
        Map props = this.getGraphCell().getProperties();
        this.clearNotOptionalOperationsOrDecisions(props, optionalTypes, "auditType");
        this.updateModelInCache();
    }

    private void clearNotOptionalOperationsOrDecisions(Map<String, Object> props, Set<String> optionalItems, String key) {
        IFormView parentView;
        List decisions = (List)DesignerModelUtil.getProperty(props, "decisionOptions");
        if (decisions == null || decisions.isEmpty()) {
            return;
        }
        boolean changed = this.removeNotOptionalItems(decisions, optionalItems, key);
        if (changed && (parentView = this.getView().getParentView()) != null) {
            parentView.getModel().setValue("participant_operation", (Object)BillPagePluginUtil.getOperationInfosFromReturnValues((Object)decisions, (String)"name"));
            this.getView().sendFormAction(parentView);
        }
    }

    private boolean removeNotOptionalItems(List<Map<String, Object>> items, Set<String> optionalItems, String key) {
        boolean changed = false;
        Iterator<Map<String, Object>> iterator = items.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> decision = iterator.next();
            String item = (String)decision.get(key);
            if (optionalItems.contains(item)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    protected void afterSetMandatoryProperty(String name, Object value) {
        if (Boolean.TRUE.equals(value)) {
            this.clearSkipCondition();
        }
        super.afterSetMandatoryProperty(name, value);
        this.removeTabPageIdCache("node_control_pageId");
    }

    private void removeTabPageIdCache(String pageIdKey) {
        IFormView parentView = this.getView().getParentView();
        String pageId = parentView.getPageCache().get(pageIdKey);
        if (pageId != null) {
            IFormView view = parentView.getView(pageId);
            if (view != null) {
                view.close();
            }
            parentView.getPageCache().remove(pageIdKey);
        }
    }

    private void clearSkipCondition() {
        String repeaterModel;
        String property;
        boolean enableRepeater;
        String skipProperty;
        Map props = this.getGraphCell().getProperties();
        Object skipCondition = DesignerModelUtil.getProperty(props, skipProperty = "skipCondition");
        if (skipCondition instanceof Map && !((Map)skipCondition).isEmpty()) {
            DesignerModelUtil.setProperty(props, skipProperty, null);
        }
        if ((enableRepeater = Boolean.TRUE.equals(DesignerModelUtil.getProperty(props, property = "repeaterbtn"))) && "skip".equals(repeaterModel = (String)DesignerModelUtil.getProperty(props, "repeaterModel"))) {
            DesignerModelUtil.setProperty(props, property, false);
        }
    }
}

