/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.proctpl.plugin.WorkflowProcTemplateTreeListPlugin;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateReleaseLogEntity;

public class WorkflowProcTemplatePlugin
extends AbstractWorkflowPlugin
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final String KEY_REFRESHCATEGORY = "refreshCategory";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgF7 = (BasedataEdit)this.getView().getControl("org");
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit category = (BasedataEdit)this.getView().getControl("category");
        category.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        BasedataEdit parent = (BasedataEdit)this.getView().getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OrgEdit org = (OrgEdit)this.getControl("org");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        ProcTemplatePluginUtil.addOrgFilter(filters, "id");
        org.setQFilters(filters);
        if (this.isAddNew()) {
            this.setControlInitialValue();
        }
    }

    private void setControlInitialValue() {
        String nodeId;
        TreeView treeView = null;
        IDataModel model = this.getModel();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            treeView = (TreeView)parentView.getControl("treeviewap");
        }
        if (treeView != null && ProcTemplatePluginUtil.isNotEmptyNode(nodeId = treeView.getTreeState().getFocusNodeId())) {
            model.setValue("category", (Object)Long.valueOf(nodeId));
            model.setDataChanged(false);
        }
        if ("bpm".equals(this.getView().getFormShowParameter().getAppId())) {
            model.setValue("processtype", (Object)ModelType.BizFlow.name());
        } else {
            model.setValue("processtype", (Object)ModelType.AuditFlow.name());
        }
        String number = ProcTemplatePluginUtil.generateTemplateNumber(model.getDataEntity());
        if (number != null) {
            model.setValue("number", (Object)number);
            model.setDataChanged(false);
        }
    }

    private boolean isAddNew() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (!(parameter instanceof BaseShowParameter)) {
            return false;
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)parameter;
        return BillOperationStatus.ADDNEW.equals((Object)baseShowParameter.getBillStatus());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("entity".equals(propName)) {
            this.entityChanged(newValue);
        }
    }

    private void entityChanged(Object newValue) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (parent == null || !(newValue instanceof DynamicObject)) {
            return;
        }
        DynamicObject newEntity = (DynamicObject)newValue;
        String entityNumber = newEntity.getString("number");
        if (WfUtils.isEmpty((String)entityNumber)) {
            return;
        }
        ProcTemplateEntity parentProcTemplate = (ProcTemplateEntity)this.getRepositoryService().findEntityById((Long)parent.getPkValue(), "wf_proctemplate", "entity");
        if (!entityNumber.equals(parentProcTemplate.getEntityNumber())) {
            this.getModel().setValue("parent", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u548c\u7236\u6a21\u677f\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7236\u6a21\u677f\u3002", (String)"WorkflowProcTemplatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && "save".equals(key = ((AbstractOperate)source).getOperateKey())) {
            this.beforeSaveOperation();
        }
    }

    private void beforeSaveOperation() {
        IDataModel model = this.getModel();
        RepositoryService repositoryService = this.getRepositoryService();
        DynamicObject parent = (DynamicObject)model.getValue("parent");
        Long parentId = null;
        String level = "1";
        if (parent != null) {
            parentId = (Long)parent.getPkValue();
            ProcTemplateEntity entity = (ProcTemplateEntity)repositoryService.findEntityById(parentId, "wf_proctemplate", "level");
            level = this.getNextLevel(entity.getLevel());
            ProcTemplateReleaseLogEntity releaseLog = repositoryService.getProcTemplateReleaseLog(parentId, null);
            if (releaseLog != null) {
                model.setValue("parentversion", (Object)releaseLog.getVersion());
            } else {
                this.logger.error(String.format("%s releaseLog is null.", parentId));
            }
        }
        model.setValue("level", (Object)level);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        this.getModel().setDataChanged(false);
        String operateKey = evt.getOperateKey();
        if ("save".equals(operateKey) || "copy".equals(operateKey)) {
            this.openProcTemplateDesigner(evt);
        }
    }

    private void openProcTemplateDesigner(AfterDoOperationEventArgs evt) {
        List ids = evt.getOperationResult().getSuccessPkIds();
        if (ids == null || ids.isEmpty()) {
            return;
        }
        Object id = ids.get(0);
        if (id instanceof Long) {
            ProcTemplatePluginUtil.openProcTemplateDesigner((Long)id, this.getView());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field;
        switch (field = evt.getProperty().getName()) {
            case "org": {
                this.beforeOrgF7Select(evt);
                break;
            }
            case "parent": {
                this.beforeParentF7Select(evt);
                break;
            }
        }
    }

    private void beforeOrgF7Select(BeforeF7SelectEvent evt) {
        evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)"01");
    }

    private void beforeParentF7Select(BeforeF7SelectEvent evt) {
        boolean isBizFlow;
        QFilter filter = new QFilter("level", "in", (Object)new String[]{"1", "2"});
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        if (entity != null) {
            String entityNumber = entity.getString("number");
            filter.and(new QFilter("entity", "=", (Object)entityNumber));
        }
        filter.and(new QFilter("processtype", "=", (Object)((isBizFlow = "bpm".equalsIgnoreCase(this.getView().getFormShowParameter().getAppId())) ? ModelType.BizFlow.name() : ModelType.AuditFlow.name())));
        evt.addCustomQFilter(filter);
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent evt) {
        FormShowParameter parameter = evt.getShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "category"));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("category".equals(evt.getActionId())) {
            this.getPageCache().put(KEY_REFRESHCATEGORY, "true");
            this.getModel().setValue("category", evt.getReturnData());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if ("true".equals(this.getPageCache().get(KEY_REFRESHCATEGORY))) {
            this.refreshTreeListCategories();
        }
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_REFRESHCATEGORY);
    }

    private void refreshTreeListCategories() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
        WorkflowProcTemplateTreeListPlugin treeListPlugin = (WorkflowProcTemplateTreeListPlugin)pluginProxy.getPlugin(WorkflowProcTemplateTreeListPlugin.class.getCanonicalName());
        if (treeListPlugin == null) {
            return;
        }
        treeListPlugin.refreshCategory();
    }

    private String getNextLevel(String level) {
        int next = Integer.parseInt(level) + 1;
        return String.valueOf(next);
    }
}

