/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.proctpl.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntity;

public class WorkflowProcTemplateTreeListPlugin
extends AbstractWorkflowListPlugin
implements TreeNodeClickListener {
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String TREE_CATEGORY = "treeviewap";
    private static final String KEY_ADD = "addCategory";
    private static final String KEY_EDIT = "editCategory";
    private static final String KEY_DELETE = "deleteCategory";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD, BTN_EDIT, BTN_DELETE, BTN_REFRESH});
        TreeView tree = (TreeView)this.getControl(TREE_CATEGORY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.initProcTemplateCategoryTree();
    }

    private TreeNode initProcTemplateCategoryTree() {
        TreeNode rootNode = this.getRepositoryService().getProcTemplateCategoryTree();
        this.getTreeView().addNode(rootNode);
        return rootNode;
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_add": {
                this.addCategory();
                break;
            }
            case "btn_edit": {
                this.editCategory();
                break;
            }
            case "btn_delete": {
                this.deleteCategory();
                break;
            }
            case "btn_refresh": {
                this.refreshCategory();
                break;
            }
        }
    }

    private void addCategory() {
        ProcTemplateCategoryEntity category;
        String nodeId = this.getFocusTreeNodeId();
        if (ProcTemplatePluginUtil.isNotEmptyNode(nodeId) && WfUtils.isNotEmpty((Long)(category = (ProcTemplateCategoryEntity)this.getRepositoryService().findEntityById(Long.valueOf(nodeId), "wf_proctemplatecategory", "parent")).getParentId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e0a\u7ea7\u5206\u7c7b\u4e2d\u65b0\u589e\u3002", (String)"WorkflowProcTemplateTreeListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_proctemplatecategory");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParam("focusedId", (Object)nodeId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ADD));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void editCategory() {
        String nodeId = this.getFocusTreeNodeId();
        if (ProcTemplatePluginUtil.isNotEmptyNode(nodeId)) {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("wf_proctemplatecategory");
            parameter.setPkId((Object)Long.valueOf(nodeId));
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_EDIT));
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u6d41\u7a0b\u6a21\u677f\u5206\u7c7b\u3002", (String)"WorkflowProcTemplateTreeListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteCategory() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_proctemplatecategory", (String)"4715e1f1000000ac")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6a21\u677f\u5206\u7c7b\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", (String)"WorkflowProcTemplateTreeListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = this.getFocusTreeNodeId();
        if (ProcTemplatePluginUtil.isNotEmptyNode(nodeId)) {
            String result = this.getRepositoryService().deleteProcTemplateCategory(Long.valueOf(nodeId), false);
            if (result != null) {
                this.getView().showTipNotification(result);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u5206\u7c7b\u5417\uff1f", (String)"WorkflowProcTemplateTreeListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u53ef\u5220\u9664\u3002", (String)"WorkflowProcTemplateTreeListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    protected TreeNode refreshCategory() {
        this.getTreeView().deleteAllNodes();
        TreeNode rootNode = this.initProcTemplateCategoryTree();
        this.getTreeView().focusNode(rootNode);
        return rootNode;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Long) {
            String actionId = e.getActionId();
            Long id = (Long)returnData;
            if (KEY_ADD.equals(actionId)) {
                this.addCategoryCallBack(id);
            } else if (KEY_EDIT.equals(actionId)) {
                this.editCategoryCallBack(id);
            }
        }
    }

    private void addCategoryCallBack(Long id) {
        ProcTemplateCategoryEntity category = this.findProcTemplateCategory(id);
        String parentId = "0";
        if (category.getParentId() != null) {
            parentId = String.valueOf(category.getParentId());
        }
        TreeNode treeNode = new TreeNode(parentId, String.valueOf(id), category.getCategoryName());
        this.getTreeView().addNode(treeNode);
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl(TREE_CATEGORY);
    }

    private void editCategoryCallBack(Long id) {
        ProcTemplateCategoryEntity category = this.findProcTemplateCategory(id);
        this.refreshCategory();
        TreeNode treeNode = new TreeNode(String.valueOf(category.getParentId()), String.valueOf(id), category.getCategoryName(), this.isCategoryHasChildren(id));
        this.getTreeView().focusNode(treeNode);
        this.refreshList(this.getFocusTreeNodeId());
    }

    private ProcTemplateCategoryEntity findProcTemplateCategory(Long id) {
        String fields = String.format("%s,%s", "name", "parent");
        return (ProcTemplateCategoryEntity)this.getRepositoryService().findEntityById(id, "wf_proctemplatecategory", fields);
    }

    private boolean isCategoryHasChildren(Long id) {
        QFilter[] filters = new QFilter[]{new QFilter("parent", "=", (Object)id)};
        Long count = this.getRepositoryService().getEntityCountByFilter("wf_proctemplatecategory", filters);
        return count > 1L;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (!MessageBoxResult.Yes.equals((Object)event.getResult())) {
            return;
        }
        String callBackId = event.getCallBackId();
        if (KEY_DELETE.equals(callBackId)) {
            this.confirmDeleteCategory();
        }
    }

    private void confirmDeleteCategory() {
        ProcTemplateCategoryEntity parentCategory;
        TreeNode rootNode;
        TreeView treeView = this.getTreeView();
        List selectedNodes = treeView.getTreeState().getSelectedNodes();
        if (selectedNodes.isEmpty()) {
            this.log.debug("no selected nodes.");
            return;
        }
        Map selectedNode = (Map)selectedNodes.get(0);
        String nodeId = (String)selectedNode.get("id");
        String parentId = (String)selectedNode.get("parentid");
        Long parentCategoryId = Long.valueOf(parentId);
        RepositoryService service = this.getRepositoryService();
        service.deleteProcTemplateCategory(Long.valueOf(nodeId), true);
        TreeNode parentNode = rootNode = this.refreshCategory();
        if (ProcTemplatePluginUtil.isNotEmptyNode(parentId) && (parentCategory = (ProcTemplateCategoryEntity)service.findEntityById(parentCategoryId, "wf_proctemplatecategory", "name")) != null) {
            parentNode = new TreeNode("0", parentId, String.valueOf(parentCategory.getName()));
        }
        treeView.focusNode(parentNode);
        TreeView tree = (TreeView)this.getControl(TREE_CATEGORY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.treeNodeClick(parentNode.getParentid(), parentNode.getId());
    }

    private String getFocusTreeNodeId() {
        return this.getTreeView().getTreeState().getFocusNodeId();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree = (TreeView)evt.getSource();
        TreeView.TreeState state = tree.getTreeState();
        String nodeId = state.getFocusNodeId();
        this.refreshList(nodeId);
    }

    private void refreshList(String nodeId) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        this.getPageCache().put("focusedId", nodeId);
        list.refreshData();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("focusedId");
    }
}

