/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.util.IBaseChangeLogCallBack;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BaseChangeLogsUtil {
    public static final String TYPE_DYNAMICFORMMAPPING = "dynamicformmapping";
    private static final String ADMIN = "admin";
    private static final String ROLE = "role";
    private static final String ORGTYPE = "orgtype";
    private static final String COMMENT = "comment";
    private static final String SUMMARY = "summary";
    private static final String KEYAUDITOR = "keyauditor";
    public static final String TASKRULE = "taskrule";
    public static final String DELETE = "delete";
    public static final String INSERT = "insert";
    public static final String MODIFY = "modify";
    private static final String NUMBER = "number";
    private static final String FORMATSTRING = "%s(%s)";
    private static final String ENTRY = "entry";
    private static final String ALTERNATEUSER = "alternateuser";
    private static final String STATE = "state";
    private static final String FIELDKEY = "fieldkey";
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDPERCENT = "fieldpercent";
    private static final String FONTCOLOR = "fontcolor";
    private static final String FONTSIZE = "fontsize";
    private static final String USERPOSITION = "userposition";
    public static final String MOVE_FLAG = "moveFlag";
    private static final String DIMENSION1 = "dimension1";
    private static final String DIMENSION2 = "dimension2";
    private static final String DIMENSION3 = "dimension3";
    private static final String DIMENSION4 = "dimension4";
    private static final String INCLUDADMINSUB = "includadminsub";

    public static void addLog(Long baseFormId, String type, String op, ILocaleString title, ILocaleString detail, String modifier) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ManagementService managementService = wfService.getManagementService();
        managementService.insertBaseChangeLogsEntity(baseFormId, type, op, title, detail, modifier);
    }

    public static void queryLog(IFormView view, String type) {
        ListSelectedRowCollection rows = ((IListView)view).getSelectedRows();
        HashSet<Object> idSet = new HashSet<Object>();
        for (ListSelectedRow row : rows) {
            idSet.add(row.getPrimaryKeyValue());
        }
        ListFilterParameter filterParameter = new ListFilterParameter();
        QFilter qType = new QFilter("type", "=", (Object)type);
        QFilter qBase = new QFilter("baseformid", "in", idSet);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qType);
        if (!idSet.isEmpty()) {
            qFilters.add(qBase);
        }
        filterParameter.setQFilters(qFilters);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setListFilterParameter(filterParameter);
        parameter.setBillFormId("wf_basechangelogs");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)parameter);
    }

    public static void putBaseArrayCache(IFormView view, String entity) {
        ListSelectedRowCollection rows = ((IListView)view).getSelectedRows();
        HashSet<Object> idSet = new HashSet<Object>();
        for (ListSelectedRow row : rows) {
            idSet.add(row.getPrimaryKeyValue());
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        JSONArray baseArray = new JSONArray();
        if ("wf_administrator".equals(entity)) {
            DynamicObject[] entityObjects;
            for (DynamicObject object : entityObjects = BusinessDataServiceHelper.load((String)entity, (String)"id,userid.name,userid.id", (QFilter[])new QFilter[]{qFilter})) {
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)object.getLong("id"));
                obj.put("name", (Object)object.getString("userid.name"));
                obj.put(NUMBER, (Object)object.getString("userid.id"));
                baseArray.add((Object)obj);
            }
        } else if ("wf_dynamicformmapping".equals(entity)) {
            DynamicObject[] entityObjects;
            for (DynamicObject object : entityObjects = BusinessDataServiceHelper.load((String)entity, (String)"id, dynamicformnumber.number, dynamicformnumber.name, entitynumber.name, entitynumber.number ", (QFilter[])new QFilter[]{qFilter})) {
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)object.getLong("id"));
                obj.put("dynamicFormNumberNumber", object.get("dynamicformnumber.number"));
                obj.put("dynamicFormNumberName", object.get("dynamicformnumber.name"));
                obj.put("entityNumberNumber", object.get("entitynumber.number"));
                obj.put("entityNumberName", object.get("entitynumber.name"));
                baseArray.add((Object)obj);
            }
        } else {
            DynamicObject[] entityObjects;
            for (DynamicObject object : entityObjects = BusinessDataServiceHelper.load((String)entity, (String)"id,number,name", (QFilter[])new QFilter[]{qFilter})) {
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)object.getLong("id"));
                obj.put("name", (Object)object.getString("name"));
                obj.put(NUMBER, (Object)object.getString(NUMBER));
                baseArray.add((Object)obj);
            }
        }
        ((IPageCache)view.getService(IPageCache.class)).put("arr", baseArray.toJSONString());
    }

    public static void addChangeLog(IFormView view, Object source, String type) {
        String arr = ((IPageCache)view.getService(IPageCache.class)).get("arr");
        JSONArray baseArray = JSONArray.parseArray((String)arr);
        LocaleString title = new LocaleString();
        String op = "";
        if (source instanceof Delete) {
            title = WfUtils.getPromptWordLocaleString((String)"\u5220\u9664", (String)"BaseChangeLogsUtil_1", (String)"bos-wf-formplugin");
            op = DELETE;
        } else if (source instanceof StatusConvert) {
            if ("disable".equals(((StatusConvert)source).getType())) {
                title = WfUtils.getPromptWordLocaleString((String)"\u7981\u7528", (String)"BaseChangeLogsUtil_2", (String)"bos-wf-formplugin");
                op = "disable";
            } else {
                title = WfUtils.getPromptWordLocaleString((String)"\u542f\u7528", (String)"BaseChangeLogsUtil_3", (String)"bos-wf-formplugin");
                op = "enable";
            }
        }
        switch (type) {
            case "admin": {
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u6d41\u7a0b\u7ba1\u7406\u5458\uff1a", (String)"BaseChangeLogsUtil_4", (String)"bos-wf-formplugin"));
                break;
            }
            case "role": {
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a", (String)"BaseChangeLogsUtil_5", (String)"bos-wf-formplugin"));
                break;
            }
            case "orgtype": {
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u7ec4\u7ec7\u5206\u7c7b\uff1a", (String)"BaseChangeLogsUtil_6", (String)"bos-wf-formplugin"));
                break;
            }
            case "comment": {
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u5e38\u7528\u5ba1\u6279\u610f\u89c1\uff1a", (String)"BaseChangeLogsUtil_7", (String)"bos-wf-formplugin"));
                break;
            }
            case "summary": {
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u79fb\u52a8\u5355\u636e\u6458\u8981\u914d\u7f6e\u4fe1\u606f\uff1a", (String)"BaseChangeLogsUtil_8", (String)"bos-wf-formplugin"));
                break;
            }
            case "keyauditor": {
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u5173\u952e\u5ba1\u6279\u4eba\uff1a", (String)"BaseChangeLogsUtil_59", (String)"bos-wf-formplugin"));
                break;
            }
        }
        if (COMMENT.equals(type)) {
            for (int i = 0; i < baseArray.size(); ++i) {
                JSONObject object = baseArray.getJSONObject(i);
                ILocaleString s = BaseChangeLogsUtil.newMulitLangAndAppendString((ILocaleString)title, String.format(FORMATSTRING, object.getString(NUMBER), object.getString("id")));
                BaseChangeLogsUtil.addLog(object.getLong("id"), type, op, s, (ILocaleString)new LocaleString(), RequestContext.get().getUserId());
            }
        } else if (TYPE_DYNAMICFORMMAPPING.equals(type)) {
            String lan = null;
            Object dynamicFormNameDetailOld = null;
            Object entityNameDetailOld = null;
            Lang[] langs = WfUtils.getSupportLangs();
            LocaleString s = new LocaleString();
            for (int i = 0; i < baseArray.size(); ++i) {
                JSONObject object = baseArray.getJSONObject(i);
                for (Lang lang : langs) {
                    lan = lang.toString();
                    dynamicFormNameDetailOld = ((JSONObject)object.get((Object)"dynamicFormNumberName")).get((Object)lan);
                    entityNameDetailOld = ((JSONObject)object.get((Object)"entityNumberName")).get((Object)lan);
                    s.setItem(lan, (Object)String.format(ResManager.loadKDString((String)"%1$s\u8868\u5355\u6620\u5c04\u5173\u7cfb\uff1a\u8868\u5355  %2$s\uff08%3$s\uff09\uff0c\u5b9e\u4f53  %4$s\uff08%5$s\uff09\u3002", (String)"BaseChangeLogsUtil_66", (String)"bos-wf-formplugin", (Object[])new Object[0]), title.get((Object)lan), WfUtils.isEmptyString((Object)dynamicFormNameDetailOld) ? "" : dynamicFormNameDetailOld, object.get((Object)"dynamicFormNumberNumber"), WfUtils.isEmptyString((Object)entityNameDetailOld) ? "" : entityNameDetailOld, object.get((Object)"entityNumberNumber")));
                }
                BaseChangeLogsUtil.addLog(object.getLong("id"), type, op, (ILocaleString)s, (ILocaleString)new LocaleString(), RequestContext.get().getUserId());
            }
        } else {
            for (int i = 0; i < baseArray.size(); ++i) {
                JSONObject object = baseArray.getJSONObject(i);
                ILocaleString s = BaseChangeLogsUtil.newMulitLangAndAppendString((ILocaleString)title, String.format(FORMATSTRING, object.getString("name"), object.getString(NUMBER)));
                BaseChangeLogsUtil.addLog(object.getLong("id"), type, op, s, (ILocaleString)new LocaleString(), RequestContext.get().getUserId());
            }
        }
    }

    private static Object getPKID(IFormView view) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)view.getFormShowParameter();
        Object id = baseShowParameter.getPkId();
        return id;
    }

    public static void addBaseLog(IFormView view, String type, String entity, String baseFormId, IBaseChangeLogCallBack callback) {
        JSONArray arr = callback.getModelArray();
        Object id = BaseChangeLogsUtil.getPKID(view);
        Boolean isAddNew = WfUtils.isNullObject((Object)id);
        LocaleString detail = new LocaleString();
        LocaleString title = new LocaleString();
        title = isAddNew != false ? WfUtils.getPromptWordLocaleString((String)"\u65b0\u589e", (String)"BaseChangeLogsUtil_9", (String)"bos-wf-formplugin") : WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539", (String)"BaseChangeLogsUtil_10", (String)"bos-wf-formplugin");
        switch (type) {
            case "admin": {
                detail = BaseChangeLogsUtil.setAdminDetail(view, arr);
                Object user = view.getModel().getValue("userid");
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u6d41\u7a0b\u7ba1\u7406\u5458\uff1a", (String)"BaseChangeLogsUtil_4", (String)"bos-wf-formplugin"));
                title = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)title, String.format(FORMATSTRING, ((DynamicObject)user).getString("name"), ((DynamicObject)user).getString("id")));
                break;
            }
            case "role": {
                detail = BaseChangeLogsUtil.setRoleDetail(view, arr);
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a", (String)"BaseChangeLogsUtil_5", (String)"bos-wf-formplugin"));
                ILocaleString roleName = (ILocaleString)view.getModel().getValue("name");
                String roleValue = (String)view.getModel().getValue(NUMBER);
                title = WfMultiLangUtils.jointILocaleString((ILocaleString)title, (ILocaleString)roleName, (String)"", (String)"", (String)("(" + roleValue + ")"));
                break;
            }
            case "orgtype": {
                detail = BaseChangeLogsUtil.setOrgDetail(view, arr);
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u7ec4\u7ec7\u5206\u7c7b\uff1a", (String)"BaseChangeLogsUtil_6", (String)"bos-wf-formplugin"));
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, (ILocaleString)view.getModel().getValue("name"));
                title = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)title, "(" + view.getModel().getValue(NUMBER) + ")");
                break;
            }
            case "comment": {
                DynamicObject groupDynamicObject = (DynamicObject)view.getModel().getValue("group");
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u5ba1\u6279\u610f\u89c1\uff1a", (String)"BaseChangeLogsUtil_11", (String)"bos-wf-formplugin"));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)view.getModel().getValue("name"));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u51b3\u7b56\u9879\uff1a", (String)"BaseChangeLogsUtil_38", (String)"bos-wf-formplugin"));
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, view.getModel().getValue("decisiontype") + "  ");
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u5206\u7ec4\u7f16\u7801\uff1a", (String)"BaseChangeLogsUtil_39", (String)"bos-wf-formplugin"));
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, groupDynamicObject.getString(NUMBER));
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u5e38\u7528\u5ba1\u6279\u610f\u89c1\uff1a", (String)"BaseChangeLogsUtil_7", (String)"bos-wf-formplugin"));
                title = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)title, String.format(FORMATSTRING, view.getModel().getValue(NUMBER), baseFormId));
                break;
            }
            case "summary": {
                detail = BaseChangeLogsUtil.setSummaryDetail(view, arr);
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u79fb\u52a8\u5355\u636e\u6458\u8981\u914d\u7f6e\u4fe1\u606f\uff1a", (String)"BaseChangeLogsUtil_8", (String)"bos-wf-formplugin"));
                title = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)title, String.format(FORMATSTRING, view.getModel().getValue("name"), view.getModel().getValue(NUMBER)));
                break;
            }
            case "keyauditor": {
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u5173\u952e\u5ba1\u6279\u4eba\uff1a", (String)"BaseChangeLogsUtil_59", (String)"bos-wf-formplugin"));
                DynamicObjectCollection keyAuditors = (DynamicObjectCollection)view.getModel().getValue(KEYAUDITOR);
                for (DynamicObject keyAuditor : keyAuditors) {
                    detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, keyAuditor.getDynamicObject("fbasedataid").getLocaleString("name") + "  ");
                }
                DynamicObject org = (DynamicObject)view.getModel().getValue("orgunit");
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\uff1b\u6240\u5c5e\u7ec4\u7ec7\uff1a", (String)"BaseChangeLogsUtil_60", (String)"bos-wf-formplugin"));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, org.getLocaleString("name"));
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, WfUtils.getPromptWordLocaleString((String)"\u5173\u952e\u5ba1\u6279\u4eba\uff1a", (String)"BaseChangeLogsUtil_59", (String)"bos-wf-formplugin"));
                ILocaleString name = (ILocaleString)view.getModel().getValue("name");
                String number = (String)view.getModel().getValue(NUMBER);
                ILocaleString name1 = BaseChangeLogsUtil.jointILocaleString(name, number, FORMATSTRING);
                title = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)title, name1);
                break;
            }
            case "dynamicformmapping": {
                detail = BaseChangeLogsUtil.setDynamicFormMappingDetail(view, arr, isAddNew, (ILocaleString)title);
                break;
            }
        }
        if (isAddNew.booleanValue()) {
            BaseChangeLogsUtil.addLog(Long.valueOf(baseFormId), type, INSERT, (ILocaleString)title, (ILocaleString)detail, RequestContext.get().getUserId());
        } else if (WfUtils.isNotEmpty((ILocaleString)detail)) {
            BaseChangeLogsUtil.addLog(Long.valueOf(baseFormId), type, MODIFY, (ILocaleString)title, (ILocaleString)detail, RequestContext.get().getUserId());
        }
        if (!arr.isEmpty()) {
            ((IPageCache)view.getService(IPageCache.class)).put(ENTRY, arr.toJSONString());
        }
    }

    private static ILocaleString setDynamicFormMappingDetail(IFormView view, JSONArray newArr, Boolean isAddNew, ILocaleString title) {
        LocaleString detail = new LocaleString();
        String lan = null;
        StringBuilder sb = null;
        String modelType = (String)((JSONObject)newArr.get(0)).get((Object)"modeltype");
        ILocaleString dynamicFormName = (ILocaleString)((JSONObject)newArr.get(0)).get((Object)"dynamicFormName");
        ILocaleString entityName = (ILocaleString)((JSONObject)newArr.get(0)).get((Object)"entityName");
        ILocaleString description = (ILocaleString)((JSONObject)newArr.get(0)).get((Object)"description");
        String dynamicFormNameDetail = null;
        String entityNameDetail = null;
        String descriptionDetail = null;
        String entityNameDetailOld = null;
        String dynamicFormNameDetailOld = null;
        Lang[] langs = WfUtils.getSupportLangs();
        if (isAddNew.booleanValue()) {
            for (Lang lang : langs) {
                sb = new StringBuilder();
                lan = lang.toString();
                dynamicFormNameDetail = (String)dynamicFormName.get((Object)lan);
                entityNameDetail = (String)entityName.get((Object)lan);
                sb.append(String.format(ResManager.loadKDString((String)"%1$s\u8868\u5355\u7c7b\u578b\u4e3a %2$s\uff0c\u8868\u5355\u4e3a %3$s\uff0c\u5b9e\u4f53\u4e3a  %4$s\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"BaseChangeLogsUtil_67", (String)"bos-wf-formplugin", (Object[])new Object[0]), title.get((Object)lan), modelType, WfUtils.isEmptyString((Object)dynamicFormNameDetail) ? dynamicFormName.toString() : dynamicFormNameDetail, WfUtils.isEmptyString((Object)entityNameDetail) ? entityName.toString() : entityNameDetail));
                if (null != description) {
                    descriptionDetail = (String)description.get((Object)lan);
                    String string = descriptionDetail = WfUtils.isEmptyString((Object)descriptionDetail) ? description.toString() : descriptionDetail;
                    if (WfUtils.isNotEmpty((String)descriptionDetail)) {
                        sb.replace(sb.lastIndexOf("\u3002"), sb.length(), "\uff0c");
                        sb.append(String.format(ResManager.loadKDString((String)"\u63cf\u8ff0\u4e3a %1$s\u3002", (String)"BaseChangeLogsUtil_68", (String)"bos-wf-formplugin", (Object[])new Object[0]), descriptionDetail));
                    }
                }
                detail.setItem(lan, (Object)sb.toString());
                dynamicFormNameDetailOld = (String)dynamicFormName.get((Object)lan);
                dynamicFormNameDetailOld = WfUtils.isEmptyString((Object)dynamicFormNameDetailOld) ? dynamicFormName.toString() : dynamicFormNameDetailOld;
                entityNameDetailOld = (String)entityName.get((Object)lan);
                entityNameDetailOld = WfUtils.isEmptyString((Object)entityNameDetailOld) ? entityName.toString() : entityNameDetailOld;
                title.setItem(lan, (Object)String.format(ResManager.loadKDString((String)"%1$s\u8868\u5355\u6620\u5c04\u5173\u7cfb\uff1a\u8868\u5355  %2$s\uff08%3$s\uff09\uff0c\u5b9e\u4f53  %4$s\uff08%5$s\uff09\u3002", (String)"BaseChangeLogsUtil_66", (String)"bos-wf-formplugin", (Object[])new Object[0]), title.get((Object)lan), dynamicFormNameDetailOld, ((JSONObject)newArr.get(0)).get((Object)"dynamicFormNumber"), entityNameDetailOld, ((JSONObject)newArr.get(0)).get((Object)"entityNumber")));
            }
            return detail;
        }
        String entry = ((IPageCache)view.getService(IPageCache.class)).get(ENTRY);
        JSONArray arr = JSONArray.parseArray((String)entry);
        String modelTypeOld = (String)((JSONObject)arr.get(0)).get((Object)"modeltype");
        JSONObject dynamicFormNameOld = (JSONObject)((JSONObject)arr.get(0)).get((Object)"dynamicFormName");
        JSONObject entityNameOld = (JSONObject)((JSONObject)arr.get(0)).get((Object)"entityName");
        JSONObject descriptionOld = (JSONObject)((JSONObject)arr.get(0)).get((Object)"description");
        String descriptionDetailOld = null;
        for (Lang lang : langs) {
            sb = new StringBuilder();
            lan = lang.toString();
            sb.append((String)title.get((Object)lan));
            if (!modelTypeOld.equals(modelType)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u8868\u5355\u7c7b\u578b\u4ece  %1$s \u4fee\u6539\u4e3a  %2$s\uff1b", (String)"BaseChangeLogsUtil_69", (String)"bos-wf-formplugin", (Object[])new Object[0]), modelTypeOld, modelType));
            }
            dynamicFormNameDetailOld = WfUtils.isEmptyString((Object)(dynamicFormNameDetailOld = dynamicFormNameOld.getString(lan))) ? "" : dynamicFormNameDetailOld;
            dynamicFormNameDetail = (String)dynamicFormName.get((Object)lan);
            String string = dynamicFormNameDetail = WfUtils.isEmptyString((Object)dynamicFormNameDetail) ? dynamicFormName.toString() : dynamicFormNameDetail;
            if (!dynamicFormNameDetailOld.equals(dynamicFormNameDetail)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u8868\u5355\u4ece  %1$s \u4fee\u6539\u4e3a  %2$s\uff1b", (String)"BaseChangeLogsUtil_70", (String)"bos-wf-formplugin", (Object[])new Object[0]), dynamicFormNameDetailOld, dynamicFormNameDetail));
            }
            entityNameDetailOld = WfUtils.isEmptyString((Object)(entityNameDetailOld = entityNameOld.getString(lan))) ? "" : entityNameDetailOld;
            entityNameDetail = (String)entityName.get((Object)lan);
            String string2 = entityNameDetail = WfUtils.isEmptyString((Object)entityNameDetail) ? entityName.toString() : entityNameDetail;
            if (!entityNameDetailOld.equals(entityNameDetail)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u4ece %1$s \u4fee\u6539\u4e3a  %2$s\uff1b", (String)"BaseChangeLogsUtil_71", (String)"bos-wf-formplugin", (Object[])new Object[0]), entityNameDetailOld, entityNameDetail));
            }
            if (null != descriptionOld) {
                descriptionDetailOld = descriptionOld.getString(lan);
                descriptionDetailOld = WfUtils.isEmptyString((Object)descriptionDetailOld) ? "" : descriptionDetailOld;
            }
            String string3 = descriptionDetailOld = WfUtils.isEmpty(descriptionDetailOld) ? " " : descriptionDetailOld;
            if (null != description) {
                descriptionDetail = (String)description.get((Object)lan);
                descriptionDetail = WfUtils.isEmptyString((Object)descriptionDetail) ? description.toString() : descriptionDetail;
            }
            String string4 = descriptionDetail = WfUtils.isEmpty((String)descriptionDetail) ? " " : descriptionDetail;
            if (null != descriptionDetailOld && null != descriptionDetail && !descriptionDetailOld.equals(descriptionDetail)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u63cf\u8ff0\u4ece %1$s \u4fee\u6539\u4e3a  %2$s\uff1b", (String)"BaseChangeLogsUtil_72", (String)"bos-wf-formplugin", (Object[])new Object[0]), descriptionDetailOld, descriptionDetail));
            }
            sb.replace(sb.lastIndexOf("\uff1b"), sb.length(), "\u3002");
            detail.setItem(lan, (Object)sb.toString());
            title.setItem(lan, (Object)String.format(ResManager.loadKDString((String)"%1$s\u8868\u5355\u6620\u5c04\u5173\u7cfb\uff1a\u8868\u5355  %2$s\uff08%3$s\uff09\uff0c\u5b9e\u4f53  %4$s\uff08%5$s\uff09\u3002", (String)"BaseChangeLogsUtil_66", (String)"bos-wf-formplugin", (Object[])new Object[0]), title.get((Object)lan), dynamicFormNameDetailOld, ((JSONObject)arr.get(0)).get((Object)"dynamicFormNumber"), entityNameDetailOld, ((JSONObject)arr.get(0)).get((Object)"entityNumber")));
        }
        return detail;
    }

    public static void putBaseModelCache(IFormView view, String type, IBaseChangeLogCallBack callback) {
        JSONArray arr = callback.getModelArray();
        ((IPageCache)view.getService(IPageCache.class)).put(ENTRY, arr.toJSONString());
    }

    private static String getUniqueKey(JSONObject item) {
        if ("approvalposition".equals(item.getString("roleType"))) {
            return String.format("%s_%s", item.getString("approvalposition"), item.getString("id"));
        }
        return String.format("%s_%s", item.getString("user"), item.getString("id"));
    }

    private static ILocaleString setRoleDetail(IFormView view, JSONArray newArr) {
        String key;
        JSONObject obj;
        int i;
        String entry = ((IPageCache)view.getService(IPageCache.class)).get(ENTRY);
        JSONArray arr = JSONArray.parseArray((String)entry);
        HashSet<String> oldSet = new HashSet<String>(arr.size());
        HashSet<String> newSet = new HashSet<String>(newArr.size());
        HashMap<String, JSONObject> oldMap = new HashMap<String, JSONObject>(arr.size());
        HashMap<String, JSONObject> newMap = new HashMap<String, JSONObject>(newArr.size());
        for (i = 0; i < arr.size(); ++i) {
            obj = arr.getJSONObject(i);
            key = BaseChangeLogsUtil.getUniqueKey(obj);
            oldSet.add(key);
            oldMap.put(key, obj);
        }
        for (i = 0; i < newArr.size(); ++i) {
            obj = newArr.getJSONObject(i);
            key = BaseChangeLogsUtil.getUniqueKey(obj);
            newSet.add(key);
            newMap.put(key, obj);
        }
        HashSet<String> delSet = new HashSet<String>();
        delSet.addAll(oldSet);
        delSet.removeAll(newSet);
        HashSet<String> addSet = new HashSet<String>();
        addSet.addAll(newSet);
        addSet.removeAll(oldSet);
        HashSet<String> changeSet = new HashSet<String>();
        changeSet.addAll(oldSet);
        changeSet.retainAll(newSet);
        LocaleString detail = new LocaleString();
        String oldDimension = ((IPageCache)view.getService(IPageCache.class)).get("roledimension");
        String newDimension = (String)view.getModel().getValue("roledimension");
        if (WfUtils.isEmpty((String)oldDimension) && WfUtils.isNotEmpty((String)newDimension) || WfUtils.isNotEmpty((String)oldDimension) && !oldDimension.equals(newDimension)) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u591a\u7ef4\u5ea6\u4fe1\u606f\u4fee\u6539\u4e3a\uff1a", (String)"BaseChangeLogsUtil_49", (String)"bos-wf-formplugin"));
            detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, newDimension);
            detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, "; ");
        }
        if (!changeSet.isEmpty()) {
            LocaleString entryDetail = new LocaleString();
            entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u5206\u5f55\uff1a", (String)"BaseChangeLogsUtil_13", (String)"bos-wf-formplugin"));
            Boolean flag = Boolean.FALSE;
            for (String o : changeSet) {
                Map dimensionInfos;
                List rdList;
                Boolean loopFlag = Boolean.FALSE;
                JSONObject oldOrg = (JSONObject)oldMap.get(o);
                JSONObject newOrg = (JSONObject)newMap.get(o);
                if (oldOrg != null && newOrg != null && (WfUtils.isEmpty((String)oldOrg.getString("org")) && WfUtils.isNotEmpty((String)newOrg.getString("org")) || WfUtils.isNotEmpty((String)oldOrg.getString("org")) && !StringUtils.equals((CharSequence)oldOrg.getString("org"), (CharSequence)newOrg.getString("org")) || !StringUtils.equals((CharSequence)oldOrg.getString("type"), (CharSequence)newOrg.getString("type")) || !StringUtils.equals((CharSequence)oldOrg.getString(ALTERNATEUSER), (CharSequence)newOrg.getString(ALTERNATEUSER)) || WfUtils.isEmpty((String)oldOrg.getString(USERPOSITION)) && WfUtils.isNotEmpty((String)newOrg.getString(USERPOSITION)) || WfUtils.isNotEmpty((String)oldOrg.getString(USERPOSITION)) && !StringUtils.equals((CharSequence)oldOrg.getString(USERPOSITION), (CharSequence)newOrg.getString(USERPOSITION))) || BaseChangeLogsUtil.isDimenSionChange(oldOrg, newOrg) || !oldOrg.getBoolean(INCLUDADMINSUB).equals(newOrg.getBoolean(INCLUDADMINSUB))) {
                    flag = Boolean.TRUE;
                }
                if (oldOrg != null && newOrg != null && (WfUtils.isEmpty((String)oldOrg.getString("org")) && WfUtils.isNotEmpty((String)newOrg.getString("org")) || WfUtils.isNotEmpty((String)oldOrg.getString("org")) && !StringUtils.equals((CharSequence)oldOrg.getString("org"), (CharSequence)newOrg.getString("org")))) {
                    loopFlag = Boolean.TRUE;
                    entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                    entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)" \u5ba1\u6279\u7ec4\u7ec7 ", (String)"BaseChangeLogsUtil_45", (String)"bos-wf-formplugin"));
                    entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, newOrg.getString("org"));
                }
                if (oldOrg != null && newOrg != null && !oldOrg.getBoolean(INCLUDADMINSUB).equals(newOrg.getBoolean(INCLUDADMINSUB))) {
                    if (loopFlag.booleanValue()) {
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, "\u3001");
                    } else {
                        loopFlag = Boolean.TRUE;
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                    }
                    entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, (ILocaleString)WfMultiLangUtils.getLocaleString((String)" \u5305\u542b\u884c\u653f\u7ec4\u7ec7\u4e0b\u7ea7 %s ", (String)"BaseChangeLogsUtil_77", (String)"bos-wf-formplugin", (Object[])new Object[]{newOrg.getString(INCLUDADMINSUB)}));
                }
                if (WfUtils.isNotEmpty((String)newDimension) && (rdList = (List)(dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)newDimension)).get("dimensions")) != null) {
                    String entityNumber;
                    DynamicObject dynObject;
                    int size = rdList.size();
                    if (BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION1)) {
                        if (loopFlag.booleanValue()) {
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, "\u3001");
                        } else {
                            loopFlag = Boolean.TRUE;
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, " ");
                        ILocaleString dimension1 = WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea61", (String)"BaseChangeLogsUtil_50", (String)"bos-wf-formplugin");
                        if (size >= 1 && (dynObject = WfRoleDimensionUtil.getObjectType((String)(entityNumber = ((RoleDimension)rdList.get(0)).getEntityNumber()))) != null) {
                            dimension1 = dynObject.getDataEntityType().getDisplayName();
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, dimension1);
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u4e3a", (String)"BaseChangeLogsUtil_58", (String)"bos-wf-formplugin"));
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, (ILocaleString)newOrg.get((Object)DIMENSION1));
                    }
                    if (BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION2)) {
                        if (loopFlag.booleanValue()) {
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, "\u3001");
                        } else {
                            loopFlag = Boolean.TRUE;
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, " ");
                        ILocaleString dimension2 = WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea62", (String)"BaseChangeLogsUtil_51", (String)"bos-wf-formplugin");
                        if (size >= 2 && (dynObject = WfRoleDimensionUtil.getObjectType((String)(entityNumber = ((RoleDimension)rdList.get(1)).getEntityNumber()))) != null) {
                            dimension2 = dynObject.getDataEntityType().getDisplayName();
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, dimension2);
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u4e3a", (String)"BaseChangeLogsUtil_58", (String)"bos-wf-formplugin"));
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, (ILocaleString)newOrg.get((Object)DIMENSION2));
                    }
                    if (BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION3)) {
                        if (loopFlag.booleanValue()) {
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, "\u3001");
                        } else {
                            loopFlag = Boolean.TRUE;
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, " ");
                        ILocaleString dimension3 = WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea63", (String)"BaseChangeLogsUtil_52", (String)"bos-wf-formplugin");
                        if (size >= 3 && (dynObject = WfRoleDimensionUtil.getObjectType((String)(entityNumber = ((RoleDimension)rdList.get(2)).getEntityNumber()))) != null) {
                            dimension3 = dynObject.getDataEntityType().getDisplayName();
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, dimension3);
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u4e3a", (String)"BaseChangeLogsUtil_58", (String)"bos-wf-formplugin"));
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, (ILocaleString)newOrg.get((Object)DIMENSION3));
                    }
                    if (BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION4)) {
                        if (loopFlag.booleanValue()) {
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, "\u3001");
                        } else {
                            loopFlag = Boolean.TRUE;
                            entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, " ");
                        ILocaleString dimension4 = WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea64", (String)"BaseChangeLogsUtil_53", (String)"bos-wf-formplugin");
                        if (size >= 4 && (dynObject = WfRoleDimensionUtil.getObjectType((String)(entityNumber = ((RoleDimension)rdList.get(3)).getEntityNumber()))) != null) {
                            dimension4 = dynObject.getDataEntityType().getDisplayName();
                        }
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, dimension4);
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u4e3a", (String)"BaseChangeLogsUtil_58", (String)"bos-wf-formplugin"));
                        entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, (ILocaleString)newOrg.get((Object)DIMENSION4));
                    }
                }
                if (!(oldOrg == null || newOrg == null || StringUtils.equals((CharSequence)oldOrg.getString("type"), (CharSequence)newOrg.getString("type")) && StringUtils.equals((CharSequence)oldOrg.getString(ALTERNATEUSER), (CharSequence)newOrg.getString(ALTERNATEUSER)))) {
                    if (loopFlag.booleanValue()) {
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, "\u3001");
                    } else {
                        loopFlag = Boolean.TRUE;
                        entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                    }
                    entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, " ");
                    LocaleString iStr = ResManager.getLocaleString((String)"\u4eba\u5458\u7f3a\u5931\u65f6\u7531 ", (String)"BaseChangeLogsUtil_20", (String)"bos-wf-formplugin");
                    entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, (ILocaleString)iStr);
                    entryDetail = !StringUtils.equals((CharSequence)oldOrg.getString("type"), (CharSequence)newOrg.getString("type")) ? ("superior".equals(newOrg.getString("type")) ? BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)"\u7531\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u5ba1\u6279", (String)"BaseChangeLogsUtil_16", (String)"bos-wf-formplugin")) : BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, newOrg.getString(ALTERNATEUSER))) : BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, newOrg.getString(ALTERNATEUSER));
                    entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, WfUtils.getPromptWordLocaleString((String)" \u5904\u7406", (String)"BaseChangeLogsUtil_17", (String)"bos-wf-formplugin"));
                }
                if (oldOrg != null && newOrg != null && (WfUtils.isEmpty((String)oldOrg.getString(USERPOSITION)) && WfUtils.isNotEmpty((String)newOrg.getString(USERPOSITION)) || WfUtils.isNotEmpty((String)oldOrg.getString(USERPOSITION)) && !StringUtils.equals((CharSequence)oldOrg.getString(USERPOSITION), (CharSequence)newOrg.getString(USERPOSITION)))) {
                    loopFlag = Boolean.TRUE;
                    LocaleString postionDetail = new LocaleString("");
                    postionDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)postionDetail, BaseChangeLogsUtil.removeIndex(o));
                    postionDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)postionDetail, WfUtils.getPromptWordLocaleString((String)" \u7684\u804c\u4f4d\u4fee\u6539\u4e3a ", (String)"BaseChangeLogsUtil_46", (String)"bos-wf-formplugin"));
                    postionDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)postionDetail, newOrg.getString(USERPOSITION));
                    entryDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)entryDetail, (ILocaleString)postionDetail);
                }
                if (!loopFlag.booleanValue()) continue;
                entryDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)entryDetail, "; ");
            }
            if (flag.booleanValue()) {
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)entryDetail);
            }
        }
        if (!addSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u589e\u52a0\u5206\u5f55\uff1a", (String)"BaseChangeLogsUtil_19", (String)"bos-wf-formplugin"));
            for (String o : addSet) {
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, BaseChangeLogsUtil.removeIndex(o) + "\u3001");
                JSONObject obj2 = (JSONObject)newMap.get(o);
                if (WfUtils.isNotEmpty((String)obj2.getString("org"))) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)" \u5ba1\u6279\u7ec4\u7ec7 ", (String)"BaseChangeLogsUtil_45", (String)"bos-wf-formplugin"));
                    detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, obj2.getString("org") + "\u3001");
                }
                if (WfUtils.isNotEmptyString((Object)obj2.get((Object)DIMENSION1))) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea61\u4e3a", (String)"BaseChangeLogsUtil_54", (String)"bos-wf-formplugin"));
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)obj2.get((Object)DIMENSION1));
                    detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, "\u3001");
                }
                if (WfUtils.isNotEmptyString((Object)obj2.get((Object)DIMENSION2))) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea62\u4e3a", (String)"BaseChangeLogsUtil_55", (String)"bos-wf-formplugin"));
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)obj2.get((Object)DIMENSION2));
                    detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, "\u3001");
                }
                if (WfUtils.isNotEmptyString((Object)obj2.get((Object)DIMENSION3))) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea63\u4e3a", (String)"BaseChangeLogsUtil_56", (String)"bos-wf-formplugin"));
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)obj2.get((Object)DIMENSION3));
                    detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, "\u3001");
                }
                if (WfUtils.isNotEmptyString((Object)obj2.get((Object)DIMENSION4))) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u7ef4\u5ea64\u4e3a", (String)"BaseChangeLogsUtil_57", (String)"bos-wf-formplugin"));
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)obj2.get((Object)DIMENSION4));
                    detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, "\u3001");
                }
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)WfMultiLangUtils.getLocaleString((String)"\u5305\u542b\u884c\u653f\u7ec4\u7ec7\u4e0b\u7ea7 %s \u3001", (String)"BaseChangeLogsUtil_73", (String)"bos-wf-formplugin", (Object[])new Object[]{obj2.get((Object)INCLUDADMINSUB)}));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u4eba\u5458\u7f3a\u5931\u65f6\u7531 ", (String)"BaseChangeLogsUtil_20", (String)"bos-wf-formplugin"));
                detail = "superior".equals(obj2.getString("type")) ? BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u7531\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u5ba1\u6279", (String)"BaseChangeLogsUtil_16", (String)"bos-wf-formplugin")) : BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, obj2.getString(ALTERNATEUSER));
                if ("approvalposition".equals(obj2.getString("roleType"))) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)" \u5904\u7406 ", (String)"BaseChangeLogsUtil_65", (String)"bos-wf-formplugin"));
                    continue;
                }
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)" \u5904\u7406\u3001 ", (String)"BaseChangeLogsUtil_17", (String)"bos-wf-formplugin"));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u8be5\u89d2\u8272\u4e0b\u804c\u4f4d ", (String)"BaseChangeLogsUtil_46", (String)"bos-wf-formplugin"));
                String userPostionStr = obj2.getString(USERPOSITION);
                LocaleString userPostion = WfUtils.isEmpty((String)userPostionStr) ? WfUtils.getPromptWordLocaleString((String)"\u672a\u8bbe\u7f6e\uff1b", (String)"BaseChangeLogsUtil_47", (String)"bos-wf-formplugin") : new LocaleString(userPostionStr + ";");
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)userPostion);
            }
        }
        if (!delSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u5220\u9664\u5206\u5f55\uff1a", (String)"BaseChangeLogsUtil_21", (String)"bos-wf-formplugin"));
            for (String o : delSet) {
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, BaseChangeLogsUtil.removeIndex(o) + ";");
            }
        }
        detail = BaseChangeLogsUtil.addLogByMove(view, (ILocaleString)detail);
        return detail;
    }

    private static boolean isDimenSionChange(JSONObject oldOrg, JSONObject newOrg) {
        return BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION1) || BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION2) || BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION3) || BaseChangeLogsUtil.isValueChange(oldOrg, newOrg, DIMENSION4);
    }

    private static boolean isValueChange(JSONObject oldOrg, JSONObject newOrg, String value) {
        if (oldOrg == null && newOrg != null || oldOrg != null && newOrg == null) {
            return Boolean.TRUE;
        }
        if (newOrg == null || value == null) {
            return Boolean.FALSE;
        }
        return WfUtils.isEmptyString((Object)oldOrg.get((Object)value)) && WfUtils.isNotEmptyString((Object)newOrg.get((Object)value)) || WfUtils.isNotEmptyString((Object)oldOrg.get((Object)value)) && !oldOrg.get((Object)value).equals(newOrg.get((Object)value));
    }

    private static ILocaleString addLogByMove(IFormView view, ILocaleString detail) {
        String moveFlag = view.getPageCache().get(MOVE_FLAG);
        if ("true".equals(moveFlag)) {
            detail = BaseChangeLogsUtil.mulitLangAppend(detail, WfUtils.getPromptWordLocaleString((String)"\u884c\u987a\u5e8f\u8c03\u6574\uff1b", (String)"BaseChangeLogsUtil_48", (String)"bos-wf-formplugin"));
            view.getPageCache().remove(MOVE_FLAG);
        }
        return detail;
    }

    private static String removeIndex(String user) {
        if (WfUtils.isNotEmpty((String)user)) {
            user = user.split("_")[0];
        }
        return user;
    }

    private static String addIndex(String user, int index) {
        return user + "_" + index;
    }

    private static ILocaleString setAdminDetail(IFormView view, JSONArray newArr) {
        String entry = ((IPageCache)view.getService(IPageCache.class)).get(ENTRY);
        JSONArray arr = JSONArray.parseArray((String)entry);
        LocaleString detail = new LocaleString();
        detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, BaseChangeLogsUtil.buildAdminEntryLog(arr, newArr, "org", STATE, (ILocaleString)ResManager.getLocaleString((String)"\u3010\u7ec4\u7ec7\u3011", (String)"BaseChangeLogsUtil_61", (String)"bos-wf-formplugin")));
        detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, BaseChangeLogsUtil.buildAdminEntryLog(arr, newArr, "appnames", "receivemsg", (ILocaleString)ResManager.getLocaleString((String)"\u3010\u5e94\u7528\u3011", (String)"BaseChangeLogsUtil_62", (String)"bos-wf-formplugin")));
        return detail;
    }

    private static ILocaleString setOrgDetail(IFormView view, JSONArray newArr) {
        ILocaleString org;
        JSONObject obj;
        JSONObject obj2;
        int i;
        String entry = ((IPageCache)view.getService(IPageCache.class)).get(ENTRY);
        JSONArray arr = JSONArray.parseArray((String)entry);
        HashSet<String> oldSet = new HashSet<String>(arr.size());
        HashSet<String> newSet = new HashSet<String>(newArr.size());
        HashMap<String, JSONObject> oldMap = new HashMap<String, JSONObject>(arr.size());
        HashMap<String, JSONObject> newMap = new HashMap<String, JSONObject>(newArr.size());
        for (i = 0; i < arr.size(); ++i) {
            obj2 = arr.getJSONObject(i);
            oldSet.add(obj2.getString("id"));
            oldMap.put(obj2.getString("id"), obj2);
        }
        for (i = 0; i < newArr.size(); ++i) {
            obj2 = newArr.getJSONObject(i);
            newSet.add(obj2.getString("id"));
            newMap.put(obj2.getString("id"), obj2);
        }
        HashSet<String> delSet = new HashSet<String>();
        delSet.addAll(oldSet);
        delSet.removeAll(newSet);
        HashSet<String> addSet = new HashSet<String>();
        addSet.addAll(newSet);
        addSet.removeAll(oldSet);
        HashSet<String> changeSet = new HashSet<String>();
        changeSet.addAll(oldSet);
        changeSet.retainAll(newSet);
        LocaleString detail = new LocaleString("");
        if (!changeSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u7ec4\u7ec7\uff1a", (String)"BaseChangeLogsUtil_22", (String)"bos-wf-formplugin"));
            boolean flag = false;
            for (String o : changeSet) {
                JSONObject oldOrg = (JSONObject)oldMap.get(o);
                JSONObject newOrg = (JSONObject)newMap.get(o);
                if (!oldOrg.getBooleanValue(STATE) != newOrg.getBooleanValue(STATE)) continue;
                flag = true;
                ILocaleString org2 = BaseChangeLogsUtil.getILocaleString(newOrg.get((Object)"org"));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, org2);
                if (newOrg.getBooleanValue(STATE)) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"; \u5305\u542b\u4e0b\u7ea7; ", (String)"BaseChangeLogsUtil_23", (String)"bos-wf-formplugin"));
                    continue;
                }
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"; \u4e0d\u5305\u542b\u4e0b\u7ea7; ", (String)"BaseChangeLogsUtil_24", (String)"bos-wf-formplugin"));
            }
            if (!flag) {
                detail = new LocaleString("");
            }
        }
        if (!addSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u589e\u52a0\u7ec4\u7ec7\uff1a", (String)"BaseChangeLogsUtil_25", (String)"bos-wf-formplugin"));
            for (String o : addSet) {
                obj = (JSONObject)newMap.get(o);
                org = BaseChangeLogsUtil.getILocaleString(obj.get((Object)"org"));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, org);
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, "\u3001");
                if (obj.getBooleanValue(STATE)) {
                    detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u5305\u542b\u4e0b\u7ea7;", (String)"BaseChangeLogsUtil_37", (String)"bos-wf-formplugin"));
                    continue;
                }
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u4e0d\u5305\u542b\u4e0b\u7ea7;", (String)"BaseChangeLogsUtil_27", (String)"bos-wf-formplugin"));
            }
        }
        if (!delSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u5220\u9664\u7ec4\u7ec7\uff1a", (String)"BaseChangeLogsUtil_28", (String)"bos-wf-formplugin"));
            for (String o : delSet) {
                obj = (JSONObject)oldMap.get(o);
                org = BaseChangeLogsUtil.getILocaleString(obj.get((Object)"org"));
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, org);
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, "\u3001");
            }
        }
        return detail;
    }

    private static ILocaleString setSummaryDetail(IFormView view, JSONArray newArr) {
        JSONObject obj;
        int i;
        String entry = ((IPageCache)view.getService(IPageCache.class)).get(ENTRY);
        JSONArray arr = JSONArray.parseArray((String)entry);
        HashSet<String> oldSet = new HashSet<String>(arr.size());
        HashSet<String> newSet = new HashSet<String>(newArr.size());
        HashMap<String, JSONObject> oldMap = new HashMap<String, JSONObject>(arr.size());
        HashMap<String, JSONObject> newMap = new HashMap<String, JSONObject>(newArr.size());
        for (i = 0; i < arr.size(); ++i) {
            obj = arr.getJSONObject(i);
            oldSet.add(obj.getString(FIELDKEY));
            oldMap.put(obj.getString(FIELDKEY), obj);
        }
        for (i = 0; i < newArr.size(); ++i) {
            obj = newArr.getJSONObject(i);
            newSet.add(obj.getString(FIELDKEY));
            newMap.put(obj.getString(FIELDKEY), obj);
        }
        HashSet<String> delSet = new HashSet<String>();
        delSet.addAll(oldSet);
        delSet.removeAll(newSet);
        HashSet<String> addSet = new HashSet<String>();
        addSet.addAll(newSet);
        addSet.removeAll(oldSet);
        HashSet<String> changeSet = new HashSet<String>();
        changeSet.addAll(oldSet);
        changeSet.retainAll(newSet);
        LocaleString detail = new LocaleString();
        if (!changeSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u5b57\u6bb5\uff1a", (String)"BaseChangeLogsUtil_29", (String)"bos-wf-formplugin"));
            boolean flag = false;
            for (String f : changeSet) {
                JSONObject oldOrg = (JSONObject)oldMap.get(f);
                JSONObject newOrg = (JSONObject)newMap.get(f);
                if (oldOrg.getString(FIELDNAME).equals(newOrg.getString(FIELDNAME)) && oldOrg.getString(FIELDPERCENT).equals(newOrg.getString(FIELDPERCENT)) && oldOrg.getString(FONTCOLOR).equals(newOrg.getString(FONTCOLOR)) && oldOrg.getString(FONTSIZE).equals(newOrg.getString(FONTSIZE))) continue;
                flag = true;
                ILocaleString localeString = WfMultiLangUtils.replaceILocaleString((ILocaleString)ResManager.getLocaleString((String)"\u5b57\u6bb5 %1$s \u914d\u7f6e  \u5b57\u6bb5\u540d\u79f0( %2$s )\u3001\u5b57\u6bb5\u5360\u6bd4( %3$s )\u3001\u5b57\u4f53\u989c\u8272( %4$s )\u3001\u5b57\u4f53\u5927\u5c0f( %5$spx );", (String)"BaseChangeLogsUtil_30", (String)"bos-wf-formplugin"), (ILocaleString[])new ILocaleString[]{BaseChangeLogsUtil.newMultiLangString(newOrg.getString(FIELDKEY)), BaseChangeLogsUtil.newMultiLangString(newOrg.getString(FIELDNAME)), BaseChangeLogsUtil.newMultiLangString(newOrg.getString(FIELDPERCENT)), BaseChangeLogsUtil.newMultiLangString(newOrg.getString(FONTCOLOR)), BaseChangeLogsUtil.newMultiLangString(newOrg.getString(FONTSIZE))});
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, localeString);
            }
            if (!flag) {
                detail = new LocaleString();
            }
        }
        if (!addSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u589e\u52a0\u5b57\u6bb5\uff1a", (String)"BaseChangeLogsUtil_35", (String)"bos-wf-formplugin"));
            for (String f : addSet) {
                JSONObject obj2 = (JSONObject)newMap.get(f);
                ILocaleString localeString = WfMultiLangUtils.replaceILocaleString((ILocaleString)ResManager.getLocaleString((String)"\u5b57\u6bb5 %1$s \u914d\u7f6e  \u5b57\u6bb5\u540d\u79f0( %2$s )\u3001\u5b57\u6bb5\u5360\u6bd4( %3$s )\u3001\u5b57\u4f53\u989c\u8272( %4$s )\u3001\u5b57\u4f53\u5927\u5c0f( %5$spx );", (String)"BaseChangeLogsUtil_30", (String)"bos-wf-formplugin"), (ILocaleString[])new ILocaleString[]{BaseChangeLogsUtil.newMultiLangString(f), BaseChangeLogsUtil.newMultiLangString(obj2.getString(FIELDNAME)), BaseChangeLogsUtil.newMultiLangString(obj2.getString(FIELDPERCENT)), BaseChangeLogsUtil.newMultiLangString(obj2.getString(FONTCOLOR)), BaseChangeLogsUtil.newMultiLangString(obj2.getString(FONTSIZE))});
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, localeString);
            }
        }
        if (!delSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, WfUtils.getPromptWordLocaleString((String)"\u5220\u9664\u5b57\u6bb5\uff1a", (String)"BaseChangeLogsUtil_36", (String)"bos-wf-formplugin"));
            for (String o : delSet) {
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, o + ";");
            }
        }
        return detail;
    }

    public static ILocaleString mulitLangAppendString(ILocaleString lString, String string) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            String l = lang.toString();
            String itemStr = WfUtils.isEmpty((String)((String)lString.getItem(l))) ? "" : (String)lString.getItem(l);
            lString.setItem(l, (Object)(itemStr + string));
        }
        return lString;
    }

    public static ILocaleString newMultiLangString(String string) {
        LocaleString localeString = new LocaleString();
        return BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)localeString, string);
    }

    public static ILocaleString newMulitLangAndAppendString(ILocaleString lString, String string) {
        LocaleString ret = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String l = lang.toString();
            String itemStr = WfUtils.isEmpty((String)((String)lString.getItem(l))) ? "" : (String)lString.getItem(l);
            ret.setItem(l, (Object)(itemStr + string));
        }
        return ret;
    }

    public static ILocaleString mulitLangAppend(ILocaleString lString1, ILocaleString lString2) {
        return WfMultiLangUtils.jointILocaleString((ILocaleString)lString1, (ILocaleString)lString2, (String)"");
    }

    private static ILocaleString getILocaleString(Object object) {
        LocaleString org = new LocaleString("");
        if (object instanceof ILocaleString) {
            return (ILocaleString)object;
        }
        if (object instanceof JSONObject) {
            JSONObject json = (JSONObject)object;
            for (Map.Entry entry : json.entrySet()) {
                org.put(entry.getKey(), (Object)String.valueOf(entry.getValue()));
            }
        }
        return org;
    }

    public static ILocaleString jointILocaleString(ILocaleString str1, String str2, String format) {
        if (WfUtils.isEmpty((ILocaleString)str1)) {
            return new LocaleString();
        }
        if (WfUtils.isEmpty((String)str2)) {
            return str1;
        }
        LocaleString newStr = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String lan = lang.toString();
            String arg1 = WfUtils.isEmpty((String)((String)str1.get((Object)lan))) ? str1.toString() : (String)str1.get((Object)lan);
            newStr.setItem(lan, (Object)String.format(format, arg1, str2));
        }
        return newStr;
    }

    private static ILocaleString buildAdminEntryLog(JSONArray arr, JSONArray newArr, String key, String onOff, ILocaleString label) {
        Map mNames;
        JSONObject obj;
        JSONObject obj2;
        int i;
        HashSet<String> oldSet = new HashSet<String>(arr.size());
        HashSet<String> newSet = new HashSet<String>(newArr.size());
        HashMap<String, JSONObject> oldMap = new HashMap<String, JSONObject>(arr.size());
        HashMap<String, JSONObject> newMap = new HashMap<String, JSONObject>(newArr.size());
        for (i = 0; i < arr.size(); ++i) {
            obj2 = arr.getJSONObject(i);
            if (obj2 != null && obj2.getString(key) != null) {
                oldSet.add(obj2.getString(key));
                oldMap.put(obj2.getString(key), obj2);
            }
            if (obj2 == null || obj2.getString(onOff) == null) continue;
            oldMap.put(obj2.getString(onOff), obj2);
        }
        for (i = 0; i < newArr.size(); ++i) {
            obj2 = newArr.getJSONObject(i);
            if (obj2 != null && obj2.getString(key) != null) {
                newSet.add(obj2.getString(key));
                newMap.put(obj2.getString(key), obj2);
            }
            if (obj2 == null || obj2.getString(onOff) == null) continue;
            newMap.put(obj2.getString(onOff), obj2);
        }
        HashSet<String> delSet = new HashSet<String>();
        delSet.addAll(oldSet);
        delSet.removeAll(newSet);
        HashSet<String> addSet = new HashSet<String>();
        addSet.addAll(newSet);
        addSet.removeAll(oldSet);
        HashSet<String> changeSet = new HashSet<String>();
        changeSet.addAll(oldSet);
        changeSet.retainAll(newSet);
        LocaleString detail = new LocaleString();
        LocaleString on = ResManager.getLocaleString((String)"\u63a5\u6536\u5f02\u5e38\u6d88\u606f", (String)"BaseChangeLogsUtil_63", (String)"bos-wf-formplugin");
        LocaleString off = ResManager.getLocaleString((String)"\u4e0d\u63a5\u6536\u5f02\u5e38\u6d88\u606f", (String)"BaseChangeLogsUtil_64", (String)"bos-wf-formplugin");
        if (!changeSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)ResManager.getLocaleString((String)"\u4fee\u6539", (String)"BaseChangeLogsUtil_10", (String)"bos-wf-formplugin"));
            detail = WfMultiLangUtils.jointILocaleString((ILocaleString)detail, (ILocaleString)label, (String)"", (String)"", (String)":");
            boolean flag = false;
            for (String s : changeSet) {
                JSONObject oldOrg = (JSONObject)oldMap.get(s);
                JSONObject newOrg = (JSONObject)newMap.get(s);
                if (!oldOrg.getBooleanValue(onOff) != newOrg.getBooleanValue(onOff)) continue;
                flag = true;
                Map mNames2 = (Map)SerializationUtils.fromJsonString((String)newOrg.get((Object)key).toString(), Map.class);
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)LocaleString.fromMap((Map)mNames2));
                LocaleString desc = newOrg.getBooleanValue(onOff) ? on : off;
                detail = WfMultiLangUtils.jointILocaleString((ILocaleString)detail, (ILocaleString)desc, (String)",", (String)"", (String)"; ");
            }
            if (!flag) {
                detail = new LocaleString();
            }
        }
        if (!addSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)ResManager.getLocaleString((String)"\u65b0\u589e", (String)"BaseChangeLogsUtil_9", (String)"bos-wf-formplugin"));
            detail = WfMultiLangUtils.jointILocaleString((ILocaleString)detail, (ILocaleString)label, (String)"", (String)"", (String)":");
            for (String o : addSet) {
                obj = (JSONObject)newMap.get(o);
                mNames = (Map)SerializationUtils.fromJsonString((String)obj.get((Object)key).toString(), Map.class);
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)LocaleString.fromMap((Map)mNames));
                LocaleString desc = obj.getBooleanValue(onOff) ? on : off;
                detail = WfMultiLangUtils.jointILocaleString((ILocaleString)detail, (ILocaleString)desc, (String)",", (String)"", (String)"; ");
            }
        }
        if (!delSet.isEmpty()) {
            detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)ResManager.getLocaleString((String)"\u5220\u9664", (String)"BaseChangeLogsUtil_1", (String)"bos-wf-formplugin"));
            detail = WfMultiLangUtils.jointILocaleString((ILocaleString)detail, (ILocaleString)label, (String)"", (String)"", (String)":");
            for (String o : delSet) {
                obj = (JSONObject)oldMap.get(o);
                mNames = (Map)SerializationUtils.fromJsonString((String)obj.get((Object)key).toString(), Map.class);
                detail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)detail, (ILocaleString)LocaleString.fromMap((Map)mNames));
                detail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)detail, ";");
            }
        }
        return detail;
    }
}

