/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.lang.StringUtils;

public class BillSubjectUtil {
    public static String getSample(String billId, ILocaleString subject, String mapJson, TreeNode root, Map<String, String> sampleMap) {
        if (subject == null) {
            return null;
        }
        return BillSubjectUtil.getSample(billId, subject.getLocaleValue(), mapJson, root, sampleMap);
    }

    public static String getSample(String billId, String localeSubject, String mapJson, TreeNode root, Map<String, String> sampleMap) {
        if (StringUtils.isBlank((String)billId) || WfUtils.isEmpty((String)localeSubject)) {
            return null;
        }
        ArrayList<String> fields = new ArrayList<String>();
        String sample = localeSubject;
        Pattern pattern = Pattern.compile("\\{([\\w.]+)\\}");
        Matcher matcher = pattern.matcher(localeSubject);
        while (matcher.find()) {
            fields.add(matcher.group(1));
        }
        for (String nodeId : fields) {
            String value;
            TreeNode checkedNode = root.getTreeNode(nodeId.contains("model.") ? nodeId.replace("model.", "") : nodeId, 3);
            String nodeName = "";
            if (!WfUtils.isNullObject((Object)checkedNode)) {
                nodeName = checkedNode.getText();
            }
            if (WfUtils.isEmpty((String)(value = BillSubjectUtil.matchType(billId, nodeName = nodeName.contains(".") ? nodeName.replace(".", "") : nodeName, nodeId, (Map)SerializationUtils.fromJsonString((String)mapJson, Map.class), sampleMap)))) continue;
            sample = sample.replaceFirst(nodeId, value);
        }
        return sample.replace(":", " : ").replace("{", "").replace("}", "");
    }

    public static Map<String, Object> getFieldsMap(String id) {
        DataEntityPropertyCollection collection = EntityMetadataCache.getDataEntityTypeById((String)id).getProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (collection == null || collection.size() < 1) {
            return null;
        }
        for (IDataEntityProperty prop : collection) {
            String name = prop.getName();
            map.put(name, prop.getPropertyType());
        }
        return map;
    }

    public static String matchType(String billId, String nodeName, String nodeId, Map<String, Object> map, Map<String, String> sampleMap) {
        String value = null;
        if (sampleMap != null && (value = sampleMap.get(nodeId)) != null) {
            return value;
        }
        if ("billno".equals(nodeId)) {
            return "KD-JDK-20190111";
        }
        if (map.get(nodeId) == null) {
            return String.format(ResManager.loadKDString((String)"%s\u6837\u4f8b", (String)"BillSubjectUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), nodeName);
        }
        String nodeType = map.get(nodeId).toString();
        if ("long".equalsIgnoreCase(nodeType)) {
            return "1001";
        }
        if ("java.util.Date".equalsIgnoreCase(nodeType)) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            return formatter.format(WfUtils.now());
        }
        if ("java.lang.Integer".equalsIgnoreCase(nodeType)) {
            return "1000";
        }
        if ("java.math.BigDecimal".equalsIgnoreCase(nodeType)) {
            return "342,800";
        }
        if ("boolean".equalsIgnoreCase(nodeType)) {
            return "true";
        }
        return String.format(ResManager.loadKDString((String)"%s\u6837\u4f8b", (String)"BillSubjectUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), nodeName);
    }

    public static TreeNode getTreeRoot(String id) {
        MetadataReader reader = new MetadataReader(true);
        EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(id, MetaCategory.Entity);
        Map fieldTree = EntityMetadataUtil.getlistFieldTree((EntityMetadata)entityMetadata);
        TreeNode root = TreeNode.Parse((String)"", (Map)fieldTree, (String)"Id", (String)"Name", (String)"Items");
        root.setIsOpened(false);
        return root;
    }

    public static String getShowSubject(String customSubject, String entityId) {
        String showSubject = null;
        if (StringUtils.isBlank((String)customSubject)) {
            showSubject = BillSubjectUtil.getGeneralSubject(entityId);
        } else {
            Pattern pattern = Pattern.compile("\\{\\{(.+?)\\}\\}");
            Matcher matcher = pattern.matcher(customSubject);
            if (matcher.find()) {
                String subjectId = matcher.group(1);
                showSubject = customSubject.replace("{{" + subjectId + "}}", BillSubjectUtil.getGeneralSubject(entityId));
            } else {
                showSubject = customSubject;
            }
        }
        return showSubject;
    }

    public static String getGeneralSubject(String entityId) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService service = wfService.getRepositoryService();
        BillSubjectModelEntity entity = service.findBillSubject(entityId);
        if (entity != null && entity.getBillSubject() != null) {
            return entity.getBillSubject().getLocaleValue();
        }
        return "";
    }
}

