/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BillSummaryUtil {
    public static final String BILLRELATIONCARDTPLID = "1M=9GUOBIYOA";
    public static final String BILLRELATION_CARDTPL_FORMID = "bpm_billrelation_cardtpl";
    public static final String BILLRELATION_STACKEDCARDTPL_ID = "1WU107IES6MG";
    public static final String BILLRELATION_STACKEDCARDTPL_FORMID = "bpm_billrelation_stkcard";

    public static boolean isBillRelationCardSummary(DynamicObject dynamicObject) {
        return String.valueOf(dynamicObject.getPkValue()).equals(BILLRELATIONCARDTPLID);
    }

    public static boolean isBillRelationCardSummary(String scene) {
        return BillSummaryType.billRelationCardSummary.name().equals(scene);
    }

    public static boolean isBillRelationCardSummaryForm(Object formId) {
        return BILLRELATION_CARDTPL_FORMID.equals(formId);
    }

    public static boolean isBillRelationStackedCardSummary(DynamicObject dynamicObject) {
        return BILLRELATION_STACKEDCARDTPL_ID.equals(String.valueOf(dynamicObject.getPkValue()));
    }

    public static boolean isBillRelationStackedCardSummary(String scene) {
        return BillSummaryType.billRelationStackedCardSummary.name().equals(scene);
    }

    public static boolean isBillRelationStackedCardSummaryForm(Object formId) {
        return BILLRELATION_STACKEDCARDTPL_FORMID.equals(formId);
    }

    public static List<ComboItem> getBillSummaryComboItems(String entityNumber, String scene) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        QFilter billTypeFilter = new QFilter("billtype", "=", (Object)entityNumber);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sceneFilter = new QFilter("scene", "=", (Object)scene);
        DynamicObject[] forms = BusinessDataServiceHelper.load((String)"wf_mbillsummary_cfg", (String)"number,name", (QFilter[])new QFilter[]{billTypeFilter, enableFilter, sceneFilter});
        if (forms.length > 0) {
            for (DynamicObject form : forms) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u5355\u636e\u6458\u8981(%2$s)", (String)"BillSummaryUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), form.getLocaleString("name").getLocaleValue(), form.getString("number"))));
                comboItem.setValue(form.getString("number"));
                comboItems.add(comboItem);
            }
        }
        return comboItems;
    }

    public static List<ComboItem> getComboAllItems(String entityNumber, String entityId, String scene) {
        ArrayList<ComboItem> comboAllItems = new ArrayList<ComboItem>();
        comboAllItems.addAll(BillSummaryUtil.getBillSummaryComboItems(entityNumber, scene));
        comboAllItems.addAll(BillSummaryUtil.getBillLayoutComboItems(entityNumber, entityId));
        return comboAllItems;
    }

    private static Collection<? extends ComboItem> getBillLayoutComboItems(String entityNumber, String entityId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ManagementService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        List items = service.getBillPageByType(entityId, "BillFormModel");
        if (CollectionUtil.isNotEmpty((Collection)items)) {
            for (Map item : items) {
                if (entityNumber.equals((String)item.get("id"))) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString((String)item.get("name") + "(" + (String)item.get("id") + ")"));
                comboItem.setValue((String)item.get("id"));
                comboItems.add(comboItem);
            }
        }
        return comboItems;
    }
}

